/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common.internal;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import weblogic.common.WLObjectOutput;
import weblogic.protocol.ServerChannel;
import weblogic.protocol.ServerChannelStream;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.io.DataIO;
import weblogic.utils.io.DelegatingOutputStream;
import weblogic.utils.io.Replacer;

public class WLObjectOutputStream
extends ObjectOutputStream
implements WLObjectOutput,
ServerChannelStream {
    private final DelegatingOutputStream delegate;
    private Replacer replacer = null;
    private ServerChannel channel = null;

    public WLObjectOutputStream(OutputStream outputStream) throws IOException {
        this(new DelegatingOutputStream(outputStream));
    }

    private WLObjectOutputStream(DelegatingOutputStream delegatingOutputStream) throws IOException {
        super((OutputStream)delegatingOutputStream);
        try {
            this.enableReplaceObject(true);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        this.delegate = delegatingOutputStream;
    }

    public final void setDelegate(OutputStream outputStream) {
        this.delegate.setDelegate(outputStream);
    }

    protected final void annotateClass(Class clazz) throws IOException {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader instanceof GenericClassLoader) {
            GenericClassLoader genericClassLoader = (GenericClassLoader)classLoader;
            String string = genericClassLoader.getAnnotation().getAnnotationString();
            if (string != null) {
                this.writeUTF(string);
            } else {
                this.writeUTF("");
            }
        } else {
            this.writeUTF("");
        }
    }

    protected void annotateProxyClass(Class clazz) throws IOException {
        this.annotateClass(clazz);
    }

    public void writeUTF(String string) throws IOException {
        DataIO.writeUTF((OutputStream)this, (String)string);
    }

    public final void setReplacer(Replacer replacer) {
        this.replacer = replacer;
    }

    public final void setServerChannel(ServerChannel serverChannel) {
        this.channel = serverChannel;
    }

    protected Object replaceObject(Object object) throws IOException {
        return this.replacer == null ? object : this.replacer.replaceObject(object);
    }

    protected final void writeStreamHeader() throws IOException {
    }

    public void writeObjectWL(Object object) throws IOException {
        this.writeObject(object);
    }

    public final void writeString(String string) throws IOException {
        this.flush();
        if (string == null) {
            this.writeByte(112);
        } else {
            this.writeByte(116);
            this.writeUTF(string);
        }
    }

    public final void writeDate(Date date) throws IOException {
        this.writeObject(date);
    }

    public final void writeArrayList(ArrayList arrayList) throws IOException {
        this.writeObject(arrayList);
    }

    public final void writeProperties(Properties properties) throws IOException {
        this.writeObject(properties);
    }

    public final void writeBytes(byte[] byArray) throws IOException {
        this.writeObject(byArray);
    }

    public final void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.writeObject(byArray2);
    }

    public final void writeArrayOfObjects(Object[] objectArray) throws IOException {
        this.writeObject(objectArray);
    }

    public void writeImmutable(Object object) throws IOException {
        this.writeObject(object);
    }

    public final void writeAbbrevString(String string) throws IOException {
        this.writeString(string);
    }

    public ServerChannel getServerChannel() {
        return this.channel;
    }
}

