/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.common;

import java.security.AccessController;
import weblogic.application.ApplicationFactoryManager;
import weblogic.connector.common.ConnectorDiagnosticImageSource;
import weblogic.connector.common.Debug;
import weblogic.connector.common.RACollectionManager;
import weblogic.connector.deploy.ConnectorDeploymentFactory;
import weblogic.connector.deploy.ConnectorModuleFactory;
import weblogic.connector.deploy.TransportableJNDIHandler;
import weblogic.connector.exception.RAException;
import weblogic.connector.monitoring.ServiceRuntimeMBeanImpl;
import weblogic.diagnostics.image.ImageManager;
import weblogic.jndi.internal.WLNamingManager;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.ActivatedService;
import weblogic.server.ServiceFailureException;
import weblogic.utils.ErrorCollectionException;

public final class ConnectorService
extends ActivatedService {
    private static ServiceRuntimeMBeanImpl sMBean;
    private static boolean alreadyInitialized;
    private static final AuthenticatedSubject kernelId;
    private static boolean imageSourceRegistered;

    public void stopService() throws ServiceFailureException {
        Debug.service("stopService() called on ConnectorService ");
        try {
            RACollectionManager.stop();
            this.haltService();
        }
        catch (RAException rAException) {
            throw new ServiceFailureException((Throwable)((Object)rAException));
        }
    }

    public void haltService() throws ServiceFailureException {
        Debug.service("haltService() called on ConnectorService ");
        ErrorCollectionException errorCollectionException = null;
        try {
            RACollectionManager.halt();
        }
        catch (RAException rAException) {
            Debug.logConnectorServiceShutdownError(rAException.toString());
            if (errorCollectionException == null) {
                errorCollectionException = new ErrorCollectionException();
            }
            errorCollectionException.addError((Throwable)((Object)rAException));
        }
        try {
            sMBean.unregister();
        }
        catch (ManagementException managementException) {
            Debug.logConnectorServiceShutdownError(managementException.toString());
            if (errorCollectionException == null) {
                errorCollectionException = new ErrorCollectionException();
            }
            errorCollectionException.addError((Throwable)managementException);
        }
        if (imageSourceRegistered) {
            try {
                Debug.service("Unregistering the Connector diagnostic image source");
                ImageManager imageManager = ImageManager.getInstance();
                imageManager.unregisterImageSource("CONNECTOR");
                imageSourceRegistered = false;
            }
            catch (Throwable throwable) {
                Debug.logDiagImageUnregisterFailure(throwable);
                if (errorCollectionException == null) {
                    errorCollectionException = new ErrorCollectionException();
                }
                errorCollectionException.addError(throwable);
            }
        }
        if (errorCollectionException != null) {
            throw new ServiceFailureException((Throwable)errorCollectionException);
        }
    }

    public boolean startService() throws ServiceFailureException {
        Debug.service("startService() called on ConnectorService ");
        Debug.logConnectorServiceInitializing();
        if (alreadyInitialized) {
            return true;
        }
        try {
            Debug.service("Creating ServiceRuntimeMBeanImpl");
            sMBean = new ServiceRuntimeMBeanImpl();
            ManagementService.getRuntimeAccess(kernelId).getServerRuntime().setConnectorServiceRuntime(sMBean);
        }
        catch (ManagementException managementException) {
            Debug.logConnectorServiceInitError(managementException.toString());
            throw new ServiceFailureException((Throwable)managementException);
        }
        ApplicationFactoryManager applicationFactoryManager = ApplicationFactoryManager.getApplicationFactoryManager();
        ConnectorDeploymentFactory connectorDeploymentFactory = new ConnectorDeploymentFactory();
        applicationFactoryManager.addDeploymentFactory(connectorDeploymentFactory);
        applicationFactoryManager.addModuleFactory(new ConnectorModuleFactory());
        alreadyInitialized = true;
        Debug.logConnectorServiceInitialized();
        try {
            Debug.service("Initializing the Connector diagnostic image source");
            ImageManager imageManager = ImageManager.getInstance();
            ConnectorDiagnosticImageSource connectorDiagnosticImageSource = new ConnectorDiagnosticImageSource();
            imageManager.registerImageSource("CONNECTOR", connectorDiagnosticImageSource);
            imageSourceRegistered = true;
        }
        catch (Throwable throwable) {
            Debug.logDiagImageRegisterFailure(throwable);
        }
        Debug.service("Registering the connector TransportableJNDIHandler as a TransportableFactory");
        WLNamingManager.addTransportableFactory(new TransportableJNDIHandler());
        return true;
    }

    public static ServiceRuntimeMBeanImpl getConnectorServiceRuntimeMBean() {
        return sMBean;
    }

    static {
        alreadyInitialized = false;
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        imageSourceRegistered = false;
    }
}

