/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.common;

import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import weblogic.connector.ConnectorLogger;
import weblogic.connector.outbound.ConnectionInfo;
import weblogic.connector.outbound.ConnectionPool;
import weblogic.connector.outbound.ProfileDataRecord;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.logging.NonCatalogLogger;

public class Debug {
    public static final int INDENT_WIDTH = 2;
    private static final String WHITE_SPACE = "";
    private static final int MAX_SPACES = "".length();
    public static boolean verbose;
    public static int indentLevel;
    static NonCatalogLogger logger;
    private static DebugLogger XAIN_LOGGER;
    private static DebugLogger CONNECTIONS_LOGGER;
    private static DebugLogger CONNEVENTS_LOGGER;
    private static DebugLogger DEPLOYMENT_LOGGER;
    private static DebugLogger LOCALOUT_LOGGER;
    private static DebugLogger PARSING_LOGGER;
    private static DebugLogger POOLING_LOGGER;
    private static DebugLogger POOLVERBOSE_LOGGER;
    private static DebugLogger RALIFECYCLE_LOGGER;
    private static DebugLogger SECURITYCTX_LOGGER;
    private static DebugLogger SERVICE_LOGGER;
    private static DebugLogger WORK_LOGGER;
    private static DebugLogger WORKEVENTS_LOGGER;
    private static DebugLogger XAOUT_LOGGER;
    private static DebugLogger XAWORK_LOGGER;
    private static DebugLogger RACLASSLOADING;

    public static DebugLogger xain() {
        if (XAIN_LOGGER == null) {
            XAIN_LOGGER = DebugLogger.getDebugLogger((String)"DebugRAXAin");
        }
        return XAIN_LOGGER;
    }

    public static DebugLogger connections() {
        if (CONNECTIONS_LOGGER == null) {
            CONNECTIONS_LOGGER = DebugLogger.getDebugLogger((String)"DebugRAConnections");
        }
        return CONNECTIONS_LOGGER;
    }

    public static DebugLogger connevents() {
        if (CONNEVENTS_LOGGER == null) {
            CONNEVENTS_LOGGER = DebugLogger.getDebugLogger((String)"DebugRAConnEvents");
        }
        return CONNEVENTS_LOGGER;
    }

    public static DebugLogger deployment() {
        if (DEPLOYMENT_LOGGER == null) {
            DEPLOYMENT_LOGGER = DebugLogger.getDebugLogger((String)"DebugRADeployment");
        }
        return DEPLOYMENT_LOGGER;
    }

    public static DebugLogger localout() {
        if (LOCALOUT_LOGGER == null) {
            LOCALOUT_LOGGER = DebugLogger.getDebugLogger((String)"DebugRALocalOut");
        }
        return LOCALOUT_LOGGER;
    }

    public static DebugLogger parsing() {
        if (PARSING_LOGGER == null) {
            PARSING_LOGGER = DebugLogger.getDebugLogger((String)"DebugRAParsing");
        }
        return PARSING_LOGGER;
    }

    public static DebugLogger pooling() {
        if (POOLING_LOGGER == null) {
            POOLING_LOGGER = DebugLogger.getDebugLogger((String)"DebugRAPooling");
        }
        return POOLING_LOGGER;
    }

    public static DebugLogger poolverbose() {
        if (POOLVERBOSE_LOGGER == null) {
            POOLVERBOSE_LOGGER = DebugLogger.getDebugLogger((String)"DebugRAPoolVerbose");
        }
        return POOLVERBOSE_LOGGER;
    }

    public static DebugLogger ralifecycle() {
        if (RALIFECYCLE_LOGGER == null) {
            RALIFECYCLE_LOGGER = DebugLogger.getDebugLogger((String)"DebugRALifecycle");
        }
        return RALIFECYCLE_LOGGER;
    }

    public static DebugLogger securityctx() {
        if (SECURITYCTX_LOGGER == null) {
            SECURITYCTX_LOGGER = DebugLogger.getDebugLogger((String)"DebugRASecurityCtx");
        }
        return SECURITYCTX_LOGGER;
    }

    public static DebugLogger service() {
        if (SERVICE_LOGGER == null) {
            SERVICE_LOGGER = DebugLogger.getDebugLogger((String)"DebugConnectorService");
        }
        return SERVICE_LOGGER;
    }

    public static DebugLogger work() {
        if (WORK_LOGGER == null) {
            WORK_LOGGER = DebugLogger.getDebugLogger((String)"DebugRAWork");
        }
        return WORK_LOGGER;
    }

    public static DebugLogger workevents() {
        if (WORKEVENTS_LOGGER == null) {
            WORKEVENTS_LOGGER = DebugLogger.getDebugLogger((String)"DebugRAWorkEvents");
        }
        return WORKEVENTS_LOGGER;
    }

    public static DebugLogger xaout() {
        if (XAOUT_LOGGER == null) {
            XAOUT_LOGGER = DebugLogger.getDebugLogger((String)"DebugRAXAout");
        }
        return XAOUT_LOGGER;
    }

    public static DebugLogger xawork() {
        if (XAWORK_LOGGER == null) {
            XAWORK_LOGGER = DebugLogger.getDebugLogger((String)"DebugRAXAwork");
        }
        return XAWORK_LOGGER;
    }

    public static DebugLogger classloading() {
        if (RACLASSLOADING == null) {
            RACLASSLOADING = DebugLogger.getDebugLogger((String)"DebugRAClassloader");
        }
        return RACLASSLOADING;
    }

    public static void connEvent(String string) {
        Debug.connevents().debug(string);
    }

    public static void connections(String string) {
        Debug.connections().debug(string);
    }

    public static void connections(String string, Throwable throwable) {
        Debug.connections().debug(string, throwable);
    }

    public static void deployment(String string) {
        Debug.deployment().debug(string);
    }

    public static void deployment(String string, Throwable throwable) {
        Debug.deployment().debug(string, throwable);
    }

    public static void localOut(String string) {
        Debug.localout().debug(string);
    }

    public static void parsing(String string) {
        Debug.parsing().debug(string);
    }

    public static void poolVerbose(String string) {
        Debug.poolverbose().debug(string);
    }

    public static void pooling(String string) {
        Debug.pooling().debug(string);
    }

    public static void raLifecycle(String string) {
        Debug.ralifecycle().debug(string);
    }

    public static void securityCtx(String string) {
        Debug.securityctx().debug(string);
    }

    public static void service(String string) {
        Debug.service().debug(string);
    }

    public static void work(String string) {
        Debug.work().debug(string);
    }

    public static void workEvent(String string) {
        Debug.workevents().debug(string);
    }

    public static void xaIn(String string) {
        Debug.xain().debug(string);
    }

    public static void xaOut(String string) {
        Debug.xaout().debug(string);
    }

    public static void xaWork(String string) {
        Debug.xawork().debug(string);
    }

    public static void classloading(String string) {
        Debug.classloading().debug(string);
    }

    public static void localOut(ConnectionPool connectionPool, String string) {
        if (Debug.isLocalOutEnabled()) {
            Debug.localOut("For pool '" + (connectionPool != null ? connectionPool.getName() : "<null>") + "' " + string);
        }
    }

    public static void xaOut(ConnectionPool connectionPool, String string) {
        if (Debug.isXAoutEnabled()) {
            Debug.xaOut("For pool '" + (connectionPool != null ? connectionPool.getName() : "<null>") + "' " + string);
        }
    }

    public static void enter(Object object, String string) {
        if (verbose || Debug.getVerbose(object)) {
            logger.debug(Debug.spaces() + Debug.getClassName(object) + "." + string + " entered: " + (object != null ? object.toString() : WHITE_SPACE));
            ++indentLevel;
        }
    }

    public static void enter(String string) {
        if (verbose) {
            logger.debug(Debug.spaces() + string + "() entered. ");
            ++indentLevel;
        }
    }

    public static void exit(Object object, String string) {
        if (verbose || Debug.getVerbose(object)) {
            --indentLevel;
            logger.debug(Debug.spaces() + Debug.getClassName(object) + "." + string + " exiting: " + (object != null ? object.toString() : WHITE_SPACE));
        }
    }

    public static void exit(String string) {
        if (verbose) {
            --indentLevel;
            logger.debug(Debug.spaces() + string + "() exiting. ");
        }
    }

    public static void println(Object object, String string) {
        if (verbose || Debug.getVerbose(object)) {
            logger.debug(Debug.spaces() + Debug.getClassName(object) + string);
        }
    }

    public static void println(String string) {
        if (verbose) {
            logger.debug(Debug.spaces() + string);
        }
    }

    public static void printHashtable(Object object, String string, String string2, Hashtable hashtable) {
        if (verbose || Debug.getVerbose(object)) {
            logger.debug(Debug.hashtableToString(object, string, string2, hashtable));
        }
    }

    public static String hashtableToString(Object object, String string, String string2, Hashtable hashtable) {
        String string3 = WHITE_SPACE;
        string3 = object != null ? Debug.getClassName(object) + string : string;
        String string4 = string3 + " Hashtable " + string2 + " =\n";
        if (hashtable == null) {
            return string4 + string3 + " Hashtable " + string2 + " is null ";
        }
        if (hashtable.isEmpty()) {
            return string4 + string3 + " Hashtable " + string2 + " is EMPTY ";
        }
        return string4 + string3 + " Hashtable " + string2 + " has " + hashtable.size() + " entries.\n" + string3 + " Hashtable " + string2 + " = " + hashtable.toString();
    }

    public static void showClassLoaders(Object object, Object object2) {
        if (verbose) {
            String string = null;
            if (object2 != null) {
                try {
                    string = object2.toString();
                }
                catch (Throwable throwable) {
                    string = "obj.toString() threw " + throwable;
                }
            }
            Debug.println("Classloaders for object " + string + ":");
            Debug.showClassLoaderTree("\t", object2.getClass().getClassLoader());
            if (object != null) {
                Debug.showClassLoaderTree("\tCaller's classloader = ", object.getClass().getClassLoader());
            }
            Debug.showClassLoaderTree("\tSystem classloader = ", ClassLoader.getSystemClassLoader());
            Debug.showClassLoaderTree("\tThread context classloader = ", Thread.currentThread().getContextClassLoader());
        }
    }

    public static void showClassLoaderTree(String string, ClassLoader classLoader) {
        String string2 = WHITE_SPACE;
        String string3 = WHITE_SPACE;
        Debug.println(string);
        while (classLoader != null) {
            Debug.println(string2 + string3 + classLoader);
            string2 = string2 + "\t";
            string3 = "parent: ";
            classLoader = classLoader.getParent();
        }
    }

    public static void assertion(boolean bl, String string) {
        if (!bl) {
            Debug.throwAssertionError(string);
        }
    }

    public static String logJarFileProcessingError(Exception exception) {
        return ConnectorLogger.logJarFileProcessingError((Throwable)exception);
    }

    public static String logStackTrace(String string, Throwable throwable) {
        return ConnectorLogger.logStackTrace((String)string, (Throwable)throwable);
    }

    public static String logStackTraceString(String string, String string2) {
        return ConnectorLogger.logStackTraceString((String)string, (String)string2);
    }

    public static String logConnectorServiceShutdownError(String string) {
        return ConnectorLogger.logConnectorServiceShutdownError((String)string);
    }

    public static String logConnectorServiceInitializing() {
        return ConnectorLogger.logConnectorServiceInitializing();
    }

    public static String logConnectorServiceInitError(String string) {
        return ConnectorLogger.logConnectorServiceInitError((String)string);
    }

    public static String logConnectorServiceInitialized() {
        return ConnectorLogger.logConnectorServiceInitialized();
    }

    public static String logDeprecationReplacedWarning(String string, String string2) {
        return ConnectorLogger.logDeprecationReplacedWarning((String)string, (String)string2);
    }

    public static String logDeprecationNotUsedWarning(String string) {
        return ConnectorLogger.logDeprecationNotUsedWarning((String)string);
    }

    public static String logDeprecatedLinkref(String string) {
        return ConnectorLogger.logDeprecatedLinkref((String)string);
    }

    public static String logJNDINameAlreadyExists(String string) {
        return ConnectorLogger.logJNDINameAlreadyExists((String)string);
    }

    public static String logRarMarkedForLateDeployment(String string) {
        return ConnectorLogger.logRarMarkedForLateDeployment((String)string);
    }

    public static String logCreateCFforMCFError(String string, ResourceException resourceException) {
        return ConnectorLogger.logCreateCFforMCFError((String)string, (Throwable)resourceException);
    }

    public static String logCreateInitialConnectionsError(String string, String string2) {
        return ConnectorLogger.logCreateInitialConnectionsError((String)string, (String)string2);
    }

    public static String logInitConnRTMBeanError(String string, String string2) {
        return ConnectorLogger.logInitConnRTMBeanError((String)string, (String)string2);
    }

    public static String logUnregisterConnRTMBeanError(String string, String string2) {
        return ConnectorLogger.logUnregisterConnRTMBeanError((String)string, (String)string2);
    }

    public static String logInitCPRTMBeanError(String string, String string2) {
        return ConnectorLogger.logInitCPRTMBeanError((String)string, (String)string2);
    }

    public static String logUnregisterCPRTMBeanError(String string, String string2) {
        return ConnectorLogger.logUnregisterCPRTMBeanError((String)string, (String)string2);
    }

    public static String logProxyTestError(String string, Throwable throwable) {
        return ConnectorLogger.logProxyTestError((String)string, (Throwable)throwable);
    }

    public static String logProxyTestFailureInfo(String string, String string2) {
        return ConnectorLogger.logProxyTestFailureInfo((String)string, (String)string2);
    }

    public static String logProxyTestStarted(String string) {
        return ConnectorLogger.logProxyTestStarted((String)string);
    }

    public static String logProxyTestSuccess(String string) {
        return ConnectorLogger.logProxyTestSuccess((String)string);
    }

    public static String logReReleasingResource(String string) {
        return ConnectorLogger.logReReleasingResource((String)string);
    }

    public static String logSetLogWriterError(String string) {
        return ConnectorLogger.logSetLogWriterError((String)string);
    }

    public static String logSetLogWriterErrorWithCause(String string, String string2, String string3) {
        return ConnectorLogger.logSetLogWriterErrorWithCause((String)string, (String)string2, (String)string3);
    }

    public static String logFindLogWriterError(String string, String string2) {
        return ConnectorLogger.logFindLogWriterError((String)string, (String)string2);
    }

    public static String logCreateManagedConnectionException(String string, String string2) {
        return ConnectorLogger.logCreateManagedConnectionException((String)string, (String)string2);
    }

    public static String logCreateManagedConnectionError(String string) {
        return ConnectorLogger.logCreateManagedConnectionError((String)string);
    }

    public static String logCloseConnectionError(String string, ConnectionInfo connectionInfo, String string2, Throwable throwable) {
        return ConnectorLogger.logCloseConnectionError((String)string, (String)(connectionInfo == null ? "[null]" : connectionInfo.toString()), (String)string2, (Throwable)throwable);
    }

    public static String logCloseNotFoundOnHandle(String string) {
        return ConnectorLogger.logCloseNotFoundOnHandle((String)string);
    }

    public static String logConnectionAlreadyClosed(String string) {
        return ConnectorLogger.logConnectionAlreadyClosed((String)string);
    }

    public static String logAccessDeniedWarning(String string, String string2, String string3, String string4) {
        return ConnectorLogger.logAccessDeniedWarning((String)string, (String)string2, (String)string3, (String)string4);
    }

    public static String logNoConnectionRequestInfo() {
        return ConnectorLogger.logNoConnectionRequestInfo();
    }

    public static String logNoResourcePrincipalFound() {
        return ConnectorLogger.logNoResourcePrincipalFound();
    }

    public static String logRequestedSecurityType(String string, String string2) {
        return ConnectorLogger.logRequestedSecurityType((String)string, (String)string2);
    }

    public static String logContextProcessingError(NamingException namingException) {
        return ConnectorLogger.logContextProcessingError((Throwable)namingException);
    }

    public static String logMCFNotFoundForJNDIName(String string) {
        return ConnectorLogger.logMCFNotFoundForJNDIName((String)string);
    }

    public static String logCreateCFReturnedNull(String string) {
        return ConnectorLogger.logCreateCFReturnedNull((String)string);
    }

    public static String logGetLocalTransactionError(String string, String string2) {
        return ConnectorLogger.logGetLocalTransactionError((String)string, (String)string2);
    }

    public static String logRegisterNonXAResourceError(String string, String string2) {
        return ConnectorLogger.logRegisterNonXAResourceError((String)string, (String)string2);
    }

    public static String logGetXAResourceError(String string, String string2) {
        return ConnectorLogger.logGetXAResourceError((String)string, (String)string2);
    }

    public static String logRegisterXAResourceError(String string, String string2) {
        return ConnectorLogger.logRegisterXAResourceError((String)string, (String)string2);
    }

    public static String logInvokeMethodError(String string, String string2, String string3) {
        return ConnectorLogger.logInvokeMethodError((String)string, (String)string2, (String)string3);
    }

    public static String logDiagImageUnregisterFailure(Throwable throwable) {
        return ConnectorLogger.logDiagImageUnregisterFailure((Throwable)throwable);
    }

    public static String logDiagImageRegisterFailure(Throwable throwable) {
        return ConnectorLogger.logDiagImageRegisterFailure((Throwable)throwable);
    }

    public static String logConfigPropWarning(String string, String string2, String string3) {
        return ConnectorLogger.logConfigPropWarning((String)string, (String)string2, (String)string3);
    }

    public static String logGetAnonymousSubjectFailed() {
        return ConnectorLogger.logGetAnonymousSubjectFailed();
    }

    public static String logFailedToFindModuleRuntimeMBean(String string) {
        return ConnectorLogger.logFailedToFindModuleRuntimeMBean((String)string);
    }

    public static String logFailedToUnregisterModuleRuntimeMBean(String string) {
        return ConnectorLogger.logFailedToUnregisterModuleRuntimeMBean((String)string);
    }

    public static String logInitJndiSubcontextsFailed(String string, String string2) {
        return ConnectorLogger.logInitJndiSubcontextsFailed((String)string, (String)string2);
    }

    public static String logExtractingNativeLib(String string, String string2) {
        return ConnectorLogger.logExtractingNativeLib((String)string, (String)string2);
    }

    public static String logTimerWarning() {
        return ConnectorLogger.logTimerWarning();
    }

    public static String logInvalidDye(String string, String string2) {
        return ConnectorLogger.logInvalidDye((String)string, (String)string2);
    }

    public static String logRegisterForXARecoveryFailed(String string) {
        return ConnectorLogger.logRegisterForXARecoveryFailed((String)string);
    }

    public static String logUnregisterForXARecoveryFailed(String string) {
        return ConnectorLogger.logUnregisterForXARecoveryFailed((String)string);
    }

    public static String logFailedToApplyPoolChanges(String string) {
        return ConnectorLogger.logFailedToApplyPoolChanges((String)string);
    }

    public static String logMCFNotImplementResourceAdapterAssociation(String string) {
        return ConnectorLogger.logMCFNotImplementResourceAdapterAssociation((String)string);
    }

    public static String logInvalidRecoveryEvent(String string) {
        return ConnectorLogger.logInvalidRecoveryEvent((String)string);
    }

    public static String logCleanupFailure(String string) {
        return ConnectorLogger.logCleanupFailure((String)string);
    }

    public static String logConnectionError(String string) {
        return ConnectorLogger.logConnectionError((String)string);
    }

    public static String logDestroyFailed(String string) {
        return ConnectorLogger.logDestroyFailed((String)string);
    }

    public static String logNullXAResource() {
        return ConnectorLogger.logNullXAResource();
    }

    public static String logDissociateHandlesFailed(String string, String string2) {
        return ConnectorLogger.logDissociateHandlesFailed((String)string, (String)string2);
    }

    public static String logLazyEnlistNullMC() {
        return ConnectorLogger.logLazyEnlistNullMC();
    }

    public static String logRequestedSharingScope(String string, String string2) {
        return ConnectorLogger.logRequestedSharingScope((String)string, (String)string2);
    }

    public static String logFailedToDeployLinkRef(String string, String string2, String string3) {
        return ConnectorLogger.logFailedToDeployLinkRef((String)string, (String)string2, (String)string3);
    }

    public static String logAssertionError(String string, Throwable throwable) {
        return ConnectorLogger.logAssertionError((String)string, (Throwable)throwable);
    }

    public static String logPoolProfilingRecord(ProfileDataRecord profileDataRecord) {
        return ConnectorLogger.logPoolProfilingRecord((String)profileDataRecord.getPoolName(), (String)profileDataRecord.getType(), (String)profileDataRecord.getTimestamp(), (String)profileDataRecord.getPropertiesString());
    }

    public static String logPropertyVetoWarning(String string, String string2, String string3, String string4, String string5) {
        return ConnectorLogger.logPropertyVetoWarning((String)string, (String)string2, (String)string3, (String)string4, (String)string5);
    }

    public static String logNoAdapterJNDInameSetForInboundRA(String string, String string2) {
        return ConnectorLogger.logNoAdapterJNDInameSetForInboundRA((String)string, (String)string2);
    }

    public static String logDiagnosticImageTimedOut() {
        return ConnectorLogger.logDiagnosticImageTimedOut();
    }

    public static String logBuildOutboundFailed(String string) {
        return ConnectorLogger.logBuildOutboundFailed((String)string);
    }

    public static String logCreateInboundRuntimeMBeanFailed(String string, String string2) {
        return ConnectorLogger.logCreateInboundRuntimeMBeanFailed((String)string, (String)string2);
    }

    public static String logFailedToCloseLog(String string, String string2) {
        return ConnectorLogger.logFailedToCloseLog((String)string, (String)string2);
    }

    public static String logFailedToCreateLogStream(String string, String string2) {
        return ConnectorLogger.logFailedToCreateLogStream((String)string, (String)string2);
    }

    public static String logSecurityPrincipalMapNotAllowed() {
        return ConnectorLogger.logSecurityPrincipalMapNotAllowed();
    }

    public static String logComplianceRAConfigurationException(String string) {
        return ConnectorLogger.logComplianceRAConfigurationException((String)string);
    }

    public static String logComplianceWLRAConfigurationException(String string) {
        return ConnectorLogger.logComplianceWLRAConfigurationException((String)string);
    }

    public static String logNoComplianceErrors(String string) {
        return ConnectorLogger.logNoComplianceErrors((String)string);
    }

    public static String logNumComplianceErrorsAndWarnings(String string, int n, int n2) {
        return ConnectorLogger.logNumComplianceErrorsAndWarnings((String)string, (int)n, (int)n2);
    }

    public static String logComplianceWarnings(String string, String string2) {
        return ConnectorLogger.logComplianceWarnings((String)string, (String)string2);
    }

    public static String logComplianceIsLinkRef(String string) {
        return ConnectorLogger.logComplianceIsLinkRef((String)string);
    }

    public static String getStringAnonymousUser() {
        return ConnectorLogger.getStringAnonymousUserLoggable().getMessageText();
    }

    public static String getStringCloseCount() {
        return ConnectorLogger.getStringCloseCountLoggable().getMessageText();
    }

    public static String getStringCreateCount() {
        return ConnectorLogger.getStringCreateCountLoggable().getMessageText();
    }

    public static String getStringFreePoolSize() {
        return ConnectorLogger.getStringFreePoolSizeLoggable().getMessageText();
    }

    public static String getStringPoolSize() {
        return ConnectorLogger.getStringPoolSizeLoggable().getMessageText();
    }

    public static String getStringWaitingThreadCount() {
        return ConnectorLogger.getStringWaitingThreadCountLoggable().getMessageText();
    }

    public static String getStringCloseCountDescription() {
        return ConnectorLogger.getStringCloseCountLoggable().getMessageText();
    }

    public static String getStringCreateCountDescription() {
        return ConnectorLogger.getStringCreateCountDescriptionLoggable().getMessageText();
    }

    public static String getStringFreePoolSizeDescription() {
        return ConnectorLogger.getStringFreePoolSizeDescriptionLoggable().getMessageText();
    }

    public static String getStringPoolSizeDescription() {
        return ConnectorLogger.getStringPoolSizeDescriptionLoggable().getMessageText();
    }

    public static String getStringWaitingThreadCountDescription() {
        return ConnectorLogger.getStringWaitingThreadCountDescriptionLoggable().getMessageText();
    }

    public static String getStringNever() {
        return ConnectorLogger.getStringNeverLoggable().getMessageText();
    }

    public static String getStringUnavailable() {
        return ConnectorLogger.getStringUnavailableLoggable().getMessageText();
    }

    public static String getStringRunning() {
        return ConnectorLogger.getStringRunningLoggable().getMessageText();
    }

    public static String getStringSuspended() {
        return ConnectorLogger.getStringSuspendedLoggable().getMessageText();
    }

    public static String getStringNew() {
        return ConnectorLogger.getStringNewLoggable().getMessageText();
    }

    public static String getStringInitialized() {
        return ConnectorLogger.getStringInitializedLoggable().getMessageText();
    }

    public static String getStringPrepared() {
        return ConnectorLogger.getStringPreparedLoggable().getMessageText();
    }

    public static String getStringActivated() {
        return ConnectorLogger.getStringActivatedLoggable().getMessageText();
    }

    public static String getStringUnknown() {
        return ConnectorLogger.getStringUnknownLoggable().getMessageText();
    }

    public static String getExceptionRANewInstanceFailed(String string, String string2) {
        return ConnectorLogger.getExceptionRANewInstanceFailedLoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionImageSourceCreation(String string) {
        return ConnectorLogger.getExceptionImageSourceCreationLoggable((String)string).getMessageText();
    }

    public static String getExceptionPrepareUninitializedRA() {
        return ConnectorLogger.getExceptionPrepareUninitializedRALoggable().getMessageText();
    }

    public static String getExceptionActivateUnpreparedRA(String string) {
        return ConnectorLogger.getExceptionActivateUnpreparedRALoggable((String)string).getMessageText();
    }

    public static String getExceptionActivateSuspendedRA(String string) {
        return ConnectorLogger.getExceptionActivateSuspendedRALoggable((String)string).getMessageText();
    }

    public static String getExceptionRollbackActivatedRA() {
        return ConnectorLogger.getExceptionRollbackActivatedRALoggable().getMessageText();
    }

    public static String getExceptionCreateNativeLib() {
        return ConnectorLogger.getExceptionCreateNativeLibLoggable().getMessageText();
    }

    public static String getExceptionBadRAClassSpec(String string, String string2) {
        return ConnectorLogger.getExceptionBadRAClassSpecLoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionBadMCFClassSpec(String string, String string2) {
        return ConnectorLogger.getExceptionBadMCFClassSpecLoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionAdapterNotVersionable() {
        return ConnectorLogger.getExceptionAdapterNotVersionableLoggable().getMessageText();
    }

    public static String getExceptionPopulateWorkManager() {
        return ConnectorLogger.getExceptionPopulateWorkManagerLoggable().getMessageText();
    }

    public static String getExceptionStartRA(String string, String string2) {
        return ConnectorLogger.getExceptionStartRALoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionCreateBootstrap(String string, String string2) {
        return ConnectorLogger.getExceptionCreateBootstrapLoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionVersionRA() {
        return ConnectorLogger.getExceptionVersionRALoggable().getMessageText();
    }

    public static String getExceptionWorkRuntimer() {
        return ConnectorLogger.getExceptionWorkRuntimerLoggable().getMessageText();
    }

    public static String getExceptionIntrospectProperties(String string) {
        return ConnectorLogger.getExceptionIntrospectPropertiesLoggable((String)string).getMessageText();
    }

    public static String getExceptionSetterNotFound(String string) {
        return ConnectorLogger.getExceptionSetterNotFoundLoggable((String)string).getMessageText();
    }

    public static String getExceptionInvokeSetter(String string) {
        return ConnectorLogger.getExceptionInvokeSetterLoggable((String)string).getMessageText();
    }

    public static String getExceptionBadPropertyType(String string) {
        return ConnectorLogger.getExceptionBadPropertyTypeLoggable((String)string).getMessageText();
    }

    public static String getExceptionPropertyValueTypeMismatch(String string, String string2, String string3, String string4) {
        return ConnectorLogger.getExceptionPropertyValueTypeMismatchLoggable((String)string, (String)string2, (String)string3, (String)string4).getMessageText();
    }

    public static String getExceptionLoginException(String string, String string2, String string3) {
        return ConnectorLogger.getExceptionLoginExceptionLoggable((String)string, (String)string2, (String)string3).getMessageText();
    }

    public static String getExceptionInitialCapacityMustBePositive() {
        return ConnectorLogger.getExceptionInitialCapacityMustBePositiveLoggable().getMessageText();
    }

    public static String getExceptionMaxCapacityZero() {
        return ConnectorLogger.getExceptionMaxCapacityZeroLoggable().getMessageText();
    }

    public static String getExceptionMaxCapacityNegative() {
        return ConnectorLogger.getExceptionMaxCapacityNegativeLoggable().getMessageText();
    }

    public static String getExceptionMaxCapacityLessThanInitialCapacity(String string) {
        return ConnectorLogger.getExceptionMaxCapacityLessThanInitialCapacityLoggable((String)string).getMessageText();
    }

    public static String getExceptionMaxCapacityIncrementMustBePositive() {
        return ConnectorLogger.getExceptionMaxCapacityIncrementMustBePositiveLoggable().getMessageText();
    }

    public static String getExceptionMaxCapacityTooHigh(String string) {
        return ConnectorLogger.getExceptionMaxCapacityTooHighLoggable((String)string).getMessageText();
    }

    public static String getExceptionShrinkFrequencySecondsMustBePositive() {
        return ConnectorLogger.getExceptionShrinkFrequencySecondsMustBePositiveLoggable().getMessageText();
    }

    public static String getExceptionInactiveConnectionTimeoutSecondsNegative() {
        return ConnectorLogger.getExceptionInactiveConnectionTimeoutSecondsNegativeLoggable().getMessageText();
    }

    public static String getExceptionNoDescriptorOrAltDD() {
        return ConnectorLogger.getExceptionNoDescriptorOrAltDDLoggable().getMessageText();
    }

    public static String getExceptionNoDescriptor() {
        return ConnectorLogger.getExceptionNoDescriptorLoggable().getMessageText();
    }

    public static String getExceptionMissingSchema() {
        return ConnectorLogger.getExceptionMissingSchemaLoggable().getMessageText();
    }

    public static String getExceptionNoComponents(String string) {
        return ConnectorLogger.getExceptionNoComponentsLoggable((String)string).getMessageText();
    }

    public static String getExceptionMoreThanOneComponent(String string) {
        return ConnectorLogger.getExceptionMoreThanOneComponentLoggable((String)string).getMessageText();
    }

    public static String getExceptionRollbackModuleFailed(String string) {
        return ConnectorLogger.getExceptionRollbackModuleFailedLoggable((String)string).getMessageText();
    }

    public static String getExceptionCreateRuntimeMBeanForConnectorModuleFailed(String string, String string2) {
        return ConnectorLogger.getExceptionCreateRuntimeMBeanForConnectorModuleFailedLoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionCloseVJarFailed(String string, String string2) {
        return ConnectorLogger.getExceptionCloseVJarFailedLoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionCreateVJarFailed(String string, String string2) {
        return ConnectorLogger.getExceptionCreateVJarFailedLoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionInitializeJndiSubcontextsFailed(String string, String string2) {
        return ConnectorLogger.getExceptionInitializeJndiSubcontextsFailedLoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionPrepareUpdateFailed(String string, String string2) {
        return ConnectorLogger.getExceptionPrepareUpdateFailedLoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionJndiNameNull() {
        return ConnectorLogger.getExceptionJndiNameNullLoggable().getMessageText();
    }

    public static String getExceptionNoInitialContextForJndi() {
        return ConnectorLogger.getExceptionNoInitialContextForJndiLoggable().getMessageText();
    }

    public static String getExceptionResourceLinkNull() {
        return ConnectorLogger.getExceptionResourceLinkNullLoggable().getMessageText();
    }

    public static String getExceptionNoInitialContextForResourceLink() {
        return ConnectorLogger.getExceptionNoInitialContextForResourceLinkLoggable().getMessageText();
    }

    public static String getExceptionJndiNameAlreadyBound(String string) {
        return ConnectorLogger.getExceptionAlreadyDeployedLoggable((String)string).getMessageText();
    }

    public static String getExceptionAlreadyDeployed(String string) {
        return ConnectorLogger.getExceptionAlreadyDeployedLoggable((String)string).getMessageText();
    }

    public static String getExceptionBindingFailed(String string, String string2) {
        return ConnectorLogger.getExceptionBindingFailedLoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionUnbindFailed(String string, String string2) {
        return ConnectorLogger.getExceptionUnbindFailedLoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionNoInitialContextForUnbind(String string) {
        return ConnectorLogger.getExceptionNoInitialContextForUnbindLoggable((String)string).getMessageText();
    }

    public static String getExceptionResourceLinkAlreadyBound(String string) {
        return ConnectorLogger.getExceptionResourceLinkAlreadyBoundLoggable((String)string).getMessageText();
    }

    public static String getExceptionAppScopedBindFailed(String string, String string2, String string3) {
        return ConnectorLogger.getExceptionAppScopedBindFailedLoggable((String)string, (String)string2, (String)string3).getMessageText();
    }

    public static String getExceptionUnbindAdminObjectFailed(String string) {
        return ConnectorLogger.getExceptionUnbindAdminObjectFailedLoggable((String)string).getMessageText();
    }

    public static String getExceptionGetConnectionFactoryFailed(String string) {
        return ConnectorLogger.getExceptionGetConnectionFactoryFailedLoggable((String)string).getMessageText();
    }

    public static String getExceptionRANotDeployed(String string) {
        return ConnectorLogger.getExceptionRANotDeployedLoggable((String)string).getMessageText();
    }

    public static String getExceptionInitializeActivationSpecFailed(String string) {
        return ConnectorLogger.getExceptionInitializeActivationSpecFailedLoggable((String)string).getMessageText();
    }

    public static String getExceptionInstantiateClassFailed(String string, String string2) {
        return ConnectorLogger.getExceptionInstantiateClassFailedLoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionBadValue(String string, String string2, String string3) {
        return ConnectorLogger.getExceptionBadValueLoggable((String)string, (String)string2, (String)string3).getMessageText();
    }

    public static String getExceptionRANotActive(String string) {
        return ConnectorLogger.getExceptionRANotActiveLoggable((String)string).getMessageText();
    }

    public static String getExceptionRANotFound(String string) {
        return ConnectorLogger.getExceptionRANotFoundLoggable((String)string).getMessageText();
    }

    public static String getExceptionNoMessageListener(String string, String string2) {
        return ConnectorLogger.getExceptionNoMessageListenerLoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionMissingRequiredProperty(String string) {
        return ConnectorLogger.getExceptionMissingRequiredPropertyLoggable((String)string).getMessageText();
    }

    public static String getExceptionNoInboundRAElement() {
        return ConnectorLogger.getExceptionNoInboundRAElementLoggable().getMessageText();
    }

    public static String getExceptionNoMessageAdapterElement() {
        return ConnectorLogger.getExceptionNoMessageAdapterElementLoggable().getMessageText();
    }

    public static String getExceptionNoMessageListenerElement() {
        return ConnectorLogger.getExceptionNoMessageListenerElementLoggable().getMessageText();
    }

    public static String getExceptionAssertionError(String string) {
        return ConnectorLogger.getExceptionAssertionErrorLoggable((String)string).getMessageText();
    }

    public static String getExceptionSetDyeBitsFailedDiagCtxNotEnabled() {
        return ConnectorLogger.getExceptionSetDyeBitsFailedDiagCtxNotEnabledLoggable().getMessageText();
    }

    public static String getExceptionInvalidDyeValue(String string) {
        return ConnectorLogger.getExceptionInvalidDyeValueLoggable((String)string).getMessageText();
    }

    public static String getExceptionFailedToGetDiagCtx(String string) {
        return ConnectorLogger.getExceptionFailedToGetDiagCtxLoggable((String)string).getMessageText();
    }

    public static String getExceptionGetDyeBitsFailedDiagCtxNotEnabled() {
        return ConnectorLogger.getExceptionGetDyeBitsFailedDiagCtxNotEnabledLoggable().getMessageText();
    }

    public static String getExceptionInvalidDye(String string, String string2) {
        return ConnectorLogger.getExceptionInvalidDyeLoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionCannotDeleteConnection() {
        return ConnectorLogger.getExceptionCannotDeleteConnectionLoggable().getMessageText();
    }

    public static String getExceptionEnlistmentFailed(String string, String string2) {
        return ConnectorLogger.getExceptionEnlistmentFailedLoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionMCGetXAResourceReturnedNull() {
        return ConnectorLogger.getExceptionMCGetXAResourceReturnedNullLoggable().getMessageText();
    }

    public static String getExceptionMCGetXAResourceThrewNonResourceException(String string) {
        return ConnectorLogger.getExceptionMCGetXAResourceThrewNonResourceExceptionLoggable((String)string).getMessageText();
    }

    public static String getExceptionMCFCreateManagedConnectionReturnedNull() {
        return ConnectorLogger.getExceptionMCFCreateManagedConnectionReturnedNullLoggable().getMessageText();
    }

    public static String getExceptionInitializeForRecoveryFailed(String string) {
        return ConnectorLogger.getExceptionInitializeForRecoveryFailedLoggable((String)string).getMessageText();
    }

    public static String getExceptionEnlistResourceIllegalType() {
        return ConnectorLogger.getExceptionEnlistResourceIllegalTypeLoggable().getMessageText();
    }

    public static String getExceptionRegisterResourceIllegalType(String string) {
        return ConnectorLogger.getExceptionRegisterResourceIllegalTypeLoggable((String)string).getMessageText();
    }

    public static String getExceptionXAStartInLocalTxIllegal() {
        return ConnectorLogger.getExceptionXAStartInLocalTxIllegalLoggable().getMessageText();
    }

    public static String getExceptionMCGetLocalTransactionThrewNonResourceException(String string, String string2) {
        return ConnectorLogger.getExceptionMCGetLocalTransactionThrewNonResourceExceptionLoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionMCGetLocalTransactionReturnedNull(String string) {
        return ConnectorLogger.getExceptionMCGetLocalTransactionReturnedNullLoggable((String)string).getMessageText();
    }

    public static String getExceptionRegisterNonXAFailed(String string) {
        return ConnectorLogger.getExceptionRegisterNonXAFailedLoggable((String)string).getMessageText();
    }

    public static String getExceptionCommitFailed(String string, String string2) {
        return ConnectorLogger.getExceptionCommitFailedLoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionRollbackFailed(String string, String string2) {
        return ConnectorLogger.getExceptionRollbackFailedLoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionCreateMCFailed(String string) {
        return ConnectorLogger.getExceptionCreateMCFailedLoggable((String)string).getMessageText();
    }

    public static String getExceptionFailedMCSetup() {
        return ConnectorLogger.getExceptionFailedMCSetupLoggable().getMessageText();
    }

    public static String getExceptionObjectIdNull() {
        return ConnectorLogger.getExceptionObjectIdNullLoggable().getMessageText();
    }

    public static String getExceptionMCGetConnectionReturnedNull(String string) {
        return ConnectorLogger.getExceptionMCGetConnectionReturnedNullLoggable((String)string).getMessageText();
    }

    public static String getExceptionDuplicateHandle() {
        return ConnectorLogger.getExceptionDuplicateHandleLoggable().getMessageText();
    }

    public static String getExceptionTestResourceException(String string) {
        return ConnectorLogger.getExceptionTestResourceExceptionLoggable((String)string).getMessageText();
    }

    public static String getExceptionTestNonResourceException(String string) {
        return ConnectorLogger.getExceptionTestNonResourceExceptionLoggable((String)string).getMessageText();
    }

    public static String getExceptionMCFNotImplementValidatingMCF() {
        return ConnectorLogger.getExceptionMCFNotImplementValidatingMCFLoggable().getMessageText();
    }

    public static String getLazyEnlistNullMC(String string) {
        return ConnectorLogger.getLazyEnlistNullMCLoggable((String)string).getMessageText();
    }

    public static String getExceptionRAAccessDenied(String string) {
        return ConnectorLogger.getExceptionRAAccessDeniedLoggable((String)string).getMessageText();
    }

    public static String getExceptionGetConnectionFailed(String string, String string2) {
        return ConnectorLogger.getExceptionGetConnectionFailedLoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionPoolDisabled(String string) {
        return ConnectorLogger.getExceptionPoolDisabledLoggable((String)string).getMessageText();
    }

    public static String getExceptionMCFCreateCFReturnedNull() {
        return ConnectorLogger.getExceptionMCFCreateCFReturnedNullLoggable().getMessageText();
    }

    public static String getExceptionStackTrace() {
        return ConnectorLogger.getExceptionStackTraceLoggable().getMessageText();
    }

    public static String getExceptionLocalTxNotSupported() {
        return ConnectorLogger.getExceptionLocalTxNotSupportedLoggable().getMessageText();
    }

    public static String getExceptionHandleNotSet() {
        return ConnectorLogger.getExceptionHandleNotSetLoggable().getMessageText();
    }

    public static String getExceptionOutboundPrepareFailed(String string, String string2) {
        return ConnectorLogger.getExceptionOutboundPrepareFailedLoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionResumePoolFailed(String string) {
        return ConnectorLogger.getExceptionResumePoolFailedLoggable((String)string).getMessageText();
    }

    public static String getExceptionActivatePoolFailed(String string) {
        return ConnectorLogger.getExceptionActivatePoolFailedLoggable((String)string).getMessageText();
    }

    public static String getExceptionJndiBindFailed(String string, String string2) {
        return ConnectorLogger.getExceptionJndiBindFailedLoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionDeactivateException(String string, String string2, String string3) {
        return ConnectorLogger.getExceptionDeactivateExceptionLoggable((String)string, (String)string2, (String)string3).getMessageText();
    }

    public static String getExceptionShutdownException(String string, String string2, String string3) {
        return ConnectorLogger.getExceptionShutdownExceptionLoggable((String)string, (String)string2, (String)string3).getMessageText();
    }

    public static String getExceptionCFJndiNameDuplicate(String string) {
        return ConnectorLogger.getExceptionCFJndiNameDuplicateLoggable((String)string).getMessageText();
    }

    public static String getExceptionCFResourceLinkDuplicate(String string) {
        return ConnectorLogger.getExceptionCFResourceLinkDuplicateLoggable((String)string).getMessageText();
    }

    public static String getExceptionJndiVerifyFailed(String string, String string2) {
        return ConnectorLogger.getExceptionJndiVerifyFailedLoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionMCFNoImplementResourceAdapterAssociation(String string) {
        return ConnectorLogger.getExceptionMCFNoImplementResourceAdapterAssociationLoggable((String)string).getMessageText();
    }

    public static String getExceptionSetRAClassFailed(String string, String string2) {
        return ConnectorLogger.getExceptionSetRAClassFailedLoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionMCFUnexpectedException(String string, String string2) {
        return ConnectorLogger.getExceptionMCFUnexpectedExceptionLoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionMCFClassNotFound(String string, String string2) {
        return ConnectorLogger.getExceptionMCFClassNotFoundLoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionInstantiateMCFFailed(String string, String string2) {
        return ConnectorLogger.getExceptionInstantiateMCFFailedLoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionAccessMCFFailed(String string, String string2) {
        return ConnectorLogger.getExceptionAccessMCFFailedLoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionGetConnectionFactoryFailedInternalError(String string) {
        return ConnectorLogger.getExceptionGetConnectionFactoryFailedInternalErrorLoggable((String)string).getMessageText();
    }

    public static String getExceptionFailedAccessOutsideApp() {
        return ConnectorLogger.getExceptionFailedAccessOutsideAppLoggable().getMessageText();
    }

    public static String getExceptionNotImplemented(String string, String string2) {
        return ConnectorLogger.getExceptionNotImplementedLoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionMustBeLinkRef() {
        return ConnectorLogger.getExceptionMustBeLinkRefLoggable().getMessageText();
    }

    public static String getExceptionNeedsRAXML() {
        return ConnectorLogger.getExceptionNeedsRAXMLLoggable().getMessageText();
    }

    public static String getExceptionErrorCreatingNativeLibDir(String string) {
        return ConnectorLogger.getExceptionErrorCreatingNativeLibDirLoggable((String)string).getMessageText();
    }

    public static String getExceptionFileNotFoundForNativeLibDir(String string) {
        return ConnectorLogger.getExceptionFileNotFoundForNativeLibDirLoggable((String)string).getMessageText();
    }

    public static String getExceptionExceptionCreatingNativeLibDir(String string, String string2) {
        return ConnectorLogger.getExceptionExceptionCreatingNativeLibDirLoggable((String)string, (String)string2).getMessageText();
    }

    public static String getExceptionStartPoolFailed(String string) {
        return ConnectorLogger.getExceptionStartPoolFailedLoggable((String)string).getMessageText();
    }

    public static String getExceptionTestFrequencyNonZero() {
        return ConnectorLogger.getExceptionTestFrequencyNonZeroLoggable().getMessageText();
    }

    public static String getExceptionInvalidTestingConfig() {
        return ConnectorLogger.getExceptionInvalidTestingConfigLoggable().getMessageText();
    }

    public static String getExceptionWorkIsNull() {
        return ConnectorLogger.getExceptionWorkIsNullLoggable().getMessageText();
    }

    public static String getExceptionDoWorkNotAccepted() {
        return ConnectorLogger.getExceptionDoWorkNotAcceptedLoggable().getMessageText();
    }

    public static String getExceptionWorkManagerSuspended() {
        return ConnectorLogger.getExceptionWorkManagerSuspendedLoggable().getMessageText();
    }

    public static String getExceptionSetExecutionContextFailed(String string) {
        return ConnectorLogger.getExceptionSetExecutionContextFailedLoggable((String)string).getMessageText();
    }

    public static String getExceptionInvalidGid(String string) {
        return ConnectorLogger.getExceptionInvalidGidLoggable((String)string).getMessageText();
    }

    public static String getExceptionGidNotRegistered(String string) {
        return ConnectorLogger.getExceptionGidNotRegisteredLoggable((String)string).getMessageText();
    }

    public static String getExceptionSecurityPrincipalMapNotSupported() {
        return ConnectorLogger.getExceptionSecurityPrincipalMapNotSupportedLoggable().getMessageText();
    }

    public static String getExceptionImportedTxAlreadyActive(String string) {
        return ConnectorLogger.getExceptionImportedTxAlreadyActiveLoggable((String)string).getMessageText();
    }

    public static String getTestConnectionsOnCreateTrue() {
        return ConnectorLogger.getTestConnectionsOnCreateTrue();
    }

    public static String getTestConnectionsOnReleaseTrue() {
        return ConnectorLogger.getTestConnectionsOnReleaseTrue();
    }

    public static String getTestConnectionsOnReserveTrue() {
        return ConnectorLogger.getTestConnectionsOnReserveTrue();
    }

    public static String getFailedToForceLogRotation(String string) {
        return ConnectorLogger.getFailedToForceLogRotation((String)string);
    }

    public static String getFailedToGetCF(String string, String string2) {
        return ConnectorLogger.getFailedToGetCF((String)string, (String)string2);
    }

    public static String getDeploySecurityBumpUpFailed(String string, String string2, String string3) {
        return ConnectorLogger.getDeploySecurityBumpUpFailed((String)string, (String)string2, (String)string3);
    }

    private static String spaces() {
        if (indentLevel > 0) {
            return WHITE_SPACE.substring(0, Math.min(indentLevel * 2, MAX_SPACES));
        }
        return new String();
    }

    public static void setVerbose(boolean bl) {
        verbose = true;
        String string = bl ? "true" : "off";
        Debug.println("___Debug=" + string);
        verbose = bl;
        Properties properties = System.getProperties();
        properties.put("Debug", string);
        System.setProperties(properties);
    }

    public static void setVerbose(String string, boolean bl) {
        boolean bl2 = verbose;
        String string2 = bl ? "true" : "false";
        Properties properties = System.getProperties();
        properties.put("Debug" + string, string2);
        System.setProperties(properties);
        verbose = true;
        Debug.println("___Debug" + string + "=" + string2);
        verbose = bl2;
    }

    public static boolean getVerbose(Object object) {
        Object object2;
        String string = null;
        Object object3 = null;
        if (object instanceof String) {
            object2 = (String)object;
            int n = ((String)object2).lastIndexOf(46);
            if (n == -1) {
                object3 = object2;
            } else {
                string = ((String)object2).substring(0, n);
                object3 = ((String)object2).substring(n + 1);
            }
        } else {
            object3 = object.getClass().getName();
            object2 = object.getClass().getPackage();
            if (object2 != null) {
                string = ((Package)object2).getName();
            }
        }
        object2 = "Debug" + (String)object3;
        if (string != null) {
            String string2 = "Debug" + string;
            return verbose || System.getProperty(string2) != null && !System.getProperty(string2).equalsIgnoreCase("false") || System.getProperty((String)object2) != null && !System.getProperty((String)object2).equalsIgnoreCase("false");
        }
        return verbose || System.getProperty((String)object2) != null && !System.getProperty((String)object2).equalsIgnoreCase("false");
    }

    public static boolean getVerbose() {
        return verbose;
    }

    public static boolean isRALifecycleEnabled() {
        return Debug.ralifecycle().isDebugEnabled();
    }

    public static boolean isPoolVerboseEnabled() {
        return Debug.poolverbose().isDebugEnabled();
    }

    public static boolean isXAinEnabled() {
        return Debug.xain().isDebugEnabled();
    }

    public static boolean isXAoutEnabled() {
        return Debug.xaout().isDebugEnabled();
    }

    public static boolean isXAworkEnabled() {
        return Debug.xawork().isDebugEnabled();
    }

    public static boolean isLocalOutEnabled() {
        return Debug.localout().isDebugEnabled();
    }

    public static boolean isConnectorServiceEnabled() {
        return Debug.service().isDebugEnabled();
    }

    public static boolean isDeploymentEnabled() {
        return Debug.deployment().isDebugEnabled();
    }

    public static boolean isSecurityCtxEnabled() {
        return Debug.securityctx().isDebugEnabled();
    }

    public static boolean isParsingEnabled() {
        return Debug.parsing().isDebugEnabled();
    }

    public static boolean isPoolingEnabled() {
        return Debug.pooling().isDebugEnabled();
    }

    public static boolean isConnectionsEnabled() {
        return Debug.connections().isDebugEnabled();
    }

    public static boolean isConnEventsEnabled() {
        return Debug.connevents().isDebugEnabled();
    }

    public static boolean isWorkEnabled() {
        return Debug.work().isDebugEnabled();
    }

    public static boolean isWorkEventsEnabled() {
        return Debug.workevents().isDebugEnabled();
    }

    public static boolean isClassLoadingEnabled() {
        return Debug.classloading().isDebugEnabled();
    }

    public static void throwAssertionError(String string) {
        String string2 = Debug.getExceptionAssertionError(string);
        AssertionError assertionError = new AssertionError((Object)string2);
        Debug.logAssertionError(string, (Throwable)((Object)assertionError));
        throw assertionError;
    }

    public static void throwAssertionError(String string, Throwable throwable) {
        String string2 = Debug.getExceptionAssertionError(string);
        AssertionError assertionError = new AssertionError((Object)string2);
        ((Throwable)((Object)assertionError)).initCause(throwable);
        Debug.logAssertionError(string, (Throwable)((Object)assertionError));
        throw assertionError;
    }

    private static String getClassName(Object object) {
        String string = null;
        string = object instanceof String ? (String)object : object.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n > -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    static {
        indentLevel = 0;
        logger = new NonCatalogLogger("ConnectorDebug");
        verbose = System.getProperty("weblogic.connector.Debug") != null && !System.getProperty("weblogic.connector.Debug").equalsIgnoreCase("false");
        XAIN_LOGGER = null;
        CONNECTIONS_LOGGER = null;
        CONNEVENTS_LOGGER = null;
        DEPLOYMENT_LOGGER = null;
        LOCALOUT_LOGGER = null;
        PARSING_LOGGER = null;
        POOLING_LOGGER = null;
        POOLVERBOSE_LOGGER = null;
        RALIFECYCLE_LOGGER = null;
        SECURITYCTX_LOGGER = null;
        SERVICE_LOGGER = null;
        WORK_LOGGER = null;
        WORKEVENTS_LOGGER = null;
        XAOUT_LOGGER = null;
        XAWORK_LOGGER = null;
        RACLASSLOADING = null;
    }
}

