/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.common;

import java.util.HashSet;
import weblogic.connector.common.Debug;
import weblogic.j2ee.dd.xml.JCAConnectionFactoryProvider;
import weblogic.j2ee.descriptor.ConnectionDefinitionBean;
import weblogic.j2ee.descriptor.ConnectorBean;
import weblogic.j2ee.descriptor.OutboundResourceAdapterBean;
import weblogic.j2ee.descriptor.ResourceAdapterBean;

public class JCAConnectionFactoryRegistry
extends JCAConnectionFactoryProvider {
    private HashSet<String> connectionFactorySet = new HashSet();
    private static JCAConnectionFactoryRegistry instance = null;

    private JCAConnectionFactoryRegistry() {
    }

    public static synchronized JCAConnectionFactoryRegistry getInstance() {
        if (instance == null) {
            JCAConnectionFactoryRegistry.createInstane();
        }
        return instance;
    }

    public synchronized boolean isAdapterConnectionFactory(String string) {
        return this.connectionFactorySet.contains(string);
    }

    private void registerConnectionFactory(String string) {
        if (!this.connectionFactorySet.contains(string)) {
            this.connectionFactorySet.add(string);
            if (Debug.isDeploymentEnabled()) {
                Debug.deployment("Registering JCA Connection Factory: " + instance);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionFactory(ConnectorBean connectorBean) {
        ConnectionDefinitionBean[] connectionDefinitionBeanArray;
        OutboundResourceAdapterBean outboundResourceAdapterBean;
        ResourceAdapterBean resourceAdapterBean;
        if (connectorBean != null && (resourceAdapterBean = connectorBean.getResourceAdapter()) != null && (outboundResourceAdapterBean = resourceAdapterBean.getOutboundResourceAdapter()) != null && (connectionDefinitionBeanArray = outboundResourceAdapterBean.getConnectionDefinitions()) != null) {
            JCAConnectionFactoryRegistry jCAConnectionFactoryRegistry = this;
            synchronized (jCAConnectionFactoryRegistry) {
                for (ConnectionDefinitionBean connectionDefinitionBean : connectionDefinitionBeanArray) {
                    String string = connectionDefinitionBean.getConnectionFactoryInterface();
                    if (string == null) continue;
                    this.registerConnectionFactory(string.trim());
                }
            }
        }
    }

    private static void createInstane() {
        instance = new JCAConnectionFactoryRegistry();
        if (Debug.isDeploymentEnabled()) {
            Debug.deployment("Registering JCAConnectionFactoryProvider: " + instance);
        }
        JCAConnectionFactoryProvider.set(instance);
    }
}

