/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.common;

import java.security.AccessController;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import weblogic.connector.common.Debug;
import weblogic.connector.common.RAInstanceManager;
import weblogic.connector.deploy.DeployerUtil;
import weblogic.connector.exception.RAException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.classloaders.GenericClassLoader;

public class LinkrefManager {
    private static Hashtable baseRAs = new Hashtable();
    private static Hashtable linkrefRAs = new Hashtable();
    private static final String CLASS_NAME = "weblogic.connector.common.LinkrefManager";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void addBaseRA(RAInstanceManager rAInstanceManager) {
        Debug.enter(CLASS_NAME, "addBaseRA(...)");
        try {
            String string = rAInstanceManager.getRAInfo().getConnectionFactoryName();
            Debug.println(CLASS_NAME, ".addBaseRA() Connection factory name : " + string);
            if (string != null && string.length() > 0) {
                Debug.println(CLASS_NAME, ".addBaseRA() Adding the base RA to the hashtable");
                baseRAs.put(string, rAInstanceManager);
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Debug.exit(CLASS_NAME, "addBaseRA(...)");
            throw throwable;
        }
        Debug.exit(CLASS_NAME, "addBaseRA(...)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized void removeBaseRA(RAInstanceManager rAInstanceManager, RAException rAException) {
        Debug.enter(CLASS_NAME, "removeBaseRA(...)");
        try {
            block4: {
                try {
                    String string = rAInstanceManager.getRAInfo().getConnectionFactoryName();
                    if (string == null || string.length() <= 0) break block4;
                    Debug.println(CLASS_NAME, ".removeBaseRA() Removing base RA with connection factory name : " + string);
                    baseRAs.remove(string);
                }
                catch (Throwable throwable) {
                    rAException.addError(throwable);
                    Object var4_5 = null;
                    Debug.exit(CLASS_NAME, "removeBaseRA(...)");
                    return;
                }
            }
            Object var4_4 = null;
            Debug.exit(CLASS_NAME, "removeBaseRA(...)");
            return;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            Debug.exit(CLASS_NAME, "removeBaseRA(...)");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void addLinkrefRA(RAInstanceManager rAInstanceManager) {
        Debug.enter(CLASS_NAME, "addLinkrefRA(...)");
        try {
            String string = rAInstanceManager.getRAInfo().getLinkref();
            Debug.println(CLASS_NAME, ".addLinkrefRA() Adding linkref with connectionFactory : " + string);
            if (string != null && string.length() > 0) {
                Vector<RAInstanceManager> vector = (Vector<RAInstanceManager>)linkrefRAs.get(string);
                if (vector == null) {
                    Debug.println(CLASS_NAME, ".addLinkrefRA() This is the first linkref RA being added under the connection factory name");
                    vector = new Vector<RAInstanceManager>(10);
                    linkrefRAs.put(string, vector);
                }
                if (!vector.contains(rAInstanceManager)) {
                    Debug.println(CLASS_NAME, ".addLinkrefRA() Adding to the list");
                    vector.add(rAInstanceManager);
                }
            } else {
                Debug.throwAssertionError("The linkref does not have a connection factory defined.");
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Debug.exit(CLASS_NAME, "addLinkrefRA(...)");
            throw throwable;
        }
        Debug.exit(CLASS_NAME, "addLinkrefRA(...)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized void removeLinkrefRA(RAInstanceManager rAInstanceManager, RAException rAException) {
        Debug.enter(CLASS_NAME, "removeLinkrefRA(...)");
        try {
            block6: {
                try {
                    String string = rAInstanceManager.getRAInfo().getLinkref();
                    if (string != null && string.length() > 0) {
                        List list = (List)linkrefRAs.get(string);
                        if (list == null) break block6;
                        list.remove(rAInstanceManager);
                        if (list.size() == 0) {
                            linkrefRAs.remove(string);
                        }
                        break block6;
                    }
                    Debug.throwAssertionError("The connection factory for the linkref has not been specified.");
                }
                catch (Throwable throwable) {
                    rAException.addError(throwable);
                    Object var5_6 = null;
                    Debug.exit(CLASS_NAME, "removeLinkrefRA(...)");
                    return;
                }
            }
            Object var5_5 = null;
            Debug.exit(CLASS_NAME, "removeLinkrefRA(...)");
            return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            Debug.exit(CLASS_NAME, "removeLinkrefRA(...)");
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deployDependentLinkrefs(RAInstanceManager rAInstanceManager) {
        Debug.enter(CLASS_NAME, "deployDependentLinkrefs(...)");
        try {
            String string = rAInstanceManager.getRAInfo().getConnectionFactoryName();
            Debug.println("Connection factory name : " + string);
            if (string != null && string.length() > 0) {
                Debug.println("Get the list of linkrefs waiting to be deployed");
                List list = (List)linkrefRAs.get(string);
                Vector<RAInstanceManager> vector = new Vector<RAInstanceManager>(10);
                Vector<RAInstanceManager> vector2 = new Vector<RAInstanceManager>(10);
                if (list != null) {
                    Debug.println("Number of linkref to be deployed : " + list.size());
                    for (RAInstanceManager rAInstanceManager2 : list) {
                        try {
                            Debug.println("Update the classloader with the base jar");
                            DeployerUtil.updateClassFinder((GenericClassLoader)rAInstanceManager2.getClassloader(), rAInstanceManager.getJarFile(), rAInstanceManager2.getRAInfo().isEnableGlobalAccessToClasses(), rAInstanceManager2.getClassFinders());
                            Debug.println("Update the RAInfo of this linkref with the base raInfo");
                            rAInstanceManager2.getRAInfo().setBaseRA(rAInstanceManager.getRAInfo());
                            Debug.println("Set the late deploy flag to false");
                            rAInstanceManager2.setLateDeploy(false);
                            Debug.println("Initialize the ra");
                            if (Debug.isDeploymentEnabled()) {
                                Debug.deployment("Starting to deploy the link-ref RA module '" + rAInstanceManager2.getModuleName() + "' with base RA module '" + rAInstanceManager.getModuleName() + "'");
                            }
                            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                            rAInstanceManager2.initialize(null, authenticatedSubject);
                            Debug.println("prepare");
                            rAInstanceManager2.prepare();
                            Debug.println("activate");
                            rAInstanceManager2.activate();
                            vector.add(rAInstanceManager2);
                            if (!Debug.isDeploymentEnabled()) continue;
                            Debug.deployment("Succeeded in deploying the link-ref RA module '" + rAInstanceManager2.getModuleName() + "' with base RA module '" + rAInstanceManager.getModuleName() + "'");
                        }
                        catch (Throwable throwable) {
                            vector2.add(rAInstanceManager2);
                            String string2 = Debug.logFailedToDeployLinkRef(rAInstanceManager2.getModuleName(), rAInstanceManager.getModuleName(), throwable.toString());
                            Debug.logStackTrace(string2, throwable);
                            if (!Debug.isDeploymentEnabled()) continue;
                            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                            Debug.deployment("Failed in deploying the link-ref RA module '" + rAInstanceManager2.getModuleName() + "' with base RA module '" + rAInstanceManager.getModuleName() + "'. Caught exception with stack trace:\n" + rAInstanceManager2.getAdapterLayer().throwable2StackTrace(throwable, authenticatedSubject));
                        }
                    }
                    linkrefRAs.remove(string);
                } else {
                    Debug.println("No linkrefs to deploy");
                }
            } else {
                Debug.println("Connection factory name is null or empty. No dependent linkrefs to deploy");
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            Debug.exit(CLASS_NAME, "deployDependentLinkrefs(...)");
            throw throwable;
        }
        Debug.exit(CLASS_NAME, "deployDependentLinkrefs(...)");
    }

    public static synchronized RAInstanceManager getBaseRA(String string) {
        Debug.enter(CLASS_NAME, "getBaseRA(...)");
        RAInstanceManager rAInstanceManager = null;
        if (string != null && string.length() > 0) {
            Debug.println("Trying to get the base RA for connection factory : " + string);
            rAInstanceManager = (RAInstanceManager)baseRAs.get(string);
        }
        Debug.exit(CLASS_NAME, "getBaseRA(...)");
        return rAInstanceManager;
    }
}

