/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.common;

import com.bea.connector.diagnostic.AdapterType;
import com.bea.connector.diagnostic.ConnectorDiagnosticImageDocument;
import com.bea.connector.diagnostic.ConnectorDiagnosticImageType;
import java.security.AccessController;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.resource.spi.ResourceAdapter;
import weblogic.connector.common.ConnectorDiagnosticImageSource;
import weblogic.connector.common.ConnectorService;
import weblogic.connector.common.Debug;
import weblogic.connector.common.RAInstanceManager;
import weblogic.connector.exception.RAException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class RACollectionManager {
    private static final String CLASS_NAME = "weblogic.connector.common.RACollectionManager";
    private static List raList = new Vector(10);
    private static int connectionPoolsTotalCount = 0;

    public static void register(RAInstanceManager rAInstanceManager) {
        raList.add(rAInstanceManager);
        ConnectorService.getConnectorServiceRuntimeMBean().addConnectorRuntime(rAInstanceManager.getConnectorComponentRuntimeMBean());
    }

    public static void unregister(RAInstanceManager rAInstanceManager) {
        raList.remove(rAInstanceManager);
        ConnectorService.getConnectorServiceRuntimeMBean().removeConnectorRuntime(rAInstanceManager.getConnectorComponentRuntimeMBean());
    }

    public static void stop() throws RAException {
        Debug.service("stop() called on RACollectionManager; will stop each RA instance.");
        for (RAInstanceManager rAInstanceManager : raList) {
            rAInstanceManager.stop();
        }
    }

    public static void halt() throws RAException {
        Debug.service("halt() called on RACollectionManager; will halt each RA instance.");
        for (RAInstanceManager rAInstanceManager : raList) {
            rAInstanceManager.halt();
        }
    }

    public static void start() throws RAException {
        Debug.service("start() called on RACollectionManager; no actions to perform.");
    }

    public static void updateCounts(RAInstanceManager rAInstanceManager) {
        connectionPoolsTotalCount = rAInstanceManager.getAvailableConnectionPoolsCount() + connectionPoolsTotalCount;
    }

    public static Iterator getRAs() {
        return raList.iterator();
    }

    public static int getConnectionPoolsTotalCount() {
        return connectionPoolsTotalCount;
    }

    public static RAInstanceManager getRAInstanceManager(ResourceAdapter resourceAdapter) {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        for (RAInstanceManager rAInstanceManager : raList) {
            ResourceAdapter resourceAdapter2 = rAInstanceManager.getResourceAdapter();
            if (resourceAdapter2 == null || !rAInstanceManager.getAdapterLayer().equals(resourceAdapter2, resourceAdapter, authenticatedSubject)) continue;
            return rAInstanceManager;
        }
        return null;
    }

    public static RAInstanceManager getRAInstanceManager(String string) {
        Debug.println(CLASS_NAME, ".getRAInstanceManager( jndiName = '" + string + "' )");
        if (string == null || string.trim().equals("")) {
            Debug.throwAssertionError("jndiName is null or empty");
        }
        RAInstanceManager rAInstanceManager2 = null;
        for (RAInstanceManager rAInstanceManager2 : raList) {
            if (!string.equals(rAInstanceManager2.getJndiName())) continue;
            Debug.println(CLASS_NAME, ".getRAInstanceManager( " + string + " ) returning RA with moduleName = " + rAInstanceManager2.getModuleName());
            return rAInstanceManager2;
        }
        Debug.println(CLASS_NAME, ".getRAInstanceManager() found no deployed RA with JNDI name = '" + string + "'");
        return null;
    }

    public static ConnectorDiagnosticImageDocument getXMLBean(ConnectorDiagnosticImageSource connectorDiagnosticImageSource) {
        boolean bl;
        ConnectorDiagnosticImageDocument connectorDiagnosticImageDocument = ConnectorDiagnosticImageDocument.Factory.newInstance();
        ConnectorDiagnosticImageType connectorDiagnosticImageType = ConnectorDiagnosticImageType.Factory.newInstance();
        boolean bl2 = bl = connectorDiagnosticImageSource != null ? connectorDiagnosticImageSource.timedout() : false;
        if (bl) {
            return connectorDiagnosticImageDocument;
        }
        AdapterType[] adapterTypeArray = new AdapterType[raList.size()];
        Iterator iterator = raList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            RAInstanceManager rAInstanceManager = (RAInstanceManager)iterator.next();
            adapterTypeArray[n] = rAInstanceManager.getXMLBean(connectorDiagnosticImageSource);
            ++n;
        }
        connectorDiagnosticImageType.setAdapterArray(adapterTypeArray);
        connectorDiagnosticImageDocument.setConnectorDiagnosticImage(connectorDiagnosticImageType);
        return connectorDiagnosticImageDocument;
    }

    public static RAInstanceManager getRAInstanceManagerByAppName(String string, String string2) {
        Debug.println(CLASS_NAME, ".getRAInstanceManagerByAppName( appName = '" + string + "' )");
        if (string == null || string.trim().equals("")) {
            Debug.throwAssertionError("jndiName is null or empty");
        }
        RAInstanceManager rAInstanceManager = null;
        Iterator iterator = raList.iterator();
        if (string2 != null && string2.length() > 0) {
            while (iterator.hasNext()) {
                rAInstanceManager = (RAInstanceManager)iterator.next();
                if (!string.equals(rAInstanceManager.getAppContext().getApplicationName()) || !string2.equals(rAInstanceManager.getVersionId())) continue;
                Debug.println(CLASS_NAME, ".getRAInstanceManager( " + string + " ) returning RA with moduleName = " + rAInstanceManager.getModuleName());
                return rAInstanceManager;
            }
        }
        Debug.println(CLASS_NAME, ".getRAInstanceManagerByAppName found no deployed RA with appName name = '" + string + "'");
        return null;
    }

    public static RAInstanceManager getRAInstanceManagerByAppIdAndModuleName(String string, String string2) {
        Debug.println(CLASS_NAME, ".getRAInstanceManagerByAppIdAndModuleName( appId = '" + string + "', moduleName = '" + string2 + "' )");
        if (string == null || string.trim().equals("")) {
            Debug.throwAssertionError("appId is null or empty");
        }
        if (string2 == null || string2.trim().equals("")) {
            Debug.throwAssertionError("moduleName is null or empty");
        }
        RAInstanceManager rAInstanceManager2 = null;
        for (RAInstanceManager rAInstanceManager2 : raList) {
            if (!string.equals(rAInstanceManager2.getAppContext().getApplicationId()) || !string2.equals(rAInstanceManager2.getModuleName())) continue;
            Debug.println(CLASS_NAME, ".getRAInstanceManagerByAppIdAndModuleName( " + string + ", " + string2 + " ) returning RA with moduleName = " + rAInstanceManager2.getModuleName());
            return rAInstanceManager2;
        }
        Debug.println(CLASS_NAME, ".getRAInstanceManagerByAppIdAndModuleName found no deployed RA with appId = '" + string + "', and moduleName = '" + string2 + "'");
        return null;
    }
}

