/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.common;

import com.bea.connector.diagnostic.AdapterType;
import com.bea.connector.diagnostic.InboundAdapterType;
import com.bea.connector.diagnostic.OutboundAdapterType;
import com.bea.connector.diagnostic.WorkManagerType;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.naming.Context;
import javax.resource.ResourceException;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.work.WorkException;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.connector.ConnectorLogger;
import weblogic.connector.common.ConnectorDiagnosticImageSource;
import weblogic.connector.common.ConnectorService;
import weblogic.connector.common.Debug;
import weblogic.connector.common.LinkrefManager;
import weblogic.connector.common.RACollectionManager;
import weblogic.connector.common.Utils;
import weblogic.connector.configuration.DDUtil;
import weblogic.connector.deploy.DeployerUtil;
import weblogic.connector.deploy.JNDIHandler;
import weblogic.connector.deploy.RarArchive;
import weblogic.connector.exception.RACommonException;
import weblogic.connector.exception.RAException;
import weblogic.connector.extensions.Suspendable;
import weblogic.connector.external.AdminObjInfo;
import weblogic.connector.external.RAComplianceException;
import weblogic.connector.external.RAInfo;
import weblogic.connector.external.RAValidationInfo;
import weblogic.connector.external.impl.RAComplianceChecker;
import weblogic.connector.inbound.RAInboundManager;
import weblogic.connector.lifecycle.BootstrapContext;
import weblogic.connector.monitoring.ConnectorComponentRuntimeMBeanImpl;
import weblogic.connector.monitoring.ServiceRuntimeMBeanImpl;
import weblogic.connector.outbound.RAOutboundManager;
import weblogic.connector.security.SecurityPermissions;
import weblogic.connector.security.layer.AdapterLayer;
import weblogic.connector.work.WorkManager;
import weblogic.management.DeploymentException;
import weblogic.management.ManagementException;
import weblogic.management.UndeploymentException;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.ConnectorComponentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ApplicationRuntimeMBean;
import weblogic.management.runtime.ComponentRuntimeMBean;
import weblogic.management.runtime.ConnectorComponentRuntimeMBean;
import weblogic.management.runtime.WorkManagerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFile;
import weblogic.work.WorkManagerCollection;
import weblogic.work.WorkManagerRuntimeMBeanImpl;
import weblogic.work.WorkManagerService;

public class RAInstanceManager {
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private final String NEW = Debug.getStringNew();
    private final String INITIALIZED = Debug.getStringInitialized();
    private final String PREPARED = Debug.getStringPrepared();
    private final String ACTIVATED = Debug.getStringActivated();
    private final String SUSPENDED = Debug.getStringSuspended();
    private SuspendState suspendState = new SuspendState();
    ConnectorComponentRuntimeMBeanImpl connectorComponentRuntimeMBean = null;
    WorkManagerRuntimeMBean workManagerRuntime = null;
    private BootstrapContext bootstrapContext = null;
    private ResourceAdapter resourceAdapter = null;
    private RAInboundManager raInboundManager = null;
    private RAOutboundManager raOutboundManager = null;
    private RAInfo raInfo = null;
    private ClassLoader classloader = null;
    private String connectorComponentName = null;
    private String applicationName = null;
    private String componentURI = null;
    private WorkManagerCollection workMgrCollection = null;
    private RarArchive explodedRar;
    private VirtualJarFile vjar;
    private boolean lateDeploy = false;
    private String state = this.NEW;
    private boolean suspendedBeforeDeactivate;
    private ApplicationContextInternal appCtx = null;
    private Context adminObjectCtx = null;
    private Hashtable<String, AdminObjVersionId> adminObjects = null;
    private Context connectionFactoryCtx = null;
    private String moduleName;
    private String jndiName;
    private AdapterLayer adapterLayer;
    private List classFinders;
    private RAValidationInfo raValidationInfo;
    private volatile boolean waitingStartVersioningComplete = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAInstanceManager(RAInfo rAInfo, ClassLoader classLoader, String string, String string2, String string3, RarArchive rarArchive, ApplicationContextInternal applicationContextInternal, Context context, Context context2, String string4, RAInstanceManager rAInstanceManager, AuthenticatedSubject authenticatedSubject) throws RAException, RAComplianceException {
        Debug.enter(this, "Constructor");
        try {
            this.classFinders = new Vector(2);
            this.appCtx = applicationContextInternal;
            this.adminObjectCtx = context;
            this.connectionFactoryCtx = context2;
            if (applicationContextInternal == null) {
                Debug.throwAssertionError("appCtx == null");
            }
            if (Debug.isWorkEnabled()) {
                Debug.work("Getting work manager collection for app with appId = " + applicationContextInternal.getApplicationId());
            }
            this.workMgrCollection = applicationContextInternal.getWorkManagerCollection();
            if (this.workMgrCollection == null) {
                Debug.throwAssertionError("appCtx.getWorkManagerCollection() == null ");
            }
            if (rAInfo == null) {
                Debug.throwAssertionError("RAInfo == null");
            }
            this.raInfo = rAInfo;
            this.classloader = classLoader;
            this.connectorComponentName = string2;
            this.componentURI = string3;
            this.applicationName = string;
            this.explodedRar = rarArchive;
            this.vjar = rarArchive.getVirtualJarFile();
            this.moduleName = string4;
            this.jndiName = rAInfo.getJndiName();
            if (this.jndiName != null && JNDIHandler.verifyJNDIName(this.jndiName)) {
                Debug.deployment("Failing deployment with duplicate RA JNDI name of " + this.jndiName + " for module " + string4);
                String string5 = Debug.getExceptionJndiNameAlreadyBound(this.jndiName);
                throw new RAException(string5);
            }
            this.adapterLayer = new AdapterLayer(this, authenticatedSubject);
            String string6 = this.raInfo.getLinkref();
            if (string6 != null && string6.length() > 0) {
                Debug.deployment("A linkref is being deployed : " + string6);
                Debug.logDeprecatedLinkref(this.getModuleName());
                Debug.println(this, "() Check if the base has been deployed");
                RAInstanceManager rAInstanceManager2 = LinkrefManager.getBaseRA(string6);
                if (rAInstanceManager2 != null) {
                    if (Debug.isDeploymentEnabled()) {
                        Debug.deployment("The base RA for the '" + string6 + "'link-ref is already deployed; base RA module name = '" + rAInstanceManager2.getModuleName() + "'");
                    }
                    this.lateDeploy = false;
                    Debug.println(this, "() Update the classloader with the base jar");
                    DeployerUtil.updateClassFinder((GenericClassLoader)this.classloader, rAInstanceManager2.getJarFile(), this.raInfo.isEnableGlobalAccessToClasses(), this.getClassFinders());
                    Debug.println(this, "() Update the RAInfo of this linkref with the base raInfo");
                    this.raInfo.setBaseRA(rAInstanceManager2.getRAInfo());
                } else {
                    Debug.deployment("The base RA for the '" + string6 + "'link-ref has not yet been deployed.");
                    this.lateDeploy = true;
                    Debug.println(this, "() Add the linkref to the linkref manager for future deployment");
                    LinkrefManager.addLinkrefRA(this);
                    Debug.logRarMarkedForLateDeployment(this.getModuleName());
                }
            }
            this.setupComponentRuntime();
            if (!this.lateDeploy) {
                Debug.println(this, "() initializing the RA object");
                this.initialize(rAInstanceManager, authenticatedSubject);
            }
            Object var16_16 = null;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            Debug.exit(this, "Constructor");
            throw throwable;
        }
        Debug.exit(this, "Constructor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void prepare() throws RAException {
        Debug.enter(this, "prepare()");
        try {
            if (!this.lateDeploy) {
                if (this.state.equals(this.NEW)) {
                    String string = Debug.getExceptionPrepareUninitializedRA();
                    throw new RAException(string);
                }
                if (this.state.equals(this.INITIALIZED)) {
                    DDUtil.validateRAInfo(this.raInfo);
                    Debug.println(this, ".prepare() Set the security permissions for the resource adapter");
                    SecurityPermissions.setSecurityPermissions(this.raInfo, this.appCtx);
                    Debug.println(this, ".prepare() the outbound manager");
                    this.raOutboundManager.prepare();
                    this.state = this.PREPARED;
                }
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Debug.exit(this, "prepare");
            throw throwable;
        }
        Debug.exit(this, "prepare");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void activate() throws RAException {
        Debug.enter(this, "activate()");
        try {
            if (!this.lateDeploy) {
                if (this.state.equals(this.NEW) || this.state.equals(this.INITIALIZED)) {
                    String string = Debug.getExceptionActivateUnpreparedRA(this.state.toString());
                    throw new RAException(string);
                }
                if (this.state.equals(this.PREPARED)) {
                    if (this.suspendedBeforeDeactivate) {
                        String string = Debug.getExceptionActivateSuspendedRA(this.state.toString());
                        throw new RAException(string);
                    }
                    Debug.println(this, ".activate() Call activate on the outbound manager");
                    this.raOutboundManager.activate();
                    Debug.println(this, ".activate() Call activate on the inbound manager");
                    this.raInboundManager.activate();
                    this.bindAdminObjects();
                    if (this.resourceAdapter != null) {
                        WorkManager workManager = (WorkManager)this.bootstrapContext.getWorkManager();
                        workManager.acceptDoWorkCalls();
                        this.putRAintoJNDITree(this.jndiName);
                    }
                    if (this.raInfo.getLinkref() == null || this.raInfo.getLinkref().length() == 0) {
                        Debug.println(this, ".activate() Add the base RA to the linkref manager");
                        LinkrefManager.addBaseRA(this);
                        Debug.println(this, ".activate() Deploy the dependent linkrefs");
                        LinkrefManager.deployDependentLinkrefs(this);
                    }
                    this.state = this.ACTIVATED;
                }
            }
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            Debug.exit(this, "activate");
            throw throwable;
        }
        Debug.exit(this, "activate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deactivate() throws RAException {
        Debug.enter(this, "deactivate()");
        RAException rAException = new RAException();
        try {
            if (!this.lateDeploy && (this.state.equals(this.ACTIVATED) || this.state.equals(this.SUSPENDED))) {
                this.suspendedBeforeDeactivate = this.state.equals(this.SUSPENDED);
                this.removeAdminObjsFromJndi(rAException);
                this.removeRAfromJNDITree(rAException);
                this.deactivateRAInboundMgr(rAException);
                this.deactivateRAOutboundMgr(rAException);
                this.state = this.PREPARED;
            }
            if (rAException.size() > 0) {
                throw rAException;
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Debug.exit(this, "deactivate");
            throw throwable;
        }
        Debug.exit(this, "deactivate");
    }

    private void deactivateRAInboundMgr(RAException rAException) {
        Debug.println(this, ".deactivateRAInboundMgr() Call deactivate on the inbound manager");
        try {
            if (this.raInboundManager != null) {
                this.raInboundManager.deactivate();
            }
        }
        catch (Throwable throwable) {
            rAException.addError(throwable);
        }
    }

    private void deactivateRAOutboundMgr(RAException rAException) {
        Debug.println(this, ".deactivateRAOutboundMgr() Call deactivate on the outbound manager");
        try {
            if (this.raOutboundManager != null) {
                this.raOutboundManager.deactivate();
            }
        }
        catch (Throwable throwable) {
            rAException.addError(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback() throws RAException {
        Debug.enter(this, "rollback()");
        RAException rAException = new RAException();
        try {
            if (this.state.equals(this.ACTIVATED)) {
                String string = Debug.getExceptionRollbackActivatedRA();
                throw new RAException(string);
            }
            if (this.state.equals(this.PREPARED)) {
                if (!this.lateDeploy) {
                    this.rollbackRAInboundMgr(rAException);
                    this.rollbackRAOutboundMgr(rAException);
                    this.rollbackWorkMgr(rAException);
                    this.suspendWorkManager(rAException);
                    this.releaseLongRunningWorks(rAException);
                    this.unsetRASecurity(rAException);
                    this.callStopOnRA(rAException);
                    this.unregisterRAInstance(rAException);
                }
                this.lateDeploy = false;
                if (this.raInfo.getLinkref() == null || this.raInfo.getLinkref().length() == 0) {
                    LinkrefManager.removeBaseRA(this, rAException);
                } else {
                    LinkrefManager.removeLinkrefRA(this, rAException);
                }
                this.state = this.INITIALIZED;
                if (rAException.size() > 0) {
                    throw rAException;
                }
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Debug.exit(this, "rollback");
            this.closeClassFinders();
            throw throwable;
        }
        Debug.exit(this, "rollback");
        this.closeClassFinders();
    }

    private void rollbackRAInboundMgr(RAException rAException) {
        Debug.println(this, ".rollbackRAInboundMgr() Call rollback on the inbound manager");
        try {
            if (this.raInboundManager != null) {
                this.raInboundManager.rollback();
            }
        }
        catch (Throwable throwable) {
            rAException.addError(throwable);
        }
    }

    private void rollbackRAOutboundMgr(RAException rAException) {
        Debug.println(this, ".rollbackRAOutboundMgr() Call rollback on the outbound manager");
        try {
            if (this.raOutboundManager != null) {
                this.raOutboundManager.rollback();
            }
        }
        catch (Throwable throwable) {
            rAException.addError(throwable);
        }
    }

    private void rollbackWorkMgr(RAException rAException) {
        Debug.work("RAInstanceManager.rollbackWorkMgr() Rollback work from the work manager");
        try {
            this.workMgrCollection.removeModuleEntries(this.moduleName);
        }
        catch (Throwable throwable) {
            rAException.addError(throwable);
        }
    }

    private void unregisterRAInstance(RAException rAException) {
        Debug.println(this, ".unregisterRAInstance() Unregister this RAInstanceManager");
        try {
            RACollectionManager.unregister(this);
        }
        catch (Throwable throwable) {
            rAException.addError(throwable);
        }
    }

    private void unsetRASecurity(RAException rAException) {
        Debug.println(this, ".unsetRASecurity() unset the security permissions for the resource adapter");
        try {
            SecurityPermissions.unSetSecurityPermissions(this.raInfo);
        }
        catch (Throwable throwable) {
            rAException.addError(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws RAException {
        Debug.enter(this, "stop()");
        Utils.startManagement();
        try {
            this.shutdownRA();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            Utils.stopManagement();
            Debug.exit(this, "stop()");
            throw throwable;
        }
        Utils.stopManagement();
        Debug.exit(this, "stop()");
    }

    private void shutdownRA() throws RAException {
        RAException rAException = new RAException();
        this.stopRAOutboundMgr(rAException);
        this.stopRAInboundMgr(rAException);
        this.suspendWorkManager(rAException);
        this.releaseLongRunningWorks(rAException);
        this.callStopOnRA(rAException);
        if (rAException.size() > 0) {
            throw rAException;
        }
    }

    private void stopRAOutboundMgr(RAException rAException) {
        try {
            this.raOutboundManager.stop();
        }
        catch (Throwable throwable) {
            rAException.addError(throwable);
        }
    }

    private void stopRAInboundMgr(RAException rAException) {
        try {
            this.raInboundManager.stop();
        }
        catch (Throwable throwable) {
            rAException.addError(throwable);
        }
    }

    private void suspendWorkManager(RAException rAException) {
        if (this.bootstrapContext != null) {
            try {
                WorkManager workManager = (WorkManager)this.bootstrapContext.getWorkManager();
                workManager.suspend();
            }
            catch (Throwable throwable) {
                rAException.addError(throwable);
            }
        }
    }

    private void releaseLongRunningWorks(RAException rAException) {
        if (this.bootstrapContext != null) {
            try {
                WorkManager workManager = (WorkManager)this.bootstrapContext.getWorkManager();
                workManager.getLongRunningWorkManager().cleanup();
            }
            catch (Throwable throwable) {
                rAException.addError(throwable);
            }
        }
    }

    private void callStopOnRA(RAException rAException) {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        if (this.resourceAdapter == null) {
            return;
        }
        try {
            if (Debug.isRALifecycleEnabled()) {
                Debug.raLifecycle("Calling stop on() the ResouceAdapter JavaBean: " + this.adapterLayer.toString(this.resourceAdapter, authenticatedSubject) + " in module '" + this.moduleName + "' having JNDI name '" + this.jndiName + "'");
            }
        }
        catch (Throwable throwable) {
            rAException.addError(throwable);
        }
        try {
            this.adapterLayer.stop(this.resourceAdapter, authenticatedSubject);
        }
        catch (Throwable throwable) {
            rAException.addError(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void halt() throws RAException {
        Debug.enter(this, "halt()");
        Utils.startManagement();
        try {
            this.shutdownRA();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            Utils.stopManagement();
            Debug.exit(this, "halt()");
            throw throwable;
        }
        Utils.stopManagement();
        Debug.exit(this, "halt()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(int n, Properties properties) throws RAException {
        Debug.enter(this, "suspend( " + n + ", props )");
        Utils.startManagement();
        try {
            RAException rAException = null;
            try {
                Debug.println(this, ".suspend() Suspending the resource adapter");
                this.suspendResourceAdapter(n, properties);
                this.state = this.SUSPENDED;
            }
            catch (ResourceException resourceException) {
                rAException = Utils.consolidateException(rAException, resourceException);
            }
            if (this.matches(n, 2)) {
                try {
                    Debug.println(this, ".suspend() Suspending all outbound");
                    if (this.raOutboundManager != null) {
                        this.raOutboundManager.suspend();
                        this.suspendState.suspendOutbound();
                    }
                }
                catch (RAException rAException2) {
                    rAException = Utils.consolidateException(rAException, (Throwable)((Object)rAException2));
                }
            }
            if (this.matches(n, 1)) {
                try {
                    Debug.println(this, ".suspend() Suspending all inbound");
                    if (this.raInboundManager != null) {
                        this.raInboundManager.suspend(properties);
                        this.suspendState.suspendInbound();
                    }
                }
                catch (RAException rAException3) {
                    rAException = Utils.consolidateException(rAException, (Throwable)((Object)rAException3));
                }
            }
            if (this.matches(n, 4) && this.bootstrapContext != null) {
                ((WorkManager)this.bootstrapContext.getWorkManager()).suspend();
                this.suspendState.suspendWork();
            }
            if (rAException != null) {
                throw rAException;
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            Utils.stopManagement();
            Debug.exit(this, "suspend( " + n + ", props )");
            throw throwable;
        }
        Utils.stopManagement();
        Debug.exit(this, "suspend( " + n + ", props )");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(int n, Properties properties) throws RAException {
        Debug.enter(this, "resume( " + n + ", props )");
        Utils.startManagement();
        try {
            RAException rAException = null;
            try {
                this.resumeResourceAdapter(n, properties);
            }
            catch (ResourceException resourceException) {
                rAException = Utils.consolidateException(rAException, resourceException);
            }
            if (this.matches(n, 2)) {
                try {
                    if (this.raOutboundManager != null) {
                        this.raOutboundManager.resume();
                        this.suspendState.resumeOutbound();
                    }
                }
                catch (RAException rAException2) {
                    rAException = Utils.consolidateException(rAException, (Throwable)((Object)rAException2));
                }
            }
            if (this.matches(n, 1)) {
                try {
                    if (this.raInboundManager != null) {
                        this.raInboundManager.resume(properties);
                        this.suspendState.resumeInbound();
                    }
                }
                catch (RAException rAException3) {
                    rAException = Utils.consolidateException(rAException, (Throwable)((Object)rAException3));
                }
            }
            if (this.matches(n, 4) && this.bootstrapContext != null) {
                ((WorkManager)this.bootstrapContext.getWorkManager()).resume();
                this.suspendState.resumeWork();
            }
            if (this.suspendState.isAllResumed()) {
                this.state = this.ACTIVATED;
            }
            if (rAException != null) {
                throw rAException;
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            Utils.stopManagement();
            Debug.exit(this, "resume( " + n + ", props )");
            throw throwable;
        }
        Utils.stopManagement();
        Debug.exit(this, "resume( " + n + ", props )");
    }

    public String toString() {
        return "ModuleName = " + this.moduleName + ", jndiName = " + this.jndiName + ", state = " + this.state + "\nRAInfo = " + this.raInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    synchronized void initialize(RAInstanceManager var1_1, AuthenticatedSubject var2_2) throws RAException, RAComplianceException {
        block25: {
            Debug.enter(this, "initialize()");
            try {
                block27: {
                    block28: {
                        if (!this.state.equals(this.NEW)) break block27;
                        Debug.println(this, ".initialize() Updating the classloader");
                        DeployerUtil.updateClassFinder((GenericClassLoader)this.classloader, this.explodedRar, this.raInfo.isEnableGlobalAccessToClasses(), this.getClassFinders());
                        this.raValidationInfo = ((RAComplianceChecker)weblogic.connector.external.RAComplianceChecker.factory.createChecker()).validate(this.vjar.getName(), this.raInfo, (GenericClassLoader)this.classloader);
                        Debug.println(this, ".initialize() Register with the RAMAnager");
                        RACollectionManager.register(this);
                        try {
                            Debug.println(this, ".initialize() Creating native lib");
                            DeployerUtil.createNativeLibDir(this.vjar, this.raInfo, this.appCtx);
                        }
                        catch (DeploymentException var3_3) {
                            var4_5 = Debug.getExceptionCreateNativeLib();
                            throw new RAException(var4_5, (Throwable)var3_3);
                        }
                        var3_4 = this.raInfo.getRAClass();
                        if (var3_4 != null) {
                            try {
                                Debug.raLifecycle("Creating the ResourceAdapter JavaBean: " + var3_4);
                                var4_6 = this.adapterLayer.forName(var3_4, true, this.classloader, var2_2);
                                this.resourceAdapter = (ResourceAdapter)this.adapterLayer.newInstance((Class)var4_6, var2_2);
                                Utils.setProperties(this, this.resourceAdapter, this.raInfo.getRAConfigProps().values(), this.raValidationInfo.getRAPropSetterTable());
                            }
                            catch (ClassNotFoundException var4_7) {
                                throw new RAException(var4_7.toString(), var4_7);
                            }
                            catch (InstantiationException var4_8) {
                                throw new RAException(var4_8.toString(), var4_8);
                            }
                            catch (IllegalAccessException var4_9) {
                                throw new RAException(var4_9.toString(), var4_9);
                            }
                            catch (Throwable var4_10) {
                                throw new RAException(var4_10.toString(), var4_10);
                            }
                        }
                        var4_6 = null;
                        if (this.resourceAdapter == null) break block28;
                        try {
                            var5_11 = null;
                            var6_16 = null;
                            var7_21 = this.appCtx.getRuntime();
                            Debug.work("RAInstanceManager.initialize() Associate the resource adapter with the WorkManagerCollection");
                            if (this.raInfo.getWorkManager() != null) {
                                var5_11 = this.raInfo.getWorkManager().getName();
                                var4_6 = this.workMgrCollection.populate(this.moduleName, this.raInfo.getWorkManager());
                            } else {
                                var5_11 = this.moduleName;
                            }
                            var6_16 = this.workMgrCollection.get(this.moduleName, var5_11);
                            this.workManagerRuntime = var7_21.lookupWorkManagerRuntime(var6_16);
                            Debug.println(this, ".initialize() Create a new BootstrapContext : " + this.moduleName);
                            this.bootstrapContext = new BootstrapContext(this, this.appCtx, this.moduleName, var6_16);
                            if (!this.isVersioned()) ** GOTO lbl66
                            if (Utils.isRAVersionable(this, var1_1)) {
                                if (var1_1 != null) {
                                    var8_22 = var1_1.getJndiName();
                                    ConnectorLogger.logDeploySideBySide((String)var8_22, (String)var1_1.getVersionId(), (String)this.getVersionId());
                                    Debug.raLifecycle("Beginning side-by-side versioning of resource adapter with JNDI name = " + var8_22 + " by calling init() on new version");
                                    this.adapterLayer.init((Suspendable)this.resourceAdapter, var1_1.getResourceAdapter(), null, var2_2);
                                    Debug.raLifecycle("Continuing side-by-side versioning of resource adapter with JNDI name = " + var8_22 + " by calling startVersioning() on old version");
                                    var1_1.waitingStartVersioningComplete = true;
                                    this.adapterLayer.startVersioning((Suspendable)var1_1.getResourceAdapter(), this.resourceAdapter, null, var2_2);
                                    Debug.raLifecycle("Completed side-by-side versioning of resource adapter with JNDI name = " + var8_22);
                                } else {
                                    ConnectorLogger.logSkipSideBySide();
                                }
                            } else {
                                var8_23 = Debug.getExceptionAdapterNotVersionable();
                                throw new RAException(var8_23);
lbl66:
                                // 1 sources

                                ConnectorLogger.logAppNotSideBySide();
                            }
                            Debug.raLifecycle("Calling start() on the ResourceAdapter bean for " + this.adapterLayer.toString(this.resourceAdapter, var2_2));
                            this.adapterLayer.start(this.resourceAdapter, this.bootstrapContext, var2_2);
                        }
                        catch (ResourceAdapterInternalException var5_12) {
                            var6_17 = Debug.getExceptionStartRA(this.getModuleName(), this.adapterLayer.toString((Object)var5_12, var2_2));
                            throw new RAException(var6_17, var5_12);
                        }
                        catch (WorkException var5_13) {
                            var6_18 = Debug.getExceptionCreateBootstrap(this.getModuleName(), this.adapterLayer.toString((Object)var5_13, var2_2));
                            throw new RAException(var6_18, var5_13);
                        }
                        catch (ResourceException var5_14) {
                            var6_19 = Debug.getExceptionVersionRA();
                            throw new RAException(var6_19, var5_14);
                        }
                        catch (Throwable var5_15) {
                            var6_20 = Debug.getExceptionStartRA(this.getModuleName(), this.adapterLayer.toString(var5_15, var2_2));
                            throw new RAException(var6_20, var5_15);
                        }
                    }
                    this.setupWorkManagerRuntime((WorkManagerService)var4_6);
                    Debug.println(this, ".initialize() Create the RAOutboundManager");
                    this.raOutboundManager = new RAOutboundManager(this);
                    Debug.println(this, ".initialize() Create the RAInboundManager");
                    this.raInboundManager = new RAInboundManager(this);
                    this.raInboundManager.setupRuntimes(this.connectorComponentRuntimeMBean);
                    this.createAdminObjects(var2_2);
                    RACollectionManager.updateCounts(this);
                    this.state = this.INITIALIZED;
                }
                var10_24 = null;
                if (this.state == this.INITIALIZED) break block25;
            }
            catch (Throwable var9_28) {
                var10_25 = null;
                if (this.state != this.INITIALIZED) {
                    try {
                        this.closeClassFinders();
                    }
                    catch (Throwable var11_27) {
                        // empty catch block
                    }
                    Debug.println(this, ".initialize() UnRegister with the RAMAnager");
                    RACollectionManager.unregister(this);
                }
                Debug.exit(this, "initialize");
                throw var9_28;
            }
            try {
                this.closeClassFinders();
            }
            catch (Throwable var11_26) {
                // empty catch block
            }
            Debug.println(this, ".initialize() UnRegister with the RAMAnager");
            RACollectionManager.unregister(this);
            {
            }
        }
        Debug.exit(this, "initialize");
    }

    private void createAdminObjects(AuthenticatedSubject authenticatedSubject) throws RAException {
        List list = this.raInfo.getAdminObjs();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.createAdminObject((AdminObjInfo)iterator.next(), authenticatedSubject);
            }
        }
    }

    private void verifyAdminJNDIAndSaveObj(Object object, AdminObjInfo adminObjInfo, String string, boolean bl) throws RAException {
        String string2 = adminObjInfo.getKey();
        if (bl) {
            boolean bl2;
            Debug.println(this, ".verifyAdminJNDIAndSaveObj() " + this.adapterLayer.toString(object, kernelId) + " in App-Scoped JNDI Tree with resourceLink '" + string2 + "'");
            boolean bl3 = bl2 = JNDIHandler.verifyResourceLink(string2, this.getAdminObjectContext()) || this.adminObjects != null && this.adminObjects.containsKey(string2);
            if (bl2) {
                String string3 = Debug.getExceptionCFResourceLinkDuplicate(string2);
                throw new RAException(string3);
            }
        } else {
            boolean bl4;
            Debug.println(this, ".verifyAdminJNDIAndSaveObj() " + this.adapterLayer.toString(object, kernelId) + " JNDI name '" + string2 + "' and versionId = " + string);
            boolean bl5 = bl4 = JNDIHandler.isJndiNameBound(string2) || this.adminObjects != null && this.adminObjects.containsKey(string2);
            if (bl4) {
                String string4 = Debug.getExceptionJndiNameAlreadyBound(string2);
                throw new RAException(string4);
            }
        }
        if (this.adminObjects == null) {
            this.adminObjects = new Hashtable();
        }
        this.adminObjects.put(string2, new AdminObjVersionId(object, string, bl, adminObjInfo));
    }

    private void bindAdminObjects() throws RACommonException {
        if (this.adminObjects != null && this.adminObjects.size() > 0) {
            for (String string : this.adminObjects.keySet()) {
                this.bindAdminObject(string);
            }
        }
    }

    private void suspendResourceAdapter(int n, Properties properties) throws ResourceException {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        if (this.resourceAdapter != null && this.resourceAdapter instanceof Suspendable && this.adapterLayer.supportsSuspend((Suspendable)this.resourceAdapter, n, authenticatedSubject)) {
            Debug.raLifecycle("Calling suspend() on the ResourceAdapter JavaBean: " + this.adapterLayer.toString(this.resourceAdapter, authenticatedSubject));
            this.adapterLayer.suspend((Suspendable)this.resourceAdapter, n, properties, authenticatedSubject);
        } else if (this.resourceAdapter != null) {
            Debug.raLifecycle("Skipping suspend() call ResourceAdapter JavaBean " + this.adapterLayer.toString(this.resourceAdapter, authenticatedSubject) + " which does not support type '" + n + "' suspend()");
        }
    }

    private void resumeResourceAdapter(int n, Properties properties) throws ResourceException {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        if (this.resourceAdapter != null && this.resourceAdapter instanceof Suspendable && this.adapterLayer.supportsSuspend((Suspendable)this.resourceAdapter, n, authenticatedSubject)) {
            Debug.raLifecycle("Calling resume() on the ResourceAdapter JavaBean: " + this.resourceAdapter);
            ((Suspendable)this.resourceAdapter).resume(n, properties);
        } else if (this.resourceAdapter != null) {
            Debug.raLifecycle("Skipping resume() call ResourceAdapter JavaBean " + this.adapterLayer.toString(this.resourceAdapter, authenticatedSubject) + " which does not support type " + n + " suspend()/resume()");
        }
    }

    private void putRAintoJNDITree(String string) throws RAException {
        String string2 = this.getVersionId();
        Debug.deployment("Module '" + this.moduleName + "' binding RA with JNDI name '" + string + "' and versionId = " + string2);
        if (string == null || string.equals("")) {
            if (this.raInboundManager.isInboundRA()) {
                Debug.logNoAdapterJNDInameSetForInboundRA(this.moduleName, this.appCtx.getApplicationName());
            }
        } else {
            JNDIHandler.bindRA(string, this.resourceAdapter, string2);
        }
    }

    private void removeRAfromJNDITree(RAException rAException) {
        Debug.println(this, ".removeRAfromJNDITree() Remove RA from JNDI tree");
        try {
            String string = this.getVersionId();
            Debug.deployment("Module '" + this.moduleName + "' unbinding RA with JNDI name '" + this.jndiName + "' and versionId = " + string);
            JNDIHandler.unbindRA(this.getJndiName(), this.resourceAdapter, string);
        }
        catch (Throwable throwable) {
            rAException.addError(throwable);
        }
    }

    private boolean matches(int n, int n2) {
        return (n & n2) > 0;
    }

    private void removeAdminObjsFromJndi(RAException rAException) {
        Debug.println(this, ".removeAdminObjsFromJndi() Remove administered objects from JNDI tree");
        if (this.raInfo == null) {
            Debug.throwAssertionError("RAInfo is null");
        }
        if (this.adminObjects != null) {
            for (Map.Entry<String, AdminObjVersionId> entry : this.adminObjects.entrySet()) {
                try {
                    JNDIHandler.unbindAdminObj(entry.getValue().adminInfo, this);
                }
                catch (Exception exception) {
                    rAException.add((Throwable)((Object)rAException));
                }
            }
        }
    }

    public void removeAdminObject(AdminObjInfo adminObjInfo) throws RAException {
        try {
            this.adminObjects.remove(adminObjInfo.getKey());
            JNDIHandler.unbindAdminObj(adminObjInfo, this);
        }
        catch (UndeploymentException undeploymentException) {
            throw new RAException((Throwable)((Object)undeploymentException));
        }
    }

    public void setLateDeploy(boolean bl) {
        this.lateDeploy = bl;
    }

    public RAOutboundManager getRAOutboundManager() {
        return this.raOutboundManager;
    }

    public RAInboundManager getRAInboundManager() {
        return this.raInboundManager;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public RAInfo getRAInfo() {
        return this.raInfo;
    }

    public ClassLoader getClassloader() {
        return this.classloader;
    }

    public ConnectorComponentMBean getConnectorComponentMBean() {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        ApplicationMBean applicationMBean = domainMBean.lookupApplication(this.applicationName);
        if (applicationMBean == null) {
            return null;
        }
        return applicationMBean.lookupConnectorComponent(this.connectorComponentName);
    }

    public VirtualJarFile getJarFile() {
        return this.vjar;
    }

    public int getAvailableConnectionPoolsCount() {
        if (this.raOutboundManager != null) {
            return this.raOutboundManager.getAvailableConnetionPoolsCount();
        }
        return 0;
    }

    public ConnectorComponentRuntimeMBean getConnectorComponentRuntimeMBean() {
        return this.connectorComponentRuntimeMBean;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public boolean isActivated() {
        return this.state.equals(this.ACTIVATED);
    }

    AdapterType getXMLBean(ConnectorDiagnosticImageSource connectorDiagnosticImageSource) {
        boolean bl;
        AdapterType adapterType = AdapterType.Factory.newInstance();
        adapterType.setJndiName(this.getRAInfo().getJndiName());
        boolean bl2 = bl = connectorDiagnosticImageSource != null ? connectorDiagnosticImageSource.timedout() : false;
        if (bl) {
            return adapterType;
        }
        OutboundAdapterType[] outboundAdapterTypeArray = this.getRAOutboundManager().getXMLBeans(connectorDiagnosticImageSource);
        adapterType.setOutboundAdapterArray(outboundAdapterTypeArray);
        InboundAdapterType[] inboundAdapterTypeArray = this.getRAInboundManager().getXMLBeans(connectorDiagnosticImageSource);
        adapterType.setInboundAdapterArray(inboundAdapterTypeArray);
        WorkManagerType workManagerType = WorkManagerType.Factory.newInstance();
        workManagerType.setWorkManagerName(this.jndiName);
        adapterType.setWorkManager(workManagerType);
        return adapterType;
    }

    public String getState() {
        return this.state;
    }

    public int getSuspendedState() {
        return this.suspendState.getSuspendState();
    }

    public String getVersionId() {
        return ApplicationVersionUtils.getVersionId(this.appCtx.getApplicationId());
    }

    public String getActiveVersion() {
        String string = null;
        String string2 = null;
        boolean bl = false;
        string = ApplicationVersionUtils.getVersionId(this.appCtx.getApplicationId());
        boolean bl2 = bl = string != null && string.length() > 0;
        if (bl) {
            string2 = ApplicationVersionUtils.getActiveVersionId(this.appCtx.getApplicationName());
        }
        return string2;
    }

    public boolean isActiveVersion() {
        String string = null;
        boolean bl = true;
        String string2 = null;
        boolean bl2 = false;
        string = ApplicationVersionUtils.getVersionId(this.appCtx.getApplicationId());
        boolean bl3 = bl2 = string != null && string.length() > 0;
        if (bl2 && string.equals(string2 = ApplicationVersionUtils.getActiveVersionId(this.appCtx.getApplicationName()))) {
            bl = true;
        }
        return bl;
    }

    public boolean isVersioned() {
        String string = null;
        boolean bl = false;
        string = ApplicationVersionUtils.getVersionId(this.appCtx.getApplicationId());
        bl = string != null && string.length() > 0;
        return bl;
    }

    public ApplicationContextInternal getAppContext() {
        return this.appCtx;
    }

    Context getAdminObjectContext() {
        return this.adminObjectCtx;
    }

    public Context getConnectionFactoryContext() {
        return this.connectionFactoryCtx;
    }

    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    public AdapterLayer getAdapterLayer() {
        return this.adapterLayer;
    }

    public List getClassFinders() {
        return this.classFinders;
    }

    public void closeClassFinders() {
        Debug.println(this, ".closeClassFinders()");
        for (ClassFinder classFinder : this.classFinders) {
            classFinder.close();
        }
    }

    public void setRAInfo(AuthenticatedSubject authenticatedSubject, RAInfo rAInfo) {
        if (!SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)authenticatedSubject)) {
            throw new SecurityException("KernelId is required to call RAInstanceManager.setRAInfo, Subject '" + (authenticatedSubject == null ? "<null>" : authenticatedSubject.toString()) + "' is not the kernel identity");
        }
        this.raInfo = rAInfo;
    }

    public void createAdminObject(AdminObjInfo adminObjInfo, AuthenticatedSubject authenticatedSubject) throws RAException {
        String string = adminObjInfo.getAdminObjClass();
        String string2 = adminObjInfo.getInterface();
        Hashtable hashtable = adminObjInfo.getConfigProps();
        try {
            String string3;
            Class clazz = this.adapterLayer.forName(string, true, this.classloader, authenticatedSubject);
            Object object = this.adapterLayer.newInstance(clazz, authenticatedSubject);
            if (object instanceof ResourceAdapterAssociation && this.resourceAdapter != null) {
                this.adapterLayer.setResourceAdapter((ResourceAdapterAssociation)object, this.resourceAdapter, authenticatedSubject);
            }
            if (hashtable != null && hashtable.size() > 0) {
                Utils.setProperties(this, object, hashtable.values(), this.raValidationInfo.getAdminPropSetterTable(string2));
            }
            boolean bl = (string3 = adminObjInfo.getJndiName()) == null || string3.length() == 0;
            this.verifyAdminJNDIAndSaveObj(object, adminObjInfo, this.getVersionId(), bl);
        }
        catch (RACommonException rACommonException) {
            throw new RAException(rACommonException.toString(), (Throwable)((Object)rACommonException));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RAException(classNotFoundException.toString(), classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new RAException(instantiationException.toString(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RAException(illegalAccessException.toString(), illegalAccessException);
        }
        catch (Throwable throwable) {
            throw new RAException(throwable.toString(), throwable);
        }
    }

    public void bindAdminObject(String string) throws RACommonException {
        AdminObjVersionId adminObjVersionId = this.adminObjects.get(string);
        if (adminObjVersionId.appScoped) {
            JNDIHandler.bindAppScopedAdminObj(adminObjVersionId.adminObj, string, this.appCtx, this.adminObjectCtx, this.moduleName);
        } else {
            JNDIHandler.bindAdminObj(adminObjVersionId.adminObj, string, adminObjVersionId.versionId, this);
        }
    }

    public String getComponentName() {
        return this.connectorComponentName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void cleanupRuntime() throws ManagementException {
        if (this.connectorComponentRuntimeMBean != null) {
            this.connectorComponentRuntimeMBean.unregister();
            ConnectorService.getConnectorServiceRuntimeMBean().removeConnectorRuntime(this.connectorComponentRuntimeMBean);
        }
    }

    public ComponentRuntimeMBean getRuntime() {
        return this.connectorComponentRuntimeMBean;
    }

    public RAValidationInfo getRAValidationInfo() {
        return this.raValidationInfo;
    }

    private String getRuntimeName() {
        String string = ApplicationVersionUtils.replaceDelimiter(this.appCtx.getApplicationId(), '_');
        String string2 = string.endsWith(".rar") || string.equals(this.connectorComponentName) ? this.connectorComponentName : string + "_" + this.connectorComponentName;
        if (string2.endsWith(".rar")) {
            string2 = string2.substring(0, string2.length() - 4);
        }
        return string2;
    }

    private void setupWorkManagerRuntime(WorkManagerService workManagerService) throws RAException {
        if (this.workManagerRuntime == null && workManagerService != null) {
            try {
                this.workManagerRuntime = WorkManagerRuntimeMBeanImpl.getWorkManagerRuntime(workManagerService.getDelegate(), (ApplicationRuntimeMBean)this.connectorComponentRuntimeMBean.getParent(), this.connectorComponentRuntimeMBean);
            }
            catch (ManagementException managementException) {
                throw new RAException(managementException);
            }
        }
        if (this.workManagerRuntime != null) {
            this.connectorComponentRuntimeMBean.addWorkManagerRuntime(this.workManagerRuntime);
        }
    }

    public ConnectorComponentRuntimeMBeanImpl setupComponentRuntime() throws RAException {
        ServiceRuntimeMBeanImpl serviceRuntimeMBeanImpl = ConnectorService.getConnectorServiceRuntimeMBean();
        try {
            this.connectorComponentRuntimeMBean = new ConnectorComponentRuntimeMBeanImpl(this.getRuntimeName(), this.componentURI, this, this.appCtx.getRuntime(), serviceRuntimeMBeanImpl);
        }
        catch (ManagementException managementException) {
            throw new RAException(managementException);
        }
        serviceRuntimeMBeanImpl.addConnectorRuntime(this.connectorComponentRuntimeMBean);
        return this.connectorComponentRuntimeMBean;
    }

    public void rebindRA(String string) throws RAException {
        RAException rAException = new RAException();
        try {
            this.removeRAfromJNDITree(rAException);
            this.putRAintoJNDITree(string);
            this.jndiName = string;
            if (Debug.isDeploymentEnabled()) {
                Debug.deployment("Module '" + this.moduleName + "' rebinding RA with new JNDI name '" + string + "' and versionId = " + this.getVersionId());
            }
        }
        catch (RAException rAException2) {
            if (rAException.getErrors().hasNext()) {
                rAException.add((Throwable)((Object)rAException2));
                throw rAException;
            }
            throw rAException2;
        }
    }

    public boolean isWaitingStartVersioningComplete() {
        return this.waitingStartVersioningComplete;
    }

    public void clearWaitingStartVersioningComplete() {
        this.waitingStartVersioningComplete = false;
    }

    private class SuspendState {
        private int suspendState = 0;

        SuspendState() {
        }

        void suspendInbound() {
            this.suspendState |= 1;
        }

        void resumeInbound() {
            this.suspendState &= 0xFFFFFFFE;
        }

        void suspendOutbound() {
            this.suspendState |= 2;
        }

        void resumeOutbound() {
            this.suspendState &= 0xFFFFFFFD;
        }

        void suspendWork() {
            this.suspendState |= 4;
        }

        void resumeWork() {
            this.suspendState &= 0xFFFFFFFB;
        }

        void suspendAll() {
            this.suspendState = 7;
        }

        void resumeAll() {
            this.suspendState = 0;
        }

        boolean isAllSuspended() {
            return this.suspendState == 7;
        }

        boolean isAllResumed() {
            return this.suspendState == 0;
        }

        boolean isInboundSuspend() {
            return this.suspendState == 1;
        }

        boolean isOutboundSuspended() {
            return this.suspendState == 2;
        }

        boolean isWorkSuspended() {
            return this.suspendState == 4;
        }

        int getSuspendState() {
            return this.suspendState;
        }
    }

    private class AdminObjVersionId {
        Object adminObj;
        String versionId;
        boolean appScoped;
        AdminObjInfo adminInfo;

        private AdminObjVersionId(Object object, String string, boolean bl, AdminObjInfo adminObjInfo) {
            this.adminObj = object;
            this.versionId = string;
            this.appScoped = bl;
            this.adminInfo = adminObjInfo;
        }
    }
}

