/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.common;

import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.resource.ResourceException;
import javax.resource.spi.ApplicationServerInternalException;
import javax.resource.spi.ResourceAdapter;
import weblogic.connector.common.Debug;
import weblogic.connector.common.ManagementCountThreadLocal;
import weblogic.connector.common.RAInstanceManager;
import weblogic.connector.exception.RACommonException;
import weblogic.connector.exception.RAException;
import weblogic.connector.extensions.Suspendable;
import weblogic.connector.external.ConfigPropInfo;
import weblogic.connector.external.PropSetterTable;
import weblogic.j2ee.descriptor.ConfigPropertyBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.PlatformConstants;

public class Utils {
    public static void throwAsResourceException(String string, Throwable throwable) throws ResourceException {
        ResourceException resourceException = new ResourceException(string);
        resourceException.initCause(throwable);
        throw resourceException;
    }

    public static void throwAsApplicationServerInternalException(String string, Exception exception) throws ApplicationServerInternalException {
        ApplicationServerInternalException applicationServerInternalException = new ApplicationServerInternalException(string);
        applicationServerInternalException.initCause((Throwable)exception);
        throw applicationServerInternalException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProperties(RAInstanceManager rAInstanceManager, Object object, Collection collection, PropSetterTable propSetterTable) {
        if (object == null) {
            throw new AssertionError((Object)"obj == null");
        }
        Debug.enter("weblogic.connector.common.Utils", "setProperties( " + object.getClass().getName() + " )");
        try {
            Iterator iterator = collection.iterator();
            Debug.println("Iterate through all the config properties and (optionally) set them in the obj");
            String string = "";
            while (iterator.hasNext()) {
                Object object2;
                ConfigPropInfo configPropInfo = (ConfigPropInfo)iterator.next();
                if (configPropInfo.getValue() == null) continue;
                try {
                    ConfigPropertyBean configPropertyBean = propSetterTable.getRAProperty(configPropInfo.getName());
                    object2 = propSetterTable.getSetMethod(configPropertyBean);
                    if (object2 == null) continue;
                    Utils.invokeSetter((Method)object2, object, configPropInfo, rAInstanceManager);
                }
                catch (RuntimeException runtimeException) {
                    object2 = Debug.getExceptionPropertyValueTypeMismatch(configPropInfo.getName(), configPropInfo.getType(), configPropInfo.getValue(), runtimeException.toString());
                    string = string + (String)object2 + PlatformConstants.EOL;
                }
                catch (RACommonException rACommonException) {
                    string = string + rACommonException.getBaseMessage() + PlatformConstants.EOL;
                }
            }
            if (string.length() > 0) {
                Debug.logConfigPropWarning(object.getClass().getName(), rAInstanceManager != null ? rAInstanceManager.getModuleName() : "", string);
            }
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            Debug.exit("weblogic.connector.common.Utils", "setProperties() ");
            throw throwable;
        }
        Debug.exit("weblogic.connector.common.Utils", "setProperties() ");
    }

    private static void invokeSetter(Method method, Object object, ConfigPropInfo configPropInfo, RAInstanceManager rAInstanceManager) throws RACommonException, NumberFormatException {
        String string = configPropInfo.getType();
        String string2 = configPropInfo.getValue();
        String string3 = configPropInfo.getName();
        if (method == null) {
            throw new AssertionError((Object)"writeMethod == null in call to Utils.invokeSetter()");
        }
        Object object2 = Utils.getValueByType(string2, string);
        Object[] objectArray = new Object[]{object2};
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        try {
            rAInstanceManager.getAdapterLayer().invoke(method, object, objectArray, authenticatedSubject);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable != null && throwable instanceof PropertyVetoException) {
                Debug.logPropertyVetoWarning(object.getClass().getName(), string3, string, string2, throwable.toString());
            }
            String string4 = Debug.getExceptionInvokeSetter(string3);
            throw new RACommonException(string4, invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            String string5 = Debug.getExceptionInvokeSetter(string3);
            throw new RACommonException(string5, illegalAccessException);
        }
    }

    public static Object getValueByType(String string, String string2) throws NumberFormatException {
        Object object = null;
        if (string2.equals("java.lang.String")) {
            object = string;
        } else if (string2.equals("java.lang.Character") || string2.equals("char")) {
            object = new Character(string.charAt(0));
        } else if (string2.equals("java.lang.Boolean") || string2.equals("boolean")) {
            object = Boolean.valueOf(string);
        } else if (string2.equals("java.lang.Integer") || string2.equals("int")) {
            object = Integer.valueOf(string);
        } else if (string2.equals("java.lang.Double") || string2.equals("double")) {
            object = Double.valueOf(string);
        } else if (string2.equals("java.lang.Byte") || string2.equals("byte")) {
            object = Byte.valueOf(string);
        } else if (string2.equals("java.lang.Short") || string2.equals("short")) {
            object = Short.valueOf(string);
        } else if (string2.equals("java.lang.Long") || string2.equals("long")) {
            object = Long.valueOf(string);
        } else if (string2.equals("java.lang.Float") || string2.equals("float")) {
            object = Float.valueOf(string);
        } else {
            String string3 = Debug.getExceptionBadPropertyType(string2);
            throw new AssertionError((Object)string3);
        }
        return object;
    }

    public static RAException consolidateException(RAException rAException, Throwable throwable) {
        if (throwable != null) {
            if (rAException == null) {
                rAException = new RAException();
            }
            rAException.addError(throwable);
            if (throwable instanceof RAException) {
                RAException rAException2 = (RAException)((Object)throwable);
                Iterator iterator = rAException2.getErrors();
                Throwable throwable2 = null;
                while (iterator.hasNext()) {
                    throwable2 = (Throwable)iterator.next();
                    Utils.consolidateException(rAException, throwable2);
                }
            }
        }
        return rAException;
    }

    public static int getManagementCount() {
        return ManagementCountThreadLocal.get();
    }

    public static void startManagement() {
        ManagementCountThreadLocal.increment();
    }

    public static void stopManagement() {
        ManagementCountThreadLocal.decrement();
    }

    public static boolean isRAVersionable(RAInstanceManager rAInstanceManager, RAInstanceManager rAInstanceManager2) {
        ResourceAdapter resourceAdapter = null;
        if (rAInstanceManager2 != null) {
            resourceAdapter = rAInstanceManager2.getResourceAdapter();
        }
        ResourceAdapter resourceAdapter2 = rAInstanceManager.getResourceAdapter();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        bl = rAInstanceManager2 == null || resourceAdapter != null && resourceAdapter instanceof Suspendable && rAInstanceManager2.getAppContext().getRuntime().isEAR() && rAInstanceManager.getAdapterLayer().supportsVersioning((Suspendable)resourceAdapter, authenticatedSubject) && !rAInstanceManager2.getRAInfo().isEnableAccessOutsideApp();
        bl2 = resourceAdapter2 != null && resourceAdapter2 instanceof Suspendable && rAInstanceManager.getAppContext().getRuntime().isEAR() && rAInstanceManager.getAdapterLayer().supportsInit((Suspendable)resourceAdapter2, authenticatedSubject) && rAInstanceManager.getAdapterLayer().supportsVersioning((Suspendable)resourceAdapter2, authenticatedSubject) && !rAInstanceManager.getRAInfo().isEnableAccessOutsideApp();
        bl3 = bl && bl2;
        return bl3;
    }

    public static Class[] getInterfaces(Class clazz) {
        ArrayList arrayList = new ArrayList();
        Utils.addInterfacesRecusively(clazz, arrayList);
        Class[] classArray = new Class[arrayList.size()];
        return arrayList.toArray(classArray);
    }

    private static void addInterfacesRecusively(Class clazz, List list) {
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (!list.contains(classArray[i])) {
                list.add(classArray[i]);
            }
            Utils.addInterfacesRecusively(classArray[i], list);
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            Utils.addInterfacesRecusively(clazz2, list);
        }
    }
}

