/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.configuration;

import com.bea.connector.monitoring1Dot0.ActivationspecDocument;
import com.bea.connector.monitoring1Dot0.AdminObjectGroupDocument;
import com.bea.connector.monitoring1Dot0.AdminObjectInstanceDocument;
import com.bea.connector.monitoring1Dot0.AdminObjectsDocument;
import com.bea.connector.monitoring1Dot0.ConnectionInstanceDocument;
import com.bea.connector.monitoring1Dot0.ConnectionPoolParamsType;
import com.bea.connector.monitoring1Dot0.ConnectorDocument;
import com.bea.connector.monitoring1Dot0.InboundDocument;
import com.bea.connector.monitoring1Dot0.MessagelistenerDocument;
import com.bea.connector.monitoring1Dot0.OutboundDocument;
import com.bea.connector.monitoring1Dot0.OutboundGroupDocument;
import com.bea.connector.monitoring1Dot0.RequiredConfigPropertyDocument;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import weblogic.connector.common.Debug;
import weblogic.connector.configuration.Configuration_BaseImpl;
import weblogic.connector.external.ActivationSpecInfo;
import weblogic.connector.external.AdminObjInfo;
import weblogic.connector.external.ElementNotFoundException;
import weblogic.connector.external.InboundInfo;
import weblogic.connector.external.OutboundInfo;
import weblogic.connector.external.RAInfo;
import weblogic.connector.external.RequiredConfigPropInfo;

public class Configuration_1_0
extends Configuration_BaseImpl {
    private final String SCHEMA_LOCATION = "weblogic/connector/extensions/connectorMonitoring_1_0.xsd";
    private final String SCHEMA_VERSION = "1.0";

    public Configuration_1_0(RAInfo rAInfo) {
        super(rAInfo);
    }

    public String getSchema() {
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("weblogic/connector/extensions/connectorMonitoring_1_0.xsd");
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            char[] cArray = new char[1024];
            StringBuffer stringBuffer = new StringBuffer("");
            int n = 0;
            n = inputStreamReader.read(cArray, 0, 1024);
            while (n != -1) {
                stringBuffer.append(cArray, 0, n);
                n = inputStreamReader.read(cArray, 0, 1024);
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            String string = Debug.getExceptionMissingSchema();
            throw new MissingResourceException(string, "weblogic/connector/extensions/connectorMonitoring_1_0.xsd", "weblogic/connector/extensions/connectorMonitoring_1_0.xsd");
        }
    }

    public String getConfigurationVersion() {
        return "1.0";
    }

    public String getConfiguration() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String[] stringArray;
        String string6;
        ConnectorDocument connectorDocument = ConnectorDocument.Factory.newInstance();
        connectorDocument.setConnector(ConnectorDocument.Connector.Factory.newInstance());
        String string7 = this.raInfo.getJndiName();
        if (string7 != null && string7.trim().length() > 0) {
            connectorDocument.getConnector().setJndiName(string7.trim());
        }
        if ((string6 = this.raInfo.getSpecVersion()) != null && string6.trim().length() > 0) {
            connectorDocument.getConnector().setVersion(string6.trim());
        }
        if ((stringArray = this.raInfo.getRADescriptions()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                connectorDocument.getConnector().addDescription(stringArray[i]);
            }
        }
        if ((string5 = this.raInfo.getVendorName()) != null && string5.trim().length() > 0) {
            connectorDocument.getConnector().setVendorName(string5.trim());
        }
        if ((string4 = this.raInfo.getEisType()) != null && string4.trim().length() > 0) {
            connectorDocument.getConnector().setEisType(string4.trim());
        }
        if ((string3 = this.raInfo.getRAVersion()) != null && string3.trim().length() > 0) {
            connectorDocument.getConnector().setResourceadapterVersion(string3.trim());
        }
        if ((string2 = this.raInfo.getRAClass()) != null && string2.trim().length() > 0) {
            connectorDocument.getConnector().setResourceadapterClass(string2.trim());
        }
        if ((string = this.raInfo.getLinkref()) != null && string.trim().length() > 0) {
            connectorDocument.getConnector().setLinkRef(string.trim());
        }
        connectorDocument.getConnector().setEnableAccessOutsideApp(this.raInfo.isEnableAccessOutsideApp());
        this.setupOutbound(connectorDocument);
        this.setupAdminObjects(connectorDocument);
        this.setupInbound(connectorDocument);
        return connectorDocument.toString();
    }

    private void setupOutbound(ConnectorDocument connectorDocument) {
        List list = null;
        Iterator iterator = null;
        OutboundInfo outboundInfo = null;
        list = this.raInfo.getOutboundInfos();
        if (list != null) {
            iterator = list.iterator();
            OutboundDocument.Outbound outbound = OutboundDocument.Outbound.Factory.newInstance();
            OutboundGroupDocument.OutboundGroup outboundGroup = null;
            Hashtable<String, OutboundGroupDocument.OutboundGroup> hashtable = new Hashtable<String, OutboundGroupDocument.OutboundGroup>();
            ConnectionInstanceDocument.ConnectionInstance connectionInstance = null;
            ConnectionPoolParamsType connectionPoolParamsType = null;
            String string = null;
            String string2 = null;
            String string3 = null;
            while (iterator.hasNext()) {
                outboundInfo = (OutboundInfo)iterator.next();
                outbound = OutboundDocument.Outbound.Factory.newInstance();
                outboundGroup = (OutboundGroupDocument.OutboundGroup)hashtable.get(outboundInfo.getCFInterface());
                if (outboundGroup == null) {
                    outboundGroup = OutboundGroupDocument.OutboundGroup.Factory.newInstance();
                    outboundGroup.setConnectionFactoryInterface(outboundInfo.getCFInterface());
                    outboundGroup.setManagedconnectionfactoryClass(outboundInfo.getMCFClass());
                    hashtable.put(outboundInfo.getCFInterface(), outboundGroup);
                }
                connectionInstance = outboundGroup.addNewConnectionInstance();
                string = outboundInfo.getJndiName();
                string2 = outboundInfo.getResourceLink();
                if (string != null && string.trim().length() > 0) {
                    connectionInstance.setJndiName(string.trim());
                } else {
                    connectionInstance.setResourceLink(string2.trim());
                }
                string3 = outboundInfo.getDescription();
                if (string3 != null && string3.trim().length() > 0) {
                    connectionInstance.setDescription(string3.trim());
                }
                connectionInstance.setTransactionSupport(outboundInfo.getTransactionSupport());
                connectionPoolParamsType = ConnectionPoolParamsType.Factory.newInstance();
                connectionPoolParamsType.setInitialCapacity(BigInteger.valueOf(outboundInfo.getInitialCapacity()));
                connectionPoolParamsType.setMaxCapacity(BigInteger.valueOf(outboundInfo.getMaxCapacity()));
                connectionPoolParamsType.setCapacityIncrement(BigInteger.valueOf(outboundInfo.getCapacityIncrement()));
                connectionPoolParamsType.setShrinkingEnabled(outboundInfo.isShrinkingEnabled());
                connectionPoolParamsType.setShrinkFrequencySeconds(BigInteger.valueOf(outboundInfo.getShrinkFrequencySeconds()));
                connectionPoolParamsType.setHighestNumWaiters(BigInteger.valueOf(outboundInfo.getHighestNumWaiters()));
                connectionPoolParamsType.setHighestNumUnavailable(BigInteger.valueOf(outboundInfo.getHighestNumUnavailable()));
                connectionPoolParamsType.setConnectionCreationRetryFrequencySeconds(BigInteger.valueOf(outboundInfo.getConnectionCreationRetryFrequencySeconds()));
                connectionPoolParamsType.setConnectionReserveTimeoutSeconds(BigInteger.valueOf(outboundInfo.getConnectionReserveTimeoutSeconds()));
                connectionPoolParamsType.setTestFrequencySeconds(BigInteger.valueOf(outboundInfo.getTestFrequencySeconds()));
                connectionPoolParamsType.setTestConnectionsOnCreate(outboundInfo.isTestConnectionsOnCreate());
                connectionPoolParamsType.setTestConnectionsOnRelease(outboundInfo.isTestConnectionsOnRelease());
                connectionPoolParamsType.setTestConnectionsOnReserve(outboundInfo.isTestConnectionsOnReserve());
                connectionPoolParamsType.setProfileHarvestFrequencySeconds(BigInteger.valueOf(outboundInfo.getProfileHarvestFrequencySeconds()));
                connectionPoolParamsType.setIgnoreInUseConnectionsEnabled(outboundInfo.isIgnoreInUseConnectionsEnabled());
                connectionPoolParamsType.setMatchConnectionsSupported(outboundInfo.isMatchConnectionsSupported());
                connectionInstance.setPoolParams(connectionPoolParamsType);
            }
            Collection collection = hashtable.values();
            Iterator iterator2 = collection.iterator();
            OutboundGroupDocument.OutboundGroup[] outboundGroupArray = new OutboundGroupDocument.OutboundGroup[collection.size()];
            int n = 0;
            while (iterator2.hasNext()) {
                outboundGroupArray[n] = (OutboundGroupDocument.OutboundGroup)iterator2.next();
                ++n;
            }
            outbound.setOutboundGroupArray(outboundGroupArray);
            connectorDocument.getConnector().setOutbound(outbound);
        }
    }

    private void setupAdminObjects(ConnectorDocument connectorDocument) {
        List list = this.raInfo.getAdminObjs();
        Hashtable<String, AdminObjectGroupDocument.AdminObjectGroup> hashtable = new Hashtable<String, AdminObjectGroupDocument.AdminObjectGroup>();
        AdminObjectGroupDocument.AdminObjectGroup adminObjectGroup = null;
        AdminObjectsDocument.AdminObjects adminObjects = null;
        if (list != null && list.size() > 0) {
            Object object;
            Object object2;
            adminObjects = AdminObjectsDocument.AdminObjects.Factory.newInstance();
            for (AdminObjInfo adminObjInfo : list) {
                adminObjectGroup = (AdminObjectGroupDocument.AdminObjectGroup)hashtable.get(adminObjInfo.getInterface());
                if (adminObjectGroup == null) {
                    adminObjectGroup = AdminObjectGroupDocument.AdminObjectGroup.Factory.newInstance();
                    adminObjectGroup.setAdminObjectInterface(adminObjInfo.getInterface());
                    hashtable.put(adminObjInfo.getInterface(), adminObjectGroup);
                }
                AdminObjectInstanceDocument.AdminObjectInstance adminObjectInstance = adminObjectGroup.addNewAdminObjectInstance();
                object2 = adminObjInfo.getJndiName();
                object = adminObjInfo.getResourceLink();
                if (object2 != null && ((String)object2).trim().length() > 0) {
                    adminObjectInstance.setJndiName(((String)object2).trim());
                    continue;
                }
                adminObjectInstance.setResourceLink(((String)object).trim());
            }
            object2 = hashtable.values();
            object = object2.iterator();
            AdminObjectGroupDocument.AdminObjectGroup[] adminObjectGroupArray = new AdminObjectGroupDocument.AdminObjectGroup[object2.size()];
            int n = 0;
            while (object.hasNext()) {
                adminObjectGroupArray[n] = (AdminObjectGroupDocument.AdminObjectGroup)object.next();
                ++n;
            }
            adminObjects.setAdminObjectGroupArray(adminObjectGroupArray);
            connectorDocument.getConnector().setAdminObjects(adminObjects);
        }
    }

    private void setupInbound(ConnectorDocument connectorDocument) {
        List list = null;
        Iterator iterator = null;
        InboundDocument.Inbound inbound = null;
        Hashtable<String, MessagelistenerDocument.Messagelistener> hashtable = new Hashtable<String, MessagelistenerDocument.Messagelistener>();
        InboundInfo inboundInfo = null;
        try {
            list = this.raInfo.getInboundInfos();
            iterator = list.iterator();
            inbound = InboundDocument.Inbound.Factory.newInstance();
            List list2 = null;
            Iterator iterator2 = null;
            RequiredConfigPropertyDocument.RequiredConfigProperty requiredConfigProperty = null;
            RequiredConfigPropInfo requiredConfigPropInfo2 = null;
            while (iterator.hasNext()) {
                ActivationSpecInfo activationSpecInfo;
                inboundInfo = (InboundInfo)iterator.next();
                MessagelistenerDocument.Messagelistener messagelistener = (MessagelistenerDocument.Messagelistener)hashtable.get(inboundInfo.getMsgType());
                if (messagelistener == null) {
                    messagelistener = inbound.addNewMessagelistener();
                    messagelistener.setMessagelistenerType(inboundInfo.getMsgType());
                    hashtable.put(inboundInfo.getMsgType(), messagelistener);
                }
                if ((activationSpecInfo = inboundInfo.getActivationSpec()) == null) continue;
                ActivationspecDocument.Activationspec activationspec = messagelistener.addNewActivationspec();
                activationspec.setActivationspecClass(activationSpecInfo.getActivationSpecClass());
                list2 = activationSpecInfo.getRequiredProps();
                if (list2 == null) continue;
                for (RequiredConfigPropInfo requiredConfigPropInfo2 : list2) {
                    String[] stringArray = requiredConfigPropInfo2.getDescriptions();
                    requiredConfigProperty = activationspec.addNewRequiredConfigProperty();
                    if (stringArray != null && stringArray.length > 0) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            requiredConfigProperty.addDescription(stringArray[i]);
                        }
                    }
                    requiredConfigProperty.setConfigPropertyName(requiredConfigPropInfo2.getName());
                }
            }
            connectorDocument.getConnector().setInbound(inbound);
        }
        catch (ElementNotFoundException elementNotFoundException) {
            // empty catch block
        }
    }
}

