/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.configuration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarFile;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.application.descriptor.AbstractDescriptorLoader;
import weblogic.application.descriptor.BasicMunger;
import weblogic.application.descriptor.NamespaceURIMunger;
import weblogic.connector.common.JCAConnectionFactoryRegistry;
import weblogic.connector.configuration.RAReader;
import weblogic.connector.configuration.WlsRAReader;
import weblogic.connector.exception.RAConfigurationException;
import weblogic.connector.exception.WLRAConfigurationException;
import weblogic.deploy.internal.DeploymentPlanDescriptorLoader;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.j2ee.descriptor.ConnectorBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.WeblogicConnectorBean;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public final class ConnectorDescriptor {
    public static final String STANDARD_DD_FILENAME = "ra.xml";
    public static final String WEBLOGIC_DD_FILENAME = "weblogic-ra.xml";
    public static final String STANDARD_DD = "META-INF/ra.xml";
    public static final String WEBLOGIC_DD = "META-INF/weblogic-ra.xml";
    private MyConnectorDescriptor connectorDescriptor;
    private MyWlsConnectorDescriptor wlsConnectorDescriptor;
    private AtomicBoolean registeredConnectionFactory = new AtomicBoolean(false);

    public ConnectorDescriptor(File file, VirtualJarFile virtualJarFile, File file2, DeploymentPlanBean deploymentPlanBean, String string) {
        this.connectorDescriptor = file != null ? new MyConnectorDescriptor(file) : new MyConnectorDescriptor(virtualJarFile);
        this.wlsConnectorDescriptor = new MyWlsConnectorDescriptor(virtualJarFile, file2, deploymentPlanBean, string);
    }

    public ConnectorDescriptor(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string) {
        if (file == null || file.getName().endsWith(WEBLOGIC_DD_FILENAME)) {
            this.wlsConnectorDescriptor = new MyWlsConnectorDescriptor(file, file2, deploymentPlanBean, string);
        } else {
            this.connectorDescriptor = new MyConnectorDescriptor(file);
        }
    }

    public ConnectorDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string) {
        this.connectorDescriptor = new MyConnectorDescriptor(descriptorManager, genericClassLoader);
        this.wlsConnectorDescriptor = new MyWlsConnectorDescriptor(descriptorManager, genericClassLoader, file, deploymentPlanBean, string);
    }

    public ConnectorDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader) {
        this(descriptorManager, genericClassLoader, true);
    }

    public ConnectorDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, boolean bl) {
        this.connectorDescriptor = new MyConnectorDescriptor(descriptorManager, genericClassLoader);
        this.wlsConnectorDescriptor = new MyWlsConnectorDescriptor(descriptorManager, genericClassLoader, bl);
    }

    public void mergeConnector(VirtualJarFile virtualJarFile) throws IOException, XMLStreamException {
        MyConnectorDescriptor myConnectorDescriptor = new MyConnectorDescriptor(virtualJarFile);
        this.connectorDescriptor.getMergedDescriptorBean(myConnectorDescriptor);
        MyWlsConnectorDescriptor myWlsConnectorDescriptor = new MyWlsConnectorDescriptor(virtualJarFile, null, null, null);
        this.wlsConnectorDescriptor.getMergedDescriptorBean(myWlsConnectorDescriptor);
    }

    public ConnectorBean getConnectorBean() throws RAConfigurationException {
        try {
            ConnectorBean connectorBean;
            ConnectorBean connectorBean2 = connectorBean = this.connectorDescriptor == null ? null : (ConnectorBean)this.connectorDescriptor.getRootDescriptorBean();
            if (this.registeredConnectionFactory.compareAndSet(false, true)) {
                JCAConnectionFactoryRegistry.getInstance().registerConnectionFactory(connectorBean);
            }
            return connectorBean;
        }
        catch (IOException iOException) {
            throw new RAConfigurationException(iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new RAConfigurationException(xMLStreamException);
        }
    }

    public WeblogicConnectorBean getWeblogicConnectorBean() throws WLRAConfigurationException {
        try {
            if (this.wlsConnectorDescriptor == null) {
                return null;
            }
            if (this.wlsConnectorDescriptor.getDeploymentPlan() != null) {
                return (WeblogicConnectorBean)this.wlsConnectorDescriptor.getPlanMergedDescriptorBean();
            }
            return (WeblogicConnectorBean)this.wlsConnectorDescriptor.getRootDescriptorBean();
        }
        catch (IOException iOException) {
            throw new WLRAConfigurationException(iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WLRAConfigurationException(xMLStreamException);
        }
    }

    public AbstractDescriptorLoader getWlsRaDescriptorLoader() {
        return this.wlsConnectorDescriptor;
    }

    public AbstractDescriptorLoader getRaDescriptorLoader() {
        return this.connectorDescriptor;
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Object object2;
        if (stringArray.length < 1) {
            ConnectorDescriptor.usage();
        }
        if (stringArray[0].lastIndexOf("create") > -1) {
            object2 = new DescriptorManager();
            object = object2.createDescriptorRoot(ConnectorBean.class);
            object.toXML((OutputStream)System.out);
            System.out.println("\n\n\n");
            object = object2.createDescriptorRoot(WeblogicConnectorBean.class);
            object.toXML((OutputStream)System.out);
            System.exit(0);
        }
        try {
            object2 = stringArray[0];
            object = new File((String)object2);
            if (((File)object).getName().endsWith(".rar")) {
                JarFile jarFile = new JarFile((String)object2);
                VirtualJarFile virtualJarFile = VirtualJarFactory.createVirtualJar((JarFile)jarFile);
                System.out.println("\n\n... getting ConnectorBean:");
                ConnectorDescriptor connectorDescriptor = new ConnectorDescriptor(null, virtualJarFile, null, null, null);
                ConnectorBean connectorBean = connectorDescriptor.getConnectorBean();
                if (connectorBean != null) {
                    ((DescriptorBean)connectorBean).getDescriptor().toXML((OutputStream)System.out);
                } else {
                    System.out.println("... connector bean was null");
                }
                System.out.println("\n\n... getting WeblogicConnectorBean:");
                WeblogicConnectorBean weblogicConnectorBean = new ConnectorDescriptor(null, virtualJarFile, null, null, null).getWeblogicConnectorBean();
                ((DescriptorBean)weblogicConnectorBean).getDescriptor().toXML((OutputStream)System.out);
                if (stringArray.length > 1) {
                    JarFile jarFile2 = new JarFile(stringArray[1]);
                    VirtualJarFile virtualJarFile2 = VirtualJarFactory.createVirtualJar((JarFile)jarFile2);
                    System.out.println("\n\n... getting 2nd ConnectorBean:");
                    connectorDescriptor.mergeConnector(virtualJarFile2);
                    ((DescriptorBean)connectorDescriptor.getConnectorBean()).getDescriptor().toXML((OutputStream)System.out);
                }
            } else if (((File)object).getPath().endsWith(WEBLOGIC_DD_FILENAME)) {
                System.out.println("\n\n... getting WeblogicConnectorBean from: " + object);
                WeblogicConnectorBean weblogicConnectorBean = new ConnectorDescriptor((File)object, null, null, null).getWeblogicConnectorBean();
                ((DescriptorBean)weblogicConnectorBean).getDescriptor().toXML((OutputStream)System.out);
                if (stringArray.length > 1) {
                    File file = new File(stringArray[1]);
                    if (file.getPath().endsWith(".xml")) {
                        System.out.println("\n\n... plan:");
                        DeploymentPlanDescriptorLoader deploymentPlanDescriptorLoader = new DeploymentPlanDescriptorLoader(file);
                        DeploymentPlanBean deploymentPlanBean = deploymentPlanDescriptorLoader.getDeploymentPlanBean();
                        ((DescriptorBean)deploymentPlanBean).getDescriptor().toXML((OutputStream)System.out);
                        if (stringArray.length > 2) {
                            ConnectorDescriptor connectorDescriptor = null;
                            File file2 = null;
                            if (deploymentPlanBean.getConfigRoot() != null) {
                                file2 = new File(deploymentPlanBean.getConfigRoot());
                            }
                            connectorDescriptor = ((String)object2).startsWith("null") ? new ConnectorDescriptor(null, file2, deploymentPlanBean, stringArray[2]) : new ConnectorDescriptor((File)object, file2, deploymentPlanBean, stringArray[2]);
                            System.out.println("\n\n... plan merged:");
                            ((DescriptorBean)connectorDescriptor.getWeblogicConnectorBean()).getDescriptor().toXML((OutputStream)System.out);
                        } else {
                            System.out.println("\n\nNO MODULE NAME\n\nusage: java weblogic.connector.configuration.ConnectorDescriptor weblogic-ra.xml plan.xml module-name");
                        }
                    } else {
                        System.out.println("\n\nPlan file '" + file.getPath() + "' does not have .xml extension.  Will not attempt merge.");
                    }
                }
            } else if (((File)object).getPath().endsWith(STANDARD_DD_FILENAME)) {
                System.out.println("\n\n... getting ConnectorBean:");
                ConnectorBean connectorBean = new ConnectorDescriptor((File)object, null, null, null).getConnectorBean();
                ((DescriptorBean)connectorBean).getDescriptor().toXML((OutputStream)System.out);
            } else {
                System.out.println("\n\n... neither ra nor weblogic-rxa xml specified");
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            System.out.println(exception.getMessage());
            System.out.println(exception.getCause());
            exception.printStackTrace();
        }
    }

    private static void usage() {
        System.err.println("usage: java weblogic.connector.configuration.ConnectorDescriptor <descriptor file name>");
        System.err.println("\n\n example:\n java weblogic.connector.configuration.ConnectorDescriptor jar or altDD file name ");
        System.exit(0);
    }

    private class MyWlsConnectorDescriptor
    extends AbstractDescriptorLoader {
        private boolean createExtensionBean;

        MyWlsConnectorDescriptor(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string) {
            super(virtualJarFile, file, deploymentPlanBean, string);
            this.createExtensionBean = true;
        }

        MyWlsConnectorDescriptor(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string) {
            super(file, file2, deploymentPlanBean, string);
            this.createExtensionBean = true;
        }

        MyWlsConnectorDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string) {
            super(descriptorManager, genericClassLoader, file, deploymentPlanBean, string);
            this.createExtensionBean = true;
        }

        MyWlsConnectorDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader) {
            super(descriptorManager, genericClassLoader);
            this.createExtensionBean = true;
        }

        MyWlsConnectorDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, boolean bl) {
            super(descriptorManager, genericClassLoader);
            this.createExtensionBean = bl;
        }

        public String getDocumentURI() {
            return ConnectorDescriptor.WEBLOGIC_DD;
        }

        protected BasicMunger createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
            ConnectorBean connectorBean = null;
            try {
                connectorBean = ConnectorDescriptor.this.getConnectorBean();
            }
            catch (RAConfigurationException rAConfigurationException) {
                // empty catch block
            }
            return new WlsRAReader(connectorBean, this.createXMLStreamReaderDelegate(inputStream), this, this.getDeploymentPlan(), this.getModuleName(), this.getDocumentURI(), this.createExtensionBean);
        }

        public XMLStreamReader createXMLStreamReaderDelegate(InputStream inputStream) throws XMLStreamException {
            String[] stringArray = new String[]{"http://www.bea.com/ns/weblogic/90", "http://www.bea.com/ns/weblogic/weblogic-connector"};
            return new NamespaceURIMunger(inputStream, "http://xmlns.oracle.com/weblogic/weblogic-connector", stringArray);
        }
    }

    private class MyConnectorDescriptor
    extends AbstractDescriptorLoader {
        MyConnectorDescriptor(File file) {
            super(file);
        }

        MyConnectorDescriptor(VirtualJarFile virtualJarFile) {
            super(virtualJarFile);
        }

        MyConnectorDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader) {
            super(descriptorManager, genericClassLoader);
        }

        public String getDocumentURI() {
            return ConnectorDescriptor.STANDARD_DD;
        }

        protected BasicMunger createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
            return new RAReader(this.createXMLStreamReaderDelegate(inputStream), (AbstractDescriptorLoader)this);
        }
    }
}

