/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.configuration;

import weblogic.connector.common.Debug;
import weblogic.xml.process.SAXValidationException;

public abstract class DDLoader {
    public static final String CONNECTOR10_RAR_PUBLIC_ID = "-//Sun Microsystems, Inc.//DTD Connector 1.0//EN";

    protected void validateInitialCapacity(int n) throws SAXValidationException {
        if (n < 0) {
            String string = Debug.getExceptionInitialCapacityMustBePositive();
            throw new SAXValidationException(string);
        }
    }

    protected void validateShrinkPeriodMinutes(int n) throws SAXValidationException {
        this.validateShrinkFrequencySeconds(n * 60);
    }

    protected void validateShrinkFrequencySeconds(int n) throws SAXValidationException {
        if (n <= 0) {
            String string = Debug.getExceptionShrinkFrequencySecondsMustBePositive();
            throw new SAXValidationException(string);
        }
    }

    protected void validateMaxIdleTime(int n) throws SAXValidationException {
        this.validateInactiveConnectionTimeoutSeconds(n);
    }

    protected void validateInactiveConnectionTimeoutSeconds(int n) throws SAXValidationException {
        if (n < 0) {
            String string = Debug.getExceptionInactiveConnectionTimeoutSecondsNegative();
            throw new SAXValidationException(string);
        }
    }

    protected void printDeprecationWarning(String string, String string2) {
        if (string2 != null) {
            Debug.logDeprecationReplacedWarning(string, string2);
        } else {
            Debug.logDeprecationNotUsedWarning(string);
        }
    }

    protected void printDeletionWarning(String string) {
        Debug.logDeprecationNotUsedWarning(string);
    }
}

