/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.configuration;

import java.io.File;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.connector.common.Debug;
import weblogic.connector.configuration.ConnectorDescriptor;
import weblogic.connector.configuration.DDValidator;
import weblogic.connector.exception.RAConfigurationException;
import weblogic.connector.exception.WLRAConfigurationException;
import weblogic.connector.external.AuthMechInfo;
import weblogic.connector.external.ConfigPropInfo;
import weblogic.connector.external.ConnectorUtils;
import weblogic.connector.external.LoggingInfo;
import weblogic.connector.external.OutboundInfo;
import weblogic.connector.external.PoolInfo;
import weblogic.connector.external.RAInfo;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.j2ee.descriptor.AdminObjectBean;
import weblogic.j2ee.descriptor.ConnectorBean;
import weblogic.j2ee.descriptor.ResourceAdapterBean;
import weblogic.j2ee.descriptor.wl.AdminObjectGroupBean;
import weblogic.j2ee.descriptor.wl.AdminObjectInstanceBean;
import weblogic.j2ee.descriptor.wl.AdminObjectsBean;
import weblogic.j2ee.descriptor.wl.ConnectionDefinitionBean;
import weblogic.j2ee.descriptor.wl.ConnectionDefinitionPropertiesBean;
import weblogic.j2ee.descriptor.wl.ConnectionInstanceBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.OutboundResourceAdapterBean;
import weblogic.j2ee.descriptor.wl.PoolParamsBean;
import weblogic.j2ee.descriptor.wl.WeblogicConnectorBean;
import weblogic.j2ee.descriptor.wl.WeblogicConnectorExtensionBean;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public class DDUtil {
    private static final String FILE_URL_PREFIX = "file:/";
    private static final String CLASS_NAME = "weblogic.connector.configuration.DDUtil";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RAInfo getRAInfo(VirtualJarFile virtualJarFile, File file, String string, AppDeploymentMBean appDeploymentMBean, DeploymentPlanBean deploymentPlanBean) throws RAConfigurationException, WLRAConfigurationException {
        RAInfo rAInfo;
        try {
            RAInfo rAInfo2;
            Object object;
            Debug.enter(CLASS_NAME, "getRAInfo()");
            Debug.parsing("Validating the RAR and the alternate descriptor");
            DDValidator.validateRARAndAltDD(virtualJarFile, file);
            Debug.println(CLASS_NAME, ".getRAInfo() Get the config directory");
            File file2 = null;
            String string2 = appDeploymentMBean == null ? string : appDeploymentMBean.getApplicationIdentifier();
            if (appDeploymentMBean != null && appDeploymentMBean.getPlanDir() != null) {
                file2 = new File(appDeploymentMBean.getLocalPlanDir());
            }
            Debug.parsing("Constructing the ConnectorDescriptor");
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            ConnectorBean connectorBean = null;
            WeblogicConnectorBean weblogicConnectorBean = null;
            try {
                Thread.currentThread().setContextClassLoader(DDUtil.class.getClassLoader());
                object = new ConnectorDescriptor(file, virtualJarFile, file2, deploymentPlanBean, DDUtil.getNameForMerging(virtualJarFile));
                Debug.println(CLASS_NAME, ".getRAInfo() Get the connector bean");
                connectorBean = ((ConnectorDescriptor)object).getConnectorBean();
                Debug.println(CLASS_NAME, ".getRAInfo() Get the weblogic connector bean");
                weblogicConnectorBean = ((ConnectorDescriptor)object).getWeblogicConnectorBean();
                rAInfo = null;
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                Thread.currentThread().setContextClassLoader(classLoader);
                throw throwable;
            }
            if (connectorBean == null) {
                if (weblogicConnectorBean instanceof WeblogicConnectorExtensionBean) {
                    if (!DDValidator.isLinkRef((WeblogicConnectorExtensionBean)weblogicConnectorBean)) {
                        object = Debug.getExceptionMustBeLinkRef();
                        throw new WLRAConfigurationException((String)object);
                    }
                } else {
                    object = Debug.getExceptionNeedsRAXML();
                    throw new WLRAConfigurationException((String)object);
                }
            }
            if (weblogicConnectorBean == null) {
                weblogicConnectorBean = DDUtil.createDefaultWLConnBean(connectorBean, DDUtil.getDefaultBaseJndiName(string2, string));
            }
            Debug.println(CLASS_NAME, ".getRAInfo()Get the url");
            object = DDUtil.getRAURL(virtualJarFile.getName());
            rAInfo = rAInfo2 = ConnectorUtils.raInfo.createRAInfo(connectorBean, weblogicConnectorBean, (URL)object, string);
            Object var14_15 = null;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            Debug.exit(CLASS_NAME, "getRAInfo()");
            throw throwable;
        }
        Debug.exit(CLASS_NAME, "getRAInfo()");
        return rAInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateRAInfo(RAInfo rAInfo) throws RAConfigurationException {
        Debug.enter(CLASS_NAME, "validateRAInfo(...)");
        try {
            boolean bl = false;
            String string = "";
            List list = rAInfo.getOutboundInfos();
            if (list != null && list.size() > 0) {
                for (OutboundInfo outboundInfo : list) {
                    if (outboundInfo == null || outboundInfo.getInitialCapacity() <= outboundInfo.getMaxCapacity()) continue;
                    bl = true;
                    string = string + Debug.getExceptionMaxCapacityLessThanInitialCapacity(outboundInfo.getJndiName()) + "\n";
                }
            }
            if (bl) {
                throw new RAConfigurationException(string);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Debug.exit(CLASS_NAME, "validateRAInfo(...)");
            throw throwable;
        }
        Debug.exit(CLASS_NAME, "validateRAInfo(...)");
    }

    private static URL getRAURL(String string) throws RAConfigurationException {
        URL uRL;
        try {
            Debug.enter(CLASS_NAME, "getRAURL()");
            String string2 = new String(FILE_URL_PREFIX).concat(string);
            uRL = new URL(string2);
            Object var4_4 = null;
        }
        catch (MalformedURLException malformedURLException) {
            try {
                throw new RAConfigurationException(malformedURLException);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                Debug.exit(CLASS_NAME, "getRAURL()");
                throw throwable;
            }
        }
        Debug.exit(CLASS_NAME, "getRAURL()");
        return uRL;
    }

    private static WeblogicConnectorBean createDefaultWLConnBean(ConnectorBean connectorBean, String string) {
        Debug.parsing("Resource Adapter being deployed does not have weblogic-ra.xml -- a default is being created.");
        WeblogicConnectorBean weblogicConnectorBean = (WeblogicConnectorBean)new DescriptorManager().createDescriptorRoot(WeblogicConnectorBean.class).getRootBean();
        weblogicConnectorBean.setNativeLibdir("/temp/nativelibs/");
        Debug.parsing("Setting adapter jndi name to '" + DDUtil.getDefaultJndiNameForRABean(string) + "'");
        weblogicConnectorBean.setJNDIName(DDUtil.getDefaultJndiNameForRABean(string));
        DDUtil.setDefaultOutboundRAs(connectorBean, weblogicConnectorBean, string);
        DDUtil.setDefaultAdminObjects(connectorBean, weblogicConnectorBean, string);
        return weblogicConnectorBean;
    }

    private static void setDefaultOutboundRAs(ConnectorBean connectorBean, WeblogicConnectorBean weblogicConnectorBean, String string) {
        ResourceAdapterBean resourceAdapterBean = connectorBean.getResourceAdapter();
        weblogic.j2ee.descriptor.OutboundResourceAdapterBean outboundResourceAdapterBean = resourceAdapterBean.getOutboundResourceAdapter();
        if (outboundResourceAdapterBean == null) {
            if (weblogicConnectorBean.getOutboundResourceAdapter() != null) {
                weblogicConnectorBean.destroyOutboundResourceAdapter(weblogicConnectorBean.getOutboundResourceAdapter());
            }
        } else {
            weblogic.j2ee.descriptor.ConnectionDefinitionBean[] connectionDefinitionBeanArray = outboundResourceAdapterBean.getConnectionDefinitions();
            int n = connectionDefinitionBeanArray.length;
            if (n > 0) {
                OutboundResourceAdapterBean outboundResourceAdapterBean2 = weblogicConnectorBean.createOutboundResourceAdapter();
                DDUtil.setDefaultMaxCapacity(outboundResourceAdapterBean2);
                for (int i = 0; i < connectionDefinitionBeanArray.length; ++i) {
                    ConnectionDefinitionBean connectionDefinitionBean = outboundResourceAdapterBean2.createConnectionDefinitionGroup();
                    String string2 = connectionDefinitionBeanArray[i].getConnectionFactoryInterface();
                    if (Debug.isParsingEnabled()) {
                        Debug.parsing("Setting ConnectionFactoryInterface of conn defn group[" + i + "] to '" + string2 + "'");
                    }
                    connectionDefinitionBean.setConnectionFactoryInterface(string2);
                    ConnectionInstanceBean connectionInstanceBean = connectionDefinitionBean.createConnectionInstance();
                    String string3 = DDUtil.getDefaultJndiName(string, string2.replace('.', '_'));
                    if (Debug.isParsingEnabled()) {
                        Debug.parsing("Setting JNDI name of conn instance[" + i + "] to '" + string3 + "'");
                    }
                    connectionInstanceBean.setJNDIName(string3);
                }
            }
        }
    }

    private static void setDefaultAdminObjects(ConnectorBean connectorBean, WeblogicConnectorBean weblogicConnectorBean, String string) {
        ResourceAdapterBean resourceAdapterBean = connectorBean.getResourceAdapter();
        AdminObjectBean[] adminObjectBeanArray = resourceAdapterBean.getAdminObjects();
        if (adminObjectBeanArray.length > 0) {
            AdminObjectsBean adminObjectsBean = weblogicConnectorBean.createAdminObjects();
            for (int i = 0; i < adminObjectBeanArray.length; ++i) {
                String string2 = adminObjectBeanArray[i].getAdminObjectInterface();
                AdminObjectGroupBean adminObjectGroupBean = adminObjectsBean.createAdminObjectGroup();
                if (Debug.isParsingEnabled()) {
                    Debug.parsing("Setting AdminObjectInterface of admin obj group[" + i + "] to '" + string2 + "'");
                }
                adminObjectGroupBean.setAdminObjectInterface(string2);
                AdminObjectInstanceBean adminObjectInstanceBean = adminObjectGroupBean.createAdminObjectInstance();
                String string3 = DDUtil.getDefaultJndiName(string, string2.replace('.', '_'));
                if (Debug.isParsingEnabled()) {
                    Debug.parsing("Setting JNDI name of Admin Obj instance[" + i + "] to '" + string3 + "'");
                }
                adminObjectInstanceBean.setJNDIName(string3);
            }
        }
    }

    private static void setDefaultMaxCapacity(OutboundResourceAdapterBean outboundResourceAdapterBean) {
        ConnectionDefinitionPropertiesBean connectionDefinitionPropertiesBean = outboundResourceAdapterBean.createDefaultConnectionProperties();
        PoolParamsBean poolParamsBean = connectionDefinitionPropertiesBean.createPoolParams();
        poolParamsBean.setMaxCapacity(Integer.MAX_VALUE);
    }

    private static String getNameForMerging(VirtualJarFile virtualJarFile) {
        String[] stringArray;
        String string = virtualJarFile.getName();
        String string2 = virtualJarFile.getName();
        String string3 = File.separator;
        if (string3.equals("\\")) {
            string3 = "\\\\";
        }
        if ((stringArray = string2.split(string3)) != null) {
            string = stringArray[stringArray.length - 1];
        }
        return string;
    }

    private static String getAppName(String string) {
        String string2 = null;
        if ((string = ApplicationVersionUtils.replaceDelimiter(string, '_')) == null || string.trim().length() == 0) {
            Debug.throwAssertionError("AppId is null or empty : " + string);
        } else {
            string2 = string.endsWith(".rar") || string.endsWith(".ear") ? string.substring(0, string.length() - 4) : string;
        }
        return string2;
    }

    public static String getModuleName(String string) {
        if (string == null || string.trim().length() == 0) {
            Debug.throwAssertionError("Module name is null or empty : " + string);
        } else if (string.endsWith(".rar")) {
            string = string.substring(0, string.length() - 4);
        }
        return string;
    }

    private static String getDefaultBaseJndiName(String string, String string2) {
        String string3;
        String string4 = null;
        String string5 = DDUtil.getAppName(string);
        string4 = string5.equals(string3 = DDUtil.getModuleName(string2)) ? "eis/" + string5 : "eis/" + string5 + "_" + string3;
        return string4;
    }

    private static String getDefaultJndiNameForRABean(String string) {
        return string + "_RABean";
    }

    private static String getDefaultJndiName(String string, String string2) {
        return string + "_" + string2;
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        if (stringArray.length >= 1) {
            if (stringArray[0].equalsIgnoreCase("testLinkRefs") && stringArray.length == 3) {
                bl = true;
                DDUtil.testLinkRefs(stringArray[1], stringArray[2]);
            } else if (stringArray[0].equalsIgnoreCase("testNoWLRaXML") && stringArray.length == 2) {
                bl = true;
                DDUtil.testNoWLraXML(stringArray[1]);
            } else if (stringArray[0].equalsIgnoreCase("testConsoleUtility") && stringArray.length == 4) {
                bl = true;
                DDUtil.testConsoleUtility(stringArray[1], stringArray[2], stringArray[3]);
            } else if (stringArray[0].equalsIgnoreCase("testDefaultBaseJndiName") && stringArray.length == 4) {
                bl = true;
                System.out.println("RABean JNDI Name : " + DDUtil.getDefaultJndiNameForRABean(DDUtil.getDefaultBaseJndiName(stringArray[1], stringArray[2])));
                System.out.println("Other JNDI Name : " + DDUtil.getDefaultJndiName(DDUtil.getDefaultBaseJndiName(stringArray[1], stringArray[2]), stringArray[3]));
            }
        }
        if (!bl) {
            DDUtil.printMainUsage();
        }
    }

    private static void testConsoleUtility(String string, String string2, String string3) {
        VirtualJarFile virtualJarFile = null;
        File file = null;
        try {
            Object object;
            Object object2;
            file = new File(string);
            virtualJarFile = VirtualJarFactory.createVirtualJar((File)file);
            RAInfo rAInfo = DDUtil.getRAInfo(virtualJarFile, null, "connector", null, null);
            System.out.println("raInfo : " + rAInfo);
            Hashtable hashtable = rAInfo.getAdminObjectGroupProperties(string2);
            Enumeration enumeration = hashtable.elements();
            System.out.println("--------------\nAdmin Group Config Properties\n--------------");
            System.out.println("HT Size : " + hashtable.size());
            while (enumeration.hasMoreElements()) {
                object2 = (ConfigPropInfo)enumeration.nextElement();
                System.out.println("--------------");
                System.out.println("Description : " + object2.getDescription());
                System.out.println("Name : " + object2.getName());
                System.out.println("Type : " + object2.getType());
                System.out.println("Value : " + object2.getValue());
                System.out.println("--------------");
            }
            hashtable = rAInfo.getConnectionGroupConfigProperties(string3);
            object2 = hashtable.values().iterator();
            System.out.println("--------------Connection Group Config Properties\n--------------");
            System.out.println("HT Size : " + hashtable.size());
            while (object2.hasNext()) {
                object = (ConfigPropInfo)object2.next();
                System.out.println("--------------");
                System.out.println("Description : " + object.getDescription());
                System.out.println("Name : " + object.getName());
                System.out.println("Type : " + object.getType());
                System.out.println("Value : " + object.getValue());
                System.out.println("--------------");
            }
            object = rAInfo.getConnectionGroupTransactionSupport(string3);
            System.out.println("TransactionSupport = " + (String)object);
            AuthMechInfo[] authMechInfoArray = rAInfo.getConnectionGroupAuthenticationMechanisms(string3);
            System.out.println("--------------Connection Group Authentication Mechanisms\n--------------");
            for (int i = 0; i < authMechInfoArray.length; ++i) {
                System.out.println("--------------");
                System.out.println("Description : " + authMechInfoArray[i].getDescription());
                System.out.println("Type : " + authMechInfoArray[i].getType());
                System.out.println("Interface : " + authMechInfoArray[i].getCredentialInterface());
                System.out.println("--------------");
            }
            String string4 = rAInfo.getConnectionGroupResAuth(string3);
            System.out.println("ResAuth = " + string4);
            boolean bl = rAInfo.isConnectionGroupReauthenticationSupport(string3);
            System.out.println("Reauthentication Support = " + bl);
            LoggingInfo loggingInfo = rAInfo.getConnectionGroupLoggingProperties(string3);
            System.out.println("--------------Connection Group Logging Properties\n--------------");
            System.out.println("--------------");
            System.out.println("logFilename:           " + loggingInfo.getLogFilename());
            System.out.println("loggingEnabled:        " + loggingInfo.isLoggingEnabled());
            System.out.println("rotationType:          " + loggingInfo.getRotationType());
            System.out.println("rotationTime:          " + loggingInfo.getRotationTime());
            System.out.println("numberOfFilesLimited:  " + loggingInfo.isNumberOfFilesLimited());
            System.out.println("fileCount:             " + loggingInfo.getFileCount());
            System.out.println("fileSizeLimit:         " + loggingInfo.getFileSizeLimit());
            System.out.println("fileTimeSpan:          " + loggingInfo.getFileTimeSpan());
            System.out.println("rotateLogOnStartup:    " + loggingInfo.isRotateLogOnStartup());
            System.out.println("logFileRotationDir:    " + loggingInfo.getLogFileRotationDir());
            System.out.println("--------------");
            PoolInfo poolInfo = rAInfo.getConnectionGroupPoolProperties(string3);
            System.out.println("--------------Connection Group Pool Properties\n--------------");
            System.out.println("--------------");
            System.out.println("initialCapacity:                 " + poolInfo.getInitialCapacity());
            System.out.println("maxCapacity:                     " + poolInfo.getMaxCapacity());
            System.out.println("capacityIncrement:               " + poolInfo.getCapacityIncrement());
            System.out.println("shrinkingEnabled:                " + poolInfo.isShrinkingEnabled());
            System.out.println("shrinkFrequencySeconds:          " + poolInfo.getShrinkFrequencySeconds());
            System.out.println("highestNumWaiters:               " + poolInfo.getHighestNumWaiters());
            System.out.println("highestNumUnavailable:           " + poolInfo.getHighestNumUnavailable());
            System.out.println("connectionCreationRetryFrequencySeconds:  " + poolInfo.getConnectionCreationRetryFrequencySeconds());
            System.out.println("connectionReserveTimeoutSeconds: " + poolInfo.getConnectionReserveTimeoutSeconds());
            System.out.println("testFrequencySeconds:            " + poolInfo.getTestFrequencySeconds());
            System.out.println("testConnectionsOnCreate:         " + poolInfo.isTestConnectionsOnCreate());
            System.out.println("testConnectionsOnRelease:        " + poolInfo.isTestConnectionsOnRelease());
            System.out.println("testConnectionsOnReserve:        " + poolInfo.isTestConnectionsOnReserve());
            System.out.println("profileHarvestFrequencySeconds:  " + poolInfo.getProfileHarvestFrequencySeconds());
            System.out.println("ignoreInUseConnectionsEnabled:   " + poolInfo.isIgnoreInUseConnectionsEnabled());
            System.out.println("matchConnectionsSupported:       " + poolInfo.isMatchConnectionsSupported());
            System.out.println("--------------");
        }
        catch (Exception exception) {
            System.out.println("Caught exception : " + exception);
            exception.printStackTrace();
        }
    }

    private static void printMainUsage() {
        System.out.println("Improper call.  Usage --->\n   java weblogic.connector.configuration.DDUtil <nameOfTest> <args> \n\n   where: nameOfTest & args = \n          testLinkRefs baseJarPath linkRefJarPath -- prints out effective properties for link-ref deployment \n          testNoWLraXML rarPath                   -- prints out generated default weblogic-ra.xml for rar without one\n          testConsoleUtility rarPath Interface    -- tests the console utility \n");
    }

    public static void testLinkRefs(String string, String string2) {
        VirtualJarFile virtualJarFile = null;
        VirtualJarFile virtualJarFile2 = null;
        try {
            File file = new File(string);
            virtualJarFile = VirtualJarFactory.createVirtualJar((File)file);
            File file2 = new File(string2);
            virtualJarFile2 = VirtualJarFactory.createVirtualJar((File)file2);
            RAInfo rAInfo = DDUtil.getRAInfo(virtualJarFile, null, "baseConnector", null, null);
            System.out.println("baseRAInfo : " + rAInfo);
            RAInfo rAInfo2 = DDUtil.getRAInfo(virtualJarFile2, null, "linkrefConnector", null, null);
            rAInfo2.setBaseRA(rAInfo);
            List list = rAInfo2.getOutboundInfos();
            OutboundInfo outboundInfo = (OutboundInfo)list.get(0);
            Hashtable hashtable = outboundInfo.getMCFProps();
            ConfigPropInfo configPropInfo2 = null;
            if (hashtable != null) {
                for (ConfigPropInfo configPropInfo2 : hashtable.values()) {
                    System.out.println("---------------------");
                    System.out.println("Name : " + configPropInfo2.getName());
                    System.out.println("Type : " + configPropInfo2.getType());
                    System.out.println("Value : " + configPropInfo2.getValue());
                    System.out.println("---------------------");
                }
            }
            System.out.println("linkrefRAInfo : " + rAInfo);
        }
        catch (Exception exception) {
            System.out.println("Caught exception : " + exception);
            exception.printStackTrace();
        }
    }

    public static void testNoWLraXML(String string) {
        VirtualJarFile virtualJarFile = null;
        try {
            File file = new File(string);
            virtualJarFile = VirtualJarFactory.createVirtualJar((File)file);
            RAInfo rAInfo = DDUtil.getRAInfo(virtualJarFile, null, DDUtil.getModuleName(file.getName()), null, null);
            System.out.println("baseRAInfo : " + rAInfo);
            WeblogicConnectorBean weblogicConnectorBean = rAInfo.getWeblogicConnectorBean();
            System.out.println("WeblogicConnectorBean :");
            new DescriptorManager().writeDescriptorAsXML(((DescriptorBean)weblogicConnectorBean).getDescriptor(), (OutputStream)System.out);
        }
        catch (Exception exception) {
            System.out.println("Caught exception : " + exception);
            exception.printStackTrace();
        }
    }
}

