/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.application.descriptor.AbstractDescriptorLoader;
import weblogic.application.descriptor.BasicMunger;
import weblogic.application.descriptor.ReaderEvent;
import weblogic.connector.common.Debug;
import weblogic.j2ee.descriptor.ConnectionDefinitionBean;
import weblogic.j2ee.descriptor.ConnectorBean;
import weblogic.j2ee.descriptor.OutboundResourceAdapterBean;
import weblogic.j2ee.descriptor.ResourceAdapterBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;

public class WlsRAReader
extends BasicMunger {
    private boolean createExtensionBean = true;
    private static final Map wlraNameChanges = new HashMap();
    ConnectorBean connBean;
    ArrayList linkRefQueue = null;
    ArrayList proxyQueue = null;
    ArrayList loggingQueue = null;
    ArrayList nativeLibdirQueue = null;
    ArrayList descriptionQueue = null;
    ArrayList jndiNameQueue = null;
    ArrayList configPropQueue = null;
    ArrayList poolParamsQueue = null;
    ArrayList unknownQueue = null;
    ArrayList currentQueue = null;
    boolean inConfigProps = false;
    boolean ignore = false;
    char[] initial_capacity = null;
    char[] max_capacity = null;
    char[] capacity_increment = null;
    char[] shrinking_enabled = null;
    char[] shrink_frequency_seconds = null;
    char[] highest_num_waiters = null;
    char[] highest_num_unavailable = null;
    char[] connection_creation_retry_frequency_seconds = null;
    char[] connection_reserve_timeout_seconds = null;
    char[] test_frequency_seconds = null;
    char[] match_connections_supported = null;
    char[] inactive_connection_timeout_seconds = null;
    String lastLocalElement;
    boolean debug = false;

    public WlsRAReader(ConnectorBean connectorBean, XMLStreamReader xMLStreamReader, AbstractDescriptorLoader abstractDescriptorLoader, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
        super(xMLStreamReader, abstractDescriptorLoader, deploymentPlanBean, string, "rar", string2);
        this.connBean = connectorBean;
        this.createExtensionBean = true;
    }

    public WlsRAReader(ConnectorBean connectorBean, XMLStreamReader xMLStreamReader, AbstractDescriptorLoader abstractDescriptorLoader, DeploymentPlanBean deploymentPlanBean, String string, String string2, boolean bl) {
        super(xMLStreamReader, abstractDescriptorLoader, deploymentPlanBean, string, "rar", string2);
        this.connBean = connectorBean;
        this.createExtensionBean = bl;
    }

    public String getDtdNamespaceURI() {
        return "http://xmlns.oracle.com/weblogic/weblogic-connector";
    }

    public Map getLocalNameMap() {
        return wlraNameChanges;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int next() throws XMLStreamException {
        int n = super.next();
        if (this.playback || !this.usingDTD()) {
            return n;
        }
        switch (n) {
            case 1: {
                this.lastLocalElement = this.getLocalName();
                if (this.lastLocalElement.equals("native-libdir")) {
                    this.currentQueue = this.getNativeLibdirQueue();
                    this.currentQueue.add(this.getQueuedEvent(1, this.lastLocalElement));
                    return this.skip(n);
                } else if (this.lastLocalElement.equals("use-connection-proxies") || this.lastLocalElement.equals("connection-profiling-enabled")) {
                    this.currentQueue = this.getProxyQueue();
                    this.currentQueue.add(this.getQueuedEvent(1, this.lastLocalElement));
                    return this.skip(n);
                } else if (this.lastLocalElement.equals("connection-factory-name") || this.lastLocalElement.equals("ra-link-ref")) {
                    this.currentQueue = this.getLinkRefQueue();
                    this.currentQueue.add(this.getQueuedEvent(1, this.lastLocalElement));
                    return this.skip(n);
                } else if (this.lastLocalElement.equals("description")) {
                    this.currentQueue = this.getDescriptionQueue();
                    this.currentQueue.add(this.getQueuedEvent(1, this.lastLocalElement));
                    return this.skip(n);
                } else if (this.lastLocalElement.equals("jndi-name")) {
                    this.currentQueue = this.getJNDINameQueue();
                    this.currentQueue.add(this.getQueuedEvent(1, this.lastLocalElement));
                    return this.skip(n);
                } else if (this.lastLocalElement.equals("logging-enabled") || this.lastLocalElement.equals("log-filename")) {
                    this.currentQueue = this.getLoggingQueue();
                    this.currentQueue.add(this.getQueuedEvent(1, this.lastLocalElement));
                    return this.skip(n);
                } else if (this.lastLocalElement.equals("property")) {
                    this.inConfigProps = true;
                    this.currentQueue = this.getConfigPropQueue();
                    this.currentQueue.add(this.getQueuedEvent(1, this.lastLocalElement));
                    return this.skip(n);
                } else if (this.lastLocalElement.equals("name") || this.lastLocalElement.equals("value")) {
                    if (this.currentQueue == null) return this.skip(n);
                    this.currentQueue.add(this.getQueuedEvent(1, this.lastLocalElement));
                    return this.skip(n);
                } else if (this.lastLocalElement.equals("security-principal-map")) {
                    Debug.logSecurityPrincipalMapNotAllowed();
                    this.currentQueue = this.getUknownQueue();
                    this.currentQueue.add(this.getQueuedEvent(1, this.lastLocalElement));
                    return this.skip(n);
                } else {
                    if (this.lastLocalElement.equals("initial-capacity") || this.lastLocalElement.equals("capacity-increment") || this.lastLocalElement.equals("connection-cleanup-frequency") || this.lastLocalElement.equals("connection-creation-retry-frequency-seconds") || this.lastLocalElement.equals("connection-duration-time") || this.lastLocalElement.equals("connection-maxidle-time") || this.lastLocalElement.equals("connection-reserve-timeout-seconds") || this.lastLocalElement.equals("highest-num-unavailable") || this.lastLocalElement.equals("highest-num-waiters") || this.lastLocalElement.equals("inactive-connection-timeout-seconds") || this.lastLocalElement.equals("map-config-property") || this.lastLocalElement.equals("match-connections-supported") || this.lastLocalElement.equals("max-capacity") || this.lastLocalElement.equals("pool-params") || this.lastLocalElement.equals("shrink-frequency-seconds") || this.lastLocalElement.equals("shrink-period-minutes") || this.lastLocalElement.equals("shrinking-enabled") || this.lastLocalElement.equals("test-frequency-seconds") || this.lastLocalElement.equals("weblogic-connection-factory") || this.ignore) return this.skip(n);
                    this.currentQueue = this.getUknownQueue();
                    this.currentQueue.add(this.getQueuedEvent(1, this.lastLocalElement));
                }
                return this.skip(n);
            }
            case 4: {
                if (this.isWhiteSpace() || this.ignore) return this.skip(n);
                if (this.currentQueue == null) {
                    if (this.lastLocalElement.equals("inactive-connection-timeout-seconds")) {
                        this.inactive_connection_timeout_seconds = this.getTextCharacters();
                        return this.skip(n);
                    } else if (this.lastLocalElement.equals("connection-maxidle-time")) {
                        if (this.inactive_connection_timeout_seconds != null) return this.skip(n);
                        this.inactive_connection_timeout_seconds = this.getTextCharacters();
                        return this.skip(n);
                    } else if (this.lastLocalElement.equals("initial-capacity")) {
                        this.initial_capacity = this.getTextCharacters();
                        return this.skip(n);
                    } else if (this.lastLocalElement.equals("max-capacity")) {
                        this.max_capacity = this.getTextCharacters();
                        return this.skip(n);
                    } else if (this.lastLocalElement.equals("capacity-increment")) {
                        this.capacity_increment = this.getTextCharacters();
                        return this.skip(n);
                    } else if (this.lastLocalElement.equals("shrinking-enabled")) {
                        this.shrinking_enabled = this.getTextCharacters();
                        return this.skip(n);
                    } else if (this.lastLocalElement.equals("shrink-period-minutes")) {
                        if (this.shrink_frequency_seconds != null) return this.skip(n);
                        try {
                            String string = new String(this.getTextCharacters());
                            if (string == null || string.length() <= 0) return this.skip(n);
                            int n2 = Integer.parseInt(string);
                            int n3 = n2 * 60;
                            String string2 = Integer.toString(n3);
                            this.shrink_frequency_seconds = string2.toCharArray();
                            return this.skip(n);
                        }
                        catch (Exception exception) {
                            this.shrink_frequency_seconds = this.getTextCharacters();
                        }
                        return this.skip(n);
                    } else if (this.lastLocalElement.equals("shrink-frequency-seconds")) {
                        this.shrink_frequency_seconds = this.getTextCharacters();
                        return this.skip(n);
                    } else if (this.lastLocalElement.equals("highest-num-waiters")) {
                        this.highest_num_waiters = this.getTextCharacters();
                        return this.skip(n);
                    } else if (this.lastLocalElement.equals("highest-num-unavailable")) {
                        this.highest_num_unavailable = this.getTextCharacters();
                        return this.skip(n);
                    } else if (this.lastLocalElement.equals("connection-creation-retry-frequency-seconds")) {
                        this.connection_creation_retry_frequency_seconds = this.getTextCharacters();
                        return this.skip(n);
                    } else if (this.lastLocalElement.equals("connection-reserve-timeout-seconds")) {
                        this.connection_reserve_timeout_seconds = this.getTextCharacters();
                        return this.skip(n);
                    } else if (this.lastLocalElement.equals("test-frequency-seconds")) {
                        this.test_frequency_seconds = this.getTextCharacters();
                        return this.skip(n);
                    } else {
                        if (!this.lastLocalElement.equals("match-connections-supported")) return this.skip(n);
                        this.match_connections_supported = this.getTextCharacters();
                    }
                    return this.skip(n);
                } else {
                    this.currentQueue.add(this.getQueuedEvent(4, this.getTextCharacters()));
                }
                return this.skip(n);
            }
            case 2: {
                if (this.getLocalName().equals("weblogic-connection-factory")) {
                    if (this.queuedEvents != null && this.queuedEvents.size() == 0) {
                        return n;
                    }
                    this.buildQueuedEvents();
                    if (this.debug) {
                        this.toXML();
                    }
                    this.setPlayback(true);
                    return this.next();
                }
                if (this.currentQueue == null) return this.skip(n);
                if (this.getLocalName().equals("property")) {
                    this.inConfigProps = false;
                }
                this.currentQueue.add(this.getQueuedEvent(2, this.getLocalName()));
                if (this.inConfigProps) return this.skip(n);
                this.currentQueue = null;
                return this.skip(n);
            }
        }
        return n;
    }

    private void buildQueuedEvents() {
        if (this.createExtensionBean) {
            this.getQueuedEvents().add(this.getQueuedEvent(1, "weblogic-connector-extension"));
        } else {
            this.getQueuedEvents().add(this.getQueuedEvent(1, "weblogic-connector"));
        }
        if (this.nativeLibdirQueue != null) {
            this.getQueuedEvents().addAll(this.getNativeLibdirQueue());
        }
        this.getQueuedEvents().add(this.getQueuedEvent(1, "enable-access-outside-app"));
        this.getQueuedEvents().add(this.getQueuedEvent(4, "true".toCharArray()));
        this.getQueuedEvents().add(this.getQueuedEvent(2, "enable-access-outside-app"));
        this.buildOutboundResourceAdapter();
        if (this.createExtensionBean && this.linkRefQueue != null) {
            this.getQueuedEvents().add(this.getQueuedEvent(1, "link-ref"));
            this.getQueuedEvents().addAll(this.getLinkRefQueue());
            this.getQueuedEvents().add(this.getQueuedEvent(2, "link-ref"));
        }
        if (this.createExtensionBean && (this.proxyQueue != null || this.inactive_connection_timeout_seconds != null)) {
            this.getQueuedEvents().add(this.getQueuedEvent(1, "proxy"));
            if (this.inactive_connection_timeout_seconds != null) {
                this.getQueuedEvents().add(this.getQueuedEvent(1, "inactive-connection-timeout-seconds"));
                this.getQueuedEvents().add(this.getQueuedEvent(4, this.inactive_connection_timeout_seconds));
                this.getQueuedEvents().add(this.getQueuedEvent(2, "inactive-connection-timeout-seconds"));
            }
            if (this.proxyQueue != null) {
                this.getQueuedEvents().addAll(this.getProxyQueue());
            }
            this.getQueuedEvents().add(this.getQueuedEvent(2, "proxy"));
        }
        if (this.unknownQueue != null) {
            this.getQueuedEvents().addAll(this.getUknownQueue());
        }
        if (this.createExtensionBean) {
            this.getQueuedEvents().add(this.getQueuedEvent(2, "weblogic-connector-extension"));
        } else {
            this.getQueuedEvents().add(this.getQueuedEvent(2, "weblogic-connector"));
        }
    }

    private void buildOutboundResourceAdapter() {
        ResourceAdapterBean resourceAdapterBean = null;
        OutboundResourceAdapterBean outboundResourceAdapterBean = null;
        ConnectionDefinitionBean[] connectionDefinitionBeanArray = null;
        char[] cArray = null;
        String string = "";
        this.getQueuedEvents().add(this.getQueuedEvent(1, "outbound-resource-adapter"));
        this.getQueuedEvents().add(this.getQueuedEvent(1, "connection-definition-group"));
        string = string + "/connector";
        if (this.connBean != null) {
            string = string + "/resourceadapter";
            resourceAdapterBean = this.connBean.getResourceAdapter();
            if (resourceAdapterBean != null) {
                string = string + "/outbound-resourceadapter";
                outboundResourceAdapterBean = resourceAdapterBean.getOutboundResourceAdapter();
                if (outboundResourceAdapterBean != null) {
                    string = string + "/connection-definition";
                    connectionDefinitionBeanArray = outboundResourceAdapterBean.getConnectionDefinitions();
                    if (connectionDefinitionBeanArray != null && connectionDefinitionBeanArray.length > 0) {
                        string = string + "/connectionfactory-interface";
                        String string2 = connectionDefinitionBeanArray[0].getConnectionFactoryInterface();
                        if (string2 != null) {
                            cArray = string2.toCharArray();
                        }
                    }
                }
            }
            if (cArray == null) {
                cArray = new char[]{' '};
                Debug.logBuildOutboundFailed(string);
            }
        } else {
            cArray = "LinkRef".toCharArray();
        }
        this.getQueuedEvents().add(this.getQueuedEvent(1, "connection-factory-interface"));
        this.getQueuedEvents().add(this.getQueuedEvent(4, cArray));
        this.getQueuedEvents().add(this.getQueuedEvent(2, "connection-factory-interface"));
        this.getQueuedEvents().add(this.getQueuedEvent(1, "connection-instance"));
        if (this.descriptionQueue != null) {
            this.getQueuedEvents().addAll(this.getDescriptionQueue());
        }
        if (this.jndiNameQueue != null) {
            this.getQueuedEvents().addAll(this.getJNDINameQueue());
        }
        this.getQueuedEvents().add(this.getQueuedEvent(1, "connection-properties"));
        this.buildPoolParams();
        if (this.loggingQueue != null) {
            this.getQueuedEvents().add(this.getQueuedEvent(1, "logging"));
            this.getQueuedEvents().addAll(this.getLoggingQueue());
            this.getQueuedEvents().add(this.getQueuedEvent(2, "logging"));
        }
        if (this.configPropQueue != null) {
            this.getQueuedEvents().add(this.getQueuedEvent(1, "properties"));
            this.getQueuedEvents().addAll(this.getConfigPropQueue());
            this.getQueuedEvents().add(this.getQueuedEvent(2, "properties"));
        }
        this.getQueuedEvents().add(this.getQueuedEvent(2, "connection-properties"));
        this.getQueuedEvents().add(this.getQueuedEvent(2, "connection-instance"));
        this.getQueuedEvents().add(this.getQueuedEvent(2, "connection-definition-group"));
        this.getQueuedEvents().add(this.getQueuedEvent(2, "outbound-resource-adapter"));
    }

    private void buildPoolParams() {
        if (this.initial_capacity != null || this.max_capacity != null || this.capacity_increment != null || this.shrinking_enabled != null || this.shrink_frequency_seconds != null || this.highest_num_waiters != null || this.highest_num_unavailable != null || this.connection_creation_retry_frequency_seconds != null || this.connection_reserve_timeout_seconds != null || this.test_frequency_seconds != null || this.match_connections_supported != null) {
            this.getQueuedEvents().add(this.getQueuedEvent(1, "pool-params"));
            if (this.initial_capacity != null) {
                this.getQueuedEvents().add(this.getQueuedEvent(1, "initial-capacity"));
                this.getQueuedEvents().add(this.getQueuedEvent(4, this.initial_capacity));
                this.getQueuedEvents().add(this.getQueuedEvent(2, "initial-capacity"));
            }
            if (this.max_capacity != null) {
                this.getQueuedEvents().add(this.getQueuedEvent(1, "max-capacity"));
                this.getQueuedEvents().add(this.getQueuedEvent(4, this.max_capacity));
                this.getQueuedEvents().add(this.getQueuedEvent(2, "max-capacity"));
            }
            if (this.capacity_increment != null) {
                this.getQueuedEvents().add(this.getQueuedEvent(1, "capacity-increment"));
                this.getQueuedEvents().add(this.getQueuedEvent(4, this.capacity_increment));
                this.getQueuedEvents().add(this.getQueuedEvent(2, "capacity-increment"));
            }
            if (this.shrinking_enabled != null) {
                this.getQueuedEvents().add(this.getQueuedEvent(1, "shrinking-enabled"));
                this.getQueuedEvents().add(this.getQueuedEvent(4, this.shrinking_enabled));
                this.getQueuedEvents().add(this.getQueuedEvent(2, "shrinking-enabled"));
            }
            if (this.shrink_frequency_seconds != null) {
                this.getQueuedEvents().add(this.getQueuedEvent(1, "shrink-frequency-seconds"));
                this.getQueuedEvents().add(this.getQueuedEvent(4, this.shrink_frequency_seconds));
                this.getQueuedEvents().add(this.getQueuedEvent(2, "shrink-frequency-seconds"));
            }
            if (this.highest_num_waiters != null) {
                this.getQueuedEvents().add(this.getQueuedEvent(1, "highest-num-waiters"));
                this.getQueuedEvents().add(this.getQueuedEvent(4, this.highest_num_waiters));
                this.getQueuedEvents().add(this.getQueuedEvent(2, "highest-num-waiters"));
            }
            if (this.highest_num_unavailable != null) {
                this.getQueuedEvents().add(this.getQueuedEvent(1, "highest-num-unavailable"));
                this.getQueuedEvents().add(this.getQueuedEvent(4, this.highest_num_unavailable));
                this.getQueuedEvents().add(this.getQueuedEvent(2, "highest-num-unavailable"));
            }
            if (this.connection_creation_retry_frequency_seconds != null) {
                this.getQueuedEvents().add(this.getQueuedEvent(1, "connection-creation-retry-frequency-seconds"));
                this.getQueuedEvents().add(this.getQueuedEvent(4, this.connection_creation_retry_frequency_seconds));
                this.getQueuedEvents().add(this.getQueuedEvent(2, "connection-creation-retry-frequency-seconds"));
            }
            if (this.connection_reserve_timeout_seconds != null) {
                this.getQueuedEvents().add(this.getQueuedEvent(1, "connection-reserve-timeout-seconds"));
                this.getQueuedEvents().add(this.getQueuedEvent(4, this.connection_reserve_timeout_seconds));
                this.getQueuedEvents().add(this.getQueuedEvent(2, "connection-reserve-timeout-seconds"));
            }
            if (this.test_frequency_seconds != null) {
                this.getQueuedEvents().add(this.getQueuedEvent(1, "test-frequency-seconds"));
                this.getQueuedEvents().add(this.getQueuedEvent(4, this.test_frequency_seconds));
                this.getQueuedEvents().add(this.getQueuedEvent(2, "test-frequency-seconds"));
            }
            if (this.match_connections_supported != null) {
                this.getQueuedEvents().add(this.getQueuedEvent(1, "match-connections-supported"));
                this.getQueuedEvents().add(this.getQueuedEvent(4, this.match_connections_supported));
                this.getQueuedEvents().add(this.getQueuedEvent(2, "match-connections-supported"));
            }
            this.getQueuedEvents().add(this.getQueuedEvent(2, "pool-params"));
        }
    }

    private void toXML() {
        int n = 0;
        ReaderEvent readerEvent = null;
        String string = "";
        for (int i = 0; i < this.getQueuedEvents().size(); ++i) {
            readerEvent = (ReaderEvent)this.getQueuedEvents().get(i);
            if (readerEvent == null) continue;
            switch (readerEvent.getEventType()) {
                case 1: {
                    string = this.indent(++n) + "<" + readerEvent.getLocalName() + ">";
                    break;
                }
                case 4: {
                    if (readerEvent.getCharacters() != null) {
                        string = this.indent(n) + new String(readerEvent.getCharacters());
                        break;
                    }
                    string = "";
                    break;
                }
                case 2: {
                    string = this.indent(n) + "</" + readerEvent.getLocalName() + ">";
                    --n;
                }
            }
            System.out.println(string);
        }
    }

    private String indent(int n) {
        String string = "";
        String string2 = "  ";
        for (int i = 0; i < n; ++i) {
            string = string + string2;
        }
        return string;
    }

    private ArrayList getQueuedEvents() {
        if (this.queuedEvents == null) {
            this.queuedEvents = new ArrayList();
        }
        return this.queuedEvents;
    }

    private ArrayList getUknownQueue() {
        if (this.unknownQueue == null) {
            this.unknownQueue = new ArrayList();
        }
        return this.unknownQueue;
    }

    private ArrayList getConfigPropQueue() {
        if (this.configPropQueue == null) {
            this.configPropQueue = new ArrayList();
        }
        return this.configPropQueue;
    }

    private ArrayList getDescriptionQueue() {
        if (this.descriptionQueue == null) {
            this.descriptionQueue = new ArrayList();
        }
        return this.descriptionQueue;
    }

    private ArrayList getJNDINameQueue() {
        if (this.jndiNameQueue == null) {
            this.jndiNameQueue = new ArrayList();
        }
        return this.jndiNameQueue;
    }

    private ArrayList getLinkRefQueue() {
        if (this.linkRefQueue == null) {
            this.linkRefQueue = new ArrayList();
        }
        return this.linkRefQueue;
    }

    private ArrayList getLoggingQueue() {
        if (this.loggingQueue == null) {
            this.loggingQueue = new ArrayList();
        }
        return this.loggingQueue;
    }

    private ArrayList getProxyQueue() {
        if (this.proxyQueue == null) {
            this.proxyQueue = new ArrayList();
        }
        return this.proxyQueue;
    }

    private ArrayList getNativeLibdirQueue() {
        if (this.nativeLibdirQueue == null) {
            this.nativeLibdirQueue = new ArrayList();
        }
        return this.nativeLibdirQueue;
    }

    public boolean supportsValidation() {
        return true;
    }

    static {
        wlraNameChanges.put("weblogic-connection-factory-dd", "weblogic-connection-factory");
        wlraNameChanges.put("map-config-property", "property");
        wlraNameChanges.put("map-config-property-name", "name");
        wlraNameChanges.put("map-config-property-value", "value");
    }
}

