/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.deploy;

import java.security.AccessController;
import java.util.Map;
import weblogic.connector.common.Debug;
import weblogic.connector.common.RAInstanceManager;
import weblogic.connector.deploy.ChangePackage;
import weblogic.connector.deploy.ConnectorModuleChangePackage;
import weblogic.connector.exception.RAException;
import weblogic.connector.external.AdminObjInfo;
import weblogic.connector.external.ConfigPropInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AdminObjectChangePackage
implements ChangePackage {
    private RAInstanceManager raIM = null;
    private ConnectorModuleChangePackage.ChangeType changeType;
    private AdminObjInfo adminInfo = null;

    protected AdminObjectChangePackage(RAInstanceManager rAInstanceManager, AdminObjInfo adminObjInfo, ConnectorModuleChangePackage.ChangeType changeType, Map<String, ConfigPropInfo> map) {
        this.raIM = rAInstanceManager;
        this.adminInfo = adminObjInfo;
        this.changeType = changeType;
    }

    @Override
    public void rollback() throws RAException {
        if (ConnectorModuleChangePackage.ChangeType.NEW.equals((Object)this.changeType)) {
            this.raIM.removeAdminObject(this.adminInfo);
        }
    }

    @Override
    public void prepare() throws RAException {
        if (ConnectorModuleChangePackage.ChangeType.NEW.equals((Object)this.changeType)) {
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            this.raIM.createAdminObject(this.adminInfo, authenticatedSubject);
        }
    }

    @Override
    public void activate() throws RAException {
        if (ConnectorModuleChangePackage.ChangeType.NEW.equals((Object)this.changeType)) {
            this.raIM.bindAdminObject(this.adminInfo.getKey());
            if (Debug.isDeploymentEnabled()) {
                Debug.deployment("Binding new Admin Object " + this.adminInfo.getJndiName());
            }
        } else if (ConnectorModuleChangePackage.ChangeType.REMOVE.equals((Object)this.changeType)) {
            this.raIM.removeAdminObject(this.adminInfo);
            if (Debug.isDeploymentEnabled()) {
                Debug.deployment("Unbinding Admin Object " + this.adminInfo.getJndiName());
            }
        }
    }

    public String toString() {
        return this.changeType.toString() + " " + this.adminInfo.getJndiName();
    }
}

