/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.deploy;

import java.util.Map;
import java.util.Properties;
import weblogic.connector.common.Debug;
import weblogic.connector.common.RAInstanceManager;
import weblogic.connector.deploy.ChangePackage;
import weblogic.connector.deploy.ConnectorModuleChangePackage;
import weblogic.connector.deploy.JNDIHandler;
import weblogic.connector.exception.RAException;
import weblogic.connector.external.ConfigPropInfo;
import weblogic.connector.external.OutboundInfo;
import weblogic.connector.outbound.ConnectionPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConnectionPoolChangePackage
implements ChangePackage {
    private RAInstanceManager raIM;
    private OutboundInfo outboundInfo;
    private Properties poolParamProperties;
    private Properties loggingProperties;
    private ConnectorModuleChangePackage.ChangeType changeType;
    private ConnectionPool pool = null;

    protected ConnectionPoolChangePackage(RAInstanceManager rAInstanceManager, OutboundInfo outboundInfo, Properties properties, Properties properties2, Map<String, ConfigPropInfo> map, ConnectorModuleChangePackage.ChangeType changeType) {
        this.raIM = rAInstanceManager;
        this.outboundInfo = outboundInfo;
        this.poolParamProperties = properties;
        this.loggingProperties = properties2;
        this.changeType = changeType;
    }

    @Override
    public void prepare() throws RAException {
        if (ConnectorModuleChangePackage.ChangeType.NEW.equals((Object)this.changeType)) {
            this.raIM.getRAOutboundManager().createConnectionFactory(this.outboundInfo);
            String string = JNDIHandler.getJndiNameAndVersion(this.outboundInfo.getKey(), this.raIM.getVersionId());
            this.raIM.getRAOutboundManager().preparePool(string);
        }
    }

    @Override
    public void activate() throws RAException {
        if (ConnectorModuleChangePackage.ChangeType.NEW.equals((Object)this.changeType)) {
            String string = JNDIHandler.getJndiNameAndVersion(this.outboundInfo.getKey(), this.raIM.getVersionId());
            this.raIM.getRAOutboundManager().activatePool(string);
            if (Debug.isDeploymentEnabled()) {
                Debug.deployment("Active Connection Pool " + string);
            }
        } else if (this.changeType.equals((Object)ConnectorModuleChangePackage.ChangeType.REMOVE)) {
            String string = JNDIHandler.getJndiNameAndVersion(this.outboundInfo.getKey(), this.raIM.getVersionId());
            this.raIM.getRAOutboundManager().deactivatePool(string);
            this.raIM.getRAOutboundManager().shutdownPool(string);
            if (Debug.isDeploymentEnabled()) {
                Debug.deployment("Shutdown Connection Pool " + string);
            }
        } else {
            this.pool = this.raIM.getRAOutboundManager().getConnectionPool(this.outboundInfo.getKey());
            this.pool.applyPoolParamChanges(this.poolParamProperties);
            this.pool.applyLoggingChanges(this.loggingProperties, this.outboundInfo);
            this.raIM.getRAOutboundManager().updateOutBoundInfo(this.outboundInfo.getKey(), this.outboundInfo);
        }
    }

    @Override
    public void rollback() throws RAException {
        if (ConnectorModuleChangePackage.ChangeType.NEW.equals((Object)this.changeType)) {
            String string = JNDIHandler.getJndiNameAndVersion(this.outboundInfo.getKey(), this.raIM.getVersionId());
            this.raIM.getRAOutboundManager().shutdownPool(string);
        }
    }

    public String toString() {
        return this.changeType.toString() + " " + this.outboundInfo.getJndiName();
    }
}

