/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.deploy;

import java.io.File;
import weblogic.application.Deployment;
import weblogic.application.Module;
import weblogic.application.internal.SingleModuleDeployment;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.connector.common.Debug;
import weblogic.connector.deploy.ConnectorModule;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ComponentMBean;

public final class ConnectorDeployment
extends SingleModuleDeployment
implements Deployment {
    public ConnectorDeployment(AppDeploymentMBean appDeploymentMBean, File file) throws DeploymentException {
        super(appDeploymentMBean, ConnectorDeployment.createModule(appDeploymentMBean), file);
    }

    private static Module createModule(AppDeploymentMBean appDeploymentMBean) throws DeploymentException {
        ComponentMBean[] componentMBeanArray = appDeploymentMBean.getAppMBean().getComponents();
        if (componentMBeanArray == null || componentMBeanArray.length == 0) {
            String string = Debug.getExceptionNoComponents(ApplicationVersionUtils.getDisplayName(appDeploymentMBean));
            throw new DeploymentException(string);
        }
        if (componentMBeanArray.length > 1) {
            String string = Debug.getExceptionMoreThanOneComponent(ApplicationVersionUtils.getDisplayName(appDeploymentMBean));
            throw new DeploymentException(string);
        }
        return new ConnectorModule(componentMBeanArray[0].getURI());
    }
}

