/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.deploy;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import weblogic.application.AdminModeCompletionBarrier;
import weblogic.application.ApplicationContext;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.ApplicationFileManager;
import weblogic.application.ConcurrentModule;
import weblogic.application.Module;
import weblogic.application.ModuleException;
import weblogic.application.UpdateListener;
import weblogic.application.internal.BaseJ2EEModule;
import weblogic.application.utils.AppFileOverrideUtils;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.connector.ConnectorLogger;
import weblogic.connector.common.Debug;
import weblogic.connector.common.RACollectionManager;
import weblogic.connector.common.RAInstanceManager;
import weblogic.connector.common.Utils;
import weblogic.connector.configuration.DDUtil;
import weblogic.connector.deploy.AdapterListenerImpl;
import weblogic.connector.deploy.ConnectorModuleChangePackage;
import weblogic.connector.deploy.DeployerUtil;
import weblogic.connector.deploy.RarArchive;
import weblogic.connector.exception.RAConfigurationException;
import weblogic.connector.exception.RAException;
import weblogic.connector.external.AdapterListener;
import weblogic.connector.external.RAComplianceException;
import weblogic.connector.external.RAInfo;
import weblogic.connector.external.impl.RAInfoImpl;
import weblogic.connector.lifecycle.BootstrapContext;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ConnectorComponentMBean;
import weblogic.management.runtime.ComponentRuntimeMBean;
import weblogic.rmi.extensions.RemoteRuntimeException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.AugmentableClassLoaderManager;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFile;
import weblogic.work.ShutdownCallback;

public final class ConnectorModule
extends BaseJ2EEModule
implements Module,
UpdateListener,
ConcurrentModule {
    private final String uri;
    private RAInfo raInfo;
    private RAInfo newRAInfo;
    private ConnectorModuleChangePackage pendingChanges = null;
    String applicationName = null;
    String componentName = null;
    String componentURI = null;
    private ApplicationContextInternal appCtx;
    private Context linkCtx;
    private Context j2caCtx;
    private Context connectionFactoryCtx;
    private Context adminObjectCtx;
    private ApplicationFileManager appFileManager;
    private VirtualJarFile jarFile;
    private GenericClassLoader classLoader;
    private boolean usingSubClassLoader;
    private String altDD = null;
    private RAInstanceManager raIM;
    private String moduleName;
    private String appId;
    private Vector vectSubContexts = new Vector();
    private RarArchive explodedRar;

    public ConnectorModule(String string) {
        Debug.deployment("Creating ConnectorModule with uri = " + string);
        this.uri = string;
    }

    /*
     * Loose catch block
     */
    public final void prepare() throws ModuleException {
        block17: {
            boolean bl = false;
            this.debugModule("is in NEW state. Calling prepare.");
            Utils.startManagement();
            this.raInfo = this.loadDescriptors();
            String string = ApplicationVersionUtils.getActiveVersionId(this.appCtx.getApplicationName());
            RAInstanceManager rAInstanceManager = RACollectionManager.getRAInstanceManagerByAppName(this.appCtx.getApplicationName(), string);
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            ClassFinder classFinder = AppFileOverrideUtils.getFinderIfRequired(this.appCtx.getAppDeploymentMBean(), this.appCtx.getRuntime().isEAR() ? this.componentURI : null);
            if (classFinder != null) {
                this.debugModule("Application File Overrides enabled");
                this.classLoader.addClassFinderFirst(classFinder);
                if (this.raInfo.isEnableGlobalAccessToClasses()) {
                    this.debugModule("Application File Overrides applied to augmented system classloader");
                    AugmentableClassLoaderManager.getAugmentableSystemClassLoader().addClassFinderFirst(classFinder);
                }
            }
            this.raIM = new RAInstanceManager(this.raInfo, (ClassLoader)this.classLoader, this.applicationName, this.componentName, this.uri, this.explodedRar, this.appCtx, this.adminObjectCtx, this.connectionFactoryCtx, this.uri, rAInstanceManager, authenticatedSubject);
            if (classFinder != null) {
                this.raIM.getClassFinders().add(classFinder);
            }
            this.raIM.prepare();
            this.debugModule("has been PREPARED.");
            Object var7_10 = null;
            if (!bl) break block17;
            try {
                this.unsetJarFile();
            }
            catch (ModuleException object) {
                // empty catch block
            }
            try {
                this.raIM.closeClassFinders();
                break block17;
            }
            catch (Throwable object) {
                // empty catch block
            }
            {
                break block17;
                catch (RAException rAException) {
                    bl = true;
                    throw new ModuleException(rAException.toString());
                }
                catch (RAComplianceException rAComplianceException) {
                    bl = true;
                    throw new ModuleException(rAComplianceException.toString());
                }
                catch (ModuleException moduleException) {
                    bl = true;
                    throw moduleException;
                }
                catch (Throwable throwable) {
                    bl = true;
                    throw new ModuleException(throwable.toString(), throwable);
                }
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                if (bl) {
                    try {
                        this.unsetJarFile();
                    }
                    catch (ModuleException object) {
                        // empty catch block
                    }
                    try {
                        this.raIM.closeClassFinders();
                    }
                    catch (Throwable object) {
                        // empty catch block
                    }
                }
                Utils.stopManagement();
                throw throwable;
            }
        }
        Utils.stopManagement();
    }

    public final void unprepare() throws ModuleException {
        this.debugModule("is being rolled back: calling unprepare.");
        Utils.startManagement();
        try {
            try {
                this.debugModule("is being rolled back. Calling Deployer.rollback( connMBean )");
                this.raIM.rollback();
            }
            catch (RAException rAException) {
                String string = Debug.getExceptionRollbackModuleFailed(rAException.toString());
                throw new ModuleException(string, (Throwable)((Object)rAException));
            }
            Object var4_1 = null;
        }
        catch (Throwable throwable) {
            Object var4_2 = null;
            Utils.stopManagement();
            throw throwable;
        }
        Utils.stopManagement();
        this.unsetJarFile();
        this.debugModule("has been rolled back: UNPREPARED");
    }

    /*
     * Loose catch block
     */
    public final void activate() throws ModuleException {
        ClassLoader classLoader;
        block8: {
            classLoader = Thread.currentThread().getContextClassLoader();
            boolean bl = false;
            this.debugModule("is being ACTIVATED: calling activate.");
            Utils.startManagement();
            Thread.currentThread().setContextClassLoader((ClassLoader)this.classLoader);
            this.raIM.activate();
            this.debugModule("has been ACTIVATED");
            Object var5_3 = null;
            if (!bl) break block8;
            try {
                this.unsetJarFile();
                break block8;
            }
            catch (ModuleException moduleException) {
                // empty catch block
            }
            {
                break block8;
                catch (Exception exception) {
                    bl = true;
                    throw new ModuleException(exception.toString(), exception);
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                if (bl) {
                    try {
                        this.unsetJarFile();
                    }
                    catch (ModuleException moduleException) {
                        // empty catch block
                    }
                }
                Utils.stopManagement();
                Thread.currentThread().setContextClassLoader(classLoader);
                throw throwable;
            }
        }
        Utils.stopManagement();
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    public final void start() {
        this.debugModule("ConnectorModule.start() called; nothing is done here.");
    }

    public final void deactivate() throws ModuleException {
        this.debugModule("is being DEACTIVATED: calling deactivate.");
        Utils.startManagement();
        try {
            try {
                this.raIM.deactivate();
                this.debugModule("has been DEACTIVATED");
            }
            catch (RAException rAException) {
                throw new ModuleException(rAException.toString(), (Throwable)((Object)rAException));
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            Utils.stopManagement();
            throw throwable;
        }
        Utils.stopManagement();
    }

    public boolean acceptURI(String string) {
        if (this.appCtx.isEar() && string.equals(this.uri + "/" + "META-INF/weblogic-ra.xml")) {
            return true;
        }
        return !this.appCtx.isEar() && string.equals("META-INF/weblogic-ra.xml");
    }

    public void prepareUpdate(String string) throws ModuleException {
        try {
            File file = this.resolveAltDD(this.appCtx, string);
            DeploymentPlanBean deploymentPlanBean = this.appCtx.findDeploymentPlan();
            AppDeploymentMBean appDeploymentMBean = this.appCtx.getAppDeploymentMBean();
            this.newRAInfo = DDUtil.getRAInfo(this.jarFile, file, this.getModuleName(), appDeploymentMBean, deploymentPlanBean);
            ((RAInfoImpl)this.newRAInfo).copyBaseRA((RAInfoImpl)this.raInfo);
            this.pendingChanges = DeployerUtil.enumerateChanges(this.raIM, this.raInfo, this.newRAInfo);
            this.preparePendingChanges();
        }
        catch (RAConfigurationException rAConfigurationException) {
            String string2 = Debug.getExceptionPrepareUpdateFailed(string, rAConfigurationException.toString());
            throw new ModuleException(string2, (Throwable)((Object)rAConfigurationException));
        }
        catch (RAException rAException) {
            String string3 = Debug.getExceptionPrepareUpdateFailed(string, rAException.toString());
            throw new ModuleException(string3, (Throwable)((Object)rAException));
        }
    }

    public void activateUpdate(String string) throws ModuleException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader((ClassLoader)this.classLoader);
                this.activatePendingChanges();
            }
            catch (RAException rAException) {
                throw new ModuleException((Throwable)((Object)rAException));
            }
            Object var5_3 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            Thread.currentThread().setContextClassLoader(classLoader);
            throw throwable;
        }
    }

    private void activatePendingChanges() throws RAException {
        if (this.pendingChanges != null) {
            this.raInfo = this.newRAInfo;
            this.newRAInfo = null;
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            this.raIM.setRAInfo(authenticatedSubject, this.raInfo);
            this.pendingChanges.activate();
            this.pendingChanges = null;
        } else {
            this.debugModule("No pending changes for update invocation");
        }
    }

    private void preparePendingChanges() throws RAException {
        if (this.pendingChanges != null) {
            this.pendingChanges.prepare(this.newRAInfo);
        } else {
            this.debugModule("No pending changes for update invocation");
        }
    }

    public void rollbackUpdate(String string) {
        this.newRAInfo = null;
        this.pendingChanges = null;
    }

    public void initUsingLoader(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) throws ModuleException {
        this.debugModule("calling initUsingLoader.");
        this.initAndSetClassLoader(applicationContext, genericClassLoader, registration, false);
        this.debugModule("has been INITED UsingLoader.");
    }

    public GenericClassLoader init(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) throws ModuleException {
        this.debugModule("calling init.");
        GenericClassLoader genericClassLoader2 = this.initAndSetClassLoader(applicationContext, genericClassLoader, registration, true);
        this.debugModule("has been INITED.");
        return genericClassLoader2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericClassLoader initAndSetClassLoader(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration, boolean bl) throws ModuleException {
        this.usingSubClassLoader = bl;
        Utils.startManagement();
        try {
            this.appCtx = (ApplicationContextInternal)applicationContext;
            ConnectorComponentMBean connectorComponentMBean = (ConnectorComponentMBean)this.findComponentMBean(this.appCtx, this.uri, ConnectorComponentMBean.class);
            this.applicationName = connectorComponentMBean.getParent().getName();
            this.componentName = connectorComponentMBean.getName();
            this.componentURI = connectorComponentMBean.getURI();
            if (bl) {
                this.classLoader = new GenericClassLoader((ClassLoader)genericClassLoader);
                this.classLoader.setAnnotation(new Annotation(this.appCtx.getApplicationId(), this.componentName));
            } else {
                this.classLoader = genericClassLoader;
            }
            registration.addUpdateListener(this);
            if (this.appCtx.getRuntime().isEAR()) {
                this.initJndiSubcontexts(applicationContext);
            }
            this.appFileManager = this.appCtx.getApplicationFileManager();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Utils.stopManagement();
            throw throwable;
        }
        Utils.stopManagement();
        return this.classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(UpdateListener.Registration registration) throws ModuleException {
        this.debugModule("calling destroy.");
        Utils.startManagement();
        try {
            if (this.usingSubClassLoader && this.classLoader != null) {
                this.classLoader.close();
            }
            this.raInfo = null;
            registration.removeUpdateListener(this);
            this.remove();
            try {
                this.cleanupJNDISubContexts();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            this.debugModule("has been DESTROIED.");
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Utils.stopManagement();
            throw throwable;
        }
        Utils.stopManagement();
    }

    private void cleanupJNDISubContexts() throws NamingException {
        for (int i = this.vectSubContexts.size() - 1; i >= 0; --i) {
            Hashtable hashtable = (Hashtable)this.vectSubContexts.get(i);
            Context context = (Context)hashtable.get("ParentCtx");
            String string = (String)hashtable.get("Name");
            context.destroySubcontext(string);
        }
        this.vectSubContexts.clear();
        if (this.j2caCtx != null) {
            if (this.adminObjectCtx != null) {
                this.j2caCtx.destroySubcontext("AdminObject");
            }
            if (this.connectionFactoryCtx != null) {
                this.j2caCtx.destroySubcontext("ConnectionFactory");
            }
            this.appCtx.getEnvContext().destroySubcontext("j2ca");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String string) throws ClassNotFoundException {
        Class clazz;
        Utils.startManagement();
        try {
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            if (this.classLoader == null || string == null || string.equals("")) {
                throw new ClassNotFoundException(string);
            }
            clazz = this.raIM.getAdapterLayer().loadClass((ClassLoader)this.classLoader, string, authenticatedSubject);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Utils.stopManagement();
            throw throwable;
        }
        Utils.stopManagement();
        return clazz;
    }

    public void remove() throws ModuleException {
        this.debugModule("calling remove.");
        try {
            if (this.raIM != null) {
                this.raIM.cleanupRuntime();
            }
            if (this.explodedRar != null) {
                this.explodedRar.remove();
            }
        }
        catch (RemoteRuntimeException remoteRuntimeException) {
            String string = Debug.logFailedToFindModuleRuntimeMBean(remoteRuntimeException.toString());
            Debug.logStackTrace(string, remoteRuntimeException);
            this.debugModule("Warning: couldn't find a runtime MBean for the module: " + remoteRuntimeException.toString());
        }
        catch (ManagementException managementException) {
            String string = Debug.logFailedToUnregisterModuleRuntimeMBean(managementException.toString());
            Debug.logStackTrace(string, managementException);
            this.debugModule("Warning: couldn't unregister a runtime MBean for the module: " + managementException.toString());
        }
        this.debugModule("has been REMOVED.");
    }

    public void adminToProduction() {
        this.debugModule("calling adminToProduction.");
        this.debugModule("has been adminToProduction.");
    }

    public void gracefulProductionToAdmin(AdminModeCompletionBarrier adminModeCompletionBarrier) throws ModuleException {
        this.debugModule("calling gracefulProductionToAdmin.");
        if (this.raIM.isWaitingStartVersioningComplete()) {
            ConnectorLogger.logWaitingComplete((String)this.raIM.toString());
            ShutdownCallback shutdownCallback = adminModeCompletionBarrier.registerWMShutdown();
            this.addListenerAndSignalShutdown(new AdapterListenerImpl(shutdownCallback));
        }
        this.debugModule("has been gracefulProductionToAdmin.");
    }

    public void forceProductionToAdmin() {
        this.debugModule("calling forceProductionToAdmin.");
        this.debugModule("has been forceProductionToAdmin.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RAInfo loadDescriptors() throws ModuleException {
        RAInfo rAInfo;
        try {
            Debug.enter(this, ".loadDescriptors()");
            this.debugModule("ConnectorModule.loadDescriptors() loading descriptors for module  of application " + ApplicationVersionUtils.getDisplayName(this.getAppId()));
            this.setJarFile();
            File file = this.resolveAltDD(this.appCtx, this.uri);
            DeploymentPlanBean deploymentPlanBean = this.appCtx.getAppDeploymentMBean().getDeploymentPlanDescriptor();
            AppDeploymentMBean appDeploymentMBean = this.appCtx.getAppDeploymentMBean();
            try {
                this.raInfo = DDUtil.getRAInfo(this.jarFile, file, this.getModuleName(), appDeploymentMBean, deploymentPlanBean);
            }
            catch (Exception exception) {
                this.debugModule("ConnectorModule.loadDescriptors() threw an exception: " + exception);
                throw new ModuleException(exception.toString(), exception);
            }
            this.debugModule("ConnectorModule.loadDescriptors() succeeded");
            rAInfo = this.raInfo;
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            Debug.exit(this, ".loadDescriptors() returning with raInfo = " + this.raInfo);
            throw throwable;
        }
        Debug.exit(this, ".loadDescriptors() returning with raInfo = " + this.raInfo);
        return rAInfo;
    }

    private void unsetJarFile() throws ModuleException {
        if (this.jarFile != null) {
            try {
                try {
                    this.jarFile.close();
                }
                catch (IOException iOException) {
                    String string = Debug.getExceptionCloseVJarFailed(this.jarFile.getName(), iOException.toString());
                    throw new ModuleException(string, iOException);
                }
                Object var4_1 = null;
                this.jarFile = null;
            }
            catch (Throwable throwable) {
                Object var4_2 = null;
                this.jarFile = null;
                throw throwable;
            }
        }
    }

    public void setAltDD(String string) {
        this.altDD = string;
    }

    private void setJarFile() throws ModuleException {
        try {
            this.jarFile = this.appFileManager.getVirtualJarFile(this.componentURI);
            this.explodedRar = new RarArchive(this.getAppId(), this.getModuleName(), this.jarFile);
        }
        catch (IOException iOException) {
            String string = Debug.getExceptionCreateVJarFailed(this.componentURI, iOException.toString());
            throw new ModuleException(string, iOException);
        }
    }

    public String getId() {
        return this.uri;
    }

    public String getType() {
        return WebLogicModuleType.MODULETYPE_RAR;
    }

    public ComponentRuntimeMBean[] getComponentRuntimeMBeans() {
        return new ComponentRuntimeMBean[]{this.getRuntimeMBean()};
    }

    public String getAltDD() {
        return this.altDD;
    }

    public ComponentRuntimeMBean getRuntimeMBean() {
        if (this.raIM != null) {
            return this.raIM.getRuntime();
        }
        return null;
    }

    private void addListenerAndSignalShutdown(AdapterListener adapterListener) throws ModuleException {
        BootstrapContext bootstrapContext = this.raIM.getBootstrapContext();
        if (bootstrapContext != null) {
            bootstrapContext.addListener(adapterListener);
            bootstrapContext.signalShutdown();
        }
    }

    public void removeListener(AdapterListener adapterListener) throws ModuleException {
        BootstrapContext bootstrapContext = this.raIM.getBootstrapContext();
        if (bootstrapContext != null) {
            bootstrapContext.removeListener(adapterListener);
        }
    }

    private String getModuleName() {
        if (this.moduleName != null) {
            return this.moduleName;
        }
        if (this.componentName == null) {
            return this.uri;
        }
        this.moduleName = this.componentName;
        return this.moduleName;
    }

    private String getAppId() {
        if (this.appId != null) {
            return this.appId;
        }
        if (this.appCtx != null) {
            this.appId = this.appCtx.getApplicationId();
        }
        return this.appId;
    }

    private void debugModule(String string) {
        if (Debug.isDeploymentEnabled()) {
            Debug.deployment("Module '" + this.getModuleName() + "' " + string);
        }
    }

    private void initJndiSubcontexts(ApplicationContext applicationContext) throws ModuleException {
        try {
            if (this.linkCtx == null) {
                this.linkCtx = this.getJndiContext(applicationContext);
            }
            if (this.j2caCtx == null) {
                try {
                    this.j2caCtx = (Context)applicationContext.getEnvContext().lookup("j2ca");
                }
                catch (NameNotFoundException nameNotFoundException) {
                    this.j2caCtx = applicationContext.getEnvContext().createSubcontext("j2ca");
                }
            }
            if (this.adminObjectCtx == null) {
                try {
                    this.adminObjectCtx = (Context)this.j2caCtx.lookup("AdminObject");
                }
                catch (NameNotFoundException nameNotFoundException) {
                    this.adminObjectCtx = this.j2caCtx.createSubcontext("AdminObject");
                }
            }
            if (this.connectionFactoryCtx == null) {
                try {
                    this.connectionFactoryCtx = (Context)this.j2caCtx.lookup("ConnectionFactory");
                }
                catch (NameNotFoundException nameNotFoundException) {
                    this.connectionFactoryCtx = this.j2caCtx.createSubcontext("ConnectionFactory");
                }
            }
        }
        catch (NamingException namingException) {
            this.debugModule("Failed to initialize the Connector-specific Jndi sub-contexts for the application, " + applicationContext.getApplicationId() + " :  " + namingException);
            String string = Debug.logInitJndiSubcontextsFailed(applicationContext.getApplicationId(), namingException.toString());
            Debug.logStackTrace(string, namingException);
            String string2 = Debug.getExceptionInitializeJndiSubcontextsFailed(applicationContext.getApplicationId(), namingException.toString());
            throw new ModuleException(string2, namingException);
        }
    }

    private Context getJndiContext(ApplicationContext applicationContext) throws NamingException {
        String[] stringArray = applicationContext.getApplicationId().split("\\.");
        Context context = (Context)new InitialContext().lookup("weblogic");
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                context = (Context)context.lookup(stringArray[i]);
                continue;
            }
            catch (NameNotFoundException nameNotFoundException) {
                Context context2 = context;
                context = context.createSubcontext(stringArray[i]);
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                hashtable.put("ParentCtx", context2);
                hashtable.put("Name", stringArray[i]);
                this.vectSubContexts.add(hashtable);
            }
        }
        return context;
    }

    public DescriptorBean[] getDescriptors() {
        DescriptorBean[] descriptorBeanArray = new DescriptorBean[]{(DescriptorBean)this.raInfo.getConnectorBean(), (DescriptorBean)this.raInfo.getWeblogicConnectorBean()};
        return descriptorBeanArray;
    }

    public boolean isParallelEnabled() {
        return true;
    }
}

