/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.deploy;

import java.util.ArrayList;
import java.util.List;
import weblogic.connector.configuration.DDUtil;
import weblogic.connector.deploy.ChangePackage;
import weblogic.connector.exception.RAException;
import weblogic.connector.external.RAInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConnectorModuleChangePackage {
    private ArrayList<ChangePackage> pendingChanges = new ArrayList();

    ConnectorModuleChangePackage() {
    }

    protected void prepare(RAInfo rAInfo) throws RAException {
        int n;
        DDUtil.validateRAInfo(rAInfo);
        try {
            int n2 = this.pendingChanges.size();
            for (n = 0; n < n2; ++n) {
                ChangePackage changePackage = this.pendingChanges.get(n);
                changePackage.prepare();
            }
        }
        catch (RAException rAException) {
            for (int i = 0; i <= n; ++i) {
                try {
                    ChangePackage changePackage = this.pendingChanges.get(i);
                    changePackage.rollback();
                    continue;
                }
                catch (RAException rAException2) {
                    // empty catch block
                }
            }
            throw rAException;
        }
    }

    protected void activate() throws RAException {
        RAException rAException = null;
        for (ChangePackage changePackage : this.pendingChanges) {
            try {
                changePackage.activate();
            }
            catch (RAException rAException2) {
                if (rAException == null) {
                    rAException = new RAException();
                }
                rAException.add((Throwable)((Object)rAException2));
            }
        }
        if (rAException != null) {
            throw rAException;
        }
    }

    protected void addChange(ChangePackage changePackage) {
        if (changePackage != null) {
            this.pendingChanges.add(changePackage);
        }
    }

    protected void addChanges(List<? extends ChangePackage> list) {
        this.pendingChanges.addAll(list);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChangeType {
        NEW,
        REMOVE,
        UPDATE;

    }
}

