/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.deploy;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import weblogic.application.ApplicationContextInternal;
import weblogic.connector.common.Debug;
import weblogic.connector.common.RAInstanceManager;
import weblogic.connector.deploy.AdminObjectChangePackage;
import weblogic.connector.deploy.ConnectionPoolChangePackage;
import weblogic.connector.deploy.ConnectorModuleChangePackage;
import weblogic.connector.deploy.RAClassFinder;
import weblogic.connector.deploy.RAPropsChangePackage;
import weblogic.connector.deploy.RarArchive;
import weblogic.connector.external.AdminObjInfo;
import weblogic.connector.external.ConfigPropInfo;
import weblogic.connector.external.OutboundInfo;
import weblogic.connector.external.RAInfo;
import weblogic.connector.external.impl.OutboundInfoImpl;
import weblogic.management.DeploymentException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityManager;
import weblogic.utils.classloaders.AugmentableClassLoaderManager;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployerUtil {
    private static String defaultNativeLibDir = "j2ca_native_lib";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createNativeLibDir(VirtualJarFile virtualJarFile, RAInfo rAInfo, ApplicationContextInternal applicationContextInternal) throws DeploymentException {
        File file;
        String string = rAInfo.getNativeLibDir();
        if (string == null || string.length() == 0) {
            file = new File(applicationContextInternal.getOutputPath());
            string = file.isDirectory() ? applicationContextInternal.getOutputPath() : new File(applicationContextInternal.getOutputPath()).getParent();
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            string = string + defaultNativeLibDir;
        }
        file = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        SecurityManager.pushSubject((AuthenticatedSubject)file, (AuthenticatedSubject)file);
        try {
            File file2 = new File(string);
            Iterator iterator = virtualJarFile.entries();
            while (iterator.hasNext()) {
                ZipEntry zipEntry = (ZipEntry)iterator.next();
                String string2 = zipEntry.getName();
                if (!string2.endsWith(".dll") && !string2.endsWith(".so") && !string2.endsWith(".sl")) continue;
                try {
                    int n;
                    int n2;
                    int n3;
                    String string3;
                    if (!file2.exists() && !file2.mkdirs() || !file2.isDirectory()) {
                        string3 = Debug.getExceptionErrorCreatingNativeLibDir(file2.getPath());
                        IOException iOException = new IOException(string3);
                        throw new DeploymentException(string3, iOException);
                    }
                    string3 = zipEntry.getName();
                    int n4 = string3.lastIndexOf("/");
                    int n5 = n3 = n4 > (n2 = string3.lastIndexOf("\\")) ? n4 : n2;
                    if (n3 != -1) {
                        string3 = string3.substring(n3 + 1);
                    }
                    Debug.logExtractingNativeLib(string3, string);
                    if (Debug.isDeploymentEnabled()) {
                        Debug.deployment("Extracting " + string3 + " to " + string);
                    }
                    InputStream inputStream = virtualJarFile.getInputStream(zipEntry);
                    FileOutputStream fileOutputStream = new FileOutputStream(string + File.separator + string3);
                    byte[] byArray = new byte[512];
                    while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                    inputStream.close();
                    fileOutputStream.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    String string4 = Debug.getExceptionFileNotFoundForNativeLibDir(rAInfo.getDisplayName());
                    throw new DeploymentException(string4, fileNotFoundException);
                }
                catch (IOException iOException) {
                    String string5 = Debug.getExceptionExceptionCreatingNativeLibDir(rAInfo.getDisplayName(), iOException.toString());
                    throw new DeploymentException(string5, iOException);
                }
            }
            Object var18_22 = null;
        }
        catch (Throwable throwable) {
            Object var18_23 = null;
            SecurityManager.popSubject((AuthenticatedSubject)file);
            throw throwable;
        }
        SecurityManager.popSubject((AuthenticatedSubject)file);
    }

    public static void updateClassFinder(GenericClassLoader genericClassLoader, RarArchive rarArchive, boolean bl, List list) {
        ArrayList<ClassFinder> arrayList = new ArrayList<ClassFinder>();
        RAClassFinder rAClassFinder = new RAClassFinder(rarArchive);
        arrayList.add(rAClassFinder);
        DeployerUtil.populateRootDirectoryClassFinder(rarArchive.getVirtualJarFile(), arrayList);
        DeployerUtil.addClassFinderToClassloader(genericClassLoader, bl, arrayList, list);
    }

    public static void updateClassFinder(GenericClassLoader genericClassLoader, VirtualJarFile virtualJarFile, boolean bl, List list) {
        ArrayList<ClassFinder> arrayList = new ArrayList<ClassFinder>();
        RAClassFinder rAClassFinder = new RAClassFinder(virtualJarFile);
        arrayList.add(rAClassFinder);
        DeployerUtil.populateRootDirectoryClassFinder(virtualJarFile, arrayList);
        DeployerUtil.addClassFinderToClassloader(genericClassLoader, bl, arrayList, list);
    }

    public static void populateRootDirectoryClassFinder(VirtualJarFile virtualJarFile, List<ClassFinder> list) {
        if (virtualJarFile.isDirectory()) {
            File[] fileArray = virtualJarFile.getRootFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                String string = fileArray[i].toString();
                ClasspathClassFinder2 classpathClassFinder2 = new ClasspathClassFinder2(string);
                list.add((ClassFinder)classpathClassFinder2);
            }
        } else {
            String string = virtualJarFile.getName();
            ClasspathClassFinder2 classpathClassFinder2 = new ClasspathClassFinder2(string);
            list.add((ClassFinder)classpathClassFinder2);
        }
    }

    public static void addClassFinderToClassloader(GenericClassLoader genericClassLoader, boolean bl, List<ClassFinder> list, List list2) {
        GenericClassLoader genericClassLoader2 = null;
        genericClassLoader2 = bl ? AugmentableClassLoaderManager.getAugmentableSystemClassLoader() : genericClassLoader;
        for (ClassFinder classFinder : list) {
            genericClassLoader2.addClassFinder(classFinder);
            list2.add(classFinder);
        }
    }

    protected static ConnectorModuleChangePackage enumerateChanges(RAInstanceManager rAInstanceManager, RAInfo rAInfo, RAInfo rAInfo2) {
        ConnectorModuleChangePackage connectorModuleChangePackage = new ConnectorModuleChangePackage();
        connectorModuleChangePackage.addChanges(DeployerUtil.enumerateAdminObjectChanges(rAInstanceManager, rAInfo, rAInfo2));
        connectorModuleChangePackage.addChanges(DeployerUtil.enumerateConnectionPoolChanges(rAInstanceManager, rAInfo, rAInfo2));
        connectorModuleChangePackage.addChange(DeployerUtil.enumerateRAPropsChanges(rAInstanceManager, rAInfo, rAInfo2));
        return connectorModuleChangePackage;
    }

    private static Properties getPoolParamPropertyChanges(OutboundInfo outboundInfo, OutboundInfo outboundInfo2) {
        Properties properties = new Properties();
        int n = outboundInfo.getInitialCapacity();
        int n2 = outboundInfo2.getInitialCapacity();
        int n3 = outboundInfo.getMaxCapacity();
        int n4 = outboundInfo2.getMaxCapacity();
        int n5 = outboundInfo.getCapacityIncrement();
        int n6 = outboundInfo2.getCapacityIncrement();
        int n7 = outboundInfo.getShrinkFrequencySeconds();
        int n8 = outboundInfo2.getShrinkFrequencySeconds();
        int n9 = outboundInfo.getInactiveConnectionTimeoutSeconds();
        int n10 = outboundInfo2.getInactiveConnectionTimeoutSeconds();
        int n11 = outboundInfo.getHighestNumWaiters();
        int n12 = outboundInfo2.getHighestNumWaiters();
        int n13 = outboundInfo.getHighestNumUnavailable();
        int n14 = outboundInfo2.getHighestNumUnavailable();
        int n15 = outboundInfo.getConnectionCreationRetryFrequencySeconds();
        int n16 = outboundInfo2.getConnectionCreationRetryFrequencySeconds();
        int n17 = outboundInfo.getConnectionReserveTimeoutSeconds();
        int n18 = outboundInfo2.getConnectionReserveTimeoutSeconds();
        int n19 = outboundInfo.getTestFrequencySeconds();
        int n20 = outboundInfo2.getTestFrequencySeconds();
        int n21 = outboundInfo.getProfileHarvestFrequencySeconds();
        int n22 = outboundInfo2.getProfileHarvestFrequencySeconds();
        boolean bl = outboundInfo.isShrinkingEnabled();
        boolean bl2 = outboundInfo2.isShrinkingEnabled();
        boolean bl3 = outboundInfo.isTestConnectionsOnCreate();
        boolean bl4 = outboundInfo2.isTestConnectionsOnCreate();
        boolean bl5 = outboundInfo.isTestConnectionsOnRelease();
        boolean bl6 = outboundInfo2.isTestConnectionsOnRelease();
        boolean bl7 = outboundInfo.isTestConnectionsOnReserve();
        boolean bl8 = outboundInfo2.isTestConnectionsOnReserve();
        if (n != n2) {
            properties.setProperty("initialCapacity", String.valueOf(n2));
        }
        if (n3 != n4) {
            properties.setProperty("maxCapacity", String.valueOf(n4));
        }
        if (n5 != n6) {
            properties.setProperty("capacityIncrement", String.valueOf(n6));
        }
        if (n7 != n8) {
            properties.setProperty("shrinkFrequencySeconds", String.valueOf(n8));
        }
        if (n9 != n10) {
            properties.setProperty("inactiveResTimeoutSeconds", String.valueOf(n10));
        }
        if (n11 != n12) {
            properties.setProperty("maxWaiters", String.valueOf(n12));
        }
        if (n13 != n14) {
            properties.setProperty("maxUnavl", String.valueOf(n14));
        }
        if (n15 != n16) {
            properties.setProperty("resCreationRetrySeconds", String.valueOf(n16));
        }
        if (n17 != n18) {
            properties.setProperty("resvTimeoutSeconds", String.valueOf(n18));
        }
        if (n19 != n20) {
            properties.setProperty("testFrequencySeconds", String.valueOf(n20));
        }
        if (n21 != n22) {
            properties.setProperty("harvestFreqSecsonds", String.valueOf(n22));
        }
        if (bl != bl2) {
            properties.setProperty("shrinkEnabled", String.valueOf(bl2));
        }
        if (bl3 != bl4) {
            properties.setProperty("testOnCreate", String.valueOf(bl4));
        }
        if (bl5 != bl6) {
            properties.setProperty("testOnRelease", String.valueOf(bl6));
        }
        if (bl7 != bl8) {
            properties.setProperty("testOnReserve", String.valueOf(bl8));
        }
        return properties.size() > 0 ? properties : null;
    }

    private static Properties getLoggingPropertyChanges(OutboundInfo outboundInfo, OutboundInfo outboundInfo2) {
        Properties properties = new Properties();
        int n = outboundInfo.getFileCount();
        int n2 = outboundInfo2.getFileCount();
        int n3 = outboundInfo.getFileSizeLimit();
        int n4 = outboundInfo2.getFileSizeLimit();
        int n5 = outboundInfo.getFileTimeSpan();
        int n6 = outboundInfo2.getFileTimeSpan();
        String string = outboundInfo.getLogFileRotationDir();
        String string2 = outboundInfo2.getLogFileRotationDir();
        String string3 = outboundInfo.getLogFilename();
        String string4 = outboundInfo2.getLogFilename();
        boolean bl = outboundInfo.isLoggingEnabled();
        boolean bl2 = outboundInfo2.isLoggingEnabled();
        boolean bl3 = outboundInfo.isNumberOfFilesLimited();
        boolean bl4 = outboundInfo2.isNumberOfFilesLimited();
        boolean bl5 = outboundInfo.isRotateLogOnStartup();
        boolean bl6 = outboundInfo2.isRotateLogOnStartup();
        String string5 = outboundInfo.getRotationTime();
        String string6 = outboundInfo2.getRotationTime();
        String string7 = outboundInfo.getRotationType();
        String string8 = outboundInfo2.getRotationType();
        if (n != n2) {
            properties.setProperty("FileCount", String.valueOf(n2));
        }
        if (n3 != n4) {
            properties.setProperty("FileSizeLimit", String.valueOf(n4));
        }
        if (n5 != n6) {
            properties.setProperty("FileTimeSpan", String.valueOf(n6));
        }
        if (!DeployerUtil.stringsMatch(string, string2)) {
            properties.setProperty("LogFileRotationDir", string2);
        }
        if (!DeployerUtil.stringsMatch(string3, string4)) {
            properties.setProperty("LogFilename", string4);
        }
        if (bl != bl2) {
            properties.setProperty("LoggingEnabled", String.valueOf(bl2));
        }
        if (bl3 != bl4) {
            properties.setProperty("NumberOfFilesLimited", String.valueOf(bl4));
        }
        if (bl5 != bl6) {
            properties.setProperty("RotateLogOnStartup", String.valueOf(bl6));
        }
        if (!DeployerUtil.stringsMatch(string5, string6)) {
            properties.setProperty("RotationTime", String.valueOf(string6));
        }
        if (!DeployerUtil.stringsMatch(string7, string8)) {
            properties.setProperty("RotationType", String.valueOf(string8));
        }
        return properties.size() > 0 ? properties : null;
    }

    private static boolean stringsMatch(String string, String string2) {
        return string == null ? string2 == null : string.equals(string2);
    }

    private static List<ConnectionPoolChangePackage> enumerateConnectionPoolChanges(RAInstanceManager rAInstanceManager, RAInfo rAInfo, RAInfo rAInfo2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        ArrayList<ConnectionPoolChangePackage> arrayList = new ArrayList<ConnectionPoolChangePackage>();
        List list = rAInfo.getOutboundInfos();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object5 = null;
            object4 = (OutboundInfoImpl)iterator.next();
            object3 = rAInfo2.getOutboundInfo(((OutboundInfoImpl)object4).getKey());
            if (object3 != null) {
                object2 = DeployerUtil.getPoolParamPropertyChanges((OutboundInfo)object4, (OutboundInfo)object3);
                object = DeployerUtil.getLoggingPropertyChanges((OutboundInfo)object4, (OutboundInfo)object3);
                HashMap<String, ConfigPropInfo> hashMap = new HashMap<String, ConfigPropInfo>();
                object5 = new ConnectionPoolChangePackage(rAInstanceManager, (OutboundInfo)object3, (Properties)object2, (Properties)object, hashMap, ConnectorModuleChangePackage.ChangeType.UPDATE);
            } else {
                object5 = new ConnectionPoolChangePackage(rAInstanceManager, (OutboundInfo)object4, null, null, null, ConnectorModuleChangePackage.ChangeType.REMOVE);
            }
            if (object5 == null) continue;
            arrayList.add((ConnectionPoolChangePackage)object5);
        }
        object5 = rAInfo2.getOutboundInfos();
        object4 = object5.iterator();
        while (object4.hasNext()) {
            object3 = null;
            object2 = (OutboundInfoImpl)object4.next();
            object = rAInfo.getOutboundInfo(((OutboundInfoImpl)object2).getKey());
            if (object != null) continue;
            object3 = new ConnectionPoolChangePackage(rAInstanceManager, (OutboundInfo)object2, null, null, null, ConnectorModuleChangePackage.ChangeType.NEW);
            arrayList.add((ConnectionPoolChangePackage)object3);
        }
        return arrayList;
    }

    private static List<AdminObjectChangePackage> enumerateAdminObjectChanges(RAInstanceManager rAInstanceManager, RAInfo rAInfo, RAInfo rAInfo2) {
        AdminObjInfo adminObjInfo;
        Object object;
        Object object2;
        ArrayList<AdminObjectChangePackage> arrayList = new ArrayList<AdminObjectChangePackage>();
        List list = rAInfo2.getAdminObjs();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object2 = null;
            object = (AdminObjInfo)iterator.next();
            adminObjInfo = rAInfo.getAdminObject(object.getJndiName());
            if (adminObjInfo != null) continue;
            object2 = new AdminObjectChangePackage(rAInstanceManager, (AdminObjInfo)object, ConnectorModuleChangePackage.ChangeType.NEW, null);
            arrayList.add((AdminObjectChangePackage)object2);
        }
        object2 = rAInfo.getAdminObjs();
        object = object2.iterator();
        while (object.hasNext()) {
            adminObjInfo = (AdminObjInfo)object.next();
            if (rAInfo2.getAdminObject(adminObjInfo.getJndiName()) != null) continue;
            arrayList.add(new AdminObjectChangePackage(rAInstanceManager, adminObjInfo, ConnectorModuleChangePackage.ChangeType.REMOVE, null));
        }
        return arrayList;
    }

    private static RAPropsChangePackage enumerateRAPropsChanges(RAInstanceManager rAInstanceManager, RAInfo rAInfo, RAInfo rAInfo2) {
        RAPropsChangePackage rAPropsChangePackage = null;
        if (!DeployerUtil.stringsMatch(rAInfo.getJndiName(), rAInfo2.getJndiName())) {
            rAPropsChangePackage = new RAPropsChangePackage(rAInstanceManager, null);
            rAPropsChangePackage.setNewJNDIName(rAInfo2.getJndiName());
        }
        return rAPropsChangePackage;
    }

    public static boolean enumeratePropsChanges(Map<String, ConfigPropInfo> map, Map<String, ConfigPropInfo> map2, Map<String, ConfigPropInfo> map3) {
        for (Map.Entry<String, ConfigPropInfo> entry : map.entrySet()) {
            ConfigPropInfo configPropInfo = entry.getValue();
            ConfigPropInfo configPropInfo2 = map2.get(configPropInfo.getName());
            if (configPropInfo2 == null || DeployerUtil.hasEqualValue(configPropInfo, configPropInfo2)) continue;
            map3.put(configPropInfo2.getName().toLowerCase(), configPropInfo2);
        }
        return !map3.isEmpty();
    }

    private static boolean hasEqualValue(ConfigPropInfo configPropInfo, ConfigPropInfo configPropInfo2) {
        if (configPropInfo.getValue() == null) {
            return configPropInfo2.getValue() == null;
        }
        return configPropInfo.getValue().equals(configPropInfo2.getValue());
    }
}

