/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.deploy;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.security.AccessController;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ApplicationServerInternalException;
import javax.resource.spi.ResourceAdapter;
import weblogic.application.ApplicationContext;
import weblogic.application.ApplicationContextInternal;
import weblogic.connector.common.Debug;
import weblogic.connector.common.RAInstanceManager;
import weblogic.connector.deploy.TransportableJNDIHandler;
import weblogic.connector.exception.RACommonException;
import weblogic.connector.exception.RAException;
import weblogic.connector.external.AdminObjInfo;
import weblogic.connector.external.OutboundInfo;
import weblogic.connector.outbound.RAOutboundManager;
import weblogic.jndi.Environment;
import weblogic.management.DeploymentException;
import weblogic.management.UndeploymentException;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class JNDIHandler
implements ObjectFactory {
    private static Context initialCtx = null;
    private static Hashtable keyNameToOutboundManagerMap = new Hashtable();
    protected static Hashtable keyNameToAdminObj = new Hashtable();
    protected static Hashtable keyNameToRA = new Hashtable();
    public static final String J2CA_CONTEXTNAME = "j2ca";
    public static final String ADMINOBJECT_NODENAME = "AdminObject";
    public static final String CONNECTIONFACTORY_NODENAME = "ConnectionFactory";
    public static final String ADMINOBJECT_CONTEXTNAME = "j2ca/AdminObject";
    public static final String CONNECTIONFACTORY_CONTEXTNAME = "j2ca/ConnectionFactory";
    public static final String THIS_FACTORY_NAME = JNDIHandler.class.getName();

    public static boolean verifyJNDIName(String string) throws RAException {
        if (string == null || string.equals("")) {
            String string2 = Debug.getExceptionJndiNameNull();
            throw new RAException(string2);
        }
        return JNDIHandler.isJndiNameBound(string);
    }

    public static boolean verifyResourceLink(String string, Context context) throws RAException {
        if (string == null || string.equals("")) {
            String string2 = Debug.getExceptionResourceLinkNull();
            throw new RAException(string2);
        }
        return JNDIHandler.isResourceLinkAlreadyBound(string, context);
    }

    public static void bindConnectionFactory(OutboundInfo outboundInfo, RAOutboundManager rAOutboundManager, Object object) throws DeploymentException {
        Debug.enter("JNDIHandler.jndiBind(...) ");
        if (outboundInfo == null) {
            Debug.throwAssertionError("OutboundInfo is null");
        }
        if (rAOutboundManager == null) {
            Debug.throwAssertionError("RAOutboundManager is null");
        }
        String string = outboundInfo.getJndiName();
        String string2 = rAOutboundManager.getRA().getVersionId();
        String string3 = JNDIHandler.getJndiNameAndVersion(string, string2);
        try {
            try {
                Debug.println("Binding to the JNDI tree : " + string);
                boolean bl = JNDIHandler.isJndiNameBound(string);
                String string4 = Debug.getExceptionAlreadyDeployed(string);
                JNDIHandler.assertDeployment(bl, string4);
                Reference reference = null;
                if (object instanceof Remote) {
                    Debug.println(".bindConnectionFactory() connFactory " + object + " is instanceof java.rmi.Remote");
                    reference = new Reference(outboundInfo.getCFImpl(), new StringRefAddr("keyName", string3), TransportableJNDIHandler.class.getName(), null);
                    if (ServerHelper.isClusterable((Remote)((Remote)object))) {
                        ServerHelper.exportObject((Remote)((Remote)object), (String)string);
                    } else {
                        ServerHelper.exportObject((Remote)((Remote)object));
                    }
                } else {
                    Debug.println(".bindConnectionFactory() connFactory " + object + " is not instanceof java.rmi.Remote");
                    reference = new Reference(outboundInfo.getCFImpl(), new StringRefAddr("keyName", string3), THIS_FACTORY_NAME, null);
                }
                Debug.println("Adding to the keyNameToOutboundManagerMap : " + string3);
                keyNameToOutboundManagerMap.put(string3, rAOutboundManager);
                if (object instanceof Referenceable) {
                    ((Referenceable)object).setReference(reference);
                }
                JNDIHandler.getInitialContext().bind(new CompositeName(string), (Object)reference);
            }
            catch (InvalidNameException invalidNameException) {
                String string5 = Debug.getExceptionBindingFailed(string, invalidNameException.toString());
                throw new DeploymentException(string5, invalidNameException);
            }
            catch (NamingException namingException) {
                String string6 = Debug.getExceptionBindingFailed(string, namingException.toString());
                throw new DeploymentException(string6, namingException);
            }
            catch (Throwable throwable) {
                String string7 = Debug.getExceptionBindingFailed(string, throwable.toString());
                throw new DeploymentException(string7, throwable);
            }
            Object var10_15 = null;
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            Debug.exit("JNDIHandler.jndiBind(...) ");
            throw throwable;
        }
        Debug.exit("JNDIHandler.jndiBind(...) ");
    }

    public static void bindAppScopedConnectionFactory(OutboundInfo outboundInfo, RAOutboundManager rAOutboundManager, ApplicationContext applicationContext, Context context, String string) throws DeploymentException {
        Debug.enter("JNDIHandler.bindAppScopedConnectionFactory(...) ");
        if (outboundInfo == null) {
            Debug.throwAssertionError("OutboundInfo is null");
        }
        if (rAOutboundManager == null) {
            Debug.throwAssertionError("RAOutboundManager is null");
        }
        String string2 = outboundInfo.getResourceLink();
        try {
            try {
                Debug.println("Binding to the App-Scoped JNDI tree : " + string2);
                boolean bl = JNDIHandler.isResourceLinkAlreadyBound(string + "#" + string2, context);
                String string3 = Debug.getExceptionAlreadyDeployed(string2);
                JNDIHandler.assertDeployment(bl, string3);
                String string4 = applicationContext.getApplicationId() + "/" + string2;
                Reference reference = new Reference(outboundInfo.getCFImpl(), new StringRefAddr("keyName", string4), THIS_FACTORY_NAME, null);
                Debug.println("Adding to the keyNameToOutboundManagerMap : " + string4 + " : " + rAOutboundManager);
                keyNameToOutboundManagerMap.put(string4, rAOutboundManager);
                context.bind(new CompositeName(string + "#" + string2), (Object)reference);
                Context context2 = JNDIHandler.getInitialContext();
                String string5 = "weblogic." + applicationContext.getApplicationId() + "." + string2;
                context2.bind(new CompositeName(string5), (Object)new LinkRef("java:app/j2ca/ConnectionFactory/" + string + "#" + string2));
            }
            catch (InvalidNameException invalidNameException) {
                String string6 = Debug.getExceptionBindingFailed(string2, invalidNameException.toString());
                throw new DeploymentException(string6, invalidNameException);
            }
            catch (NamingException namingException) {
                String string7 = Debug.getExceptionBindingFailed(string2, namingException.toString());
                throw new DeploymentException(string7, namingException);
            }
            catch (Throwable throwable) {
                String string8 = Debug.getExceptionBindingFailed(string2, throwable.toString());
                throw new DeploymentException(string8, throwable);
            }
            Object var13_18 = null;
        }
        catch (Throwable throwable) {
            Object var13_19 = null;
            Debug.exit("JNDIHandler.bindAppScopedConnectionFactory(...) ");
            throw throwable;
        }
        Debug.exit("JNDIHandler.bindAppScopedConnectionFactory(...) ");
    }

    public static void assertDeployment(boolean bl, String string) throws DeploymentException {
        if (!bl) {
            return;
        }
        throw new DeploymentException(string);
    }

    public static void unbindConnectionFactory(OutboundInfo outboundInfo, RAOutboundManager rAOutboundManager, Object object) throws UndeploymentException {
        Debug.enter("JNDIHandler.unbindConnectionFactory(...) ");
        if (outboundInfo == null) {
            Debug.throwAssertionError("OutboundInfo is null");
        }
        try {
            block8: {
                try {
                    String string = outboundInfo.getJndiName();
                    boolean bl = string == null || string.length() == 0;
                    String string2 = JNDIHandler.getJndiNameAndVersion(string, rAOutboundManager.getRA().getVersionId());
                    if (!bl) {
                        Context context = JNDIHandler.getInitialContext();
                        Debug.println("Unbind JNDI name : " + string);
                        context.unbind(new CompositeName(string));
                        Debug.println("Remove from keyNameToOutboundManagerMap : " + string2);
                        keyNameToOutboundManagerMap.remove(string2);
                        try {
                            ServerHelper.unexportObject((Object)object, (boolean)true, (boolean)true);
                        }
                        catch (NoSuchObjectException noSuchObjectException) {}
                        break block8;
                    }
                    String string3 = outboundInfo.getResourceLink();
                    Debug.println("Unbind app-scoped ConnectionFactory, resource-link : " + string3);
                    ApplicationContextInternal applicationContextInternal = rAOutboundManager.getRA().getAppContext();
                    applicationContextInternal.getEnvContext().unbind(new CompositeName("j2ca/ConnectionFactory/" + rAOutboundManager.getModuleName() + "#" + string3));
                    Context context = JNDIHandler.getInitialContext();
                    context.unbind("weblogic." + applicationContextInternal.getApplicationId() + "." + string3);
                    String string4 = applicationContextInternal.getApplicationId() + "/" + string3;
                    Debug.println("Remove from keyNameToOutboundManagerMap : " + string4);
                    keyNameToOutboundManagerMap.remove(string4);
                }
                catch (NamingException namingException) {
                    String string = Debug.getExceptionNoInitialContextForUnbind(namingException.toString());
                    throw new UndeploymentException(string, namingException);
                }
            }
            Object var11_14 = null;
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            Debug.exit("JNDIHandler.unbindConnectionFactory(...) ");
            throw throwable;
        }
        Debug.exit("JNDIHandler.unbindConnectionFactory(...) ");
    }

    public static void bindRA(String string, ResourceAdapter resourceAdapter, String string2) throws RACommonException {
        if (resourceAdapter == null) {
            Debug.throwAssertionError("ResourceAdapter is null");
        }
        if (string != null && !string.equals("")) {
            try {
                String string3 = JNDIHandler.getJndiNameAndVersion(string, string2);
                boolean bl = JNDIHandler.isJndiNameBound(string);
                String string4 = Debug.getExceptionJndiNameAlreadyBound(string);
                JNDIHandler.assertDeployment(bl, string4);
                keyNameToRA.put(string3, resourceAdapter);
                Reference reference = null;
                if (resourceAdapter instanceof Remote) {
                    reference = new Reference(resourceAdapter.getClass().toString(), new StringRefAddr("keyName", string3), TransportableJNDIHandler.class.getName(), null);
                    Remote remote = ServerHelper.isClusterable((Remote)((Remote)resourceAdapter)) ? ServerHelper.exportObject((Remote)((Remote)resourceAdapter), (String)string) : ServerHelper.exportObject((Remote)((Remote)resourceAdapter));
                    if (Debug.isDeploymentEnabled()) {
                        Debug.deployment("Bind Remote RA " + remote + " with JNDI name = " + string);
                    }
                } else {
                    reference = new Reference(resourceAdapter.getClass().toString(), new StringRefAddr("keyName", string3), JNDIHandler.class.getName(), null);
                    if (Debug.isDeploymentEnabled()) {
                        Debug.deployment("Bind non-Remote RA ref" + reference + " with JNDI name = " + string);
                    }
                }
                JNDIHandler.getInitialContext().bind(new CompositeName(string), (Object)reference);
            }
            catch (Exception exception) {
                String string5 = Debug.getExceptionBindingFailed(string, exception.toString());
                throw new RACommonException(string5, exception);
            }
        }
    }

    public static void unbindRA(String string, ResourceAdapter resourceAdapter, String string2) throws NamingException {
        if (string != null && !string.equals("")) {
            if (Debug.isDeploymentEnabled()) {
                Debug.deployment("Unbind RA JNDI name '" + string + "'");
            }
            JNDIHandler.getInitialContext().unbind(new CompositeName(string));
            keyNameToRA.remove(JNDIHandler.getJndiNameAndVersion(string, string2));
            try {
                ServerHelper.unexportObject((Object)resourceAdapter, (boolean)true, (boolean)true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
    }

    public static void bindAdminObj(Object object, String string, String string2, RAInstanceManager rAInstanceManager) throws RACommonException {
        if (string == null || string.trim().equals("")) {
            Debug.throwAssertionError("JNDI name null or blank");
        }
        if (object == null) {
            Debug.throwAssertionError("Administered object is null");
        }
        try {
            boolean bl = JNDIHandler.isJndiNameBound(string);
            String string3 = Debug.getExceptionJndiNameAlreadyBound(string);
            JNDIHandler.assertDeployment(bl, string3);
            String string4 = JNDIHandler.getJndiNameAndVersion(string, string2);
            keyNameToAdminObj.put(string4, object);
            Reference reference = null;
            if (object instanceof Remote) {
                reference = new Reference(object.getClass().toString(), new StringRefAddr("keyName", string4), TransportableJNDIHandler.class.getName(), null);
                if (ServerHelper.isClusterable((Remote)((Remote)object))) {
                    ServerHelper.exportObject((Remote)((Remote)object), (String)string);
                } else {
                    ServerHelper.exportObject((Remote)((Remote)object));
                }
            } else {
                reference = new Reference(object.getClass().toString(), new StringRefAddr("keyName", string4), JNDIHandler.class.getName(), null);
            }
            JNDIHandler.getInitialContext().bind(new CompositeName(string), (Object)reference);
            if (Debug.isDeploymentEnabled()) {
                AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                Debug.deployment("Binding admin object '" + rAInstanceManager.getAdapterLayer().toString(object, authenticatedSubject) + "' to JNDI name '" + string + "'.");
            }
        }
        catch (Exception exception) {
            String string5 = Debug.getExceptionBindingFailed(string, exception.toString());
            throw new RACommonException(string5, exception);
        }
    }

    public static void bindAppScopedAdminObj(Object object, String string, ApplicationContext applicationContext, Context context, String string2) throws RACommonException {
        if (string == null || string.equals("")) {
            Debug.throwAssertionError("resourceLink is null or empty");
        }
        if (object == null) {
            Debug.throwAssertionError("Administer object is null");
        }
        try {
            boolean bl = JNDIHandler.isResourceLinkAlreadyBound(string2 + "#" + string, context);
            String string3 = Debug.getExceptionResourceLinkAlreadyBound(string);
            JNDIHandler.assertDeployment(bl, string3);
            String string4 = applicationContext.getApplicationId() + "/" + string;
            keyNameToAdminObj.put(string4, object);
            Reference reference = new Reference(object.getClass().toString(), new StringRefAddr("keyName", string4), THIS_FACTORY_NAME, null);
            context.bind(new CompositeName(string2 + "#" + string), (Object)reference);
            Context context2 = JNDIHandler.getInitialContext();
            String string5 = "weblogic." + applicationContext.getApplicationId() + "." + string;
            String string6 = "java:app/j2ca/AdminObject/" + string2 + "#" + string;
            if (Debug.isDeploymentEnabled()) {
                Debug.deployment("Binding app-scoped admin object ref = '" + string6 + "' to JNDI name '" + string5 + "'.");
            }
            context2.bind(new CompositeName(string5), (Object)new LinkRef(string6));
        }
        catch (Exception exception) {
            String string7 = Debug.getExceptionAppScopedBindFailed(string2, string, exception.toString());
            throw new RACommonException(string7, exception);
        }
    }

    public static void unbindAdminObj(AdminObjInfo adminObjInfo, RAInstanceManager rAInstanceManager) throws UndeploymentException {
        String string = adminObjInfo.getJndiName();
        try {
            String string2 = JNDIHandler.getJndiNameAndVersion(string, rAInstanceManager.getVersionId());
            if (string == null || string.equals("")) {
                String string3 = adminObjInfo.getResourceLink();
                Debug.deployment("Unbind app-scoped Admin Object resource-link : " + string3);
                ApplicationContextInternal applicationContextInternal = rAInstanceManager.getAppContext();
                applicationContextInternal.getEnvContext().unbind(new CompositeName("j2ca/AdminObject/" + rAInstanceManager.getModuleName() + "#" + string3));
                Context context = JNDIHandler.getInitialContext();
                context.unbind("weblogic." + applicationContextInternal.getApplicationId() + "." + string3);
                String string4 = applicationContextInternal.getApplicationId() + "/" + string3;
                Debug.println("Remove from keyNameToAdminObj : " + string4);
                keyNameToAdminObj.remove(string4);
            } else {
                Debug.deployment("Unbind Admin Object, jndi-name : " + string);
                JNDIHandler.getInitialContext().unbind(new CompositeName(string));
                Debug.println("Remove from keyNameToAdminObj : " + string2);
                keyNameToAdminObj.remove(string2);
            }
        }
        catch (NamingException namingException) {
            String string5 = Debug.getExceptionUnbindAdminObjectFailed(namingException.toString());
            throw new UndeploymentException(string5, namingException);
        }
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        Reference reference = null;
        String string = null;
        if (!(object instanceof Reference)) {
            return null;
        }
        reference = (Reference)object;
        string = reference.getFactoryClassName();
        if (!string.equals(THIS_FACTORY_NAME)) {
            return null;
        }
        return this.lookupObject(object, name, context, hashtable, reference, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object lookupObject(Object object, Name name, Context context, Hashtable hashtable, Reference reference, String string) throws ResourceException, ApplicationServerInternalException, NoPermissionException, NameNotFoundException {
        String string2;
        Object object2;
        block6: {
            Object var11_11;
            object2 = null;
            try {
                Debug.enter(this, "getObjectInstance( " + object + ", " + name + ", " + context + ", " + hashtable + " )");
                String string3 = reference.getClassName();
                RefAddr refAddr = reference.get("keyName");
                string2 = null;
                if (refAddr != null) {
                    string2 = (String)refAddr.getContent();
                }
                Debug.println(this, ".getObjectInstance() FactoryClassName = " + string + ", ClassName = " + string3 + ", Ref = " + refAddr + ", Key name = " + string2);
                if (string2 != null) break block6;
                var11_11 = null;
                Object var13_13 = null;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                Debug.exit(this, "getObjectInstance(...) returning: " + object2);
                throw throwable;
            }
            Debug.exit(this, "getObjectInstance(...) returning: " + object2);
            return var11_11;
        }
        object2 = this.getConnectionFactory(string2);
        if (object2 == null && (object2 = keyNameToAdminObj.get(string2)) == null) {
            object2 = keyNameToRA.get(string2);
        }
        if (object2 == null) {
            throw new NameNotFoundException("No Object found:  " + string2);
        }
        Object object3 = object2;
        Object var13_14 = null;
        Debug.exit(this, "getObjectInstance(...) returning: " + object2);
        return object3;
    }

    private static Context getInitialContext() throws NamingException {
        if (initialCtx == null) {
            Environment environment = new Environment();
            environment.setCreateIntermediateContexts(true);
            environment.setReplicateBindings(false);
            initialCtx = environment.getInitialContext();
        }
        return initialCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isJndiNameBound(String string) {
        boolean bl;
        boolean bl2;
        Debug.enter("JNDIHandler.isJndiNameBound( " + string + " )");
        if (string == null || string.trim().equals("")) {
            Debug.throwAssertionError("JNDI Name is null");
        }
        Context context = null;
        Object object = null;
        try {
            try {
                context = JNDIHandler.getInitialContext();
                object = context.lookup(string);
            }
            catch (NameNotFoundException nameNotFoundException) {
                Object var6_4 = null;
                bl2 = object != null;
                Debug.exit("JNDIHandler.isJndiNameBound( " + string + " ) returning " + bl2);
                return bl2;
            }
            catch (Throwable throwable) {
                Debug.throwAssertionError("No Initial Context for Jndi:  " + throwable, throwable);
                Object var6_5 = null;
                bl2 = object != null;
                Debug.exit("JNDIHandler.isJndiNameBound( " + string + " ) returning " + bl2);
                return bl2;
            }
            Object var6_3 = null;
            bl = object != null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            boolean bl22 = object != null;
            Debug.exit("JNDIHandler.isJndiNameBound( " + string + " ) returning " + bl22);
            throw throwable;
        }
        bl2 = bl;
        Debug.exit("JNDIHandler.isJndiNameBound( " + string + " ) returning " + bl2);
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isResourceLinkAlreadyBound(String string, Context context) {
        boolean bl;
        boolean bl2;
        Debug.enter("JNDIHandler.isResourceLinkAlreadyBound( " + string + " )");
        if (string == null || string.trim().equals("")) {
            Debug.throwAssertionError("ResourceLink is null or empty");
        }
        Object object = null;
        try {
            try {
                object = context.lookup(string);
            }
            catch (NameNotFoundException nameNotFoundException) {
                Object var6_4 = null;
                bl2 = object != null;
                Debug.exit("JNDIHandler.isResourceLinkAlreadyBound( " + string + " ) returning " + bl2);
                return bl2;
            }
            catch (Throwable throwable) {
                Debug.throwAssertionError("isResourceLinkAlreadyBound threw Exception:  " + throwable);
                Object var6_5 = null;
                bl2 = object != null;
                Debug.exit("JNDIHandler.isResourceLinkAlreadyBound( " + string + " ) returning " + bl2);
                return bl2;
            }
            Object var6_3 = null;
            bl = object != null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            boolean bl22 = object != null;
            Debug.exit("JNDIHandler.isResourceLinkAlreadyBound( " + string + " ) returning " + bl22);
            throw throwable;
        }
        bl2 = bl;
        Debug.exit("JNDIHandler.isResourceLinkAlreadyBound( " + string + " ) returning " + bl2);
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getConnectionFactory(String string) throws ApplicationServerInternalException, NoPermissionException, ResourceException {
        Object object;
        Debug.enter(this, "getConnectionFactory( keyName = " + string + " ) ");
        Object object2 = null;
        try {
            RAOutboundManager rAOutboundManager = (RAOutboundManager)keyNameToOutboundManagerMap.get(string);
            Debug.println(this, ".getConnectionFactory(): Got the outbound manager associated with the Key name : " + string + " : " + rAOutboundManager);
            if (rAOutboundManager != null) {
                Debug.println("Get the connection factory from the outbound manager");
                object2 = rAOutboundManager.getConnectionFactory(string);
            }
            object = object2;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Debug.exit(this, "getConnectionFactory( " + string + " ) returning: " + object2);
            throw throwable;
        }
        Debug.exit(this, "getConnectionFactory( " + string + " ) returning: " + object2);
        return object;
    }

    public static String getJndiNameAndVersion(String string, String string2) {
        return string + "|" + string2;
    }
}

