/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.deploy;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import weblogic.connector.common.Debug;
import weblogic.connector.deploy.ClassPathUtil;
import weblogic.connector.deploy.RASource;
import weblogic.connector.deploy.RarArchive;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClassFinderUtils;
import weblogic.utils.classloaders.MultiClassFinder;
import weblogic.utils.classloaders.Source;
import weblogic.utils.enumerations.EmptyEnumerator;
import weblogic.utils.enumerations.IteratorEnumerator;
import weblogic.utils.jars.VirtualJarFile;

public final class RAClassFinder
implements ClassFinder {
    private VirtualJarFile connectorVJar;
    private String[] jarEntries;
    private Hashtable classEntries;
    private Hashtable indexedJars;
    private boolean isClosed = false;
    private String classpath = null;
    private RarArchive rar = null;

    public RAClassFinder(VirtualJarFile virtualJarFile) {
        this.connectorVJar = virtualJarFile;
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.connectorVJar.entries();
        while (iterator.hasNext()) {
            ZipEntry zipEntry = (ZipEntry)iterator.next();
            if (!zipEntry.getName().endsWith(".jar")) continue;
            arrayList.add(zipEntry.getName());
        }
        this.jarEntries = arrayList.toArray(new String[arrayList.size()]);
        this.indexedJars = new Hashtable();
        this.classEntries = new Hashtable();
    }

    public RAClassFinder(RarArchive rarArchive) {
        this(rarArchive.getVirtualJarFile());
        this.rar = rarArchive;
    }

    public Source getSource(String string) {
        if (!this.isClosed) {
            Source source = null;
            for (int i = 0; i < this.jarEntries.length && source == null; ++i) {
                String string2 = this.jarEntries[i];
                source = this.findClassInJar(string, string2);
            }
            return source;
        }
        return null;
    }

    private Source findClassInJar(String string, String string2) {
        RASource rASource = null;
        if (!this.isClosed) {
            ZipEntry zipEntry = this.connectorVJar.getEntry(string2);
            this.indexJar(zipEntry);
            if (this.jarContainsClass(string2, string)) {
                rASource = new RASource(this.connectorVJar, zipEntry, string);
            }
        }
        return rASource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void indexJar(ZipEntry zipEntry) {
        block13: {
            if (!this.jarIndexed(zipEntry.getName())) {
                String string;
                ZipEntry zipEntry2;
                ZipInputStream zipInputStream = null;
                zipInputStream = new ZipInputStream(this.connectorVJar.getInputStream(zipEntry));
                do {
                    if ((zipEntry2 = zipInputStream.getNextEntry()) == null) continue;
                    string = zipEntry.getName() + "#" + zipEntry2.getName();
                    this.classEntries.put(string, string);
                } while (zipEntry2 != null);
                string = zipEntry.getName();
                this.indexedJars.put(string, string);
                Object var6_6 = null;
                try {
                    if (zipInputStream != null) {
                        zipInputStream.close();
                    }
                    break block13;
                }
                catch (IOException iOException) {
                    RAClassFinder.debug("Caught IOException while trying to close " + zipEntry.getName() + ": " + iOException.getMessage());
                }
                break block13;
                {
                    catch (IOException iOException) {
                        RAClassFinder.debug("Caught IOException while trying to find all classes in " + zipEntry.getName() + ": " + iOException.getMessage());
                        Object var6_7 = null;
                        try {
                            if (zipInputStream != null) {
                                zipInputStream.close();
                            }
                            break block13;
                        }
                        catch (IOException iOException2) {
                            RAClassFinder.debug("Caught IOException while trying to close " + zipEntry.getName() + ": " + iOException2.getMessage());
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    try {
                        if (zipInputStream != null) {
                            zipInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        RAClassFinder.debug("Caught IOException while trying to close " + zipEntry.getName() + ": " + iOException.getMessage());
                    }
                    throw throwable;
                }
            }
        }
    }

    private boolean jarIndexed(String string) {
        return this.indexedJars.get(string) != null;
    }

    private boolean jarContainsClass(String string, String string2) {
        return this.classEntries.get(string + "#" + string2) != null;
    }

    public Enumeration getSources(String string) {
        ArrayList<Source> arrayList = new ArrayList<Source>();
        if (!this.isClosed) {
            for (int i = 0; i < this.jarEntries.length; ++i) {
                String string2 = this.jarEntries[i];
                Source source = this.findClassInJar(string, string2);
                if (source == null) continue;
                arrayList.add(source);
            }
        }
        return new IteratorEnumerator(arrayList.iterator());
    }

    public Source getClassSource(String string) {
        if (!this.isClosed) {
            string = string.replace('.', '/') + ".class";
            return this.getSource(string);
        }
        return null;
    }

    public String getClassPath() {
        if (!this.isClosed) {
            if (this.rar != null) {
                return this.rar.getClassPath();
            }
            if (this.connectorVJar.isDirectory()) {
                return this.computeClassPathForExplodedRar();
            }
            return this.connectorVJar.getName();
        }
        return "";
    }

    private String computeClassPathForExplodedRar() {
        if (this.classpath == null) {
            this.classpath = ClassPathUtil.computeClasspath(this.connectorVJar.getName(), this.jarEntries);
        }
        return this.classpath;
    }

    public void close() {
        this.connectorVJar = null;
        this.jarEntries = null;
        this.isClosed = true;
    }

    public ClassFinder getManifestFinder() {
        MultiClassFinder multiClassFinder = new MultiClassFinder();
        if (!this.isClosed) {
            HashSet hashSet = new HashSet();
            try {
                ClassFinder classFinder;
                if (this.connectorVJar.isDirectory()) {
                    File file = new File(this.connectorVJar.getDirectory().toString());
                    classFinder = ClassFinderUtils.getManifestFinder((File)file, hashSet);
                } else {
                    classFinder = ClassFinderUtils.getManifestFinder((ZipFile)this.connectorVJar.getJarFile(), hashSet);
                }
                if (classFinder != null) {
                    multiClassFinder.addFinder(classFinder);
                }
            }
            catch (IOException iOException) {
                RAClassFinder.debug("Caught IOException while trying to get the manifest finders :" + iOException.getMessage());
            }
        }
        return multiClassFinder;
    }

    public Enumeration entries() {
        return EmptyEnumerator.EMPTY;
    }

    private static void debug(String string) {
        if (Debug.isClassLoadingEnabled()) {
            Debug.classloading(string);
        }
    }
}

