/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.deploy;

import java.security.AccessController;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import weblogic.connector.common.Debug;
import weblogic.connector.external.OutboundInfo;
import weblogic.connector.outbound.ConnectionPool;
import weblogic.connector.outbound.RAOutboundManager;
import weblogic.management.DeploymentException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.PlatformConstants;

public final class RAOutboundDeployer {
    private static final String CLASS_NAME = "weblogic.connector.deploy.RAOutboundDeployer";

    public static ConnectionPool prepare(ManagedConnectionFactory managedConnectionFactory, OutboundInfo outboundInfo, String string, String string2, RAOutboundManager rAOutboundManager) throws DeploymentException {
        Debug.enter(CLASS_NAME, "prepare(...) ");
        String string3 = outboundInfo.getKey();
        String string4 = outboundInfo.getRAInfo().getModuleName();
        ConnectionPool connectionPool = null;
        RAOutboundDeployer.checkValidTestParameters(managedConnectionFactory, outboundInfo);
        try {
            try {
                Debug.pooling("Constructing the connection pool for module '" + string4 + "' with key:  '" + string3 + "'");
                connectionPool = new ConnectionPool(managedConnectionFactory, outboundInfo, string, string2, rAOutboundManager);
                Debug.pooling("Starting the connection pool for module '" + string4 + "' with key:  '" + string3 + "'");
                connectionPool.start(RAOutboundDeployer.getPoolProperties(outboundInfo, connectionPool.getName()));
            }
            catch (weblogic.common.ResourceException resourceException) {
                Debug.pooling("While preparing the connection pool for module '" + string4 + "' with key:  '" + string3 + "' an exception was thrown.");
                String string5 = Debug.getExceptionStartPoolFailed(resourceException.toString());
                throw new DeploymentException(string5, (Throwable)((Object)resourceException));
            }
            Object var11_8 = null;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            Debug.pooling("Done preparing the connection pool for module '" + string4 + "' with key:  '" + string3 + "'.");
            Debug.exit(CLASS_NAME, "prepare(...) ");
            throw throwable;
        }
        Debug.pooling("Done preparing the connection pool for module '" + string4 + "' with key:  '" + string3 + "'.");
        Debug.exit(CLASS_NAME, "prepare(...) ");
        return connectionPool;
    }

    private static void checkValidTestParameters(ManagedConnectionFactory managedConnectionFactory, OutboundInfo outboundInfo) throws DeploymentException {
        if (!(managedConnectionFactory instanceof ValidatingManagedConnectionFactory)) {
            String string;
            Vector<String> vector = new Vector<String>();
            if (outboundInfo.getTestFrequencySeconds() != 0) {
                string = Debug.getExceptionTestFrequencyNonZero();
                vector.add(string);
            }
            if (outboundInfo.isTestConnectionsOnCreate()) {
                string = Debug.getTestConnectionsOnCreateTrue();
                vector.add(string);
            }
            if (outboundInfo.isTestConnectionsOnRelease()) {
                string = Debug.getTestConnectionsOnReleaseTrue();
                vector.add(string);
            }
            if (outboundInfo.isTestConnectionsOnReserve()) {
                string = Debug.getTestConnectionsOnReserveTrue();
                vector.add(string);
            }
            if (vector.size() > 0) {
                string = Debug.getExceptionInvalidTestingConfig();
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    string = string + (String)iterator.next();
                    if (!iterator.hasNext()) continue;
                    string = string + PlatformConstants.EOL + "  ";
                }
                throw new DeploymentException(string);
            }
        }
    }

    public static void updateInitialCapacity(ConnectionPool connectionPool, OutboundInfo outboundInfo) {
        try {
            connectionPool.setInitialCapacity(outboundInfo.getInitialCapacity());
        }
        catch (weblogic.common.ResourceException resourceException) {
            Object object = resourceException;
            while (object instanceof weblogic.common.ResourceException && object.getNested() != null) {
                object = object.getNested();
            }
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            while (object instanceof ResourceException && connectionPool.getRAInstanceManager().getAdapterLayer().getLinkedException((ResourceException)((Object)object), authenticatedSubject) != null) {
                object = connectionPool.getRAInstanceManager().getAdapterLayer().getLinkedException((ResourceException)((Object)object), authenticatedSubject);
            }
            String string = connectionPool.getRAInstanceManager().getAdapterLayer().toString(object, authenticatedSubject);
            Debug.logCreateInitialConnectionsError(connectionPool.getName(), string);
            Debug.pooling("Failed to open initial connections for " + connectionPool.getName() + " root cause " + string + " stacktrace:\n" + connectionPool.getRAInstanceManager().getAdapterLayer().throwable2StackTrace((Throwable)object, authenticatedSubject));
        }
    }

    public static Properties getPoolProperties(OutboundInfo outboundInfo, String string) {
        Properties properties = new Properties();
        properties.setProperty("name", string);
        properties.setProperty("maxCapacity", String.valueOf(outboundInfo.getMaxCapacity()));
        properties.setProperty("capacityIncrement", String.valueOf(outboundInfo.getCapacityIncrement()));
        properties.setProperty("testOnReserve", String.valueOf(outboundInfo.isTestConnectionsOnReserve()));
        properties.setProperty("testOnRelease", String.valueOf(outboundInfo.isTestConnectionsOnRelease()));
        properties.setProperty("testOnCreate", String.valueOf(outboundInfo.isTestConnectionsOnCreate()));
        properties.setProperty("testFrequencySeconds", String.valueOf(outboundInfo.getTestFrequencySeconds()));
        properties.setProperty("shrinkEnabled", String.valueOf(outboundInfo.isShrinkingEnabled()));
        properties.setProperty("resvTimeoutSeconds", String.valueOf(outboundInfo.getConnectionReserveTimeoutSeconds()));
        properties.setProperty("shrinkFrequencySeconds", String.valueOf(outboundInfo.getShrinkFrequencySeconds()));
        properties.setProperty("resCreationRetrySeconds", String.valueOf(outboundInfo.getConnectionCreationRetryFrequencySeconds()));
        properties.setProperty("maxWaiters", String.valueOf(outboundInfo.getHighestNumWaiters()));
        properties.setProperty("maxUnavl", String.valueOf(outboundInfo.getHighestNumUnavailable()));
        properties.setProperty("inactiveResTimeoutSeconds", String.valueOf(outboundInfo.getInactiveConnectionTimeoutSeconds()));
        properties.setProperty("harvestFreqSecsonds", String.valueOf(outboundInfo.getProfileHarvestFrequencySeconds()));
        properties.setProperty("ignoreInUseResources", String.valueOf(outboundInfo.isIgnoreInUseConnectionsEnabled()));
        properties.setProperty("matchConnectionsSupported", String.valueOf(outboundInfo.isMatchConnectionsSupported()));
        properties.setProperty("initialCapacity", "0");
        return properties;
    }
}

