/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.deploy;

import java.util.Map;
import weblogic.connector.common.Debug;
import weblogic.connector.common.RAInstanceManager;
import weblogic.connector.deploy.ChangePackage;
import weblogic.connector.deploy.JNDIHandler;
import weblogic.connector.exception.RAException;
import weblogic.connector.external.ConfigPropInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RAPropsChangePackage
implements ChangePackage {
    private RAInstanceManager raIM;
    private Map<String, ConfigPropInfo> changedProperties;
    private String newJNDIName;

    public void setNewJNDIName(String string) {
        this.newJNDIName = string;
    }

    protected RAPropsChangePackage(RAInstanceManager rAInstanceManager, Map<String, ConfigPropInfo> map) {
        this.raIM = rAInstanceManager;
        this.changedProperties = map;
    }

    @Override
    public void rollback() throws RAException {
    }

    @Override
    public void prepare() throws RAException {
        String string;
        if (this.newJNDIName != null && JNDIHandler.verifyJNDIName(string = JNDIHandler.getJndiNameAndVersion(this.newJNDIName, this.raIM.getVersionId()))) {
            String string2 = Debug.getExceptionJndiNameAlreadyBound(this.newJNDIName);
            throw new RAException(string2);
        }
    }

    @Override
    public void activate() throws RAException {
        if (this.newJNDIName != null) {
            this.raIM.rebindRA(this.newJNDIName);
        }
    }
}

