/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.deploy;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import weblogic.connector.common.Debug;
import weblogic.utils.classloaders.Source;
import weblogic.utils.io.UnsyncByteArrayInputStream;
import weblogic.utils.io.UnsyncByteArrayOutputStream;
import weblogic.utils.jars.VirtualJarFile;

public final class RASource
implements Source {
    private ZipEntry ze = null;
    private String className = null;
    private VirtualJarFile vjar = null;

    public RASource(VirtualJarFile virtualJarFile, ZipEntry zipEntry, String string) {
        this.vjar = virtualJarFile;
        this.ze = zipEntry;
        this.className = string;
    }

    public byte[] getBytes() throws IOException {
        return RASource.getClassBytes(this.vjar, this.ze, this.className);
    }

    public InputStream getInputStream() throws IOException {
        return this.vjar.getInputStream(this.ze);
    }

    public URL getURL() {
        URL uRL = null;
        try {
            if (this.vjar.isDirectory()) {
                String string = this.vjar.getName().replace(File.separatorChar, '/');
                if (!string.endsWith("/")) {
                    string = string + '/';
                }
                String string2 = string + this.ze.getName() + '!' + '/' + this.className;
                uRL = new URL("zip", "", string2);
            } else {
                String string = this.vjar.getName().replace(File.separatorChar, '/');
                String string3 = "rar://" + string + '!' + this.ze.getName() + '!' + '/' + this.className;
                uRL = new URL(null, string3, new RAStreamHandler(this.vjar, this.ze, this.className));
            }
        }
        catch (MalformedURLException malformedURLException) {
            RASource.debug("Caught MalformedURLException while trying to create a URL in getURL :" + malformedURLException.getMessage());
        }
        catch (Exception exception) {
            RASource.debug("Caught general Exception while trying to create a URL in getURL :" + exception.getMessage());
        }
        return uRL;
    }

    public URL getCodeSourceURL() {
        URL uRL = null;
        try {
            File file = new File(this.vjar.getName());
            uRL = file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            RASource.debug("Caught MalformedURLException while trying to create a URL in getCoseSourceURL : " + malformedURLException.getMessage());
        }
        return uRL;
    }

    public long lastModified() {
        return this.ze.getTime();
    }

    public long length() {
        return this.ze.getSize();
    }

    private static void debug(String string) {
        if (Debug.isClassLoadingEnabled()) {
            Debug.classloading(string);
        }
    }

    /*
     * Loose catch block
     */
    protected static byte[] getClassBytes(VirtualJarFile virtualJarFile, ZipEntry zipEntry, String string) throws IOException {
        byte[] byArray;
        block18: {
            Exception exception2222;
            ZipInputStream zipInputStream;
            UnsyncByteArrayOutputStream unsyncByteArrayOutputStream;
            block17: {
                byArray = new byte[512];
                unsyncByteArrayOutputStream = null;
                zipInputStream = null;
                boolean bl = false;
                boolean bl2 = false;
                zipInputStream = new ZipInputStream(virtualJarFile.getInputStream(zipEntry));
                while (!bl && !bl2) {
                    int n;
                    ZipEntry zipEntry2 = zipInputStream.getNextEntry();
                    if (zipEntry2 == null) {
                        bl2 = true;
                        continue;
                    }
                    if (!zipEntry2.getName().equals(string)) continue;
                    unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                    while ((n = zipInputStream.read(byArray, 0, byArray.length)) != -1) {
                        unsyncByteArrayOutputStream.write(byArray, 0, n);
                    }
                    byArray = unsyncByteArrayOutputStream.toByteArray();
                    bl = true;
                }
                Object var11_12 = null;
                try {
                    unsyncByteArrayOutputStream.close();
                }
                catch (Exception exception2222) {
                    if (!Debug.isClassLoadingEnabled()) break block17;
                    Debug.classloading("Caught Exception while closing outputstream : " + string + " in zip entry: " + zipEntry.getName() + " in vjar: " + virtualJarFile.getName() + " exception: " + exception2222.getMessage());
                }
            }
            try {
                zipInputStream.close();
            }
            catch (Exception exception2222) {
                if (Debug.isClassLoadingEnabled()) {
                    Debug.classloading("Caught Exception while closing zip input stream : " + string + " in zip entry: " + zipEntry.getName() + " in vjar: " + virtualJarFile.getName() + " exception: " + exception2222.getMessage());
                }
                break block18;
            }
            {
                catch (IOException iOException) {
                    if (Debug.isClassLoadingEnabled()) {
                        Debug.classloading("Caught IOException while trying to read the bytes of resource : " + string + " in zip entry: " + zipEntry.getName() + " in vjar: " + virtualJarFile.getName() + " exception: " + iOException.getMessage());
                    }
                    throw iOException;
                }
                catch (Exception exception3) {
                    if (Debug.isClassLoadingEnabled()) {
                        Debug.classloading("Caught unkown Exception while trying to read the bytes of resource : " + string + " in zip entry: " + zipEntry.getName() + " in vjar: " + virtualJarFile.getName() + " exception: " + exception3.getMessage());
                    }
                    throw (IOException)new IOException().initCause(exception3);
                }
            }
            catch (Throwable throwable) {
                block20: {
                    Exception exception42222;
                    block19: {
                        Object var11_13 = null;
                        try {
                            unsyncByteArrayOutputStream.close();
                        }
                        catch (Exception exception42222) {
                            if (!Debug.isClassLoadingEnabled()) break block19;
                            Debug.classloading("Caught Exception while closing outputstream : " + string + " in zip entry: " + zipEntry.getName() + " in vjar: " + virtualJarFile.getName() + " exception: " + exception42222.getMessage());
                        }
                    }
                    try {
                        zipInputStream.close();
                    }
                    catch (Exception exception42222) {
                        if (!Debug.isClassLoadingEnabled()) break block20;
                        Debug.classloading("Caught Exception while closing zip input stream : " + string + " in zip entry: " + zipEntry.getName() + " in vjar: " + virtualJarFile.getName() + " exception: " + exception42222.getMessage());
                    }
                }
                throw throwable;
            }
        }
        return byArray;
    }

    static final class RAStreamHandler
    extends URLStreamHandler {
        private final ZipEntry zipEntry;
        private final VirtualJarFile vjar;
        private final String className;

        public RAStreamHandler(VirtualJarFile virtualJarFile, ZipEntry zipEntry, String string) {
            this.zipEntry = zipEntry;
            this.vjar = virtualJarFile;
            this.className = string;
        }

        protected URLConnection openConnection(URL uRL) {
            RarURLConnection rarURLConnection = new RarURLConnection(uRL, this.vjar, this.zipEntry, this.className);
            return rarURLConnection;
        }

        final class RarURLConnection
        extends URLConnection {
            private final ZipEntry zipEntry;
            private final VirtualJarFile vjar;
            private final String className;

            RarURLConnection(URL uRL, VirtualJarFile virtualJarFile, ZipEntry zipEntry, String string) {
                super(uRL);
                this.zipEntry = zipEntry;
                this.vjar = virtualJarFile;
                this.className = string;
            }

            public void connect() throws IOException {
            }

            public InputStream getInputStream() throws IOException {
                byte[] byArray = RASource.getClassBytes(this.vjar, this.zipEntry, this.className);
                return new UnsyncByteArrayInputStream(byArray);
            }
        }
    }
}

