/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.deploy;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import weblogic.application.io.ClasspathInfo;
import weblogic.application.io.ExplodedJar;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.application.utils.PathUtils;
import weblogic.connector.ConnectorLogger;
import weblogic.connector.common.Debug;
import weblogic.connector.deploy.ClassPathUtil;
import weblogic.utils.FileUtils;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public class RarArchive {
    private String tempPath;
    private String applicationId;
    private String applicationName;
    private VirtualJarFile originalVj;
    private VirtualJarFile tempVj;
    private File rootTempDir;
    private String classpath;
    private volatile boolean initialized = false;
    private ExplodedJar explodedJarFile = null;
    private static ClasspathInfo RARClasspathInfo = new ClasspathInfo(){

        public String[] getClasspathURIs() {
            return new String[0];
        }

        public String[] getJarURIs() {
            return new String[0];
        }
    };

    public RarArchive(String string, String string2, VirtualJarFile virtualJarFile) {
        this.applicationId = string;
        this.applicationName = string2;
        this.originalVj = virtualJarFile;
    }

    public VirtualJarFile getVirtualJarFile() {
        return this.originalVj;
    }

    public void remove() {
        if (this.rootTempDir == null) {
            this.generateTempPath();
        }
        if (this.rootTempDir.exists()) {
            File file = this.rootTempDir.getParentFile();
            if (this.explodedJarFile != null) {
                this.explodedJarFile.remove();
            }
            if (Debug.isDeploymentEnabled()) {
                Debug.deployment("Remove temporary directory" + this.rootTempDir.getAbsolutePath());
            }
            if (file != null && file.list().length == 0) {
                FileUtils.remove((File)file);
            }
        }
    }

    public String getClassPath() {
        this.extractIfNeed();
        this.computerClassPath();
        return this.classpath;
    }

    private void computerClassPath() {
        if (this.classpath == null) {
            String string = this.tempVj.getName();
            if (this.tempVj.isDirectory()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                Iterator iterator = this.tempVj.entries();
                while (iterator.hasNext()) {
                    ZipEntry zipEntry = (ZipEntry)iterator.next();
                    if (!zipEntry.getName().endsWith(".jar")) continue;
                    arrayList.add(zipEntry.getName());
                }
                this.classpath = ClassPathUtil.computeClasspath(string, arrayList);
            } else {
                this.classpath = string;
            }
        }
    }

    private boolean initializeTempDir() {
        if (this.originalVj.isDirectory()) {
            return false;
        }
        this.generateTempPath();
        if (!this.rootTempDir.exists() && !this.rootTempDir.mkdirs()) {
            if (Debug.isDeploymentEnabled()) {
                Debug.deployment(ConnectorLogger.logCannotExtractRARtoTempDir((String)this.originalVj.getName()));
            }
            return false;
        }
        return true;
    }

    private void generateTempPath() {
        String string = ApplicationVersionUtils.replaceDelimiter(this.applicationId, '_');
        String string2 = ApplicationVersionUtils.replaceDelimiter(this.applicationName, '_');
        this.tempPath = PathUtils.generateTempPath(null, string, string2);
        this.rootTempDir = PathUtils.getAppTempDir(this.tempPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractIfNeed() {
        if (this.initialized) {
            return;
        }
        try {
            RarArchive rarArchive = this;
            synchronized (rarArchive) {
                if (!this.initialized) {
                    if (!this.initializeTempDir()) {
                        this.tempVj = this.originalVj;
                    } else {
                        this.explodedJarFile = new ExplodedJar(this.applicationId, this.rootTempDir, new File(this.originalVj.getName()), RARClasspathInfo);
                        this.tempVj = VirtualJarFactory.createVirtualJar((File)this.rootTempDir);
                    }
                    this.initialized = true;
                }
            }
        }
        catch (Exception exception) {
            if (Debug.isDeploymentEnabled()) {
                Debug.deployment(ConnectorLogger.logCannotExtractRARtoTempDir((String)this.originalVj.getName()), exception);
            }
            this.tempVj = this.originalVj;
        }
    }
}

