/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.external;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.resource.spi.ResourceAdapter;
import weblogic.connector.common.RACollectionManager;
import weblogic.connector.common.RAInstanceManager;
import weblogic.connector.external.OutboundInfo;
import weblogic.connector.external.RAInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.SecurityServiceManager;

public class RAUtil {
    public static final String CONNECTOR_LOG = "ConnectorLog";

    public static RAInfo getRAInfo(ResourceAdapter resourceAdapter) {
        RAInstanceManager rAInstanceManager;
        RAInfo rAInfo = null;
        if (resourceAdapter != null && (rAInstanceManager = RACollectionManager.getRAInstanceManager(resourceAdapter)) != null) {
            rAInfo = rAInstanceManager.getRAInfo();
        }
        return rAInfo;
    }

    public static RAInfo getRAInfo(String string) {
        RAInstanceManager rAInstanceManager = null;
        RAInfo rAInfo = null;
        Iterator iterator = RACollectionManager.getRAs();
        block0: while (iterator.hasNext()) {
            rAInstanceManager = (RAInstanceManager)iterator.next();
            if (string.equals(rAInstanceManager.getRAInfo().getJndiName())) {
                rAInfo = rAInstanceManager.getRAInfo();
                break;
            }
            if (rAInstanceManager.getRAInfo().getOutboundInfos().size() <= 0) continue;
            Iterator iterator2 = rAInstanceManager.getRAInfo().getOutboundInfos().iterator();
            OutboundInfo outboundInfo = null;
            while (iterator2.hasNext()) {
                outboundInfo = (OutboundInfo)iterator2.next();
                if (!outboundInfo.getKey().equals(string)) continue;
                rAInfo = rAInstanceManager.getRAInfo();
                continue block0;
            }
        }
        return rAInfo;
    }

    public static Set getAvailableConnectorLogNames() {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = RACollectionManager.getRAs();
        while (iterator.hasNext()) {
            RAInstanceManager rAInstanceManager = (RAInstanceManager)iterator.next();
            RAInfo rAInfo = rAInstanceManager.getRAInfo();
            for (OutboundInfo outboundInfo : rAInfo.getOutboundInfos()) {
                String string = outboundInfo.getLogFilename();
                if (string == null || string.length() <= 0) continue;
                hashSet.add("ConnectorLog/" + outboundInfo.getKey());
            }
        }
        return hashSet;
    }

    public static String getLogFileName(String string) {
        OutboundInfo outboundInfo = RAUtil.getOutboundInfo(string);
        String string2 = outboundInfo != null ? outboundInfo.getLogFilename() : null;
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        return string2;
    }

    public static String getLogFileRotationDir(String string) {
        OutboundInfo outboundInfo = RAUtil.getOutboundInfo(string);
        String string2 = outboundInfo != null ? outboundInfo.getLogFileRotationDir() : null;
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        return string2;
    }

    private static OutboundInfo getOutboundInfo(String string) {
        Iterator iterator = RACollectionManager.getRAs();
        while (iterator.hasNext()) {
            RAInstanceManager rAInstanceManager = (RAInstanceManager)iterator.next();
            RAInfo rAInfo = rAInstanceManager.getRAInfo();
            for (OutboundInfo outboundInfo : rAInfo.getOutboundInfos()) {
                if (!outboundInfo.getKey().equals(string)) continue;
                return outboundInfo;
            }
        }
        return null;
    }

    public static void testLogUtils(AuthenticatedSubject authenticatedSubject) {
        if (!SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)authenticatedSubject)) {
            throw new SecurityException("KernelId is required to call RAUtils.testLogUtils, Subject '" + (authenticatedSubject == null ? "<null>" : authenticatedSubject.toString()) + "' is not the kernel identity");
        }
        System.out.println("^^^^^ TESTLOGUTILS STARTING ^^^^^^^");
        Set set = RAUtil.getAvailableConnectorLogNames();
        int n = CONNECTOR_LOG.length() + 1;
        Iterator iterator = set.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = string.substring(n);
            String string3 = RAUtil.getLogFileName(string2);
            String string4 = RAUtil.getLogFileRotationDir(string2);
            System.out.println("CONNECTOR LOG #" + ++n2);
            System.out.println("================================================");
            System.out.println("  LogicalName:         " + string);
            System.out.println("  KeyName:             " + string2);
            System.out.println("  LogFilename:         " + string3);
            System.out.println("  LogFileRotationDir:  " + string4);
        }
        System.out.println("^^^^^ TESTLOGUTILS COMPLETE ^^^^^^^");
    }
}

