/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.external.impl;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import weblogic.connector.common.Debug;
import weblogic.connector.common.RACollectionManager;
import weblogic.connector.common.RAInstanceManager;
import weblogic.connector.exception.RAInternalException;
import weblogic.connector.extensions.Suspendable;
import weblogic.connector.external.ActivationSpecFindOrCreateException;
import weblogic.connector.external.ActivationSpecInfo;
import weblogic.connector.external.ElementNotFoundException;
import weblogic.connector.external.EndpointActivationException;
import weblogic.connector.external.InboundInfo;
import weblogic.connector.external.MissingPropertiesException;
import weblogic.connector.external.RAInfo;
import weblogic.connector.external.RequiredConfigPropInfo;
import weblogic.connector.external.ResourceAdapterNotActiveException;
import weblogic.connector.external.ResourceAdapterNotFoundException;
import weblogic.connector.inbound.RAInboundManager;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;
import weblogic.management.runtime.MessageDrivenEJBRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.PlatformConstants;

public class EndpointActivationUtils
implements weblogic.connector.external.EndpointActivationUtils {
    private static final String CLASS_NAME = "weblogic.connector.external.impl.EndpointActivationUtils";
    private static final EndpointActivationUtils SINGLETON;
    static final long serialVersionUID = -1427661757008357138L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Endpoint_Deactivate_Low;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_After_Inbound;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Endpoint_Activate_Low;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Before_Inbound;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Around_Inbound;
    public static final JoinPoint _WLDF$INST_JPFLD_0;
    public static final JoinPoint _WLDF$INST_JPFLD_1;

    private EndpointActivationUtils() {
    }

    public static weblogic.connector.external.EndpointActivationUtils getAccessor() {
        return SINGLETON;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void activateEndpoint(String string, String string2, String string3, ActivationSpec activationSpec, MessageEndpointFactory messageEndpointFactory, MessageDrivenEJBRuntimeMBean messageDrivenEJBRuntimeMBean) throws ResourceAdapterNotFoundException, MissingPropertiesException, EndpointActivationException {
        block17: {
            DynamicJoinPoint dynamicJoinPoint;
            Object[] objectArray;
            if (_WLDF$INST_FLD_Connector_Endpoint_Deactivate_Low.isEnabledAndNotDyeFiltered()) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Endpoint_Deactivate_Low.isArgumentsCaptureNeeded()) {
                    objectArray = new Object[]{this, string, string2, string3, activationSpec, messageEndpointFactory, messageDrivenEJBRuntimeMBean};
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Endpoint_Deactivate_Low;
                InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
            if (_WLDF$INST_FLD_Connector_Endpoint_Activate_Low.isEnabledAndNotDyeFiltered()) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Endpoint_Activate_Low.isArgumentsCaptureNeeded()) {
                    objectArray = new Object[]{this, string, string2, string3, activationSpec, messageEndpointFactory, messageDrivenEJBRuntimeMBean};
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Endpoint_Activate_Low;
                InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
            if (_WLDF$INST_FLD_Connector_Before_Inbound.isEnabledAndNotDyeFiltered()) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Before_Inbound.isArgumentsCaptureNeeded()) {
                    objectArray = new Object[]{this, string, string2, string3, activationSpec, messageEndpointFactory, messageDrivenEJBRuntimeMBean};
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Before_Inbound;
                InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
            boolean bl = _WLDF$INST_FLD_Connector_Around_Inbound.isEnabledAndNotDyeFiltered();
            DiagnosticAction[] diagnosticActionArray = null;
            DiagnosticActionState[] diagnosticActionStateArray = null;
            Object var17_12 = null;
            if (bl) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Around_Inbound.isArgumentsCaptureNeeded()) {
                    objectArray = new Object[]{this, string, string2, string3, activationSpec, messageEndpointFactory, messageDrivenEJBRuntimeMBean};
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Around_Inbound;
                diagnosticActionArray = delegatingMonitor.getActions();
                diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
                InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            }
            try {
                ResourceAdapter resourceAdapter = null;
                if (Debug.isRALifecycleEnabled()) {
                    Debug.raLifecycle("weblogic.connector.external.impl.EndpointActivationUtils.activateEndpoint called, ejbName = " + string + ", jndiName = " + string2 + ", messageListenerType = " + string3 + ", .. )");
                }
                EndpointActivationUtils.checkStringArg("activateEndPoint()", "ejbName", string);
                EndpointActivationUtils.checkStringArg("activateEndPoint()", "jndiName", string2);
                EndpointActivationUtils.checkStringArg("activateEndpoint()", "messageListenerType", string3);
                EndpointActivationUtils.checkObjectArg("activateEndpoint()", "activationSpec", activationSpec);
                EndpointActivationUtils.checkObjectArg("activateEndpoint()", "endpointFactory", messageEndpointFactory);
                RAInstanceManager rAInstanceManager = RACollectionManager.getRAInstanceManager(string2);
                if (rAInstanceManager != null) {
                    resourceAdapter = rAInstanceManager.getResourceAdapter();
                    if (resourceAdapter == null) {
                        Debug.throwAssertionError("RA bean bound with JNDI name '" + string2 + "' is null");
                    }
                } else {
                    String string4 = Debug.getExceptionRANotDeployed(string2);
                    throw new ResourceAdapterNotFoundException(string4);
                }
                this.checkRequiredConfigProperties(activationSpec, string2, string3);
                AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                try {
                    RAInboundManager rAInboundManager = rAInstanceManager.getRAInboundManager();
                    String string5 = messageDrivenEJBRuntimeMBean.getApplicationName() + "_" + messageDrivenEJBRuntimeMBean.getEJBName();
                    rAInboundManager.setupForRecovery(activationSpec, string5);
                    rAInstanceManager.getAdapterLayer().endpointActivation(resourceAdapter, messageEndpointFactory, activationSpec, authenticatedSubject);
                    rAInboundManager.addEJB(string3, string);
                    rAInboundManager.addEndpointFactory(string3, messageEndpointFactory, messageDrivenEJBRuntimeMBean);
                }
                catch (Throwable throwable) {
                    String string6 = rAInstanceManager.getAdapterLayer().toString(throwable, authenticatedSubject);
                    throw (EndpointActivationException)((Object)new EndpointActivationException(string6, false).initCause(throwable));
                }
                Object var15_22 = null;
                if (!bl) break block17;
            }
            catch (Throwable throwable) {
                Object var15_23 = null;
                if (bl) {
                    InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Inbound, diagnosticActionArray, diagnosticActionStateArray);
                }
                if (!_WLDF$INST_FLD_Connector_After_Inbound.isEnabledAndNotDyeFiltered()) throw throwable;
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Inbound;
                InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
                throw throwable;
            }
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Inbound, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        if (!_WLDF$INST_FLD_Connector_After_Inbound.isEnabledAndNotDyeFiltered()) return;
        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Inbound;
        InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deActivateEndpoint(String string, String string2, String string3, ActivationSpec activationSpec, MessageEndpointFactory messageEndpointFactory, MessageDrivenEJBRuntimeMBean messageDrivenEJBRuntimeMBean) throws EndpointActivationException {
        block14: {
            DynamicJoinPoint dynamicJoinPoint;
            Object[] objectArray;
            if (_WLDF$INST_FLD_Connector_Before_Inbound.isEnabledAndNotDyeFiltered()) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Before_Inbound.isArgumentsCaptureNeeded()) {
                    objectArray = InstrumentationSupport.toSensitive((int)7);
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Before_Inbound;
                InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
            boolean bl = _WLDF$INST_FLD_Connector_Around_Inbound.isEnabledAndNotDyeFiltered();
            DiagnosticAction[] diagnosticActionArray = null;
            DiagnosticActionState[] diagnosticActionStateArray = null;
            Object var17_12 = null;
            if (bl) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Around_Inbound.isArgumentsCaptureNeeded()) {
                    objectArray = InstrumentationSupport.toSensitive((int)7);
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Around_Inbound;
                diagnosticActionArray = delegatingMonitor.getActions();
                diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
                InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            }
            try {
                ResourceAdapter resourceAdapter = null;
                if (Debug.isRALifecycleEnabled()) {
                    Debug.raLifecycle("weblogic.connector.external.impl.EndpointActivationUtils.deactivateEndpoint called, ejbName = " + string + ", jndiName = " + string2 + ", messageListenerType = " + string3 + ", .. )");
                }
                EndpointActivationUtils.checkStringArg("deActivateEndpoint()", "ejbName", string);
                EndpointActivationUtils.checkStringArg("deActivateEndpoint()", "jndiName", string2);
                EndpointActivationUtils.checkObjectArg("deActivateEndpoint()", "activationSpec", activationSpec);
                EndpointActivationUtils.checkObjectArg("deActivateEndpoint()", "endpointFactory", messageEndpointFactory);
                RAInstanceManager rAInstanceManager = RACollectionManager.getRAInstanceManager(string2);
                if (rAInstanceManager != null) {
                    resourceAdapter = rAInstanceManager.getResourceAdapter();
                    if (resourceAdapter == null) {
                        Debug.throwAssertionError("RA bean bound with JNDI name '" + string2 + "' is null");
                    }
                } else {
                    Debug.throwAssertionError("Attempt to deactivate RA with JNDI name '" + string2 + "' and RA cannot be found");
                }
                AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                try {
                    rAInstanceManager.getAdapterLayer().endpointDeactivation(resourceAdapter, messageEndpointFactory, activationSpec, authenticatedSubject);
                    RAInboundManager rAInboundManager = rAInstanceManager.getRAInboundManager();
                    if (rAInboundManager == null) {
                        Debug.throwAssertionError("Attempt to deactivate endpoint of RA with JNDI name = '" + string2 + "' but no InboundManger can be found for that RA");
                    }
                    rAInboundManager.removeEJB(string3, string);
                    rAInboundManager.removeEndpointFactory(string3, messageEndpointFactory, messageDrivenEJBRuntimeMBean);
                    rAInboundManager.cleanupForRecovery(activationSpec);
                }
                catch (Throwable throwable) {
                    String string4 = rAInstanceManager.getAdapterLayer().toString(throwable, authenticatedSubject);
                    throw (EndpointActivationException)((Object)new EndpointActivationException(string4, false).initCause(throwable));
                }
                Object var15_20 = null;
                if (!bl) break block14;
            }
            catch (Throwable throwable) {
                Object var15_21 = null;
                if (bl) {
                    InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Inbound, diagnosticActionArray, diagnosticActionStateArray);
                }
                if (!_WLDF$INST_FLD_Connector_After_Inbound.isEnabledAndNotDyeFiltered()) throw throwable;
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Inbound;
                InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
                throw throwable;
            }
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Inbound, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        if (!_WLDF$INST_FLD_Connector_After_Inbound.isEnabledAndNotDyeFiltered()) return;
        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Inbound;
        InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
    }

    public void suspendInbound(String string, MessageEndpointFactory messageEndpointFactory, Properties properties) throws EndpointActivationException {
        ResourceAdapter resourceAdapter = null;
        if (Debug.isRALifecycleEnabled()) {
            Debug.raLifecycle("weblogic.connector.external.impl.EndpointActivationUtils.suspendInbound() called, jndiName = " + string + ", endpointFactory = " + messageEndpointFactory);
        }
        EndpointActivationUtils.checkStringArg("deActivateEndpoint()", "jndiName", string);
        EndpointActivationUtils.checkObjectArg("deActivateEndpoint()", "endpointFactory", messageEndpointFactory);
        RAInstanceManager rAInstanceManager = RACollectionManager.getRAInstanceManager(string);
        if (rAInstanceManager != null) {
            resourceAdapter = rAInstanceManager.getResourceAdapter();
            if (resourceAdapter == null) {
                Debug.throwAssertionError("RA bean bound with JNDI name '" + string + "' is null");
            }
        } else {
            Debug.throwAssertionError("Attempt to suspend inbound of RA with JNDI name '" + string + "' and RA cannot be found");
        }
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        try {
            RAInboundManager rAInboundManager;
            if (resourceAdapter instanceof Suspendable && rAInstanceManager.getAdapterLayer().supportsSuspend((Suspendable)resourceAdapter, 1, authenticatedSubject)) {
                rAInstanceManager.getAdapterLayer().suspendInbound((Suspendable)resourceAdapter, messageEndpointFactory, properties, authenticatedSubject);
            }
            if ((rAInboundManager = rAInstanceManager.getRAInboundManager()) == null) {
                Debug.throwAssertionError("Attempt to suspend inbound for endpoint of RA with JNDI name = '" + string + "' but no InboundManger can be found for that RA");
            }
            rAInboundManager.setEndpointFactorySuspendedState(messageEndpointFactory, true);
        }
        catch (Throwable throwable) {
            String string2 = rAInstanceManager.getAdapterLayer().toString(throwable, authenticatedSubject);
            throw (EndpointActivationException)((Object)new EndpointActivationException(string2, false).initCause(throwable));
        }
    }

    public void resumeInbound(String string, MessageEndpointFactory messageEndpointFactory, Properties properties) throws EndpointActivationException {
        ResourceAdapter resourceAdapter = null;
        if (Debug.isRALifecycleEnabled()) {
            Debug.raLifecycle("weblogic.connector.external.impl.EndpointActivationUtils.resumeInbound() called, jndiName = " + string + ", endpointFactory = " + messageEndpointFactory);
        }
        EndpointActivationUtils.checkStringArg("deActivateEndpoint()", "jndiName", string);
        EndpointActivationUtils.checkObjectArg("deActivateEndpoint()", "endpointFactory", messageEndpointFactory);
        RAInstanceManager rAInstanceManager = RACollectionManager.getRAInstanceManager(string);
        if (rAInstanceManager != null) {
            resourceAdapter = rAInstanceManager.getResourceAdapter();
            if (resourceAdapter == null) {
                Debug.throwAssertionError("RA bean bound with JNDI name '" + string + "' is null");
            }
        } else {
            Debug.throwAssertionError("Attempt to resume inbound of RA with JNDI name '" + string + "' and RA cannot be found");
        }
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        try {
            RAInboundManager rAInboundManager;
            if (resourceAdapter instanceof Suspendable) {
                rAInstanceManager.getAdapterLayer().resumeInbound((Suspendable)resourceAdapter, messageEndpointFactory, properties, authenticatedSubject);
            }
            if ((rAInboundManager = rAInstanceManager.getRAInboundManager()) == null) {
                Debug.throwAssertionError("Attempt to resume inbound for endpoint of RA with JNDI name = '" + string + "' but no InboundManger can be found for that RA");
            }
            rAInboundManager.setEndpointFactorySuspendedState(messageEndpointFactory, false);
        }
        catch (Throwable throwable) {
            String string2 = rAInstanceManager.getAdapterLayer().toString(throwable, authenticatedSubject);
            throw (EndpointActivationException)((Object)new EndpointActivationException(string2, false).initCause(throwable));
        }
    }

    private static Object initializeActivationSpec(RAInstanceManager rAInstanceManager, String string) throws ActivationSpecFindOrCreateException {
        Debug.println(CLASS_NAME, ".initializeActivationSpec( raIM = " + rAInstanceManager + ", activationSpecClass = " + string);
        Object object = null;
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        try {
            object = EndpointActivationUtils.instantiateActivationSpec(rAInstanceManager, string, rAInstanceManager.getClassloader());
            rAInstanceManager.getAdapterLayer().setResourceAdapter((ResourceAdapterAssociation)object, rAInstanceManager.getResourceAdapter(), authenticatedSubject);
        }
        catch (ActivationSpecFindOrCreateException activationSpecFindOrCreateException) {
            throw activationSpecFindOrCreateException;
        }
        catch (Throwable throwable) {
            String string2 = rAInstanceManager.getAdapterLayer().toString(throwable, authenticatedSubject);
            throw (ActivationSpecFindOrCreateException)((Object)new ActivationSpecFindOrCreateException(string2).initCause(throwable));
        }
        if (object == null) {
            String string3 = Debug.getExceptionInitializeActivationSpecFailed(string);
            throw new ActivationSpecFindOrCreateException(string3);
        }
        return object;
    }

    private static Object instantiateActivationSpec(RAInstanceManager rAInstanceManager, String string, ClassLoader classLoader) throws ActivationSpecFindOrCreateException {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        try {
            Class<?> clazz = Class.forName(string, true, classLoader);
            return rAInstanceManager.getAdapterLayer().newInstance(clazz, authenticatedSubject);
        }
        catch (RAInternalException rAInternalException) {
            String string2 = Debug.getExceptionInstantiateClassFailed(string, rAInternalException.toString());
            throw new ActivationSpecFindOrCreateException(string2, (Throwable)((Object)rAInternalException));
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string3 = Debug.getExceptionInstantiateClassFailed(string, classNotFoundException.toString());
            throw new ActivationSpecFindOrCreateException(string3, classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            String string4 = Debug.getExceptionInstantiateClassFailed(string, instantiationException.toString());
            throw new ActivationSpecFindOrCreateException(string4, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            String string5 = Debug.getExceptionInstantiateClassFailed(string, illegalAccessException.toString());
            throw new ActivationSpecFindOrCreateException(string5, illegalAccessException);
        }
    }

    private static void checkStringArg(String string, String string2, String string3) {
        if (string3 == null || string3.trim().equals("")) {
            String string4 = string + " passed " + string2 + " of '" + string3 + "'";
            Debug.throwAssertionError(string4);
        }
    }

    private static void checkObjectArg(String string, String string2, Object object) {
        if (object == null) {
            String string3 = string + " passed " + string2 + " of 'null'";
            Debug.throwAssertionError(string3);
        }
    }

    public Object getActivationSpec(String string, String string2) throws ActivationSpecFindOrCreateException, ResourceAdapterNotActiveException, ResourceAdapterNotFoundException {
        ActivationSpecInfo activationSpecInfo = null;
        Object object = null;
        Debug.println(CLASS_NAME, ".getActivationSpec( " + string + ", " + string2 + " )");
        EndpointActivationUtils.checkStringArg("getActivationSpec()", "jndiName", string);
        EndpointActivationUtils.checkStringArg("getAcitvationSpec()", "messageListenerType", string2);
        String string3 = null;
        RAInstanceManager rAInstanceManager = RACollectionManager.getRAInstanceManager(string);
        if (rAInstanceManager == null) {
            string3 = Debug.getExceptionRANotDeployed(string);
            throw new ResourceAdapterNotFoundException(string3);
        }
        if (!rAInstanceManager.isActivated()) {
            string3 = Debug.getExceptionRANotActive(string);
            throw new ResourceAdapterNotActiveException(string3);
        }
        RAInfo rAInfo = rAInstanceManager.getRAInfo();
        activationSpecInfo = EndpointActivationUtils.getActivationSpecInfo(rAInfo, string2, string);
        object = EndpointActivationUtils.initializeActivationSpec(rAInstanceManager, activationSpecInfo.getActivationSpecClass());
        return object;
    }

    public List getRequiredConfigProperties(String string, String string2) throws ResourceAdapterNotFoundException, ActivationSpecFindOrCreateException {
        EndpointActivationUtils.checkStringArg("getRequiredConfigProperties()", "jndiName", string);
        EndpointActivationUtils.checkStringArg("getRequiredConfigProperties()", "messageListenerType", string2);
        RAInstanceManager rAInstanceManager = RACollectionManager.getRAInstanceManager(string);
        if (rAInstanceManager == null) {
            String string3 = Debug.getExceptionRANotFound(string);
            throw new ResourceAdapterNotFoundException(string3);
        }
        RAInfo rAInfo = rAInstanceManager.getRAInfo();
        ActivationSpecInfo activationSpecInfo = EndpointActivationUtils.getActivationSpecInfo(rAInfo, string2, string);
        return activationSpecInfo.getRequiredProps();
    }

    private static ActivationSpecInfo getActivationSpecInfo(RAInfo rAInfo, String string, String string2) throws ActivationSpecFindOrCreateException {
        Iterator iterator = null;
        ActivationSpecInfo activationSpecInfo = null;
        boolean bl = false;
        try {
            iterator = rAInfo.getInboundInfos().iterator();
        }
        catch (ElementNotFoundException elementNotFoundException) {
            throw new ActivationSpecFindOrCreateException(elementNotFoundException.toString());
        }
        while (iterator.hasNext() && !bl) {
            InboundInfo inboundInfo = (InboundInfo)iterator.next();
            if (Debug.getVerbose()) {
                Debug.println(CLASS_NAME, ".getActivationSpecInfo( " + string + " ) found " + inboundInfo.getMsgType());
            }
            if (!inboundInfo.getMsgType().equals(string)) continue;
            activationSpecInfo = inboundInfo.getActivationSpec();
            bl = true;
        }
        if (activationSpecInfo == null) {
            String string3 = Debug.getExceptionNoMessageListener(string2, string);
            throw new ActivationSpecFindOrCreateException(string3);
        }
        return activationSpecInfo;
    }

    private void checkRequiredConfigProperties(ActivationSpec activationSpec, String string, String string2) throws MissingPropertiesException, ResourceAdapterNotFoundException, ActivationSpecFindOrCreateException {
        Object object;
        Vector<String> vector = new Vector<String>();
        List list = this.getRequiredConfigProperties(string, string2);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            object = (RequiredConfigPropInfo)iterator.next();
            String string3 = object.getName();
            Method[] methodArray = activationSpec.getClass().getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                if (!methodArray[i].getName().equalsIgnoreCase("get" + string3)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            if (Debug.getVerbose()) {
                Debug.println(CLASS_NAME, ".checkRequiredConfigProperties():  missing property found, '" + string3 + "'");
            }
            vector.add(string3);
        }
        Debug.println(CLASS_NAME, ".checkRequiredConfigProperties found " + vector.size() + " missing properties in the activation spec");
        if (vector.size() > 0) {
            Object[] objectArray = vector.toArray();
            object = "";
            for (int i = 0; i < objectArray.length; ++i) {
                if (i > 0) {
                    object = (String)object + PlatformConstants.EOL + "  ";
                }
                object = (String)object + (String)objectArray[i];
            }
            Debug.println(CLASS_NAME, ".activateEndpoint call missing required properties in the passed activation spec, " + (String)object);
            String string4 = Debug.getExceptionMissingRequiredProperty((String)object);
            throw new MissingPropertiesException(string4);
        }
    }

    static {
        _WLDF$INST_FLD_class = Class.forName(CLASS_NAME);
        _WLDF$INST_FLD_Connector_Endpoint_Deactivate_Low = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Endpoint_Deactivate_Low");
        _WLDF$INST_FLD_Connector_After_Inbound = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_After_Inbound");
        _WLDF$INST_FLD_Connector_Endpoint_Activate_Low = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Endpoint_Activate_Low");
        _WLDF$INST_FLD_Connector_Before_Inbound = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Before_Inbound");
        _WLDF$INST_FLD_Connector_Around_Inbound = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Around_Inbound");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"EndpointActivationUtils.java", (String)CLASS_NAME, (String)"activateEndpoint", (String)"(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljavax/resource/spi/ActivationSpec;Ljavax/resource/spi/endpoint/MessageEndpointFactory;Lweblogic/management/runtime/MessageDrivenEJBRuntimeMBean;)V", (int)87, (Map)InstrumentationSupport.makeMap((String[])new String[]{"Connector_Around_Inbound", "Connector_Endpoint_Deactivate_Low", "Connector_Before_Inbound", "Connector_After_Inbound", "Connector_Endpoint_Activate_Low"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{null, InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"ejb", null, (boolean)false, (boolean)true), InstrumentationSupport.createValueHandlingInfo((String)"jndi", null, (boolean)false, (boolean)true), InstrumentationSupport.createValueHandlingInfo((String)"listener", null, (boolean)false, (boolean)true), null, null, null}), null, null, InstrumentationSupport.createPointcutHandlingInfo(null, null, (ValueHandlingInfo[])new ValueHandlingInfo[]{InstrumentationSupport.createValueHandlingInfo((String)"ejb", null, (boolean)false, (boolean)true), InstrumentationSupport.createValueHandlingInfo((String)"jndi", null, (boolean)false, (boolean)true), InstrumentationSupport.createValueHandlingInfo((String)"listener", null, (boolean)false, (boolean)true), null, null, null})}), (boolean)false);
        _WLDF$INST_JPFLD_1 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"EndpointActivationUtils.java", (String)CLASS_NAME, (String)"deActivateEndpoint", (String)"(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljavax/resource/spi/ActivationSpec;Ljavax/resource/spi/endpoint/MessageEndpointFactory;Lweblogic/management/runtime/MessageDrivenEJBRuntimeMBean;)V", (int)169, null, (boolean)false);
        SINGLETON = new EndpointActivationUtils();
    }
}

