/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.external.impl;

import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import weblogic.connector.common.Debug;
import weblogic.connector.external.OutboundInfo;
import weblogic.connector.external.RAInfo;
import weblogic.connector.external.impl.AuthMechInfoImpl;
import weblogic.connector.external.impl.ConfigPropInfoImpl;
import weblogic.connector.external.impl.DDLayerUtils;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.AuthenticationMechanismBean;
import weblogic.j2ee.descriptor.ConfigPropertyBean;
import weblogic.j2ee.descriptor.ConnectionDefinitionBean;
import weblogic.j2ee.descriptor.ConnectorBean;
import weblogic.j2ee.descriptor.OutboundResourceAdapterBean;
import weblogic.j2ee.descriptor.ResourceAdapterBean;
import weblogic.j2ee.descriptor.wl.ConnectionDefinitionPropertiesBean;
import weblogic.j2ee.descriptor.wl.ConnectionInstanceBean;
import weblogic.j2ee.descriptor.wl.LoggingBean;
import weblogic.j2ee.descriptor.wl.WeblogicConnectorBean;
import weblogic.j2ee.descriptor.wl.WeblogicConnectorExtensionBean;

public class OutboundInfoImpl
implements OutboundInfo {
    private RAInfo raInfo = null;
    private ConnectorBean connBean = null;
    private WeblogicConnectorBean wlConnBean = null;
    private ConnectionDefinitionBean connDefn = null;
    private weblogic.j2ee.descriptor.wl.ConnectionDefinitionBean wlConnDefnGroup = null;
    private OutboundInfo baseOutboundInfo = null;
    private ConnectionDefinitionPropertiesBean defOutRADefnProps = null;
    private ConnectionDefinitionPropertiesBean defGroupDefnProps = null;
    private ConnectionInstanceBean wlConnInstance = null;
    private ConnectionDefinitionPropertiesBean connInstanceDefnProps = null;
    private ResourceAdapterBean raBean = null;
    private OutboundResourceAdapterBean outboundRABean = null;
    String jndiName;
    List authenticationMechanisms;

    public OutboundInfoImpl(RAInfo rAInfo, ConnectorBean connectorBean, WeblogicConnectorBean weblogicConnectorBean, ConnectionDefinitionBean connectionDefinitionBean, weblogic.j2ee.descriptor.wl.ConnectionDefinitionBean connectionDefinitionBean2, ConnectionInstanceBean connectionInstanceBean) {
        this.raInfo = rAInfo;
        this.connBean = connectorBean;
        this.wlConnBean = weblogicConnectorBean;
        this.connDefn = connectionDefinitionBean;
        this.wlConnDefnGroup = connectionDefinitionBean2;
        this.wlConnInstance = connectionInstanceBean;
        if (weblogicConnectorBean.getOutboundResourceAdapter() == null) {
            Debug.throwAssertionError("wlConnBean.getOutboundResourceAdapter() == null");
        }
        this.initProperties();
        this.getJndiName();
        this.getAuthenticationMechanisms();
    }

    private void initProperties() {
        if (this.wlConnBean.getOutboundResourceAdapter().getDefaultConnectionProperties() == null) {
            this.wlConnBean.getOutboundResourceAdapter().createDefaultConnectionProperties();
        }
        if (this.wlConnDefnGroup.getDefaultConnectionProperties() == null) {
            this.wlConnDefnGroup.createDefaultConnectionProperties();
        }
        if (this.wlConnInstance.getConnectionProperties() == null) {
            this.wlConnInstance.createConnectionProperties();
        }
        this.defOutRADefnProps = this.wlConnBean.getOutboundResourceAdapter().getDefaultConnectionProperties();
        this.defGroupDefnProps = this.wlConnDefnGroup.getDefaultConnectionProperties();
        this.connInstanceDefnProps = this.wlConnInstance.getConnectionProperties();
        if (this.defOutRADefnProps.getPoolParams() == null) {
            this.defOutRADefnProps.createPoolParams();
        }
        if (this.defOutRADefnProps.getLogging() == null) {
            this.defOutRADefnProps.createLogging();
        }
        if (this.defGroupDefnProps.getPoolParams() == null) {
            this.defGroupDefnProps.createPoolParams();
        }
        if (this.defGroupDefnProps.getLogging() == null) {
            this.defGroupDefnProps.createLogging();
        }
        if (this.connInstanceDefnProps.getPoolParams() == null) {
            this.connInstanceDefnProps.createPoolParams();
        }
        if (this.connInstanceDefnProps.getLogging() == null) {
            this.connInstanceDefnProps.createLogging();
        }
    }

    private List convertAuthMechArrayToVector(AuthenticationMechanismBean[] authenticationMechanismBeanArray) {
        Vector<AuthMechInfoImpl> vector = new Vector<AuthMechInfoImpl>();
        if (authenticationMechanismBeanArray != null) {
            for (int i = 0; i < authenticationMechanismBeanArray.length; ++i) {
                AuthMechInfoImpl authMechInfoImpl = new AuthMechInfoImpl(authenticationMechanismBeanArray[i]);
                vector.add(authMechInfoImpl);
            }
        }
        return vector;
    }

    public void setBaseOutboundInfo(OutboundInfo outboundInfo) {
        this.baseOutboundInfo = outboundInfo;
    }

    public String getRADescription() {
        if ((this.raInfo.getRADescription() == null || this.raInfo.getRADescription().length() == 0) && this.baseOutboundInfo != null) {
            return this.baseOutboundInfo.getRADescription();
        }
        return this.raInfo.getRADescription();
    }

    public String getDisplayName() {
        if ((this.raInfo.getDisplayName() == null || this.raInfo.getDisplayName().length() == 0) && this.baseOutboundInfo != null) {
            return this.baseOutboundInfo.getDisplayName();
        }
        return this.raInfo.getDisplayName();
    }

    public String getVendorName() {
        if ((this.raInfo.getVendorName() == null || this.raInfo.getVendorName().length() == 0) && this.baseOutboundInfo != null) {
            return this.baseOutboundInfo.getVendorName();
        }
        return this.raInfo.getVendorName();
    }

    public String getEisType() {
        if ((this.raInfo.getEisType() == null || this.raInfo.getEisType().length() == 0) && this.baseOutboundInfo != null) {
            return this.baseOutboundInfo.getEisType();
        }
        return this.raInfo.getEisType();
    }

    public String getTransactionSupport() {
        String string = null;
        string = this.connInstanceDefnProps.isSet("TransactionSupport") && this.baseOutboundInfo != null ? this.baseOutboundInfo.getTransactionSupport() : (this.connInstanceDefnProps.isSet("TransactionSupport") ? this.connInstanceDefnProps.getTransactionSupport() : (this.defGroupDefnProps.isSet("TransactionSupport") ? this.defGroupDefnProps.getTransactionSupport() : (this.defOutRADefnProps.isSet("TransactionSupport") ? this.defOutRADefnProps.getTransactionSupport() : this.getOutboundRABean().getTransactionSupport())));
        return string;
    }

    public List getAuthenticationMechanisms() {
        if (this.authenticationMechanisms != null) {
            return this.authenticationMechanisms;
        }
        if ((this.connInstanceDefnProps.getAuthenticationMechanisms() == null || this.connInstanceDefnProps.getAuthenticationMechanisms().length == 0) && this.baseOutboundInfo != null) {
            return this.baseOutboundInfo.getAuthenticationMechanisms();
        }
        AuthenticationMechanismBean[] authenticationMechanismBeanArray = this.getOutboundRABean().getAuthenticationMechanisms();
        if (this.defOutRADefnProps.getAuthenticationMechanisms() != null && this.defOutRADefnProps.getAuthenticationMechanisms().length > 0) {
            authenticationMechanismBeanArray = this.defOutRADefnProps.getAuthenticationMechanisms();
        }
        if (this.defGroupDefnProps.getAuthenticationMechanisms() != null && this.defGroupDefnProps.getAuthenticationMechanisms().length > 0) {
            authenticationMechanismBeanArray = this.defGroupDefnProps.getAuthenticationMechanisms();
        }
        if (this.connInstanceDefnProps.getAuthenticationMechanisms() != null && this.connInstanceDefnProps.getAuthenticationMechanisms().length > 0) {
            authenticationMechanismBeanArray = this.connInstanceDefnProps.getAuthenticationMechanisms();
        }
        this.authenticationMechanisms = authenticationMechanismBeanArray == null ? null : this.convertAuthMechArrayToVector(authenticationMechanismBeanArray);
        return this.authenticationMechanisms;
    }

    public boolean getReauthenticationSupport() {
        if (!((DescriptorBean)this.connInstanceDefnProps).isSet("ReauthenticationSupport") && this.baseOutboundInfo != null) {
            return this.baseOutboundInfo.getReauthenticationSupport();
        }
        boolean bl = this.getOutboundRABean().isReauthenticationSupport();
        if (((DescriptorBean)this.defOutRADefnProps).isSet("ReauthenticationSupport")) {
            bl = this.defOutRADefnProps.isReauthenticationSupport();
        }
        if (((DescriptorBean)this.defGroupDefnProps).isSet("ReauthenticationSupport")) {
            bl = this.defGroupDefnProps.isReauthenticationSupport();
        }
        if (((DescriptorBean)this.connInstanceDefnProps).isSet("ReauthenticationSupport")) {
            bl = this.connInstanceDefnProps.isReauthenticationSupport();
        }
        return bl;
    }

    public String getResAuth() {
        if (!((DescriptorBean)this.connInstanceDefnProps).isSet("ResAuth") && this.baseOutboundInfo != null) {
            return this.baseOutboundInfo.getResAuth();
        }
        String string = this.defOutRADefnProps.getResAuth();
        if (((DescriptorBean)this.defGroupDefnProps).isSet("ResAuth")) {
            string = this.defGroupDefnProps.getResAuth();
        }
        if (((DescriptorBean)this.connInstanceDefnProps).isSet("ResAuth")) {
            string = this.connInstanceDefnProps.getResAuth();
        }
        return string;
    }

    public String getMCFClass() {
        if ((this.connDefn.getManagedConnectionFactoryClass() == null || this.connDefn.getManagedConnectionFactoryClass().length() == 0) && this.baseOutboundInfo != null) {
            return this.baseOutboundInfo.getMCFClass();
        }
        return this.connDefn.getManagedConnectionFactoryClass();
    }

    public Hashtable getMCFProps() {
        if (this.connInstanceDefnProps.getProperties() == null && this.baseOutboundInfo != null) {
            return this.baseOutboundInfo.getMCFProps();
        }
        Hashtable<String, ConfigPropInfoImpl> hashtable = new Hashtable<String, ConfigPropInfoImpl>();
        ConfigPropertyBean[] configPropertyBeanArray = this.connDefn.getConfigProperties();
        for (int i = 0; configPropertyBeanArray != null && i < configPropertyBeanArray.length; ++i) {
            ConfigPropInfoImpl configPropInfoImpl = new ConfigPropInfoImpl(configPropertyBeanArray[i], configPropertyBeanArray[i].getConfigPropertyValue());
            configPropInfoImpl = DDLayerUtils.getConfigPropInfoWithOverrides(configPropInfoImpl, this.wlConnBean.getProperties());
            if (this.defOutRADefnProps != null) {
                configPropInfoImpl = DDLayerUtils.getConfigPropInfoWithOverrides(configPropInfoImpl, this.defOutRADefnProps.getProperties());
            }
            if (this.defGroupDefnProps != null) {
                configPropInfoImpl = DDLayerUtils.getConfigPropInfoWithOverrides(configPropInfoImpl, this.defGroupDefnProps.getProperties());
            }
            if (this.connInstanceDefnProps.getProperties() != null) {
                configPropInfoImpl = DDLayerUtils.getConfigPropInfoWithOverrides(configPropInfoImpl, this.connInstanceDefnProps.getProperties());
            }
            if (configPropInfoImpl.getName() == null) continue;
            hashtable.put(configPropInfoImpl.getName(), configPropInfoImpl);
        }
        return hashtable;
    }

    public String getCFInterface() {
        if ((this.connDefn.getConnectionFactoryInterface() == null || this.connDefn.getConnectionFactoryInterface().length() == 0) && this.baseOutboundInfo != null) {
            return this.baseOutboundInfo.getCFInterface();
        }
        return this.connDefn.getConnectionFactoryInterface();
    }

    public String getCFImpl() {
        if ((this.connDefn.getConnectionFactoryImplClass() == null || this.connDefn.getConnectionFactoryImplClass().length() == 0) && this.baseOutboundInfo != null) {
            return this.baseOutboundInfo.getCFImpl();
        }
        return this.connDefn.getConnectionFactoryImplClass();
    }

    public String getConnectionInterface() {
        if ((this.connDefn.getConnectionInterface() == null || this.connDefn.getConnectionInterface().length() == 0) && this.baseOutboundInfo != null) {
            return this.baseOutboundInfo.getConnectionInterface();
        }
        return this.connDefn.getConnectionInterface();
    }

    public String getConnectionImpl() {
        if ((this.connDefn.getConnectionImplClass() == null || this.connDefn.getConnectionImplClass().length() == 0) && this.baseOutboundInfo != null) {
            return this.baseOutboundInfo.getConnectionImpl();
        }
        return this.connDefn.getConnectionImplClass();
    }

    public String getConnectionFactoryName() {
        String string = null;
        if (this.isPreDiabloRA() && ((WeblogicConnectorExtensionBean)this.wlConnBean).getLinkRef() != null) {
            string = ((WeblogicConnectorExtensionBean)this.wlConnBean).getLinkRef().getConnectionFactoryName();
        }
        return string;
    }

    public String getJndiName() {
        if (this.jndiName != null) {
            return this.jndiName;
        }
        if (this.wlConnInstance != null) {
            this.jndiName = this.wlConnInstance.getJNDIName();
        }
        return this.jndiName;
    }

    public String getResourceLink() {
        return this.wlConnInstance.getResourceLink();
    }

    public int getInitialCapacity() {
        if (this.isLinkRefOverridingPoolParams()) {
            return this.baseOutboundInfo.getInitialCapacity();
        }
        int n = this.defOutRADefnProps.getPoolParams().getInitialCapacity();
        if (((DescriptorBean)this.defGroupDefnProps.getPoolParams()).isSet("InitialCapacity")) {
            n = this.defGroupDefnProps.getPoolParams().getInitialCapacity();
        }
        if (((DescriptorBean)this.connInstanceDefnProps.getPoolParams()).isSet("InitialCapacity")) {
            n = this.connInstanceDefnProps.getPoolParams().getInitialCapacity();
        }
        return n;
    }

    public int getMaxCapacity() {
        if (this.isLinkRefOverridingPoolParams()) {
            return this.baseOutboundInfo.getMaxCapacity();
        }
        int n = this.defOutRADefnProps.getPoolParams().getMaxCapacity();
        if (((DescriptorBean)this.defGroupDefnProps.getPoolParams()).isSet("MaxCapacity")) {
            n = this.defGroupDefnProps.getPoolParams().getMaxCapacity();
        }
        if (((DescriptorBean)this.connInstanceDefnProps.getPoolParams()).isSet("MaxCapacity")) {
            n = this.connInstanceDefnProps.getPoolParams().getMaxCapacity();
        }
        return n;
    }

    public int getCapacityIncrement() {
        if (this.isLinkRefOverridingPoolParams()) {
            return this.baseOutboundInfo.getCapacityIncrement();
        }
        int n = this.defOutRADefnProps.getPoolParams().getCapacityIncrement();
        if (((DescriptorBean)this.defGroupDefnProps.getPoolParams()).isSet("CapacityIncrement")) {
            n = this.defGroupDefnProps.getPoolParams().getCapacityIncrement();
        }
        if (((DescriptorBean)this.connInstanceDefnProps.getPoolParams()).isSet("CapacityIncrement")) {
            n = this.connInstanceDefnProps.getPoolParams().getCapacityIncrement();
        }
        return n;
    }

    public boolean isShrinkingEnabled() {
        if (this.isLinkRefOverridingPoolParams()) {
            return this.baseOutboundInfo.isShrinkingEnabled();
        }
        boolean bl = this.defOutRADefnProps.getPoolParams().isShrinkingEnabled();
        if (((DescriptorBean)this.defGroupDefnProps.getPoolParams()).isSet("ShrinkingEnabled")) {
            bl = this.defGroupDefnProps.getPoolParams().isShrinkingEnabled();
        }
        if (((DescriptorBean)this.connInstanceDefnProps.getPoolParams()).isSet("ShrinkingEnabled")) {
            bl = this.connInstanceDefnProps.getPoolParams().isShrinkingEnabled();
        }
        return bl;
    }

    public int getShrinkFrequencySeconds() {
        if (this.isLinkRefOverridingPoolParams()) {
            return this.baseOutboundInfo.getShrinkFrequencySeconds();
        }
        int n = this.defOutRADefnProps.getPoolParams().getShrinkFrequencySeconds();
        if (((DescriptorBean)this.defGroupDefnProps.getPoolParams()).isSet("ShrinkFrequencySeconds")) {
            n = this.defGroupDefnProps.getPoolParams().getShrinkFrequencySeconds();
        }
        if (((DescriptorBean)this.connInstanceDefnProps.getPoolParams()).isSet("ShrinkFrequencySeconds")) {
            n = this.connInstanceDefnProps.getPoolParams().getShrinkFrequencySeconds();
        }
        return n;
    }

    public int getInactiveConnectionTimeoutSeconds() {
        int n = 0;
        if (this.isLinkRefOverridingPoolParams()) {
            return this.baseOutboundInfo.getInactiveConnectionTimeoutSeconds();
        }
        if (this.isPreDiabloRA() && ((WeblogicConnectorExtensionBean)this.wlConnBean).getProxy() != null) {
            n = ((WeblogicConnectorExtensionBean)this.wlConnBean).getProxy().getInactiveConnectionTimeoutSeconds();
        }
        return n;
    }

    public boolean getConnectionProfilingEnabled() {
        boolean bl = false;
        if (this.isLinkRefOverridingPoolParams()) {
            return this.baseOutboundInfo.getConnectionProfilingEnabled();
        }
        if (this.isPreDiabloRA() && ((WeblogicConnectorExtensionBean)this.wlConnBean).getProxy() != null) {
            bl = ((WeblogicConnectorExtensionBean)this.wlConnBean).getProxy().isConnectionProfilingEnabled();
        }
        return bl;
    }

    public int getHighestNumWaiters() {
        if (this.isLinkRefOverridingPoolParams()) {
            return this.baseOutboundInfo.getHighestNumWaiters();
        }
        int n = this.defOutRADefnProps.getPoolParams().getHighestNumWaiters();
        if (((DescriptorBean)this.defGroupDefnProps.getPoolParams()).isSet("HighestNumWaiters")) {
            n = this.defGroupDefnProps.getPoolParams().getHighestNumWaiters();
        }
        if (((DescriptorBean)this.connInstanceDefnProps.getPoolParams()).isSet("HighestNumWaiters")) {
            n = this.connInstanceDefnProps.getPoolParams().getHighestNumWaiters();
        }
        return n;
    }

    public int getHighestNumUnavailable() {
        if (this.isLinkRefOverridingPoolParams()) {
            return this.baseOutboundInfo.getHighestNumUnavailable();
        }
        int n = this.defOutRADefnProps.getPoolParams().getHighestNumUnavailable();
        if (((DescriptorBean)this.defGroupDefnProps.getPoolParams()).isSet("HighestNumUnavailable")) {
            n = this.defGroupDefnProps.getPoolParams().getHighestNumUnavailable();
        }
        if (((DescriptorBean)this.connInstanceDefnProps.getPoolParams()).isSet("HighestNumUnavailable")) {
            n = this.connInstanceDefnProps.getPoolParams().getHighestNumUnavailable();
        }
        return n;
    }

    public int getConnectionCreationRetryFrequencySeconds() {
        if (this.isLinkRefOverridingPoolParams()) {
            return this.baseOutboundInfo.getConnectionCreationRetryFrequencySeconds();
        }
        int n = this.defOutRADefnProps.getPoolParams().getConnectionCreationRetryFrequencySeconds();
        if (((DescriptorBean)this.defGroupDefnProps.getPoolParams()).isSet("ConnectionCreationRetryFrequencySeconds")) {
            n = this.defGroupDefnProps.getPoolParams().getConnectionCreationRetryFrequencySeconds();
        }
        if (((DescriptorBean)this.connInstanceDefnProps.getPoolParams()).isSet("ConnectionCreationRetryFrequencySeconds")) {
            n = this.connInstanceDefnProps.getPoolParams().getConnectionCreationRetryFrequencySeconds();
        }
        return n;
    }

    public int getConnectionReserveTimeoutSeconds() {
        if (this.isLinkRefOverridingPoolParams()) {
            return this.baseOutboundInfo.getConnectionReserveTimeoutSeconds();
        }
        int n = this.defOutRADefnProps.getPoolParams().getConnectionReserveTimeoutSeconds();
        if (((DescriptorBean)this.defGroupDefnProps.getPoolParams()).isSet("ConnectionReserveTimeoutSeconds")) {
            n = this.defGroupDefnProps.getPoolParams().getConnectionReserveTimeoutSeconds();
        }
        if (((DescriptorBean)this.connInstanceDefnProps.getPoolParams()).isSet("ConnectionReserveTimeoutSeconds")) {
            n = this.connInstanceDefnProps.getPoolParams().getConnectionReserveTimeoutSeconds();
        }
        return n;
    }

    public int getTestFrequencySeconds() {
        if (this.isLinkRefOverridingPoolParams()) {
            return this.baseOutboundInfo.getTestFrequencySeconds();
        }
        int n = this.defOutRADefnProps.getPoolParams().getTestFrequencySeconds();
        if (((DescriptorBean)this.defGroupDefnProps.getPoolParams()).isSet("TestFrequencySeconds")) {
            n = this.defGroupDefnProps.getPoolParams().getTestFrequencySeconds();
        }
        if (((DescriptorBean)this.connInstanceDefnProps.getPoolParams()).isSet("TestFrequencySeconds")) {
            n = this.connInstanceDefnProps.getPoolParams().getTestFrequencySeconds();
        }
        return n;
    }

    public boolean isTestConnectionsOnCreate() {
        if (this.isLinkRefOverridingPoolParams()) {
            return this.baseOutboundInfo.isTestConnectionsOnCreate();
        }
        boolean bl = this.defOutRADefnProps.getPoolParams().isTestConnectionsOnCreate();
        if (((DescriptorBean)this.defGroupDefnProps.getPoolParams()).isSet("TestConnectionsOnCreate")) {
            bl = this.defGroupDefnProps.getPoolParams().isTestConnectionsOnCreate();
        }
        if (((DescriptorBean)this.connInstanceDefnProps.getPoolParams()).isSet("TestConnectionsOnCreate")) {
            bl = this.connInstanceDefnProps.getPoolParams().isTestConnectionsOnCreate();
        }
        return bl;
    }

    public boolean isTestConnectionsOnRelease() {
        if (this.isLinkRefOverridingPoolParams()) {
            return this.baseOutboundInfo.isTestConnectionsOnRelease();
        }
        boolean bl = this.defOutRADefnProps.getPoolParams().isTestConnectionsOnRelease();
        if (((DescriptorBean)this.defGroupDefnProps.getPoolParams()).isSet("TestConnectionsOnRelease")) {
            bl = this.defGroupDefnProps.getPoolParams().isTestConnectionsOnRelease();
        }
        if (((DescriptorBean)this.connInstanceDefnProps.getPoolParams()).isSet("TestConnectionsOnRelease")) {
            bl = this.connInstanceDefnProps.getPoolParams().isTestConnectionsOnRelease();
        }
        return bl;
    }

    public boolean isTestConnectionsOnReserve() {
        if (this.isLinkRefOverridingPoolParams()) {
            return this.baseOutboundInfo.isTestConnectionsOnReserve();
        }
        boolean bl = this.defOutRADefnProps.getPoolParams().isTestConnectionsOnReserve();
        if (((DescriptorBean)this.defGroupDefnProps.getPoolParams()).isSet("TestConnectionsOnReserve")) {
            bl = this.defGroupDefnProps.getPoolParams().isTestConnectionsOnReserve();
        }
        if (((DescriptorBean)this.connInstanceDefnProps.getPoolParams()).isSet("TestConnectionsOnReserve")) {
            bl = this.connInstanceDefnProps.getPoolParams().isTestConnectionsOnReserve();
        }
        return bl;
    }

    public Boolean getUseConnectionProxies() {
        String string;
        Boolean bl = null;
        if (!this.isPreDiabloRA()) {
            bl = new Boolean(false);
        } else if (this.isLinkRefOverridingPoolParams()) {
            bl = this.baseOutboundInfo.getUseConnectionProxies();
        } else if (((WeblogicConnectorExtensionBean)this.wlConnBean).getProxy() != null && (string = ((WeblogicConnectorExtensionBean)this.wlConnBean).getProxy().getUseConnectionProxies()) != null) {
            bl = new Boolean(string);
        }
        return bl;
    }

    public RAInfo getRAInfo() {
        return this.raInfo;
    }

    public String getRaLinkRef() {
        String string = null;
        if (this.isPreDiabloRA() && ((WeblogicConnectorExtensionBean)this.wlConnBean).getLinkRef() != null) {
            string = ((WeblogicConnectorExtensionBean)this.wlConnBean).getLinkRef().getRaLinkRef();
        }
        return string;
    }

    public LoggingBean getLoggingBean() {
        return this.connInstanceDefnProps.getLogging();
    }

    public boolean isMatchConnectionsSupported() {
        if (this.isLinkRefOverridingPoolParams()) {
            return this.baseOutboundInfo.isMatchConnectionsSupported();
        }
        boolean bl = this.defOutRADefnProps.getPoolParams().isMatchConnectionsSupported();
        if (((DescriptorBean)this.defGroupDefnProps.getPoolParams()).isSet("MatchConnectionsSupported")) {
            bl = this.defGroupDefnProps.getPoolParams().isMatchConnectionsSupported();
        }
        if (((DescriptorBean)this.connInstanceDefnProps.getPoolParams()).isSet("MatchConnectionsSupported")) {
            bl = this.connInstanceDefnProps.getPoolParams().isMatchConnectionsSupported();
        }
        return bl;
    }

    public boolean isUseFirstAvailable() {
        if (this.isLinkRefOverridingPoolParams()) {
            return this.baseOutboundInfo.isUseFirstAvailable();
        }
        boolean bl = this.defOutRADefnProps.getPoolParams().isUseFirstAvailable();
        if (((DescriptorBean)this.defGroupDefnProps.getPoolParams()).isSet("UseFirstAvailable")) {
            bl = this.defGroupDefnProps.getPoolParams().isUseFirstAvailable();
        }
        if (((DescriptorBean)this.connInstanceDefnProps.getPoolParams()).isSet("UseFirstAvailable")) {
            bl = this.connInstanceDefnProps.getPoolParams().isUseFirstAvailable();
        }
        return bl;
    }

    private boolean isLinkRefOverridingPoolParams() {
        if (this.connInstanceDefnProps == null) {
            Debug.throwAssertionError("connInstanceDefnProps == null");
        }
        if (this.connInstanceDefnProps.getPoolParams() == null) {
            Debug.throwAssertionError("connInstanceDefnProps.getPoolParams() == null");
        }
        return this.connInstanceDefnProps.getPoolParams().getMaxCapacity() == 0;
    }

    private boolean isPreDiabloRA() {
        return this.wlConnBean instanceof WeblogicConnectorExtensionBean;
    }

    private ResourceAdapterBean getRABean() {
        Debug.println(this, ".getRABean()");
        if (this.raBean == null) {
            this.raBean = this.connBean.getResourceAdapter();
        }
        Debug.println(this, ".getRABean() returning " + (this.raBean != null ? "non-null" : "null"));
        if (this.raBean != null) {
            Debug.println(this, ".getRABean().getResourceAdapterClass() = " + this.raBean.getResourceAdapterClass());
        }
        return this.raBean;
    }

    private OutboundResourceAdapterBean getOutboundRABean() {
        if (this.outboundRABean == null) {
            this.outboundRABean = this.getRABean().getOutboundResourceAdapter();
        }
        return this.outboundRABean;
    }

    public int getProfileHarvestFrequencySeconds() {
        if (this.isLinkRefOverridingPoolParams()) {
            return this.baseOutboundInfo.getProfileHarvestFrequencySeconds();
        }
        int n = this.defOutRADefnProps.getPoolParams().getProfileHarvestFrequencySeconds();
        if (((DescriptorBean)this.defGroupDefnProps.getPoolParams()).isSet("ProfileHarvestFrequencySeconds")) {
            n = this.defGroupDefnProps.getPoolParams().getProfileHarvestFrequencySeconds();
        }
        if (((DescriptorBean)this.connInstanceDefnProps.getPoolParams()).isSet("ProfileHarvestFrequencySeconds")) {
            n = this.connInstanceDefnProps.getPoolParams().getProfileHarvestFrequencySeconds();
        }
        return n;
    }

    public boolean isIgnoreInUseConnectionsEnabled() {
        if (this.isLinkRefOverridingPoolParams()) {
            return this.baseOutboundInfo.isIgnoreInUseConnectionsEnabled();
        }
        boolean bl = this.defOutRADefnProps.getPoolParams().isIgnoreInUseConnectionsEnabled();
        if (((DescriptorBean)this.defGroupDefnProps.getPoolParams()).isSet("IgnoreInUseConnectionsEnabled")) {
            bl = this.defGroupDefnProps.getPoolParams().isIgnoreInUseConnectionsEnabled();
        }
        if (((DescriptorBean)this.connInstanceDefnProps.getPoolParams()).isSet("IgnoreInUseConnectionsEnabled")) {
            bl = this.connInstanceDefnProps.getPoolParams().isIgnoreInUseConnectionsEnabled();
        }
        return bl;
    }

    public String getKey() {
        String string = null;
        String string2 = this.getJndiName();
        string = string2 == null || string2.length() == 0 ? this.getResourceLink() : string2;
        return string;
    }

    public String getLogFilename() {
        String string = this.defOutRADefnProps.getLogging().getLogFilename();
        if (((DescriptorBean)this.defGroupDefnProps.getLogging()).isSet("LogFilename")) {
            string = this.defGroupDefnProps.getLogging().getLogFilename();
        }
        if (((DescriptorBean)this.connInstanceDefnProps.getLogging()).isSet("LogFilename")) {
            string = this.connInstanceDefnProps.getLogging().getLogFilename();
        }
        return string;
    }

    public boolean isLoggingEnabled() {
        boolean bl = this.defOutRADefnProps.getLogging().isLoggingEnabled();
        if (((DescriptorBean)this.defGroupDefnProps.getLogging()).isSet("LoggingEnabled")) {
            bl = this.defGroupDefnProps.getLogging().isLoggingEnabled();
        }
        if (((DescriptorBean)this.connInstanceDefnProps.getLogging()).isSet("LoggingEnabled")) {
            bl = this.connInstanceDefnProps.getLogging().isLoggingEnabled();
        }
        return bl;
    }

    public String getRotationType() {
        String string = this.defOutRADefnProps.getLogging().getRotationType();
        if (((DescriptorBean)this.defGroupDefnProps.getLogging()).isSet("RotationType")) {
            string = this.defGroupDefnProps.getLogging().getRotationType();
        }
        if (((DescriptorBean)this.connInstanceDefnProps.getLogging()).isSet("RotationType")) {
            string = this.connInstanceDefnProps.getLogging().getRotationType();
        }
        return string;
    }

    public String getRotationTime() {
        String string = this.defOutRADefnProps.getLogging().getRotationTime();
        if (((DescriptorBean)this.defGroupDefnProps.getLogging()).isSet("RotationTime")) {
            string = this.defGroupDefnProps.getLogging().getRotationTime();
        }
        if (((DescriptorBean)this.connInstanceDefnProps.getLogging()).isSet("RotationTime")) {
            string = this.connInstanceDefnProps.getLogging().getRotationTime();
        }
        return string;
    }

    public boolean isNumberOfFilesLimited() {
        boolean bl = this.defOutRADefnProps.getLogging().isNumberOfFilesLimited();
        if (((DescriptorBean)this.defGroupDefnProps.getLogging()).isSet("NumberOfFilesLimited")) {
            bl = this.defGroupDefnProps.getLogging().isNumberOfFilesLimited();
        }
        if (((DescriptorBean)this.connInstanceDefnProps.getLogging()).isSet("NumberOfFilesLimited")) {
            bl = this.connInstanceDefnProps.getLogging().isNumberOfFilesLimited();
        }
        return bl;
    }

    public int getFileCount() {
        int n = this.defOutRADefnProps.getLogging().getFileCount();
        if (((DescriptorBean)this.defGroupDefnProps.getLogging()).isSet("FileCount")) {
            n = this.defGroupDefnProps.getLogging().getFileCount();
        }
        if (((DescriptorBean)this.connInstanceDefnProps.getLogging()).isSet("FileCount")) {
            n = this.connInstanceDefnProps.getLogging().getFileCount();
        }
        return n;
    }

    public int getFileSizeLimit() {
        int n = this.defOutRADefnProps.getLogging().getFileSizeLimit();
        if (((DescriptorBean)this.defGroupDefnProps.getLogging()).isSet("FileSizeLimit")) {
            n = this.defGroupDefnProps.getLogging().getFileSizeLimit();
        }
        if (((DescriptorBean)this.connInstanceDefnProps.getLogging()).isSet("FileSizeLimit")) {
            n = this.connInstanceDefnProps.getLogging().getFileSizeLimit();
        }
        return n;
    }

    public int getFileTimeSpan() {
        int n = this.defOutRADefnProps.getLogging().getFileTimeSpan();
        if (((DescriptorBean)this.defGroupDefnProps.getLogging()).isSet("FileTimeSpan")) {
            n = this.defGroupDefnProps.getLogging().getFileTimeSpan();
        }
        if (((DescriptorBean)this.connInstanceDefnProps.getLogging()).isSet("FileTimeSpan")) {
            n = this.connInstanceDefnProps.getLogging().getFileTimeSpan();
        }
        return n;
    }

    public boolean isRotateLogOnStartup() {
        boolean bl = this.defOutRADefnProps.getLogging().isRotateLogOnStartup();
        if (((DescriptorBean)this.defGroupDefnProps.getLogging()).isSet("RotateLogOnStartup")) {
            bl = this.defGroupDefnProps.getLogging().isRotateLogOnStartup();
        }
        if (((DescriptorBean)this.connInstanceDefnProps.getLogging()).isSet("RotateLogOnStartup")) {
            bl = this.connInstanceDefnProps.getLogging().isRotateLogOnStartup();
        }
        return bl;
    }

    public String getLogFileRotationDir() {
        String string = this.defOutRADefnProps.getLogging().getLogFileRotationDir();
        if (((DescriptorBean)this.defGroupDefnProps.getLogging()).isSet("LogFileRotationDir")) {
            string = this.defGroupDefnProps.getLogging().getLogFileRotationDir();
        }
        if (((DescriptorBean)this.connInstanceDefnProps.getLogging()).isSet("LogFileRotationDir")) {
            string = this.connInstanceDefnProps.getLogging().getLogFileRotationDir();
        }
        return string;
    }

    public String getDescription() {
        return this.wlConnInstance.getDescription();
    }
}

