/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.external.impl;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import weblogic.connector.common.Debug;
import weblogic.connector.common.Utils;
import weblogic.connector.compliance.RAComplianceTextFormatter;
import weblogic.connector.configuration.DDUtil;
import weblogic.connector.deploy.DeployerUtil;
import weblogic.connector.exception.RACommonException;
import weblogic.connector.exception.RAConfigurationException;
import weblogic.connector.exception.WLRAConfigurationException;
import weblogic.connector.external.PropSetterTable;
import weblogic.connector.external.RAComplianceException;
import weblogic.connector.external.RAInfo;
import weblogic.connector.external.RAValidationInfo;
import weblogic.connector.external.impl.RAValidationInfoImpl;
import weblogic.descriptor.DescriptorException;
import weblogic.j2ee.descriptor.AdminObjectBean;
import weblogic.j2ee.descriptor.ConfigPropertyBean;
import weblogic.j2ee.descriptor.ConnectorBean;
import weblogic.j2ee.descriptor.IconBean;
import weblogic.j2ee.descriptor.InboundResourceAdapterBean;
import weblogic.j2ee.descriptor.MessageAdapterBean;
import weblogic.j2ee.descriptor.MessageListenerBean;
import weblogic.j2ee.descriptor.ResourceAdapterBean;
import weblogic.j2ee.descriptor.wl.AdminObjectGroupBean;
import weblogic.j2ee.descriptor.wl.AdminObjectInstanceBean;
import weblogic.j2ee.descriptor.wl.AdminObjectsBean;
import weblogic.j2ee.descriptor.wl.ConfigPropertiesBean;
import weblogic.j2ee.descriptor.wl.ConnectionDefinitionBean;
import weblogic.j2ee.descriptor.wl.ConnectionDefinitionPropertiesBean;
import weblogic.j2ee.descriptor.wl.ConnectionInstanceBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.OutboundResourceAdapterBean;
import weblogic.j2ee.descriptor.wl.WeblogicConnectorBean;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFile;

public final class RAComplianceChecker
implements weblogic.connector.external.RAComplianceChecker {
    private static RAComplianceTextFormatter fmt = new RAComplianceTextFormatter();
    private static Class JAVA_LANG_OBJECT_CLASS = new Object().getClass();
    private static final Class[] PRIMITIVE_CLASSES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    private static final String[] PRIMITIVE_TYPES = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"};
    private static final String[] PRIMITIVE_OBJ_CLASSES = new String[]{"java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double"};
    private static final int NUM_PRIMS = PRIMITIVE_TYPES.length;
    private static final int NUM_OBJ_PRIMS = PRIMITIVE_OBJ_CLASSES.length;
    private List classFinders;
    private Vector raErrors;
    private Vector raWarnings;
    private RAValidationInfo raValidationInfo;
    private GenericClassLoader raClassLoader = null;
    private ConnectorBean raConnectorBean = null;
    private WeblogicConnectorBean wlraConnectorBean = null;
    public static final weblogic.connector.external.RAComplianceChecker factoryHelper = new RAComplianceChecker();
    private Set<Class> introspectedClasses = new HashSet<Class>();
    private boolean clearIntrospectorCacheNeeded = false;

    private RAComplianceChecker() {
        this.classFinders = new Vector(1);
        this.raErrors = new Vector();
        this.raWarnings = new Vector();
        this.raValidationInfo = new RAValidationInfoImpl();
    }

    public weblogic.connector.external.RAComplianceChecker createChecker() {
        return new RAComplianceChecker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(GenericClassLoader genericClassLoader, VirtualJarFile virtualJarFile, File file, File file2, DeploymentPlanBean deploymentPlanBean) throws RAComplianceException {
        boolean bl;
        block5: {
            bl = false;
            try {
                try {
                    String string = DDUtil.getModuleName(virtualJarFile.getName());
                    RAInfo rAInfo = DDUtil.getRAInfo(virtualJarFile, file, string, null, deploymentPlanBean);
                    DeployerUtil.updateClassFinder(genericClassLoader, virtualJarFile, false, this.classFinders);
                    this.setClearIntrospectorCacheNeeded();
                    this.raValidationInfo = this.validate(virtualJarFile.getName(), rAInfo, genericClassLoader);
                    bl = this.raValidationInfo.isCompliant();
                }
                catch (WLRAConfigurationException wLRAConfigurationException) {
                    Debug.logComplianceWLRAConfigurationException(wLRAConfigurationException.getMessage());
                    Object var10_12 = null;
                    this.clearIntrospectorCache();
                    break block5;
                }
                catch (RAConfigurationException rAConfigurationException) {
                    this.handleRAException(rAConfigurationException);
                    Object var10_13 = null;
                    this.clearIntrospectorCache();
                }
                Object var10_11 = null;
                this.clearIntrospectorCache();
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                this.clearIntrospectorCache();
                throw throwable;
            }
        }
        return bl;
    }

    public RAValidationInfo validate(String string, RAInfo rAInfo, GenericClassLoader genericClassLoader) throws RAComplianceException {
        ((RAValidationInfoImpl)this.raValidationInfo).linkRef = rAInfo.getLinkref();
        ((RAValidationInfoImpl)this.raValidationInfo).isLinkRef = this.raValidationInfo.getLinkRef() != null;
        this.raConnectorBean = rAInfo.getConnectorBean();
        this.wlraConnectorBean = rAInfo.getWeblogicConnectorBean();
        this.raClassLoader = genericClassLoader;
        this.validate(string);
        return this.raValidationInfo;
    }

    private void validate(String string) throws RAComplianceException {
        Iterator iterator;
        RAComplianceException rAComplianceException = new RAComplianceException();
        ((RAValidationInfoImpl)this.raValidationInfo).moduleName = string;
        this.validateRADD();
        this.validateWLRADD();
        int n = this.raErrors.size();
        int n2 = this.raWarnings.size();
        if (n == 0 && n2 == 0) {
            Debug.logNoComplianceErrors(string);
        } else {
            Debug.logNumComplianceErrorsAndWarnings(string, n, n2);
        }
        if (n > 0) {
            iterator = this.raErrors.iterator();
            while (iterator.hasNext()) {
                rAComplianceException.addMessage((String)iterator.next());
            }
        }
        if (n2 > 0) {
            iterator = this.raWarnings.iterator();
            RAComplianceException rAComplianceException2 = new RAComplianceException();
            while (iterator.hasNext()) {
                rAComplianceException2.addMessage((String)iterator.next());
            }
            Debug.logComplianceWarnings(string, rAComplianceException2.getMessage());
        }
        if (n > 0) {
            ((RAValidationInfoImpl)this.raValidationInfo).isCompliant = false;
            throw rAComplianceException;
        }
        ((RAValidationInfoImpl)this.raValidationInfo).isCompliant = n == 0;
    }

    private RAValidationInfo validateRADD() {
        if (this.raConnectorBean != null) {
            ((RAValidationInfoImpl)this.raValidationInfo).hasRAxml = !this.raValidationInfo.isLinkRef();
            this.validateIconFiles();
            this.validateResourceAdapter();
        } else if (this.raValidationInfo.isLinkRef()) {
            Debug.logComplianceIsLinkRef(this.raValidationInfo.getLinkRef());
        } else if (!this.raValidationInfo.isLinkRef() && this.raConnectorBean == null) {
            this.raErrors.addElement(fmt.MISSING_RA_XML());
        }
        return this.raValidationInfo;
    }

    private void validateIconFiles() {
        IconBean[] iconBeanArray = this.raConnectorBean.getIcons();
        if (iconBeanArray != null && iconBeanArray.length > 0) {
            for (int i = 0; i < iconBeanArray.length; ++i) {
                boolean bl;
                String string = iconBeanArray[i].getLargeIcon();
                String string2 = iconBeanArray[i].getSmallIcon();
                if (string2 != null) {
                    boolean bl2 = bl = this.raClassLoader.getResource(string2) != null;
                    if (!bl) {
                        this.raWarnings.addElement(fmt.FILE_NOT_FOUND("ra.xml", "<small-icon>", string2));
                    }
                }
                if (string == null) continue;
                boolean bl3 = bl = this.raClassLoader.getResource(string) != null;
                if (bl) continue;
                this.raWarnings.addElement(fmt.FILE_NOT_FOUND("ra.xml", "<large-icon>", string));
            }
        }
    }

    private void validateResourceAdapter() {
        ResourceAdapterBean resourceAdapterBean = this.raConnectorBean.getResourceAdapter();
        Class clazz = null;
        if (resourceAdapterBean == null) {
            return;
        }
        weblogic.j2ee.descriptor.OutboundResourceAdapterBean outboundResourceAdapterBean = resourceAdapterBean.getOutboundResourceAdapter();
        AdminObjectBean[] adminObjectBeanArray = resourceAdapterBean.getAdminObjects();
        clazz = this.validateResourceAdapterBean();
        this.validateAdminObjects(adminObjectBeanArray);
        this.validateOutboundResourceAdapter(outboundResourceAdapterBean);
        this.validateMessageListeners();
        if (this.raValidationInfo.isInbound() && !this.raValidationInfo.hasRAbean()) {
            this.raWarnings.addElement(fmt.MISSING_RA_BEAN_FOR_INBOUND());
        }
    }

    private void validateWLRADD() {
        AdminObjectsBean adminObjectsBean = this.wlraConnectorBean.getAdminObjects();
        String string = this.wlraConnectorBean.getJNDIName();
        OutboundResourceAdapterBean outboundResourceAdapterBean = this.wlraConnectorBean.getOutboundResourceAdapter();
        if (this.raValidationInfo.isInbound() && this.raValidationInfo.hasRAbean() && string == null) {
            this.raWarnings.addElement(fmt.MISSING_JNDI_NAME());
        }
        if (string != null && !this.raValidationInfo.hasRAbean()) {
            this.raErrors.addElement(fmt.MISSING_RA_BEAN());
        }
        this.validateWLProps("<weblogic-connector><properties>", this.wlraConnectorBean.getProperties(), this.raValidationInfo.getRAPropSetterTable());
        this.validateWLAdminObjects(adminObjectsBean);
        this.validateWLOutboundResourceAdapter(outboundResourceAdapterBean);
    }

    private void validateWLAdminObjects(AdminObjectsBean adminObjectsBean) {
        if (adminObjectsBean == null) {
            return;
        }
        ConfigPropertiesBean configPropertiesBean = adminObjectsBean.getDefaultProperties();
        this.validateWLGroupProps("<admin-objects><default-properties>", configPropertiesBean, this.raValidationInfo.getAllAdminPropSetters());
        for (AdminObjectGroupBean adminObjectGroupBean : adminObjectsBean.getAdminObjectGroups()) {
            String string = adminObjectGroupBean.getAdminObjectInterface();
            if (!this.hasMatchingAdminInterfaceInRA(string)) {
                this.raErrors.addElement(fmt.NO_MATCHING_ADMIN_INTERFACE(string));
                continue;
            }
            ConfigPropertiesBean configPropertiesBean2 = adminObjectGroupBean.getDefaultProperties();
            PropSetterTable propSetterTable = this.raValidationInfo.getAdminPropSetterTable(string);
            this.validateWLProps("<admin-objects><admin-object-group>[admin-object-interface = " + string + "]", configPropertiesBean2, propSetterTable);
            for (AdminObjectInstanceBean adminObjectInstanceBean : adminObjectGroupBean.getAdminObjectInstances()) {
                ConfigPropertiesBean configPropertiesBean3 = adminObjectInstanceBean.getProperties();
                this.validateWLProps("<admin-objects><admin-object-group>[admin-object-interface = " + string + "]<admin-object-instance>[jndi-name = " + adminObjectInstanceBean.getJNDIName() + "]", configPropertiesBean3, propSetterTable);
            }
        }
    }

    private boolean hasMatchingAdminInterfaceInRA(String string) {
        boolean bl = false;
        if (this.raConnectorBean != null && this.raConnectorBean.getResourceAdapter() != null) {
            AdminObjectBean[] adminObjectBeanArray = this.raConnectorBean.getResourceAdapter().getAdminObjects();
            for (int i = 0; i < adminObjectBeanArray.length && !bl; ++i) {
                AdminObjectBean adminObjectBean = adminObjectBeanArray[i];
                String string2 = adminObjectBean.getAdminObjectInterface();
                bl = string.equals(string2);
            }
        }
        return bl;
    }

    private Class validateResourceAdapterBean() {
        String[] stringArray = new String[]{"javax.resource.spi.ResourceAdapter"};
        String[] stringArray2 = new String[]{"java.io.Serializable"};
        String string = this.raConnectorBean.getResourceAdapter().getResourceAdapterClass();
        Class clazz = null;
        if (string == null) {
            return null;
        }
        ((RAValidationInfoImpl)this.raValidationInfo).hasRAbean = true;
        clazz = this.checkClass("<resourceadapter-class>", "ra.xml", string, stringArray, stringArray2, true, null);
        if (clazz != null) {
            this.validateProperties(clazz, this.raConnectorBean.getResourceAdapter().getConfigProperties(), this.raValidationInfo.getRAPropSetterTable(), "<resourceadapter>", "ra.xml");
        }
        return clazz;
    }

    private void validateOutboundResourceAdapter(weblogic.j2ee.descriptor.OutboundResourceAdapterBean outboundResourceAdapterBean) {
        if (outboundResourceAdapterBean == null) {
            return;
        }
        weblogic.j2ee.descriptor.ConnectionDefinitionBean[] connectionDefinitionBeanArray = outboundResourceAdapterBean.getConnectionDefinitions();
        if (connectionDefinitionBeanArray == null || connectionDefinitionBeanArray.length == 0) {
            return;
        }
        for (int i = 0; i < connectionDefinitionBeanArray.length; ++i) {
            weblogic.j2ee.descriptor.ConnectionDefinitionBean connectionDefinitionBean = connectionDefinitionBeanArray[i];
            this.validateConnectionDefinition(connectionDefinitionBean);
        }
    }

    private void validateWLOutboundResourceAdapter(OutboundResourceAdapterBean outboundResourceAdapterBean) {
        if (outboundResourceAdapterBean == null || this.raValidationInfo.isLinkRef() && this.raConnectorBean == null) {
            return;
        }
        ConnectionDefinitionPropertiesBean connectionDefinitionPropertiesBean = outboundResourceAdapterBean.getDefaultConnectionProperties();
        ConfigPropertiesBean configPropertiesBean = null;
        if (connectionDefinitionPropertiesBean != null) {
            configPropertiesBean = connectionDefinitionPropertiesBean.getProperties();
            this.validateWLGroupProps("<outbound-resource-adapter><default-connection-properties><properties>", configPropertiesBean, this.raValidationInfo.getAllConnectionFactoryPropSetters());
        }
        ConnectionDefinitionBean[] connectionDefinitionBeanArray = outboundResourceAdapterBean.getConnectionDefinitionGroups();
        for (int i = 0; i < connectionDefinitionBeanArray.length; ++i) {
            ConnectionDefinitionBean connectionDefinitionBean = connectionDefinitionBeanArray[i];
            String string = connectionDefinitionBean.getConnectionFactoryInterface();
            if (!this.hasMatchingConnFactoryInterfaceInRA(string)) {
                this.raErrors.addElement(fmt.NO_MATCHING_CONN_FACTORY_INTERFACE(string));
                continue;
            }
            PropSetterTable propSetterTable = this.raValidationInfo.getConnectionFactoryPropSetterTable(string);
            ConnectionDefinitionPropertiesBean connectionDefinitionPropertiesBean2 = connectionDefinitionBean.getDefaultConnectionProperties();
            ConfigPropertiesBean configPropertiesBean2 = null;
            if (connectionDefinitionPropertiesBean2 != null) {
                configPropertiesBean2 = connectionDefinitionPropertiesBean2.getProperties();
                this.validateWLProps("<outbound-resource-adapter><connection-definition-group>[connection-factory-interface = " + string + "]<default-connection-properties>", configPropertiesBean2, propSetterTable);
            }
            for (ConnectionInstanceBean connectionInstanceBean : connectionDefinitionBean.getConnectionInstances()) {
                ConnectionDefinitionPropertiesBean connectionDefinitionPropertiesBean3 = connectionInstanceBean.getConnectionProperties();
                ConfigPropertiesBean configPropertiesBean3 = null;
                if (connectionDefinitionPropertiesBean3 == null) continue;
                configPropertiesBean3 = connectionDefinitionPropertiesBean3.getProperties();
                this.validateWLProps("<outbound-resource-adapter><connection-definition-group>[connection-factory-interface = " + string + "]<connection-instance>[ jndi-name = " + connectionInstanceBean.getJNDIName() + "]", configPropertiesBean3, propSetterTable);
            }
        }
    }

    private boolean hasMatchingConnFactoryInterfaceInRA(String string) {
        weblogic.j2ee.descriptor.OutboundResourceAdapterBean outboundResourceAdapterBean;
        weblogic.j2ee.descriptor.ConnectionDefinitionBean[] connectionDefinitionBeanArray;
        boolean bl = false;
        if (this.raConnectorBean != null && this.raConnectorBean.getResourceAdapter() != null && (connectionDefinitionBeanArray = (outboundResourceAdapterBean = this.raConnectorBean.getResourceAdapter().getOutboundResourceAdapter()).getConnectionDefinitions()) != null && connectionDefinitionBeanArray.length > 0) {
            for (int i = 0; i < connectionDefinitionBeanArray.length && !bl; ++i) {
                weblogic.j2ee.descriptor.ConnectionDefinitionBean connectionDefinitionBean = connectionDefinitionBeanArray[i];
                bl = string.equals(connectionDefinitionBean.getConnectionFactoryInterface());
            }
        }
        return bl;
    }

    private void validateConnectionDefinition(weblogic.j2ee.descriptor.ConnectionDefinitionBean connectionDefinitionBean) {
        String string;
        String string2;
        String[] stringArray = new String[]{"javax.resource.spi.ManagedConnectionFactory"};
        String[] stringArray2 = new String[]{"java.io.Serializable", "javax.resource.Referenceable", "<connectionfactory-interface>"};
        String[] stringArray3 = new String[]{"<connection-interface>"};
        String string3 = connectionDefinitionBean.getManagedConnectionFactoryClass();
        String string4 = connectionDefinitionBean.getConnectionFactoryImplClass();
        stringArray2[2] = string2 = connectionDefinitionBean.getConnectionFactoryInterface();
        String string5 = connectionDefinitionBean.getConnectionImplClass();
        stringArray3[0] = string = connectionDefinitionBean.getConnectionInterface();
        ConfigPropertyBean[] configPropertyBeanArray = connectionDefinitionBean.getConfigProperties();
        Class clazz = null;
        this.checkClass("<connection-interface>", "ra.xml", string, null, null, false);
        this.checkClass("<connection-impl-class>", "ra.xml", string5, stringArray3, null, false);
        clazz = this.checkClass("<managedconnectionfactory-class>", "ra.xml", string3, stringArray, null, false, Boolean.TRUE);
        this.checkClass("<connectionfactory-interface>", "ra.xml", string2, null, null, false);
        this.checkClass("<connectionfactory-impl-class>", "ra.xml", string4, stringArray2, null, false);
        this.validateProperties(clazz, configPropertyBeanArray, this.raValidationInfo.getConnectionFactoryPropSetterTable(string2), "<connection-definition>", "ra.xml");
    }

    private void validateMessageListeners() {
        if (this.raConnectorBean == null) {
            this.raErrors.addElement(fmt.ELEMENT_IS_EMPTY("ra.xml", "<connector>"));
            return;
        }
        InboundResourceAdapterBean inboundResourceAdapterBean = this.raConnectorBean.getResourceAdapter().getInboundResourceAdapter();
        if (inboundResourceAdapterBean == null) {
            return;
        }
        MessageAdapterBean messageAdapterBean = inboundResourceAdapterBean.getMessageAdapter();
        if (messageAdapterBean == null) {
            return;
        }
        MessageListenerBean[] messageListenerBeanArray = messageAdapterBean.getMessageListeners();
        if (messageListenerBeanArray == null || messageListenerBeanArray.length == 0) {
            return;
        }
        ((RAValidationInfoImpl)this.raValidationInfo).isInbound = true;
        for (int i = 0; i < messageListenerBeanArray.length; ++i) {
            this.validateMessageListener(messageListenerBeanArray[i]);
        }
    }

    private void validateMessageListener(MessageListenerBean messageListenerBean) {
        String[] stringArray = new String[]{"javax.resource.spi.ActivationSpec", "java.io.Serializable"};
        if (messageListenerBean == null) {
            this.raErrors.addElement(fmt.ELEMENT_IS_EMPTY("ra.xml", "<messagelistener-type>"));
            return;
        }
        String string = messageListenerBean.getMessageListenerType();
        String string2 = messageListenerBean.getActivationSpec().getActivationSpecClass();
        this.checkClass("<messagelistener-type>", "ra.xml", string, null, null, false);
        this.checkClass("<activationspec-class>", "ra.xml", string2, stringArray, null, true, Boolean.FALSE);
    }

    private void validateAdminObjects(AdminObjectBean[] adminObjectBeanArray) {
        String[] stringArray = new String[]{"<adminobject-interface>"};
        String[] stringArray2 = new String[]{"java.io.Serializable"};
        Class clazz = null;
        if (adminObjectBeanArray != null && adminObjectBeanArray.length > 0) {
            for (int i = 0; i < adminObjectBeanArray.length; ++i) {
                AdminObjectBean adminObjectBean = adminObjectBeanArray[i];
                String string = adminObjectBean.getAdminObjectInterface();
                this.checkClass("<adminobject-interface>", "ra.xml", string, null, null, false);
                stringArray[0] = string;
                String string2 = adminObjectBean.getAdminObjectClass();
                clazz = this.checkClass("<adminobject-class>", "ra.xml", string2, stringArray, stringArray2, true);
                if (clazz == null) continue;
                this.validateProperties(clazz, adminObjectBean.getConfigProperties(), this.raValidationInfo.getAdminPropSetterTable(string), "<adminobject>", "ra.xml");
            }
        }
    }

    private Class checkClass(String string, String string2, String string3, String[] stringArray, String[] stringArray2, boolean bl, Boolean bl2) {
        boolean bl3;
        boolean bl4 = true;
        Class<?> clazz = null;
        if (string3 == null || string3.length() == 0) {
            this.raErrors.addElement(fmt.ZERO_LENGTH_NAME(string2, string, string3));
            return clazz;
        }
        try {
            clazz = Class.forName(string3, false, (ClassLoader)this.raClassLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.raErrors.addElement(fmt.CLASS_NOT_FOUND(string2, string, string3));
            return clazz;
        }
        catch (Throwable throwable) {
            this.raErrors.addElement(fmt.COULDNT_LOAD_CLASS(string2, string, string3, throwable.toString()));
            return clazz;
        }
        Class[] classArray = Utils.getInterfaces(clazz);
        if (stringArray != null) {
            this.validateImplements(string2, true, string, string3, classArray, stringArray);
        }
        if (stringArray2 != null) {
            this.validateImplements(string2, false, string, string3, classArray, stringArray2);
        }
        if (bl) {
            this.checkJavaBeanCompliance(string2, string, clazz);
        }
        if (bl2 != null && !(bl4 = RAComplianceChecker.checkOverrides(clazz, bl3 = bl2.booleanValue()))) {
            if (bl3) {
                this.raErrors.addElement(fmt.MUST_OVERRIDE(string2, string, string3));
            } else {
                this.raWarnings.addElement(fmt.SHOULD_NOT_OVERRIDE(string2, string, string3));
            }
        }
        return clazz;
    }

    private Class checkClass(String string, String string2, String string3, String[] stringArray, String[] stringArray2, boolean bl) {
        return this.checkClass(string, string2, string3, stringArray, stringArray2, bl, null);
    }

    private void validateImplements(String string, boolean bl, String string2, String string3, Class[] classArray, String[] stringArray) {
        boolean bl2;
        boolean bl3 = bl2 = classArray != null && classArray.length > 0;
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl4 = false;
            if (bl2) {
                for (int j = 0; !bl4 && j < classArray.length; ++j) {
                    if (!classArray[j].getName().equals(stringArray[i])) continue;
                    bl4 = true;
                }
            }
            if (bl4) continue;
            this.reportMissingInterface(string, bl, string2, string3, stringArray[i]);
        }
    }

    private void reportMissingInterface(String string, boolean bl, String string2, String string3, String string4) {
        if (bl) {
            this.raErrors.addElement(fmt.MUST_IMPLEMENT_INTERFACE(string, string2, string3, string4));
        } else {
            this.raWarnings.addElement(fmt.SHOULD_IMPLEMENT_INTERFACE(string, string2, string3, string4));
        }
    }

    private void checkJavaBeanCompliance(String string, String string2, Class clazz) {
        BeanInfo beanInfo = null;
        if (clazz == null) {
            return;
        }
        try {
            Introspector.flushFromCaches(clazz);
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {
            this.raWarnings.addElement(fmt.NOT_A_JAVA_BEAN(string, string2, clazz.getName(), introspectionException.getMessage()));
        }
    }

    private static boolean checkOverrides(Class clazz, boolean bl) throws SecurityException {
        boolean bl2 = false;
        boolean bl3 = false;
        Method[] methodArray = clazz.getMethods();
        if (methodArray != null && methodArray.length > 0) {
            for (int i = 0; !(i >= methodArray.length || bl2 && bl3); ++i) {
                Method method = methodArray[i];
                if (!bl2) {
                    boolean bl4 = bl2 = !method.getDeclaringClass().equals(JAVA_LANG_OBJECT_CLASS) && method.getName().equals("equals") && method.getReturnType().equals(Boolean.TYPE) && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].getName().equals("java.lang.Object");
                }
                if (bl3) continue;
                bl3 = !method.getDeclaringClass().equals(JAVA_LANG_OBJECT_CLASS) && method.getName().equals("hashCode") && method.getReturnType().equals(Integer.TYPE) && method.getParameterTypes().length == 0;
            }
        }
        return bl && bl2 && bl3 || !bl && !bl2 && !bl3;
    }

    private void handleRAException(RAConfigurationException rAConfigurationException) {
        String string;
        Throwable throwable = rAConfigurationException.getCause();
        if (throwable == null) {
            string = rAConfigurationException.getMessage();
        } else {
            Throwable throwable2 = throwable.getCause();
            if (throwable instanceof DescriptorException) {
                string = "DescriptorException: ";
                string = throwable2 != null ? string + throwable2.toString() : string + throwable.toString();
            } else {
                string = throwable2 != null ? throwable2.getClass().getName() + ": " + throwable2.toString() : throwable.getClass().getName() + ": " + throwable.toString();
            }
        }
        Debug.logComplianceRAConfigurationException(string);
    }

    private void setClearIntrospectorCacheNeeded() {
        this.clearIntrospectorCacheNeeded = true;
    }

    private void clearIntrospectorCache() {
        Debug.println("Clear the BeanInfo cache for RA Classes");
        for (Class clazz : this.introspectedClasses) {
            Introspector.flushFromCaches(clazz);
        }
        this.introspectedClasses.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateProperties(Class clazz, ConfigPropertyBean[] configPropertyBeanArray, PropSetterTable propSetterTable, String string, String string2) {
        Debug.enter("weblogic.connector.external.impl.RAComplianceChecker", ".validateProperties( " + (clazz == null ? "missing class" : clazz.getName()) + " )");
        try {
            BeanInfo beanInfo = null;
            PropertyDescriptor[] propertyDescriptorArray = null;
            MethodDescriptor[] methodDescriptorArray = null;
            Hashtable hashtable = new Hashtable();
            Method method = null;
            try {
                if (clazz != null) {
                    Debug.println("Get the BeanInfo object for the obj");
                    Introspector.flushFromCaches(clazz);
                    beanInfo = Introspector.getBeanInfo(clazz);
                    if (this.clearIntrospectorCacheNeeded) {
                        this.introspectedClasses.add(clazz);
                    }
                    Debug.println("Get all the methods & properties of the class");
                    propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                    methodDescriptorArray = beanInfo.getMethodDescriptors();
                }
                Debug.println("Iterate through all the config properties and (optionally) set them in the obj");
                String string3 = "";
                for (int i = 0; i < configPropertyBeanArray.length; ++i) {
                    ConfigPropertyBean configPropertyBean = configPropertyBeanArray[i];
                    method = null;
                    this.validateConfigProperty(string, configPropertyBean);
                    if (clazz != null && (method = this.findWriteMethod(string, configPropertyBean, propertyDescriptorArray, methodDescriptorArray, clazz)) == null) {
                        Debug.println("For property " + configPropertyBean.getConfigPropertyName() + " no write method was found.");
                    }
                    this.checkForDuplicateProperty(string, configPropertyBean, hashtable);
                    RAComplianceChecker.registerWriteMethod(configPropertyBean, method, propSetterTable);
                }
            }
            catch (IntrospectionException introspectionException) {
                String string4 = Debug.getExceptionIntrospectProperties(clazz.getName());
                Debug.println("Utils.validateProperties() error: " + string4);
                this.raErrors.addElement(string4);
            }
            Object var15_16 = null;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            Debug.exit("weblogic.connector.external.impl.RAComplianceChecker", "validateProperties() ");
            throw throwable;
        }
        Debug.exit("weblogic.connector.external.impl.RAComplianceChecker", "validateProperties() ");
    }

    private void validateConfigProperty(String string, ConfigPropertyBean configPropertyBean) {
        String string2 = configPropertyBean.getConfigPropertyName();
        String string3 = configPropertyBean.getConfigPropertyValue();
        String string4 = configPropertyBean.getConfigPropertyType();
        Debug.println("Validate the config property Name = '" + string2 + "' Type = '" + string4 + "' value = '" + string3 + "'");
        if (string2 == null || string2.length() == 0) {
            this.raWarnings.addElement(fmt.NULL_PROPERTY_NAME(string, string4, string3));
        }
        if (string3 != null) {
            try {
                Utils.getValueByType(string3, string4);
            }
            catch (NumberFormatException numberFormatException) {
                this.raWarnings.addElement(fmt.PROPERTY_TYPE_VALUE_MISMATCH("ra.xml", string, string2, string4, string3, numberFormatException.toString()));
            }
        }
    }

    private Method findWriteMethod(String string, ConfigPropertyBean configPropertyBean, PropertyDescriptor[] propertyDescriptorArray, MethodDescriptor[] methodDescriptorArray, Class clazz) {
        Debug.println("Find the write method");
        String string2 = configPropertyBean.getConfigPropertyName();
        String string3 = configPropertyBean.getConfigPropertyValue();
        String string4 = configPropertyBean.getConfigPropertyType();
        Method method = null;
        MethodDescriptor methodDescriptor = null;
        try {
            methodDescriptor = this.findMethod(string, string2, string4, methodDescriptorArray);
        }
        catch (RACommonException rACommonException) {
            return null;
        }
        if (methodDescriptor != null) {
            method = methodDescriptor.getMethod();
            if (method != null) {
                Debug.println("In findWriteMethod(): Found a method whose name matches set" + string2);
                return method;
            }
            Debug.println("In findWriteMethod(): Failed to find a method that matches set" + string2);
        }
        Debug.println("Utils.findWriteMethod() failed to find setter method. Looking for a PropertyDescriptor for a match");
        try {
            method = this.findPropertyWriteMethod(string, string2, string4, propertyDescriptorArray);
        }
        catch (RACommonException rACommonException) {
            return null;
        }
        if (method != null) {
            Debug.println("In findWriteMethod(): Found a method whose name matches set" + string2);
            return method;
        }
        Debug.println("Utils.findWriteMethod() couldn't find property write method.  Looking for properties with a different type to help user out");
        PropertyDescriptor[] propertyDescriptorArray2 = RAComplianceChecker.findProperties(string2, propertyDescriptorArray);
        if (propertyDescriptorArray != null && propertyDescriptorArray2 != null) {
            for (int i = 0; i < propertyDescriptorArray2.length; ++i) {
                method = this.checkPropByTypeAndGetWriteMethodOrReport(string, propertyDescriptorArray2[i], string2, string4, string3, clazz.getName());
            }
        }
        if (method != null) {
            Debug.println("In findWriteMethod(): Found a method whose name matches set" + string2);
            return method;
        }
        Debug.println("In findWriteMethod(): Unable to find a method whose name matches set" + string2);
        this.raWarnings.addElement(fmt.NO_SET_METHOD_FOR_PROPERTY("ra.xml", string, configPropertyBean.getConfigPropertyName(), configPropertyBean.getConfigPropertyType(), clazz.getName()));
        return null;
    }

    private void checkForDuplicateProperty(String string, ConfigPropertyBean configPropertyBean, Hashtable hashtable) {
        String string2 = configPropertyBean.getConfigPropertyName();
        ConfigPropertyBean configPropertyBean2 = (ConfigPropertyBean)hashtable.get(string2);
        if (configPropertyBean2 == null) {
            hashtable.put(string2, configPropertyBean);
        } else if (configPropertyBean2.getConfigPropertyType().equals(configPropertyBean.getConfigPropertyType())) {
            String string3 = fmt.DUPLICATE_RA_PROPERTY(string, string2, configPropertyBean.getConfigPropertyType(), configPropertyBean.getConfigPropertyValue());
            this.raWarnings.addElement(string3);
        } else {
            String string4 = fmt.DUPLICATE_RA_PROPERTY_MULTI_TYPES(string, string2, configPropertyBean.getConfigPropertyType(), configPropertyBean.getConfigPropertyValue(), configPropertyBean2.getConfigPropertyType());
            this.raWarnings.addElement(string4);
        }
    }

    private static void registerWriteMethod(ConfigPropertyBean configPropertyBean, Method method, PropSetterTable propSetterTable) {
        Debug.println("Utils.registerWriteMethod( " + configPropertyBean + ", " + method + " )");
        if (propSetterTable.hasRAProperty(configPropertyBean)) {
            Debug.println("Utils.registerWriteMethod( table already contains prop = " + configPropertyBean);
        }
        propSetterTable.setMethod(configPropertyBean, method);
    }

    private MethodDescriptor findMethod(String string, String string2, String string3, MethodDescriptor[] methodDescriptorArray) throws RACommonException {
        String string4 = "set" + string2;
        Class[] classArray = new Class[2];
        try {
            classArray[0] = RAComplianceChecker.getClass(string3);
            String string5 = RAComplianceChecker.switchType(string3);
            classArray[1] = string5 != null && !string3.equals(string5) ? RAComplianceChecker.getClass(string5) : null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string6 = fmt.INVALID_PROPERTY_TYPE("ra.xml", string, string3, string2, classNotFoundException.toString());
            this.raWarnings.addElement(string6);
            throw new RACommonException();
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i] == null) continue;
            for (int j = 0; j < methodDescriptorArray.length; ++j) {
                MethodDescriptor methodDescriptor = methodDescriptorArray[j];
                String string7 = methodDescriptor.getName();
                if (string7 == null || !string7.equalsIgnoreCase(string4) || methodDescriptor.getMethod().getParameterTypes().length != 1 || !methodDescriptor.getMethod().getParameterTypes()[0].equals(classArray[i])) continue;
                return methodDescriptor;
            }
        }
        return null;
    }

    private Method findPropertyWriteMethod(String string, String string2, String string3, PropertyDescriptor[] propertyDescriptorArray) throws RACommonException {
        Class[] classArray = new Class[2];
        try {
            classArray[0] = RAComplianceChecker.getClass(string3);
            String string4 = RAComplianceChecker.switchType(string3);
            classArray[1] = string4 != null && !string3.equals(string4) ? RAComplianceChecker.getClass(string4) : null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string5 = fmt.INVALID_PROPERTY_TYPE("ra.xml", string, string3, string2, classNotFoundException.toString());
            this.raWarnings.addElement(string5);
            throw new RACommonException();
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i] == null) continue;
            for (int j = 0; j < propertyDescriptorArray.length; ++j) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[j];
                String string6 = propertyDescriptor.getName();
                Method method = propertyDescriptor.getWriteMethod();
                if (string6 == null || !string6.equalsIgnoreCase(string2) || method == null || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(classArray[i])) continue;
                return method;
            }
        }
        return null;
    }

    private static PropertyDescriptor[] findProperties(String string, PropertyDescriptor[] propertyDescriptorArray) {
        Vector<PropertyDescriptor> vector = new Vector<PropertyDescriptor>();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
            String string2 = propertyDescriptor.getName();
            if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
            vector.addElement(propertyDescriptor);
        }
        if (vector.size() > 0) {
            return (PropertyDescriptor[])vector.toArray();
        }
        return null;
    }

    private Method checkPropByTypeAndGetWriteMethodOrReport(String string, PropertyDescriptor propertyDescriptor, String string2, String string3, String string4, String string5) {
        Debug.println("In setProperty(): Found a property whose name matches " + string2);
        Class<?> clazz = propertyDescriptor.getPropertyType();
        if (clazz != null) {
            boolean bl;
            boolean bl2 = string3.equals(clazz.getName());
            boolean bl3 = clazz.isPrimitive() && string3.equals(RAComplianceChecker.primitiveToObject(clazz.getName()));
            boolean bl4 = bl = RAComplianceChecker.isPrimitive(string3) && clazz.getName().equals(RAComplianceChecker.primitiveToObject(string3));
            if (Debug.getVerbose()) {
                Debug.println("For config prop with name '" + string2 + "' and type '" + string3 + "', ");
                Debug.println("\tthe object property found " + (bl2 ? "had" : "did not have") + " the same type");
                if (bl2) {
                    Method method = propertyDescriptor.getWriteMethod();
                    if (method != null) {
                        return method;
                    }
                } else if (bl3) {
                    Debug.println("\tthe object property type is primitive, and the config prop has the corresponding object type");
                } else if (bl) {
                    Debug.println("\tthe config property type is primitive, and the object property type has the corresponding object type");
                } else {
                    Debug.println("\tthe config property type and the object property type do not correspond");
                }
            }
            if (!(bl2 || bl3 || bl)) {
                this.raWarnings.addElement(fmt.PROPERTY_TYEPE_MISMATCH("ra.xml", string, string2, string3, string4, string5));
            }
        } else {
            this.raWarnings.addElement(fmt.NULL_PROPERTYDESCRIPTOR_TYPE("ra.xml", string, string2, string3, propertyDescriptor.getName(), string5));
        }
        return null;
    }

    private static Class getClass(String string) throws ClassNotFoundException {
        if (string == null || string.equals("")) {
            throw new ClassNotFoundException(string);
        }
        for (int i = 0; i < NUM_PRIMS; ++i) {
            if (!string.equals(PRIMITIVE_TYPES[i])) continue;
            return PRIMITIVE_CLASSES[i];
        }
        return Class.forName(string);
    }

    private static String switchType(String string) {
        String string2 = null;
        if (RAComplianceChecker.isPrimitive(string)) {
            string2 = RAComplianceChecker.primitiveToObject(string);
        } else if (RAComplianceChecker.isObjectTypeOfPrimitive(string)) {
            string2 = RAComplianceChecker.objectToPrimitive(string);
        }
        return string2;
    }

    private static String primitiveToObject(String string) {
        for (int i = 0; i < NUM_PRIMS; ++i) {
            if (!string.equals(PRIMITIVE_TYPES[i])) continue;
            return PRIMITIVE_OBJ_CLASSES[i];
        }
        return null;
    }

    private static String objectToPrimitive(String string) {
        for (int i = 0; i < NUM_PRIMS; ++i) {
            if (!string.equals(PRIMITIVE_OBJ_CLASSES[i])) continue;
            return PRIMITIVE_TYPES[i];
        }
        return null;
    }

    private static boolean isPrimitive(String string) {
        for (int i = 0; i < NUM_PRIMS; ++i) {
            if (!string.equals(PRIMITIVE_TYPES[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean isObjectTypeOfPrimitive(String string) {
        for (int i = 0; i < NUM_OBJ_PRIMS; ++i) {
            if (!string.equals(PRIMITIVE_OBJ_CLASSES[i])) continue;
            return true;
        }
        return false;
    }

    private void validateWLProps(String string, ConfigPropertiesBean configPropertiesBean, PropSetterTable propSetterTable) {
        if (configPropertiesBean == null) {
            return;
        }
        weblogic.j2ee.descriptor.wl.ConfigPropertyBean[] configPropertyBeanArray = configPropertiesBean.getProperties();
        for (int i = 0; configPropertyBeanArray != null && i < configPropertyBeanArray.length; ++i) {
            weblogic.j2ee.descriptor.wl.ConfigPropertyBean configPropertyBean = configPropertyBeanArray[i];
            ConfigPropertyBean configPropertyBean2 = propSetterTable.getRAProperty(configPropertyBean.getName());
            if (configPropertyBean2 != null) {
                String string2 = configPropertyBean.getValue();
                String string3 = configPropertyBean2.getConfigPropertyType();
                try {
                    Utils.getValueByType(string2, string3);
                }
                catch (NumberFormatException numberFormatException) {
                    this.raWarnings.addElement(fmt.PROPERTY_TYPE_VALUE_MISMATCH("weblogic-ra.xml", string, configPropertyBean.getName(), string3, string2, numberFormatException.toString()));
                }
                continue;
            }
            this.raWarnings.addElement(fmt.MISSING_RA_PROPERTY(string, configPropertyBean.getName(), configPropertyBean.getValue()));
        }
    }

    private void validateWLGroupProps(String string, ConfigPropertiesBean configPropertiesBean, Collection collection) {
        if (configPropertiesBean == null) {
            return;
        }
        weblogic.j2ee.descriptor.wl.ConfigPropertyBean[] configPropertyBeanArray = configPropertiesBean.getProperties();
        for (int i = 0; configPropertyBeanArray != null && i < configPropertyBeanArray.length; ++i) {
            weblogic.j2ee.descriptor.wl.ConfigPropertyBean configPropertyBean = configPropertyBeanArray[i];
            ConfigPropertyBean configPropertyBean2 = this.raValidationInfo.getProperty(configPropertyBean.getName(), collection);
            if (configPropertyBean2 != null) {
                String string2 = configPropertyBean.getValue();
                String string3 = configPropertyBean2.getConfigPropertyType();
                try {
                    Utils.getValueByType(string2, string3);
                }
                catch (NumberFormatException numberFormatException) {
                    this.raWarnings.addElement(fmt.PROPERTY_TYPE_VALUE_MISMATCH("weblogic-ra.xml", string, configPropertyBean.getName(), string3, string2, numberFormatException.toString()));
                }
                continue;
            }
            this.raWarnings.addElement(fmt.MISSING_RA_PROPERTY(string, configPropertyBean.getName(), configPropertyBean.getValue()));
        }
    }
}

