/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.external.impl;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import weblogic.connector.common.Debug;
import weblogic.connector.external.AdminObjInfo;
import weblogic.connector.external.AuthMechInfo;
import weblogic.connector.external.ElementNotFoundException;
import weblogic.connector.external.LoggingInfo;
import weblogic.connector.external.OutboundInfo;
import weblogic.connector.external.PoolInfo;
import weblogic.connector.external.RAInfo;
import weblogic.connector.external.SecurityIdentityInfo;
import weblogic.connector.external.impl.AdminObjInfoImpl;
import weblogic.connector.external.impl.AuthMechInfoImpl;
import weblogic.connector.external.impl.ConfigPropInfoImpl;
import weblogic.connector.external.impl.InboundInfoImpl;
import weblogic.connector.external.impl.LoggingInfoImpl;
import weblogic.connector.external.impl.OutboundInfoImpl;
import weblogic.connector.external.impl.PoolInfoImpl;
import weblogic.connector.external.impl.SecurityIdentityInfoImpl;
import weblogic.connector.external.impl.SecurityPermissionInfoImpl;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.AdminObjectBean;
import weblogic.j2ee.descriptor.AuthenticationMechanismBean;
import weblogic.j2ee.descriptor.ConfigPropertyBean;
import weblogic.j2ee.descriptor.ConnectorBean;
import weblogic.j2ee.descriptor.IconBean;
import weblogic.j2ee.descriptor.InboundResourceAdapterBean;
import weblogic.j2ee.descriptor.MessageAdapterBean;
import weblogic.j2ee.descriptor.MessageListenerBean;
import weblogic.j2ee.descriptor.ResourceAdapterBean;
import weblogic.j2ee.descriptor.SecurityPermissionBean;
import weblogic.j2ee.descriptor.wl.AdminObjectGroupBean;
import weblogic.j2ee.descriptor.wl.AdminObjectInstanceBean;
import weblogic.j2ee.descriptor.wl.AdminObjectsBean;
import weblogic.j2ee.descriptor.wl.ConnectionDefinitionBean;
import weblogic.j2ee.descriptor.wl.ConnectionDefinitionPropertiesBean;
import weblogic.j2ee.descriptor.wl.ConnectionInstanceBean;
import weblogic.j2ee.descriptor.wl.OutboundResourceAdapterBean;
import weblogic.j2ee.descriptor.wl.ResourceAdapterSecurityBean;
import weblogic.j2ee.descriptor.wl.WeblogicConnectorBean;
import weblogic.j2ee.descriptor.wl.WeblogicConnectorExtensionBean;
import weblogic.j2ee.descriptor.wl.WorkManagerBean;

public class RAInfoImpl
implements RAInfo {
    private static String DEFAULT_NATIVE_LIBDIR = "/temp/nativelibs/";
    private ConnectorBean connBean;
    private WeblogicConnectorBean wlConnBean;
    private RAInfo baseRA = null;
    private ResourceAdapterSecurityBean raSecurityBean;
    private WorkManagerBean workManagerBean;
    private URL url;
    private String moduleName;
    public static final RAInfo factoryHelper = new RAInfoImpl();
    private Vector inboundInfos = null;
    private ResourceAdapterBean raBean = null;
    private weblogic.j2ee.descriptor.OutboundResourceAdapterBean outboundRABean = null;
    private OutboundResourceAdapterBean wlOutboundRABean = null;
    private InboundResourceAdapterBean inboundRABean = null;
    private MessageListenerBean[] msgListeners = null;

    public RAInfo createRAInfo(ConnectorBean connectorBean, WeblogicConnectorBean weblogicConnectorBean, URL uRL, String string) {
        return new RAInfoImpl(connectorBean, weblogicConnectorBean, uRL, string);
    }

    private RAInfoImpl() {
    }

    private RAInfoImpl(ConnectorBean connectorBean, WeblogicConnectorBean weblogicConnectorBean, URL uRL, String string) {
        Debug.println(this, "( moduleName = '" + string + "' )");
        if (weblogicConnectorBean == null) {
            Debug.throwAssertionError("WeblogicConnectorBean == null");
        }
        if (uRL == null) {
            Debug.throwAssertionError("URL == null");
        }
        if (string == null || string.trim().equals("")) {
            Debug.throwAssertionError("ModuleName == null or the empty string");
        }
        if (connectorBean == null) {
            Debug.parsing("connectorBean == null");
        }
        this.moduleName = string;
        this.url = uRL;
        this.setConnBean(connectorBean);
        this.setWeblogicConnectorBean(weblogicConnectorBean);
        this.dump();
    }

    public void dump() {
        if (!Debug.isParsingEnabled()) {
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream;
            if (this.connBean != null) {
                byteArrayOutputStream = new ByteArrayOutputStream();
                ((DescriptorBean)this.connBean).getDescriptor().toXML((OutputStream)byteArrayOutputStream);
                Debug.parsing("ConnectorBean = \n" + byteArrayOutputStream.toString());
            }
            if (this.wlConnBean != null) {
                byteArrayOutputStream = new ByteArrayOutputStream();
                ((DescriptorBean)this.wlConnBean).getDescriptor().toXML((OutputStream)byteArrayOutputStream);
                Debug.parsing("WeblogicConnectorBean = \n" + byteArrayOutputStream.toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setBaseRA(RAInfo rAInfo) {
        weblogic.j2ee.descriptor.ConnectionDefinitionBean[] connectionDefinitionBeanArray;
        Debug.println(this, ".setBaseRA()");
        if (rAInfo == null) {
            Debug.throwAssertionError("RAInfo == null");
        }
        this.baseRA = rAInfo;
        ConnectorBean connectorBean = ((RAInfoImpl)this.baseRA).getConnectorBean();
        if (connectorBean == null) {
            Debug.throwAssertionError("RAInfo.getConnBean() == null");
        }
        this.setConnBean(connectorBean);
        if (this.getOutboundRABean() == null) {
            Debug.throwAssertionError("RAInfo.getOutboundRABean() == null");
        }
        if ((connectionDefinitionBeanArray = this.getOutboundRABean().getConnectionDefinitions()).length == 0) {
            Debug.throwAssertionError("connDefns.length == 0");
        }
        String string = connectionDefinitionBeanArray[0].getConnectionFactoryInterface();
        ConnectionDefinitionBean[] connectionDefinitionBeanArray2 = this.getWeblogicOutboundRABean().getConnectionDefinitionGroups();
        connectionDefinitionBeanArray2[0].setConnectionFactoryInterface(string);
    }

    private void setConnBean(ConnectorBean connectorBean) {
        this.connBean = connectorBean;
        this.inboundInfos = null;
        this.raBean = null;
        this.outboundRABean = null;
        this.inboundRABean = null;
        this.msgListeners = null;
        if (this.connBean != null && this.connBean.getLicense() == null) {
            this.connBean.createLicense();
        }
    }

    private void setWeblogicConnectorBean(WeblogicConnectorBean weblogicConnectorBean) {
        this.wlConnBean = weblogicConnectorBean;
        this.raSecurityBean = this.wlConnBean.getSecurity() == null ? this.wlConnBean.createSecurity() : this.wlConnBean.getSecurity();
        this.workManagerBean = this.wlConnBean.getWorkManager();
    }

    public WeblogicConnectorBean getWeblogicConnectorBean() {
        return this.wlConnBean;
    }

    public List getOutboundInfos() {
        Vector<OutboundInfoImpl> vector = new Vector<OutboundInfoImpl>();
        weblogic.j2ee.descriptor.ConnectionDefinitionBean[] connectionDefinitionBeanArray = null;
        OutboundInfo outboundInfo = null;
        if (this.baseRA != null) {
            outboundInfo = (OutboundInfo)this.baseRA.getOutboundInfos().get(0);
        }
        if (this.getOutboundRABean() != null) {
            connectionDefinitionBeanArray = this.getOutboundRABean().getConnectionDefinitions();
            Debug.println(this, ".getOutboundInfos() found " + (connectionDefinitionBeanArray == null ? 0 : connectionDefinitionBeanArray.length) + " connection definitions.");
        }
        for (int i = 0; connectionDefinitionBeanArray != null && i < connectionDefinitionBeanArray.length; ++i) {
            ConnectionDefinitionBean connectionDefinitionBean = this.getConnectionDefnRef(connectionDefinitionBeanArray[i], this.connBean, this.wlConnBean);
            if (connectionDefinitionBean == null || connectionDefinitionBean.getConnectionInstances() == null || connectionDefinitionBean.getConnectionInstances().length == 0) continue;
            ConnectionInstanceBean[] connectionInstanceBeanArray = connectionDefinitionBean.getConnectionInstances();
            for (int j = 0; j < connectionDefinitionBean.getConnectionInstances().length; ++j) {
                OutboundInfoImpl outboundInfoImpl = new OutboundInfoImpl(this, this.connBean, this.wlConnBean, connectionDefinitionBeanArray[i], connectionDefinitionBean, connectionInstanceBeanArray[j]);
                vector.add(outboundInfoImpl);
                if (outboundInfo == null) continue;
                outboundInfoImpl.setBaseOutboundInfo(outboundInfo);
            }
        }
        return vector;
    }

    public OutboundInfo getOutboundInfo(String string) {
        OutboundInfo outboundInfo = null;
        List list = this.getOutboundInfos();
        Iterator iterator = list.iterator();
        OutboundInfo outboundInfo2 = null;
        while (iterator.hasNext()) {
            outboundInfo2 = (OutboundInfo)iterator.next();
            if (!outboundInfo2.getKey().equals(string)) continue;
            outboundInfo = outboundInfo2;
            break;
        }
        return outboundInfo;
    }

    public List getInboundInfos() throws ElementNotFoundException {
        Debug.println(this, ".getInboundInfos()");
        if (this.inboundInfos == null) {
            Debug.println(this, ".getInboundInfos() computing/caching InboundInfos");
            MessageListenerBean[] messageListenerBeanArray = this.getMessageListeners();
            this.inboundInfos = new Vector();
            Debug.println(this, ".getInboundInfos() found " + messageListenerBeanArray.length + " MessageListeners");
            for (int i = 0; i < messageListenerBeanArray.length; ++i) {
                Debug.println(this, ".getInboundInfos() creating InboundInfoImpl for listener: '" + this.msgListeners[i] + "'");
                InboundInfoImpl inboundInfoImpl = new InboundInfoImpl(this, this.msgListeners[i]);
                this.inboundInfos.add(inboundInfoImpl);
            }
        }
        return this.inboundInfos;
    }

    public String getRADescription() {
        String string = null;
        String[] stringArray = this.connBean.getDescriptions();
        if (stringArray.length != 0) {
            string = stringArray[0];
        }
        return string;
    }

    public String getDisplayName() {
        String string = null;
        String[] stringArray = this.connBean.getDisplayNames();
        if (stringArray.length != 0) {
            string = stringArray[0];
        }
        return string;
    }

    public String getSmallIcon() {
        String string = null;
        IconBean[] iconBeanArray = this.connBean.getIcons();
        if (iconBeanArray.length != 0) {
            string = iconBeanArray[0].getSmallIcon();
        }
        return string;
    }

    public String getLargeIcon() {
        String string = null;
        IconBean[] iconBeanArray = this.connBean.getIcons();
        if (iconBeanArray.length != 0) {
            string = iconBeanArray[0].getLargeIcon();
        }
        return string;
    }

    public String getVendorName() {
        return this.connBean.getVendorName();
    }

    public String getEisType() {
        return this.connBean != null ? this.connBean.getEisType() : null;
    }

    public String getRAVersion() {
        return this.connBean.getResourceAdapterVersion();
    }

    public String getLicenseDescription() {
        String[] stringArray;
        String string = null;
        if (this.connBean.getLicense() == null) {
            Debug.throwAssertionError("connBean.getLicense() == null");
        }
        if ((stringArray = this.connBean.getLicense().getDescriptions()) != null && stringArray.length != 0) {
            string = stringArray[0];
        }
        return string;
    }

    public String[] getLicenseDescriptions() {
        if (this.connBean.getLicense() == null) {
            Debug.throwAssertionError("connBean.getLicense() == null");
        }
        return this.connBean.getLicense().getDescriptions();
    }

    public boolean getLicenseRequired() {
        if (this.connBean.getLicense() == null) {
            Debug.throwAssertionError("connBean.getLicense() == null");
        }
        return this.connBean.getLicense().isLicenseRequired();
    }

    public String getRAClass() {
        return this.getRABean().getResourceAdapterClass();
    }

    public List getAdminObjs() {
        Vector<AdminObjInfoImpl> vector = new Vector<AdminObjInfoImpl>();
        AdminObjectBean[] adminObjectBeanArray = this.getRABean().getAdminObjects();
        AdminObjectsBean adminObjectsBean = this.wlConnBean.getAdminObjects();
        if (adminObjectsBean != null) {
            AdminObjectGroupBean[] adminObjectGroupBeanArray = adminObjectsBean.getAdminObjectGroups();
            for (int i = 0; i < adminObjectBeanArray.length; ++i) {
                AdminObjectGroupBean adminObjectGroupBean = this.getAdminObjectGroup(adminObjectBeanArray[i], adminObjectGroupBeanArray);
                if (adminObjectGroupBean == null || adminObjectGroupBean.getAdminObjectInstances() == null || adminObjectGroupBean.getAdminObjectInstances().length == 0) continue;
                AdminObjectInstanceBean[] adminObjectInstanceBeanArray = adminObjectGroupBean.getAdminObjectInstances();
                for (int j = 0; j < adminObjectInstanceBeanArray.length; ++j) {
                    AdminObjInfoImpl adminObjInfoImpl = new AdminObjInfoImpl(adminObjectBeanArray[i], adminObjectInstanceBeanArray[j], this.wlConnBean, adminObjectGroupBean);
                    vector.add(adminObjInfoImpl);
                }
            }
        }
        return vector;
    }

    public String getNativeLibDir() {
        if (this.wlConnBean != null) {
            return this.wlConnBean.getNativeLibdir();
        }
        return this.getDefaultNativeLibDir();
    }

    private Hashtable getWLRAConfigPropertyOverrides() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        weblogic.j2ee.descriptor.wl.ConfigPropertyBean[] configPropertyBeanArray = null;
        if (this.wlConnBean != null && this.wlConnBean.getProperties() != null) {
            configPropertyBeanArray = this.wlConnBean.getProperties().getProperties();
        }
        int n = configPropertyBeanArray != null ? configPropertyBeanArray.length : 0;
        for (int i = 0; i < n; ++i) {
            String string = new String(configPropertyBeanArray[i].getName()).toLowerCase();
            hashtable.put(string, configPropertyBeanArray[i].getValue());
        }
        return hashtable;
    }

    public Hashtable getRAConfigProps() {
        ConfigPropertyBean[] configPropertyBeanArray = this.getRABean().getConfigProperties();
        Hashtable hashtable = this.getWLRAConfigPropertyOverrides();
        if (configPropertyBeanArray == null) {
            return null;
        }
        Hashtable<String, ConfigPropInfoImpl> hashtable2 = new Hashtable<String, ConfigPropInfoImpl>();
        for (int i = 0; i < configPropertyBeanArray.length; ++i) {
            String string = new String(configPropertyBeanArray[i].getConfigPropertyName()).toLowerCase();
            String string2 = (String)hashtable.get(string);
            if (string2 == null) {
                string2 = configPropertyBeanArray[i].getConfigPropertyValue();
            }
            ConfigPropInfoImpl configPropInfoImpl = new ConfigPropInfoImpl(configPropertyBeanArray[i], string2);
            if (string == null) continue;
            hashtable2.put(string, configPropInfoImpl);
        }
        return hashtable2;
    }

    public String getLinkref() {
        String string = null;
        if (this.isPreDiabloRA() && ((WeblogicConnectorExtensionBean)this.wlConnBean).getLinkRef() != null) {
            string = ((WeblogicConnectorExtensionBean)this.wlConnBean).getLinkRef().getRaLinkRef();
        }
        return string;
    }

    public String getConnectionFactoryName() {
        String string = null;
        if (this.isPreDiabloRA() && ((WeblogicConnectorExtensionBean)this.wlConnBean).getLinkRef() != null) {
            string = ((WeblogicConnectorExtensionBean)this.wlConnBean).getLinkRef().getConnectionFactoryName();
        }
        return string;
    }

    public String getSpecVersion() {
        if (this.connBean.getVersion() == null) {
            Debug.throwAssertionError("connBean.getVersion() == null");
        }
        return this.connBean.getVersion().toString();
    }

    public String getJndiName() {
        return this.wlConnBean.getJNDIName();
    }

    public List getSecurityPermissions() {
        SecurityPermissionBean[] securityPermissionBeanArray = this.getRABean().getSecurityPermissions();
        Vector<SecurityPermissionInfoImpl> vector = new Vector<SecurityPermissionInfoImpl>();
        if (securityPermissionBeanArray != null) {
            for (int i = 0; i < securityPermissionBeanArray.length; ++i) {
                vector.add(new SecurityPermissionInfoImpl(securityPermissionBeanArray[i]));
            }
        }
        return vector;
    }

    public SecurityIdentityInfo getSecurityIdentityInfo() {
        ResourceAdapterSecurityBean resourceAdapterSecurityBean = this.wlConnBean.getSecurity();
        if (resourceAdapterSecurityBean != null) {
            return new SecurityIdentityInfoImpl(resourceAdapterSecurityBean);
        }
        return null;
    }

    public URL getURL() {
        return this.url;
    }

    public boolean isEnableAccessOutsideApp() {
        return this.wlConnBean.isEnableAccessOutsideApp();
    }

    public boolean isEnableGlobalAccessToClasses() {
        return this.wlConnBean.isEnableGlobalAccessToClasses();
    }

    public WorkManagerBean getWorkManager() {
        return this.workManagerBean;
    }

    private AdminObjectGroupBean getAdminObjectGroup(AdminObjectBean adminObjectBean, AdminObjectGroupBean[] adminObjectGroupBeanArray) {
        AdminObjectGroupBean adminObjectGroupBean = null;
        for (int i = 0; adminObjectGroupBeanArray != null && i < adminObjectGroupBeanArray.length; ++i) {
            if (!adminObjectGroupBeanArray[i].getAdminObjectInterface().equals(adminObjectBean.getAdminObjectInterface())) continue;
            adminObjectGroupBean = adminObjectGroupBeanArray[i];
        }
        return adminObjectGroupBean;
    }

    private ConnectionDefinitionBean getConnectionDefnRef(weblogic.j2ee.descriptor.ConnectionDefinitionBean connectionDefinitionBean, ConnectorBean connectorBean, WeblogicConnectorBean weblogicConnectorBean) {
        ConnectionDefinitionBean connectionDefinitionBean2 = null;
        ConnectionDefinitionBean[] connectionDefinitionBeanArray = null;
        if (connectionDefinitionBean == null) {
            Debug.println(this, ".getConnectionDefnRef(): argument ConnectorDefinitionBean (connDefn) is null; returning null ConnectionDefinitionBean");
            return null;
        }
        if (connectorBean == null) {
            Debug.println(this, ".getConnectionDefnRef(): argument ConnectorBean (connBean) == null; returning null ConnectionDefinitionBean");
            return null;
        }
        if (weblogicConnectorBean == null) {
            Debug.println(this, ".getConnectionDefnRef(): argument WeblogicConnectorBean (wlConnBean) == null; returning null ConnectionDefinitionBean");
            return null;
        }
        OutboundResourceAdapterBean outboundResourceAdapterBean = this.getWeblogicOutboundRABean();
        if (outboundResourceAdapterBean == null) {
            Debug.println(this, ".getConnectionDefnRef(): getWeblogicOutboundRABean() is null; returning null ConnectionDefinitionBean");
            return null;
        }
        connectionDefinitionBeanArray = outboundResourceAdapterBean.getConnectionDefinitionGroups();
        if (this.isPreDiabloRA()) {
            if (connectionDefinitionBeanArray == null || connectionDefinitionBeanArray.length == 1) {
                Debug.println(this, ".getConnectionDefnRef() found " + (connectionDefinitionBeanArray == null ? 0 : connectionDefinitionBeanArray.length) + " connection factory(ies).  There should be exactly 1.  Returning the first one or null.");
                return connectionDefinitionBeanArray == null ? null : connectionDefinitionBeanArray[0];
            }
        } else {
            String string = connectionDefinitionBean.getConnectionFactoryInterface();
            Debug.println(this, ".getConnectionDefnRef() looking for a WL conn defn with connection factory interface = '" + string + "'");
            if (string == null || string.trim().equals("")) {
                Debug.println(this, ".getConnectionDefnRef() found an null or empty string as the ConnectionFactoryInteface on the connection definition.  Returning a null ConnectionDefinitionBean");
                return null;
            }
            for (int i = 0; connectionDefinitionBeanArray != null && i < connectionDefinitionBeanArray.length; ++i) {
                String string2 = connectionDefinitionBeanArray[i].getConnectionFactoryInterface();
                if (string2.equals(string)) {
                    Debug.println(this, ".getConnectionDefnRef() found a WL conn defn with connection factory interface = '" + string + "'");
                    connectionDefinitionBean2 = connectionDefinitionBeanArray[i];
                    break;
                }
                Debug.println(this, ".getConnectionDefnRef() looking for a WL conn defn with connection factory interface = '" + string + "' but found one with '" + string2 + "' instead. " + (i + 1 < connectionDefinitionBeanArray.length ? "Still looking." : "Done looking."));
            }
        }
        return connectionDefinitionBean2;
    }

    private String getDefaultNativeLibDir() {
        return DEFAULT_NATIVE_LIBDIR;
    }

    public ConnectorBean getConnectorBean() {
        return this.connBean;
    }

    private boolean isPreDiabloRA() {
        return this.wlConnBean instanceof WeblogicConnectorExtensionBean;
    }

    private ResourceAdapterBean getRABean() {
        Debug.println(this, ".getRABean()");
        if (this.raBean == null) {
            this.raBean = this.connBean.getResourceAdapter();
        }
        Debug.println(this, ".getRABean() returning " + (this.raBean != null ? "non-null" : "null"));
        if (this.raBean != null) {
            Debug.println(this, ".getRABean().getResourceAdapterClass() = " + this.raBean.getResourceAdapterClass());
        }
        return this.raBean;
    }

    private weblogic.j2ee.descriptor.OutboundResourceAdapterBean getOutboundRABean() {
        if (this.outboundRABean == null) {
            this.outboundRABean = this.getRABean().getOutboundResourceAdapter();
        }
        return this.outboundRABean;
    }

    private OutboundResourceAdapterBean getWeblogicOutboundRABean() {
        if (this.wlOutboundRABean == null) {
            this.wlOutboundRABean = this.wlConnBean.getOutboundResourceAdapter();
            if (this.wlOutboundRABean == null) {
                this.wlOutboundRABean = this.wlConnBean.createOutboundResourceAdapter();
            }
        }
        return this.wlOutboundRABean;
    }

    private InboundResourceAdapterBean getInboundRABean() {
        Debug.println(this, ".getInboundRABean()");
        if (this.inboundRABean == null) {
            this.inboundRABean = this.getRABean().getInboundResourceAdapter();
        }
        Debug.println(this, ".getInboundRABean() returning " + (this.inboundRABean != null ? "non-null" : "null"));
        return this.inboundRABean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageListenerBean[] getMessageListeners() throws ElementNotFoundException {
        InboundResourceAdapterBean inboundResourceAdapterBean;
        Debug.enter(this, "getMessageListeners()");
        try {
            if (this.msgListeners == null) {
                Debug.println(this, ".getMessageListeners() computing/caching MessageListeners");
                inboundResourceAdapterBean = this.getInboundRABean();
                if (inboundResourceAdapterBean == null) {
                    Debug.println(this, ".getMessageListeners() found no InboundResourceAdapter");
                    String string = Debug.getExceptionNoInboundRAElement();
                    throw new ElementNotFoundException(string);
                }
                MessageAdapterBean messageAdapterBean = inboundResourceAdapterBean.getMessageAdapter();
                if (messageAdapterBean == null) {
                    Debug.println(this, ".getMessageListeners() found no MessageAdapter");
                    String string = Debug.getExceptionNoMessageAdapterElement();
                    throw new ElementNotFoundException(string);
                }
                this.msgListeners = messageAdapterBean.getMessageListeners();
                if (this.msgListeners == null) {
                    Debug.println(this, ".getMessageListeners() found no message listeners");
                    String string = Debug.getExceptionNoMessageListenerElement();
                    throw new IllegalStateException(string);
                }
            }
            inboundResourceAdapterBean = this.msgListeners;
            Object var5_6 = null;
            Debug.println(this, ".getMessageListeners() returning " + (this.msgListeners != null ? this.msgListeners.length : 0) + " listeners.");
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            Debug.println(this, ".getMessageListeners() returning " + (this.msgListeners != null ? this.msgListeners.length : 0) + " listeners.");
            throw throwable;
        }
        return inboundResourceAdapterBean;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String[] getRADescriptions() {
        return this.connBean.getDescriptions();
    }

    public Hashtable getConnectionGroupConfigProperties(String string) {
        Hashtable hashtable = this.getRAConnectionDefinitionProperties(string);
        Hashtable hashtable2 = this.getWLDefaultOutboundProperties();
        Hashtable hashtable3 = this.getWLConnectionDefinitionProperties(string);
        Hashtable hashtable4 = this.getOverriddenConfigProperties(hashtable, hashtable2, hashtable3);
        return hashtable4;
    }

    public String getConnectionGroupTransactionSupport(String string) {
        String string2 = null;
        String string3 = this.getOutboundRABean() != null ? this.getOutboundRABean().getTransactionSupport() : null;
        String string4 = this.getWLDefaultTransactionSupport();
        String string5 = this.getWLGroupTransactionSupport(string);
        string2 = string5 != null && string5.length() > 0 ? string5 : (string4 != null && string4.length() > 0 ? string4 : string3);
        return string2;
    }

    public String getConnectionGroupResAuth(String string) {
        String string2 = null;
        String string3 = this.getWLDefaultResAuth();
        String string4 = this.getWLGroupResAuth(string);
        if (string4 != null && string4.length() > 0) {
            string2 = string4;
        } else if (string3 != null && string3.length() > 0) {
            string2 = string3;
        }
        return string2;
    }

    public boolean isConnectionGroupReauthenticationSupport(String string) {
        boolean bl = this.getOutboundRABean() != null ? this.getOutboundRABean().isReauthenticationSupport() : false;
        String string2 = this.getWLDefaultReauthenticationSupport();
        String string3 = this.getWLGroupReauthenticationSupport(string);
        boolean bl2 = string3 != null && string3.length() > 0 ? Boolean.valueOf(string3) : (string2 != null && string2.length() > 0 ? Boolean.valueOf(string2) : bl);
        return bl2;
    }

    public AuthMechInfo[] getConnectionGroupAuthenticationMechanisms(String string) {
        AuthMechInfo[] authMechInfoArray = new AuthMechInfo[]{};
        AuthMechInfo[] authMechInfoArray2 = this.getRAAuthenticationMechanisms();
        AuthMechInfo[] authMechInfoArray3 = this.getWLDefaultAuthenticationMechanisms();
        AuthMechInfo[] authMechInfoArray4 = this.getWLGroupAuthenticationMechanisms(string);
        authMechInfoArray = authMechInfoArray4 != null && authMechInfoArray4.length > 0 ? authMechInfoArray4 : (authMechInfoArray3 != null && authMechInfoArray3.length > 0 ? authMechInfoArray3 : authMechInfoArray2);
        return authMechInfoArray;
    }

    public LoggingInfo getConnectionGroupLoggingProperties(String string) {
        ConnectionDefinitionPropertiesBean connectionDefinitionPropertiesBean = this.getWeblogicOutboundRABean().getDefaultConnectionProperties();
        if (connectionDefinitionPropertiesBean == null) {
            connectionDefinitionPropertiesBean = this.getWeblogicOutboundRABean().createDefaultConnectionProperties();
        }
        if (connectionDefinitionPropertiesBean.getLogging() == null) {
            connectionDefinitionPropertiesBean.createLogging();
        }
        ConnectionDefinitionBean connectionDefinitionBean = this.getWLConnectionDefinition(string);
        ConnectionDefinitionPropertiesBean connectionDefinitionPropertiesBean2 = null;
        if (connectionDefinitionBean != null) {
            connectionDefinitionPropertiesBean2 = connectionDefinitionBean.getDefaultConnectionProperties();
        }
        String string2 = connectionDefinitionPropertiesBean.getLogging().getLogFilename();
        boolean bl = connectionDefinitionPropertiesBean.getLogging().isLoggingEnabled();
        String string3 = connectionDefinitionPropertiesBean.getLogging().getRotationType();
        String string4 = connectionDefinitionPropertiesBean.getLogging().getRotationTime();
        boolean bl2 = connectionDefinitionPropertiesBean.getLogging().isNumberOfFilesLimited();
        int n = connectionDefinitionPropertiesBean.getLogging().getFileCount();
        int n2 = connectionDefinitionPropertiesBean.getLogging().getFileSizeLimit();
        int n3 = connectionDefinitionPropertiesBean.getLogging().getFileTimeSpan();
        boolean bl3 = connectionDefinitionPropertiesBean.getLogging().isRotateLogOnStartup();
        String string5 = connectionDefinitionPropertiesBean.getLogging().getLogFileRotationDir();
        if (connectionDefinitionPropertiesBean2 != null && connectionDefinitionPropertiesBean2.getLogging() != null) {
            if (((DescriptorBean)connectionDefinitionPropertiesBean2.getLogging()).isSet("LogFilename")) {
                string2 = connectionDefinitionPropertiesBean2.getLogging().getLogFilename();
            }
            if (((DescriptorBean)connectionDefinitionPropertiesBean2.getLogging()).isSet("LoggingEnabled")) {
                bl = connectionDefinitionPropertiesBean2.getLogging().isLoggingEnabled();
            }
            if (((DescriptorBean)connectionDefinitionPropertiesBean2.getLogging()).isSet("RotationType")) {
                string3 = connectionDefinitionPropertiesBean2.getLogging().getRotationType();
            }
            if (((DescriptorBean)connectionDefinitionPropertiesBean2.getLogging()).isSet("RotationTime")) {
                string4 = connectionDefinitionPropertiesBean2.getLogging().getRotationTime();
            }
            if (((DescriptorBean)connectionDefinitionPropertiesBean2.getLogging()).isSet("NumberOfFilesLimited")) {
                bl2 = connectionDefinitionPropertiesBean2.getLogging().isNumberOfFilesLimited();
            }
            if (((DescriptorBean)connectionDefinitionPropertiesBean2.getLogging()).isSet("FileCount")) {
                n = connectionDefinitionPropertiesBean2.getLogging().getFileCount();
            }
            if (((DescriptorBean)connectionDefinitionPropertiesBean2.getLogging()).isSet("FileSizeLimit")) {
                n2 = connectionDefinitionPropertiesBean2.getLogging().getFileSizeLimit();
            }
            if (((DescriptorBean)connectionDefinitionPropertiesBean2.getLogging()).isSet("FileTimeSpan")) {
                n3 = connectionDefinitionPropertiesBean2.getLogging().getFileTimeSpan();
            }
            if (((DescriptorBean)connectionDefinitionPropertiesBean2.getLogging()).isSet("RotateLogOnStartup")) {
                bl3 = connectionDefinitionPropertiesBean2.getLogging().isRotateLogOnStartup();
            }
            if (((DescriptorBean)connectionDefinitionPropertiesBean2.getLogging()).isSet("LogFileRotationDir")) {
                string5 = connectionDefinitionPropertiesBean2.getLogging().getLogFileRotationDir();
            }
        }
        return new LoggingInfoImpl(string2, bl, string3, string4, bl2, n, n2, n3, bl3, string5);
    }

    public PoolInfo getConnectionGroupPoolProperties(String string) {
        ConnectionDefinitionPropertiesBean connectionDefinitionPropertiesBean = null;
        connectionDefinitionPropertiesBean = this.getWeblogicOutboundRABean().getDefaultConnectionProperties();
        if (connectionDefinitionPropertiesBean == null) {
            connectionDefinitionPropertiesBean = this.getWeblogicOutboundRABean().createDefaultConnectionProperties();
        }
        if (connectionDefinitionPropertiesBean.getPoolParams() == null) {
            connectionDefinitionPropertiesBean.createPoolParams();
        }
        ConnectionDefinitionBean connectionDefinitionBean = this.getWLConnectionDefinition(string);
        ConnectionDefinitionPropertiesBean connectionDefinitionPropertiesBean2 = null;
        if (connectionDefinitionBean != null) {
            connectionDefinitionPropertiesBean2 = connectionDefinitionBean.getDefaultConnectionProperties();
        }
        int n = connectionDefinitionPropertiesBean.getPoolParams().getInitialCapacity();
        int n2 = connectionDefinitionPropertiesBean.getPoolParams().getMaxCapacity();
        int n3 = connectionDefinitionPropertiesBean.getPoolParams().getCapacityIncrement();
        boolean bl = connectionDefinitionPropertiesBean.getPoolParams().isShrinkingEnabled();
        int n4 = connectionDefinitionPropertiesBean.getPoolParams().getShrinkFrequencySeconds();
        int n5 = connectionDefinitionPropertiesBean.getPoolParams().getHighestNumWaiters();
        int n6 = connectionDefinitionPropertiesBean.getPoolParams().getHighestNumUnavailable();
        int n7 = connectionDefinitionPropertiesBean.getPoolParams().getConnectionCreationRetryFrequencySeconds();
        int n8 = connectionDefinitionPropertiesBean.getPoolParams().getConnectionReserveTimeoutSeconds();
        int n9 = connectionDefinitionPropertiesBean.getPoolParams().getTestFrequencySeconds();
        boolean bl2 = connectionDefinitionPropertiesBean.getPoolParams().isTestConnectionsOnCreate();
        boolean bl3 = connectionDefinitionPropertiesBean.getPoolParams().isTestConnectionsOnRelease();
        boolean bl4 = connectionDefinitionPropertiesBean.getPoolParams().isTestConnectionsOnReserve();
        int n10 = connectionDefinitionPropertiesBean.getPoolParams().getProfileHarvestFrequencySeconds();
        boolean bl5 = connectionDefinitionPropertiesBean.getPoolParams().isIgnoreInUseConnectionsEnabled();
        boolean bl6 = connectionDefinitionPropertiesBean.getPoolParams().isMatchConnectionsSupported();
        if (connectionDefinitionPropertiesBean2 != null && connectionDefinitionPropertiesBean2.getPoolParams() != null) {
            if (((DescriptorBean)connectionDefinitionPropertiesBean2.getPoolParams()).isSet("InitialCapacity")) {
                n = connectionDefinitionPropertiesBean2.getPoolParams().getInitialCapacity();
            }
            if (((DescriptorBean)connectionDefinitionPropertiesBean2.getPoolParams()).isSet("MaxCapacity")) {
                n2 = connectionDefinitionPropertiesBean2.getPoolParams().getMaxCapacity();
            }
            if (((DescriptorBean)connectionDefinitionPropertiesBean2.getPoolParams()).isSet("CapacityIncrement")) {
                n3 = connectionDefinitionPropertiesBean2.getPoolParams().getCapacityIncrement();
            }
            if (((DescriptorBean)connectionDefinitionPropertiesBean2.getPoolParams()).isSet("ShrinkingEnabled")) {
                bl = connectionDefinitionPropertiesBean2.getPoolParams().isShrinkingEnabled();
            }
            if (((DescriptorBean)connectionDefinitionPropertiesBean2.getPoolParams()).isSet("ShrinkFrequencySeconds")) {
                n4 = connectionDefinitionPropertiesBean2.getPoolParams().getShrinkFrequencySeconds();
            }
            if (((DescriptorBean)connectionDefinitionPropertiesBean2.getPoolParams()).isSet("HighestNumWaiters")) {
                n5 = connectionDefinitionPropertiesBean2.getPoolParams().getHighestNumWaiters();
            }
            if (((DescriptorBean)connectionDefinitionPropertiesBean2.getPoolParams()).isSet("HighestNumUnavailable")) {
                n6 = connectionDefinitionPropertiesBean2.getPoolParams().getHighestNumUnavailable();
            }
            if (((DescriptorBean)connectionDefinitionPropertiesBean2.getPoolParams()).isSet("ConnectionCreationRetryFrequencySeconds")) {
                n7 = connectionDefinitionPropertiesBean2.getPoolParams().getConnectionCreationRetryFrequencySeconds();
            }
            if (((DescriptorBean)connectionDefinitionPropertiesBean2.getPoolParams()).isSet("ConnectionReserveTimeoutSeconds")) {
                n8 = connectionDefinitionPropertiesBean2.getPoolParams().getConnectionReserveTimeoutSeconds();
            }
            if (((DescriptorBean)connectionDefinitionPropertiesBean2.getPoolParams()).isSet("TestFrequencySeconds")) {
                n9 = connectionDefinitionPropertiesBean2.getPoolParams().getTestFrequencySeconds();
            }
            if (((DescriptorBean)connectionDefinitionPropertiesBean2.getPoolParams()).isSet("TestConnectionsOnCreate")) {
                bl2 = connectionDefinitionPropertiesBean2.getPoolParams().isTestConnectionsOnCreate();
            }
            if (((DescriptorBean)connectionDefinitionPropertiesBean2.getPoolParams()).isSet("TestConnectionsOnRelease")) {
                bl3 = connectionDefinitionPropertiesBean2.getPoolParams().isTestConnectionsOnRelease();
            }
            if (((DescriptorBean)connectionDefinitionPropertiesBean2.getPoolParams()).isSet("TestConnectionsOnReserve")) {
                bl4 = connectionDefinitionPropertiesBean2.getPoolParams().isTestConnectionsOnReserve();
            }
            if (((DescriptorBean)connectionDefinitionPropertiesBean2.getPoolParams()).isSet("ProfileHarvestFrequencySeconds")) {
                n10 = connectionDefinitionPropertiesBean2.getPoolParams().getProfileHarvestFrequencySeconds();
            }
            if (((DescriptorBean)connectionDefinitionPropertiesBean2.getPoolParams()).isSet("IgnoreInUseConnectionsEnabled")) {
                bl5 = connectionDefinitionPropertiesBean2.getPoolParams().isIgnoreInUseConnectionsEnabled();
            }
            if (((DescriptorBean)connectionDefinitionPropertiesBean2.getPoolParams()).isSet("MatchConnectionsSupported")) {
                bl6 = connectionDefinitionPropertiesBean2.getPoolParams().isMatchConnectionsSupported();
            }
        }
        return new PoolInfoImpl(n, n2, n3, bl, n4, n5, n6, n7, n8, n9, bl2, bl3, bl4, n10, bl5, bl6);
    }

    public Hashtable getAdminObjectGroupProperties(String string) {
        Hashtable hashtable = this.getRAAdminProperties(string);
        if (hashtable.size() == 0) {
            return hashtable;
        }
        Hashtable hashtable2 = this.getGlobalAdminProperties();
        Hashtable hashtable3 = this.getGroupAdminProperties(string);
        return this.getOverriddenConfigProperties(hashtable, hashtable2, hashtable3);
    }

    public AdminObjInfo getAdminObject(String string) {
        AdminObjectBean[] adminObjectBeanArray = this.getRABean().getAdminObjects();
        AdminObjectsBean adminObjectsBean = this.wlConnBean.getAdminObjects();
        AdminObjInfoImpl adminObjInfoImpl = null;
        if (adminObjectsBean != null) {
            AdminObjectGroupBean[] adminObjectGroupBeanArray = adminObjectsBean.getAdminObjectGroups();
            block0: for (int i = 0; i < adminObjectBeanArray.length; ++i) {
                AdminObjectGroupBean adminObjectGroupBean = this.getAdminObjectGroup(adminObjectBeanArray[i], adminObjectGroupBeanArray);
                if (adminObjectGroupBean == null || adminObjectGroupBean.getAdminObjectInstances() == null || adminObjectGroupBean.getAdminObjectInstances().length == 0) continue;
                AdminObjectInstanceBean[] adminObjectInstanceBeanArray = adminObjectGroupBean.getAdminObjectInstances();
                for (int j = 0; j < adminObjectInstanceBeanArray.length; ++j) {
                    String string2 = adminObjectInstanceBeanArray[j].getJNDIName();
                    if (string2 == null || !string2.equals(string)) continue;
                    adminObjInfoImpl = new AdminObjInfoImpl(adminObjectBeanArray[i], adminObjectInstanceBeanArray[j], this.wlConnBean, adminObjectGroupBean);
                    continue block0;
                }
            }
        }
        return adminObjInfoImpl;
    }

    private String getWLDefaultTransactionSupport() {
        String string = null;
        ConnectionDefinitionPropertiesBean connectionDefinitionPropertiesBean = this.getWeblogicOutboundRABean().getDefaultConnectionProperties();
        if (connectionDefinitionPropertiesBean != null) {
            string = connectionDefinitionPropertiesBean.getTransactionSupport();
        }
        return string;
    }

    private String getWLDefaultResAuth() {
        String string = null;
        ConnectionDefinitionPropertiesBean connectionDefinitionPropertiesBean = this.getWeblogicOutboundRABean().getDefaultConnectionProperties();
        if (connectionDefinitionPropertiesBean != null) {
            string = connectionDefinitionPropertiesBean.getResAuth();
        }
        return string;
    }

    private String getWLDefaultReauthenticationSupport() {
        String string = null;
        ConnectionDefinitionPropertiesBean connectionDefinitionPropertiesBean = this.getWeblogicOutboundRABean().getDefaultConnectionProperties();
        if (connectionDefinitionPropertiesBean != null && ((DescriptorBean)connectionDefinitionPropertiesBean).isSet("ReauthenticationSupport")) {
            string = String.valueOf(connectionDefinitionPropertiesBean.isReauthenticationSupport());
        }
        return string;
    }

    private String getWLGroupTransactionSupport(String string) {
        ConnectionDefinitionPropertiesBean connectionDefinitionPropertiesBean;
        String string2 = null;
        ConnectionDefinitionBean connectionDefinitionBean = this.getWLConnectionDefinition(string);
        if (connectionDefinitionBean != null && (connectionDefinitionPropertiesBean = connectionDefinitionBean.getDefaultConnectionProperties()) != null) {
            string2 = connectionDefinitionPropertiesBean.getTransactionSupport();
        }
        return string2;
    }

    private String getWLGroupResAuth(String string) {
        ConnectionDefinitionPropertiesBean connectionDefinitionPropertiesBean;
        String string2 = null;
        ConnectionDefinitionBean connectionDefinitionBean = this.getWLConnectionDefinition(string);
        if (connectionDefinitionBean != null && (connectionDefinitionPropertiesBean = connectionDefinitionBean.getDefaultConnectionProperties()) != null) {
            string2 = connectionDefinitionPropertiesBean.getResAuth();
        }
        return string2;
    }

    private String getWLGroupReauthenticationSupport(String string) {
        ConnectionDefinitionPropertiesBean connectionDefinitionPropertiesBean;
        String string2 = null;
        ConnectionDefinitionBean connectionDefinitionBean = this.getWLConnectionDefinition(string);
        if (connectionDefinitionBean != null && (connectionDefinitionPropertiesBean = connectionDefinitionBean.getDefaultConnectionProperties()) != null && ((DescriptorBean)connectionDefinitionPropertiesBean).isSet("ReauthenticationSupport")) {
            string2 = String.valueOf(connectionDefinitionPropertiesBean.isReauthenticationSupport());
        }
        return string2;
    }

    private AuthMechInfo[] getRAAuthenticationMechanisms() {
        AuthMechInfo[] authMechInfoArray = new AuthMechInfo[]{};
        if (this.getOutboundRABean() != null) {
            AuthenticationMechanismBean[] authenticationMechanismBeanArray = this.getOutboundRABean().getAuthenticationMechanisms();
            authMechInfoArray = new AuthMechInfo[authenticationMechanismBeanArray.length];
            for (int i = 0; i < authenticationMechanismBeanArray.length; ++i) {
                authMechInfoArray[i] = new AuthMechInfoImpl(authenticationMechanismBeanArray[i]);
            }
        }
        return authMechInfoArray;
    }

    private AuthMechInfo[] getWLDefaultAuthenticationMechanisms() {
        AuthMechInfo[] authMechInfoArray = new AuthMechInfo[]{};
        ConnectionDefinitionPropertiesBean connectionDefinitionPropertiesBean = this.getWeblogicOutboundRABean().getDefaultConnectionProperties();
        if (connectionDefinitionPropertiesBean != null) {
            AuthenticationMechanismBean[] authenticationMechanismBeanArray = connectionDefinitionPropertiesBean.getAuthenticationMechanisms();
            authMechInfoArray = new AuthMechInfo[authenticationMechanismBeanArray.length];
            for (int i = 0; i < authenticationMechanismBeanArray.length; ++i) {
                authMechInfoArray[i] = new AuthMechInfoImpl(authenticationMechanismBeanArray[i]);
            }
        }
        return authMechInfoArray;
    }

    private AuthMechInfo[] getWLGroupAuthenticationMechanisms(String string) {
        ConnectionDefinitionPropertiesBean connectionDefinitionPropertiesBean;
        AuthMechInfo[] authMechInfoArray = new AuthMechInfo[]{};
        ConnectionDefinitionBean connectionDefinitionBean = this.getWLConnectionDefinition(string);
        if (connectionDefinitionBean != null && (connectionDefinitionPropertiesBean = connectionDefinitionBean.getDefaultConnectionProperties()) != null) {
            AuthenticationMechanismBean[] authenticationMechanismBeanArray = connectionDefinitionPropertiesBean.getAuthenticationMechanisms();
            authMechInfoArray = new AuthMechInfo[authenticationMechanismBeanArray.length];
            for (int i = 0; i < authenticationMechanismBeanArray.length; ++i) {
                authMechInfoArray[i] = new AuthMechInfoImpl(authenticationMechanismBeanArray[i]);
            }
        }
        return authMechInfoArray;
    }

    private Hashtable getOverriddenConfigProperties(Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3) {
        Hashtable<String, ConfigPropInfoImpl> hashtable4 = new Hashtable<String, ConfigPropInfoImpl>();
        for (ConfigPropertyBean configPropertyBean : hashtable.values()) {
            ConfigPropInfoImpl configPropInfoImpl;
            if (configPropertyBean == null || configPropertyBean.getConfigPropertyName() == null || configPropertyBean.getConfigPropertyName().length() <= 0) continue;
            weblogic.j2ee.descriptor.wl.ConfigPropertyBean configPropertyBean2 = (weblogic.j2ee.descriptor.wl.ConfigPropertyBean)hashtable2.get(configPropertyBean.getConfigPropertyName());
            weblogic.j2ee.descriptor.wl.ConfigPropertyBean configPropertyBean3 = (weblogic.j2ee.descriptor.wl.ConfigPropertyBean)hashtable3.get(configPropertyBean.getConfigPropertyName());
            if (configPropertyBean3 != null) {
                configPropInfoImpl = new ConfigPropInfoImpl(configPropertyBean, configPropertyBean3.getValue());
                hashtable4.put(configPropertyBean3.getName(), configPropInfoImpl);
                continue;
            }
            if (configPropertyBean2 != null) {
                configPropInfoImpl = new ConfigPropInfoImpl(configPropertyBean, configPropertyBean2.getValue());
                hashtable4.put(configPropertyBean2.getName(), configPropInfoImpl);
                continue;
            }
            configPropInfoImpl = new ConfigPropInfoImpl(configPropertyBean, configPropertyBean.getConfigPropertyValue());
            hashtable4.put(configPropertyBean.getConfigPropertyName(), configPropInfoImpl);
        }
        return hashtable4;
    }

    private weblogic.j2ee.descriptor.ConnectionDefinitionBean getRAConnectionDefinition(String string) {
        weblogic.j2ee.descriptor.ConnectionDefinitionBean connectionDefinitionBean = null;
        if (this.getOutboundRABean() != null) {
            weblogic.j2ee.descriptor.ConnectionDefinitionBean[] connectionDefinitionBeanArray = this.getOutboundRABean().getConnectionDefinitions();
            for (int i = 0; connectionDefinitionBeanArray != null && i < connectionDefinitionBeanArray.length; ++i) {
                if (!connectionDefinitionBeanArray[i].getConnectionFactoryInterface().equals(string)) continue;
                connectionDefinitionBean = connectionDefinitionBeanArray[i];
                break;
            }
        }
        return connectionDefinitionBean;
    }

    private ConnectionDefinitionBean getWLConnectionDefinition(String string) {
        ConnectionDefinitionBean connectionDefinitionBean = null;
        ConnectionDefinitionBean[] connectionDefinitionBeanArray = this.getWeblogicOutboundRABean().getConnectionDefinitionGroups();
        for (int i = 0; connectionDefinitionBeanArray != null && i < connectionDefinitionBeanArray.length; ++i) {
            if (!connectionDefinitionBeanArray[i].getConnectionFactoryInterface().equals(string)) continue;
            connectionDefinitionBean = connectionDefinitionBeanArray[i];
            break;
        }
        return connectionDefinitionBean;
    }

    private Hashtable getRAConnectionDefinitionProperties(String string) {
        Hashtable<String, ConfigPropertyBean> hashtable = new Hashtable<String, ConfigPropertyBean>();
        weblogic.j2ee.descriptor.ConnectionDefinitionBean connectionDefinitionBean = null;
        connectionDefinitionBean = this.getRAConnectionDefinition(string);
        if (connectionDefinitionBean != null) {
            ConfigPropertyBean[] configPropertyBeanArray = connectionDefinitionBean.getConfigProperties();
            for (int i = 0; i < configPropertyBeanArray.length; ++i) {
                if (configPropertyBeanArray[i].getConfigPropertyName() == null || configPropertyBeanArray[i].getConfigPropertyName().length() <= 0) continue;
                hashtable.put(configPropertyBeanArray[i].getConfigPropertyName(), configPropertyBeanArray[i]);
            }
        }
        return hashtable;
    }

    private Hashtable getWLDefaultOutboundProperties() {
        Hashtable<String, weblogic.j2ee.descriptor.wl.ConfigPropertyBean> hashtable = new Hashtable<String, weblogic.j2ee.descriptor.wl.ConfigPropertyBean>();
        ConnectionDefinitionPropertiesBean connectionDefinitionPropertiesBean = this.getWeblogicOutboundRABean().getDefaultConnectionProperties();
        if (connectionDefinitionPropertiesBean != null && connectionDefinitionPropertiesBean.getProperties() != null && connectionDefinitionPropertiesBean.getProperties().getProperties() != null) {
            weblogic.j2ee.descriptor.wl.ConfigPropertyBean[] configPropertyBeanArray = connectionDefinitionPropertiesBean.getProperties().getProperties();
            for (int i = 0; i < configPropertyBeanArray.length; ++i) {
                if (configPropertyBeanArray[i].getName() == null || configPropertyBeanArray[i].getName().length() <= 0) continue;
                hashtable.put(configPropertyBeanArray[i].getName(), configPropertyBeanArray[i]);
            }
        }
        return hashtable;
    }

    private Hashtable getWLConnectionDefinitionProperties(String string) {
        ConnectionDefinitionPropertiesBean connectionDefinitionPropertiesBean;
        Hashtable<String, weblogic.j2ee.descriptor.wl.ConfigPropertyBean> hashtable = new Hashtable<String, weblogic.j2ee.descriptor.wl.ConfigPropertyBean>();
        ConnectionDefinitionBean connectionDefinitionBean = null;
        connectionDefinitionBean = this.getWLConnectionDefinition(string);
        if (connectionDefinitionBean != null && (connectionDefinitionPropertiesBean = connectionDefinitionBean.getDefaultConnectionProperties()) != null && connectionDefinitionPropertiesBean.getProperties() != null && connectionDefinitionPropertiesBean.getProperties().getProperties() != null) {
            weblogic.j2ee.descriptor.wl.ConfigPropertyBean[] configPropertyBeanArray = connectionDefinitionPropertiesBean.getProperties().getProperties();
            for (int i = 0; i < configPropertyBeanArray.length; ++i) {
                if (configPropertyBeanArray[i].getName() == null || configPropertyBeanArray[i].getName().length() <= 0) continue;
                hashtable.put(configPropertyBeanArray[i].getName(), configPropertyBeanArray[i]);
            }
        }
        return hashtable;
    }

    private Hashtable getGroupAdminProperties(String string) {
        Hashtable<String, weblogic.j2ee.descriptor.wl.ConfigPropertyBean> hashtable = new Hashtable<String, weblogic.j2ee.descriptor.wl.ConfigPropertyBean>();
        if (string != null && string.trim().length() > 0 && this.wlConnBean.getAdminObjects() != null && this.wlConnBean.getAdminObjects().getAdminObjectGroups() != null) {
            AdminObjectGroupBean[] adminObjectGroupBeanArray = this.wlConnBean.getAdminObjects().getAdminObjectGroups();
            AdminObjectGroupBean adminObjectGroupBean = null;
            for (int i = 0; i < adminObjectGroupBeanArray.length; ++i) {
                adminObjectGroupBean = adminObjectGroupBeanArray[i];
                if (adminObjectGroupBean == null || !string.equals(adminObjectGroupBean.getAdminObjectInterface()) || adminObjectGroupBean.getDefaultProperties() == null || adminObjectGroupBean.getDefaultProperties().getProperties() == null) continue;
                weblogic.j2ee.descriptor.wl.ConfigPropertyBean[] configPropertyBeanArray = adminObjectGroupBean.getDefaultProperties().getProperties();
                weblogic.j2ee.descriptor.wl.ConfigPropertyBean configPropertyBean = null;
                for (int j = 0; j < configPropertyBeanArray.length; ++j) {
                    configPropertyBean = configPropertyBeanArray[j];
                    if (configPropertyBean == null) continue;
                    hashtable.put(configPropertyBean.getName(), configPropertyBean);
                }
            }
        }
        return hashtable;
    }

    private Hashtable getGlobalAdminProperties() {
        Hashtable<String, weblogic.j2ee.descriptor.wl.ConfigPropertyBean> hashtable = new Hashtable<String, weblogic.j2ee.descriptor.wl.ConfigPropertyBean>();
        if (this.wlConnBean.getAdminObjects() != null && this.wlConnBean.getAdminObjects().getDefaultProperties() != null && this.wlConnBean.getAdminObjects().getDefaultProperties().getProperties() != null) {
            weblogic.j2ee.descriptor.wl.ConfigPropertyBean[] configPropertyBeanArray = this.wlConnBean.getAdminObjects().getDefaultProperties().getProperties();
            weblogic.j2ee.descriptor.wl.ConfigPropertyBean configPropertyBean = null;
            for (int i = 0; i < configPropertyBeanArray.length; ++i) {
                configPropertyBean = configPropertyBeanArray[i];
                if (configPropertyBean == null) continue;
                hashtable.put(configPropertyBean.getName(), configPropertyBean);
            }
        }
        return hashtable;
    }

    private Hashtable getRAAdminProperties(String string) {
        ConfigPropertyBean[] configPropertyBeanArray = null;
        Hashtable<String, ConfigPropertyBean> hashtable = new Hashtable<String, ConfigPropertyBean>();
        if (string != null && string.trim().length() > 0 && this.connBean.getResourceAdapter() != null && this.connBean.getResourceAdapter().getAdminObjects() != null) {
            AdminObjectBean[] adminObjectBeanArray = this.connBean.getResourceAdapter().getAdminObjects();
            AdminObjectBean adminObjectBean = null;
            for (int i = 0; i < adminObjectBeanArray.length; ++i) {
                adminObjectBean = adminObjectBeanArray[i];
                if (adminObjectBean == null || !string.equals(adminObjectBean.getAdminObjectInterface()) || adminObjectBean.getConfigProperties() == null) continue;
                configPropertyBeanArray = adminObjectBean.getConfigProperties();
                for (int j = 0; j < configPropertyBeanArray.length; ++j) {
                    ConfigPropertyBean configPropertyBean = configPropertyBeanArray[j];
                    hashtable.put(configPropertyBean.getConfigPropertyName(), configPropertyBean);
                }
            }
        }
        return hashtable;
    }

    public void copyBaseRA(RAInfoImpl rAInfoImpl) {
        this.baseRA = rAInfoImpl.baseRA;
    }
}

