/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.external.impl;

import weblogic.connector.external.SecurityIdentityInfo;
import weblogic.j2ee.descriptor.wl.AnonPrincipalBean;
import weblogic.j2ee.descriptor.wl.AnonPrincipalCallerBean;
import weblogic.j2ee.descriptor.wl.ResourceAdapterSecurityBean;

public class SecurityIdentityInfoImpl
implements SecurityIdentityInfo {
    private ResourceAdapterSecurityBean raSecurityBean;

    public SecurityIdentityInfoImpl(ResourceAdapterSecurityBean resourceAdapterSecurityBean) {
        this.raSecurityBean = resourceAdapterSecurityBean;
    }

    public boolean useAnonForManageAs() {
        boolean bl = true;
        AnonPrincipalBean anonPrincipalBean = this.raSecurityBean.getManageAsPrincipalName();
        if (anonPrincipalBean != null) {
            return anonPrincipalBean.isUseAnonymousIdentity();
        }
        if (this.raSecurityBean.getDefaultPrincipalName() != null) {
            bl = this.useAnonForDefault();
        }
        return bl;
    }

    public boolean useAnonForRunAs() {
        boolean bl = false;
        AnonPrincipalCallerBean anonPrincipalCallerBean = this.raSecurityBean.getRunAsPrincipalName();
        if (anonPrincipalCallerBean != null) {
            return anonPrincipalCallerBean.isUseAnonymousIdentity();
        }
        if (this.raSecurityBean.getDefaultPrincipalName() != null) {
            bl = this.useAnonForDefault();
        }
        return bl;
    }

    public boolean useCallerForRunAs() {
        boolean bl = true;
        AnonPrincipalCallerBean anonPrincipalCallerBean = this.raSecurityBean.getRunAsPrincipalName();
        if (anonPrincipalCallerBean != null && !anonPrincipalCallerBean.isUseCallerIdentity()) {
            bl = false;
        }
        return bl;
    }

    public boolean useAnonForRunWorkAs() {
        boolean bl = false;
        AnonPrincipalCallerBean anonPrincipalCallerBean = this.raSecurityBean.getRunWorkAsPrincipalName();
        if (anonPrincipalCallerBean != null) {
            return anonPrincipalCallerBean.isUseAnonymousIdentity();
        }
        if (this.raSecurityBean.getDefaultPrincipalName() != null) {
            bl = this.useAnonForDefault();
        }
        return bl;
    }

    public boolean useCallerForRunWorkAs() {
        boolean bl = true;
        AnonPrincipalCallerBean anonPrincipalCallerBean = this.raSecurityBean.getRunWorkAsPrincipalName();
        if (anonPrincipalCallerBean != null && !anonPrincipalCallerBean.isUseCallerIdentity()) {
            bl = false;
        }
        return bl;
    }

    private boolean useAnonForDefault() {
        AnonPrincipalBean anonPrincipalBean = this.raSecurityBean.getDefaultPrincipalName();
        return anonPrincipalBean != null && anonPrincipalBean.isUseAnonymousIdentity();
    }

    public String getManageAsPrincipalName() {
        String string = this.getDefaultPrincipalName();
        AnonPrincipalBean anonPrincipalBean = this.raSecurityBean.getManageAsPrincipalName();
        if (anonPrincipalBean != null && anonPrincipalBean.getPrincipalName() != null) {
            string = anonPrincipalBean.getPrincipalName();
        }
        return string;
    }

    public String getRunAsPrincipalName() {
        String string = this.getDefaultPrincipalName();
        AnonPrincipalCallerBean anonPrincipalCallerBean = this.raSecurityBean.getRunAsPrincipalName();
        if (anonPrincipalCallerBean != null && anonPrincipalCallerBean.getPrincipalName() != null) {
            string = anonPrincipalCallerBean.getPrincipalName();
        }
        return string;
    }

    public String getRunWorkAsPrincipalName() {
        String string = this.getDefaultPrincipalName();
        AnonPrincipalCallerBean anonPrincipalCallerBean = this.raSecurityBean.getRunWorkAsPrincipalName();
        if (anonPrincipalCallerBean != null && anonPrincipalCallerBean.getPrincipalName() != null) {
            string = anonPrincipalCallerBean.getPrincipalName();
        }
        return string;
    }

    public String getDefaultPrincipalName() {
        AnonPrincipalBean anonPrincipalBean = this.raSecurityBean.getDefaultPrincipalName();
        if (anonPrincipalBean != null) {
            return anonPrincipalBean.getPrincipalName();
        }
        return null;
    }
}

