/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.inbound;

import com.bea.connector.diagnostic.EndpointType;
import com.bea.connector.diagnostic.InboundAdapterType;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.SystemException;
import weblogic.connector.common.ConnectorDiagnosticImageSource;
import weblogic.connector.common.Debug;
import weblogic.connector.common.RAInstanceManager;
import weblogic.connector.common.Utils;
import weblogic.connector.exception.RAInboundException;
import weblogic.connector.external.ElementNotFoundException;
import weblogic.connector.external.InboundInfo;
import weblogic.connector.external.SuspendableEndpointFactory;
import weblogic.connector.monitoring.ConnectorComponentRuntimeMBeanImpl;
import weblogic.connector.monitoring.inbound.ConnectorInboundRuntimeMBeanImpl;
import weblogic.connector.transaction.inbound.InboundRecoveryManager;
import weblogic.management.runtime.MessageDrivenEJBRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class RAInboundManager {
    private RAInstanceManager raInstanceMgr;
    private InboundRecoveryManager recoveryMgr;
    private Hashtable msgListenerToEndptFactoryMap;
    private Hashtable endptFactorySuspendStateMap;
    private Hashtable msgListenerToEJBMap;
    private Hashtable msgListenerToInboundRuntimeMap;
    private String state;
    private static final String RUNNING = Debug.getStringRunning();
    private static final String SUSPENDED = Debug.getStringSuspended();
    private boolean isInbound;

    public RAInboundManager(RAInstanceManager rAInstanceManager) throws RAInboundException {
        this.raInstanceMgr = rAInstanceManager;
        this.msgListenerToEndptFactoryMap = new Hashtable();
        this.msgListenerToEJBMap = new Hashtable();
        this.msgListenerToInboundRuntimeMap = new Hashtable();
        this.endptFactorySuspendStateMap = new Hashtable();
        this.recoveryMgr = new InboundRecoveryManager();
        this.state = RUNNING;
    }

    public void activate() throws RAInboundException {
    }

    public void deactivate() throws RAInboundException {
        this.stop();
    }

    public void rollback() throws RAInboundException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(Properties properties) throws RAInboundException {
        Debug.enter(this, "suspend(properties)");
        try {
            this.suspendOrResumeMEF(1, properties);
            this.state = SUSPENDED;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Debug.exit(this, "suspend(properties)");
            throw throwable;
        }
        Debug.exit(this, "suspend(properties)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(Properties properties) throws RAInboundException {
        Debug.enter(this, "resume(properties)");
        try {
            this.suspendOrResumeMEF(2, properties);
            this.state = RUNNING;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Debug.exit(this, "resume(properties)");
            throw throwable;
        }
        Debug.exit(this, "resume(properties)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws RAInboundException {
        Debug.enter(this, "stop()");
        RAInboundException rAInboundException = new RAInboundException();
        try {
            this.recoveryMgr.onRAStop(rAInboundException);
            this.disconnectMEFs(rAInboundException);
            if (!rAInboundException.isEmpty()) {
                throw rAInboundException;
            }
            Object var3_2 = null;
            this.msgListenerToEndptFactoryMap.clear();
            this.removeAllMDBRuntimeBeans();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.msgListenerToEndptFactoryMap.clear();
            this.removeAllMDBRuntimeBeans();
            Debug.exit(this, "stop()");
            throw throwable;
        }
        Debug.exit(this, "stop()");
    }

    private void removeAllMDBRuntimeBeans() {
        for (ConnectorInboundRuntimeMBeanImpl connectorInboundRuntimeMBeanImpl : this.msgListenerToInboundRuntimeMap.values()) {
            connectorInboundRuntimeMBeanImpl.removeAllMDBRuntimes();
        }
    }

    public void addEndpointFactory(String string, MessageEndpointFactory messageEndpointFactory, MessageDrivenEJBRuntimeMBean messageDrivenEJBRuntimeMBean) {
        List<MessageEndpointFactory> list = null;
        if (this.msgListenerToEndptFactoryMap.containsKey(string)) {
            list = (List)this.msgListenerToEndptFactoryMap.get(string);
        } else {
            list = new Vector();
            this.msgListenerToEndptFactoryMap.put(string, list);
        }
        list.add(messageEndpointFactory);
        this.endptFactorySuspendStateMap.put(messageEndpointFactory, Boolean.FALSE);
        ConnectorInboundRuntimeMBeanImpl connectorInboundRuntimeMBeanImpl = (ConnectorInboundRuntimeMBeanImpl)this.msgListenerToInboundRuntimeMap.get(string);
        if (connectorInboundRuntimeMBeanImpl != null) {
            connectorInboundRuntimeMBeanImpl.addMDBRuntime(messageDrivenEJBRuntimeMBean);
        }
    }

    public void removeEndpointFactory(String string, MessageEndpointFactory messageEndpointFactory, MessageDrivenEJBRuntimeMBean messageDrivenEJBRuntimeMBean) throws SystemException {
        List list = null;
        if (this.msgListenerToEndptFactoryMap.containsKey(string)) {
            list = (List)this.msgListenerToEndptFactoryMap.get(string);
            list.remove(messageEndpointFactory);
            if (list.isEmpty()) {
                this.msgListenerToEndptFactoryMap.remove(string);
            }
            this.endptFactorySuspendStateMap.remove(messageEndpointFactory);
            ConnectorInboundRuntimeMBeanImpl connectorInboundRuntimeMBeanImpl = (ConnectorInboundRuntimeMBeanImpl)this.msgListenerToInboundRuntimeMap.get(string);
            if (connectorInboundRuntimeMBeanImpl != null) {
                connectorInboundRuntimeMBeanImpl.removeMDBRuntime(messageDrivenEJBRuntimeMBean);
            }
        }
    }

    public void setupForRecovery(ActivationSpec activationSpec, String string) throws SystemException {
        this.recoveryMgr.onActivateEndpoint(this.raInstanceMgr, activationSpec, string);
    }

    public void cleanupForRecovery(ActivationSpec activationSpec) throws SystemException {
        this.recoveryMgr.onDeActivateEndpoint(activationSpec);
    }

    public void addEJB(String string, String string2) {
        List<String> list = null;
        if (this.msgListenerToEJBMap.containsKey(string)) {
            list = (List)this.msgListenerToEJBMap.get(string);
        } else {
            list = new Vector();
            this.msgListenerToEJBMap.put(string, list);
        }
        list.add(string2);
    }

    public void removeEJB(String string, String string2) {
        List list = null;
        if (this.msgListenerToEJBMap.containsKey(string)) {
            list = (List)this.msgListenerToEJBMap.get(string);
            list.remove(string2);
            if (list.isEmpty()) {
                this.msgListenerToEJBMap.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendOrResumeMEF(int n, Properties properties) throws RAInboundException {
        Debug.enter(this, "suspendOrResumeMEF( action , props )");
        try {
            Iterator iterator = this.getEndpointFactories().iterator();
            MessageEndpointFactory messageEndpointFactory = null;
            RAInboundException rAInboundException = null;
            while (iterator.hasNext()) {
                messageEndpointFactory = (MessageEndpointFactory)iterator.next();
                if (messageEndpointFactory == null || !(messageEndpointFactory instanceof SuspendableEndpointFactory)) continue;
                AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                try {
                    if (n == 1) {
                        this.raInstanceMgr.getAdapterLayer().suspend((SuspendableEndpointFactory)messageEndpointFactory, properties, authenticatedSubject);
                        continue;
                    }
                    this.raInstanceMgr.getAdapterLayer().resume((SuspendableEndpointFactory)messageEndpointFactory, properties, authenticatedSubject);
                }
                catch (ResourceException resourceException) {
                    if (rAInboundException == null) {
                        rAInboundException = new RAInboundException();
                    }
                    Utils.consolidateException(rAInboundException, resourceException);
                }
            }
            if (rAInboundException != null) {
                throw rAInboundException;
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            Debug.exit(this, "suspendOrResumeMEF( action , props )");
            throw throwable;
        }
        Debug.exit(this, "suspendOrResumeMEF( action , props )");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectMEFs(RAInboundException rAInboundException) {
        Debug.enter(this, "disconnect()");
        try {
            Iterator iterator = this.getEndpointFactories().iterator();
            MessageEndpointFactory messageEndpointFactory = null;
            while (iterator.hasNext()) {
                messageEndpointFactory = (MessageEndpointFactory)iterator.next();
                if (messageEndpointFactory == null || !(messageEndpointFactory instanceof SuspendableEndpointFactory)) continue;
                AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                try {
                    this.raInstanceMgr.getAdapterLayer().disconnect((SuspendableEndpointFactory)messageEndpointFactory, authenticatedSubject);
                }
                catch (ResourceException resourceException) {
                    Utils.consolidateException(rAInboundException, resourceException);
                }
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Debug.exit(this, "suspendOrResumeMEF( action , props )");
            throw throwable;
        }
        Debug.exit(this, "suspendOrResumeMEF( action , props )");
    }

    public RAInstanceManager getRA() {
        return this.raInstanceMgr;
    }

    public List getEndpointFactories() {
        Vector<MessageEndpointFactory> vector = new Vector<MessageEndpointFactory>();
        Iterator iterator = this.msgListenerToEndptFactoryMap.values().iterator();
        MessageEndpointFactory messageEndpointFactory2 = null;
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            for (MessageEndpointFactory messageEndpointFactory2 : list) {
                if (messageEndpointFactory2 == null) continue;
                vector.add(messageEndpointFactory2);
            }
        }
        return vector;
    }

    public List getEndpointFactories(String string) {
        return (List)this.msgListenerToEndptFactoryMap.get(string);
    }

    public List getEJBs(String string) {
        return (List)this.msgListenerToEJBMap.get(string);
    }

    public int getAvailableInboundConnectionsCount() {
        int n = 0;
        try {
            n = this.raInstanceMgr.getRAInfo().getInboundInfos().size();
        }
        catch (ElementNotFoundException elementNotFoundException) {
            // empty catch block
        }
        return n;
    }

    public int getSubscribedInboundConnectionsCount() {
        return this.msgListenerToEJBMap.size();
    }

    public int getActiveInboundConnectionsCount() {
        return 0;
    }

    public InboundAdapterType[] getXMLBeans(ConnectorDiagnosticImageSource connectorDiagnosticImageSource) {
        boolean bl = connectorDiagnosticImageSource != null ? connectorDiagnosticImageSource.timedout() : false;
        int n = this.getAvailableInboundConnectionsCount();
        InboundAdapterType[] inboundAdapterTypeArray = new InboundAdapterType[n];
        if (n > 0 && !bl) {
            Iterator iterator = null;
            try {
                iterator = this.raInstanceMgr.getRAInfo().getInboundInfos().iterator();
            }
            catch (ElementNotFoundException elementNotFoundException) {
                // empty catch block
            }
            int n2 = 0;
            while (iterator.hasNext()) {
                InboundInfo inboundInfo = (InboundInfo)iterator.next();
                InboundAdapterType inboundAdapterType = InboundAdapterType.Factory.newInstance();
                inboundAdapterType.setName(inboundInfo.getDisplayName());
                List list = (List)this.msgListenerToEJBMap.get(inboundInfo.getMsgType());
                if (list != null && list.size() > 0) {
                    EndpointType[] endpointTypeArray = new EndpointType[list.size()];
                    Iterator iterator2 = list.iterator();
                    int n3 = 0;
                    while (iterator2.hasNext()) {
                        EndpointType endpointType = EndpointType.Factory.newInstance();
                        endpointType.setMsgType(inboundInfo.getMsgType());
                        endpointType.setName((String)iterator2.next());
                        endpointTypeArray[n3] = endpointType;
                        ++n3;
                    }
                    inboundAdapterType.addNewEndpoints().setEndpointArray(endpointTypeArray);
                }
                inboundAdapterTypeArray[n2] = inboundAdapterType;
                ++n2;
            }
        }
        return inboundAdapterTypeArray;
    }

    public void setupRuntimes(ConnectorComponentRuntimeMBeanImpl connectorComponentRuntimeMBeanImpl) {
        List list = null;
        try {
            list = this.raInstanceMgr.getRAInfo().getInboundInfos();
        }
        catch (ElementNotFoundException elementNotFoundException) {
            // empty catch block
        }
        if (list != null) {
            Iterator iterator = list.iterator();
            InboundInfo inboundInfo = null;
            while (iterator.hasNext()) {
                this.isInbound = true;
                inboundInfo = (InboundInfo)iterator.next();
                String string = inboundInfo.getMsgType();
                try {
                    Debug.deployment("Creating a new ConnectorInboundRuntimeMBeanImpl for " + string);
                    ConnectorInboundRuntimeMBeanImpl connectorInboundRuntimeMBeanImpl = new ConnectorInboundRuntimeMBeanImpl(string, inboundInfo.getMsgType(), inboundInfo.getActivationSpec().getActivationSpecClass(), connectorComponentRuntimeMBeanImpl, this);
                    this.msgListenerToInboundRuntimeMap.put(inboundInfo.getMsgType(), connectorInboundRuntimeMBeanImpl);
                    connectorComponentRuntimeMBeanImpl.addConnInboundRuntime(connectorInboundRuntimeMBeanImpl);
                }
                catch (Exception exception) {
                    Debug.logCreateInboundRuntimeMBeanFailed(string, exception.toString());
                    Debug.deployment("Exception Creating a new ConnectorInboundRuntimeMBeanImpl for " + string, exception);
                }
            }
        }
    }

    public String getState() {
        return this.state;
    }

    public boolean isInboundRA() {
        return this.isInbound;
    }

    public void setEndpointFactorySuspendedState(MessageEndpointFactory messageEndpointFactory, boolean bl) {
        if (!this.endptFactorySuspendStateMap.containsKey(messageEndpointFactory)) {
            throw new AssertionError((Object)"Attempt to set suspend state for endpoint factory not in map");
        }
        this.endptFactorySuspendStateMap.put(messageEndpointFactory, bl);
    }
}

