/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.lifecycle;

import java.io.Serializable;
import java.util.Timer;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.spi.ApplicationServerInternalException;
import javax.resource.spi.work.WorkException;
import weblogic.application.ApplicationContextInternal;
import weblogic.connector.ConnectorLogger;
import weblogic.connector.common.Debug;
import weblogic.connector.common.RAInstanceManager;
import weblogic.connector.extensions.ExtendedBootstrapContext;
import weblogic.connector.external.AdapterListener;
import weblogic.connector.inbound.XATerminator;
import weblogic.connector.work.WorkManager;
import weblogic.diagnostics.context.DiagnosticContext;
import weblogic.diagnostics.context.DiagnosticContextFactory;
import weblogic.diagnostics.context.DiagnosticContextHelper;
import weblogic.diagnostics.context.DiagnosticContextManager;
import weblogic.diagnostics.context.InvalidDyeException;

public class BootstrapContext
implements javax.resource.spi.BootstrapContext,
ExtendedBootstrapContext,
Serializable {
    private static final long serialVersionUID = -6084262294645664250L;
    private String moduleName;
    private WorkManager workManager;
    private Vector listeners;
    private RAInstanceManager raIM;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BootstrapContext(RAInstanceManager rAInstanceManager, ApplicationContextInternal applicationContextInternal, String string, weblogic.work.WorkManager workManager) throws WorkException {
        Debug.enter(this, "( " + rAInstanceManager + ", " + applicationContextInternal + ", " + string + " )");
        try {
            this.raIM = rAInstanceManager;
            this.workManager = null;
            this.moduleName = string;
            this.listeners = new Vector(10);
            if (string == null || string.trim().equals("")) {
                Debug.throwAssertionError("moduleName is null or blank");
            }
            if (workManager == null) {
                Debug.throwAssertionError("Couldn't obtain WorkManager for resource adapter '" + string + "'");
            }
            if (Debug.isWorkEnabled()) {
                Debug.work("BootStrapContext() creating WorkManager for RA=" + string);
            }
            this.workManager = WorkManager.create(applicationContextInternal.getApplicationId(), string, workManager);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Debug.exit(this, "()");
            throw throwable;
        }
        Debug.exit(this, "()");
    }

    public Timer createTimer() {
        Debug.logTimerWarning();
        return new Timer();
    }

    public javax.resource.spi.work.WorkManager getWorkManager() {
        return this.workManager;
    }

    public javax.resource.spi.XATerminator getXATerminator() {
        return XATerminator.getXATerminator();
    }

    public void setDiagnosticContextID(String string) {
        DiagnosticContextHelper.setPayload(string);
    }

    public String getDiagnosticContextID() {
        return DiagnosticContextHelper.getPayload();
    }

    public void setDyeBits(byte by) throws ResourceException {
        if (!DiagnosticContextManager.getDiagnosticContextManager().isEnabled()) {
            Debug.println("BootstrapContext.setDyeBits failed because Diagnostic Contexts are not enabled");
            String string = Debug.getExceptionSetDyeBitsFailedDiagCtxNotEnabled();
            throw new ResourceException(string);
        }
        if (by < 0 || by > 15) {
            String string = Debug.getExceptionInvalidDyeValue(String.valueOf(by));
            throw new ResourceException(string);
        }
        boolean bl = (by & 8) != 0;
        boolean bl2 = (by & 4) != 0;
        boolean bl3 = (by & 2) != 0;
        boolean bl4 = (by & 1) != 0;
        DiagnosticContext diagnosticContext = DiagnosticContextFactory.findOrCreateDiagnosticContext();
        if (diagnosticContext == null) {
            Debug.println("<" + this.moduleName + "> Failed to obtain Diagnostic" + "Context for BootstrapContext.setDyeBits call");
            String string = Debug.getExceptionFailedToGetDiagCtx(this.moduleName);
            throw new ApplicationServerInternalException(string);
        }
        try {
            diagnosticContext.setDye((byte)30, bl);
            diagnosticContext.setDye((byte)29, bl2);
            diagnosticContext.setDye((byte)28, bl3);
            diagnosticContext.setDye((byte)27, bl4);
        }
        catch (InvalidDyeException invalidDyeException) {
            String string = Debug.logInvalidDye(this.moduleName, invalidDyeException.toString());
            Debug.logStackTrace(string, (Throwable)((Object)invalidDyeException));
            String string2 = Debug.getExceptionInvalidDye(this.moduleName, invalidDyeException.toString());
            throw new ApplicationServerInternalException(string2, (Throwable)((Object)invalidDyeException));
        }
    }

    public byte getDyeBits() throws ResourceException {
        if (!DiagnosticContextManager.getDiagnosticContextManager().isEnabled()) {
            Debug.println("BootstrapContext.getDyeBits failed because Diagnostic Contexts are not enabled");
            String string = Debug.getExceptionGetDyeBitsFailedDiagCtxNotEnabled();
            throw new ResourceException(string);
        }
        byte by = 0;
        DiagnosticContext diagnosticContext = DiagnosticContextFactory.findOrCreateDiagnosticContext();
        try {
            if (diagnosticContext.isDyedWith((byte)30)) {
                by = (byte)(by | 8);
            }
            if (diagnosticContext.isDyedWith((byte)29)) {
                by = (byte)(by | 4);
            }
            if (diagnosticContext.isDyedWith((byte)28)) {
                by = (byte)(by | 2);
            }
            if (diagnosticContext.isDyedWith((byte)27)) {
                by = (byte)(by | 1);
            }
        }
        catch (InvalidDyeException invalidDyeException) {
            String string = Debug.logInvalidDye(this.moduleName, invalidDyeException.toString());
            Debug.logStackTrace(string, (Throwable)((Object)invalidDyeException));
            String string2 = Debug.getExceptionInvalidDye(this.moduleName, invalidDyeException.toString());
            throw new ApplicationServerInternalException(string2, (Throwable)((Object)invalidDyeException));
        }
        return by;
    }

    public void complete() {
        ConnectorLogger.logCompleteCalled((String)this.moduleName, (String)this.raIM.getVersionId());
        this.raIM.clearWaitingStartVersioningComplete();
        this.signalShutdown();
    }

    public void signalShutdown() {
        if (!this.raIM.isWaitingStartVersioningComplete()) {
            for (AdapterListener adapterListener : this.listeners) {
                adapterListener.completed();
            }
        }
    }

    public void addListener(AdapterListener adapterListener) {
        if (adapterListener != null) {
            this.listeners.add(adapterListener);
        }
    }

    public void removeListener(AdapterListener adapterListener) {
        if (adapterListener != null) {
            this.listeners.remove(adapterListener);
        }
    }
}

