/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.monitoring;

import java.security.AccessController;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.j2ee.statistics.Stats;
import weblogic.connector.common.Debug;
import weblogic.connector.common.RAInstanceManager;
import weblogic.connector.configuration.Configuration;
import weblogic.connector.configuration.ConfigurationFactory;
import weblogic.connector.external.OutboundInfo;
import weblogic.connector.external.RAInfo;
import weblogic.connector.monitoring.outbound.JCAStatsImpl;
import weblogic.connector.security.outbound.SecurityContext;
import weblogic.j2ee.ComponentRuntimeMBeanImpl;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ConnectorComponentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ConnectorComponentRuntimeMBean;
import weblogic.management.runtime.ConnectorConnectionPoolRuntimeMBean;
import weblogic.management.runtime.ConnectorInboundRuntimeMBean;
import weblogic.management.runtime.ConnectorServiceRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.EISResource;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.ErrorCollectionException;

public final class ConnectorComponentRuntimeMBeanImpl
extends ComponentRuntimeMBeanImpl
implements ConnectorComponentRuntimeMBean {
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private Set connPoolRuntimes;
    private Set connInboundRuntimes;
    private ConnectorServiceRuntimeMBean connServiceRuntime;
    private RAInstanceManager raInstanceManager;

    public ConnectorComponentRuntimeMBeanImpl(String string, String string2, RAInstanceManager rAInstanceManager, RuntimeMBean runtimeMBean, ConnectorServiceRuntimeMBean connectorServiceRuntimeMBean) throws ManagementException {
        super(string, string2, runtimeMBean, false);
        this.connServiceRuntime = connectorServiceRuntimeMBean;
        this.raInstanceManager = rAInstanceManager;
        this.connPoolRuntimes = new HashSet(10);
        this.connInboundRuntimes = new HashSet(10);
        this.register();
    }

    public void suspendAll() throws ErrorCollectionException {
        if (this.raInstanceManager != null) {
            this.raInstanceManager.suspend(7, null);
        }
    }

    public void resumeAll() throws ErrorCollectionException {
        if (this.raInstanceManager != null) {
            this.raInstanceManager.resume(7, null);
        }
    }

    public void suspend(int n) throws ErrorCollectionException {
        if (this.raInstanceManager != null) {
            this.raInstanceManager.suspend(n, null);
        }
    }

    public void suspend(int n, Properties properties) throws ErrorCollectionException {
        if (this.raInstanceManager != null) {
            this.raInstanceManager.suspend(n, properties);
        }
    }

    public void resume(int n) throws ErrorCollectionException {
        if (this.raInstanceManager != null) {
            this.raInstanceManager.resume(n, null);
        }
    }

    public void resume(int n, Properties properties) throws ErrorCollectionException {
        if (this.raInstanceManager != null) {
            this.raInstanceManager.resume(n, properties);
        }
    }

    public void setRAInstanceManager(RAInstanceManager rAInstanceManager) {
        Debug.println(this, ".setRAInstanceManager() called.");
        this.raInstanceManager = rAInstanceManager;
    }

    public int getConnectionPoolCount() {
        return this.connPoolRuntimes.size();
    }

    public ConnectorConnectionPoolRuntimeMBean[] getConnectionPools() {
        return this.connPoolRuntimes.toArray(new ConnectorConnectionPoolRuntimeMBean[this.connPoolRuntimes.size()]);
    }

    public ConnectorConnectionPoolRuntimeMBean getConnectionPool(String string) {
        boolean bl = false;
        ConnectorConnectionPoolRuntimeMBean connectorConnectionPoolRuntimeMBean = null;
        ConnectorConnectionPoolRuntimeMBean connectorConnectionPoolRuntimeMBean2 = null;
        if (string != null && string.length() > 0) {
            Iterator iterator = this.connPoolRuntimes.iterator();
            while (iterator.hasNext() && !bl) {
                connectorConnectionPoolRuntimeMBean = (ConnectorConnectionPoolRuntimeMBean)iterator.next();
                if (!string.equals(connectorConnectionPoolRuntimeMBean.getKey())) continue;
                connectorConnectionPoolRuntimeMBean2 = connectorConnectionPoolRuntimeMBean;
                bl = true;
            }
        }
        return connectorConnectionPoolRuntimeMBean2;
    }

    public int getInboundConnectionsCount() {
        return this.connInboundRuntimes.size();
    }

    public ConnectorInboundRuntimeMBean[] getInboundConnections() {
        for (ConnectorInboundRuntimeMBean connectorInboundRuntimeMBean : this.connInboundRuntimes) {
            if (connectorInboundRuntimeMBean != null) {
                System.out.println("[ConnectorComponentRuntimeMBeanImpl.getInboundConnections()] inboundMBean = " + connectorInboundRuntimeMBean);
                continue;
            }
            System.out.println("[ConnectorComponentRuntimeMBeanImpl.getInboundConnections()] inboundMBean = <NULL>");
        }
        return this.connInboundRuntimes.toArray(new ConnectorInboundRuntimeMBean[this.connInboundRuntimes.size()]);
    }

    public ConnectorInboundRuntimeMBean getInboundConnection(String string) {
        boolean bl = false;
        ConnectorInboundRuntimeMBean connectorInboundRuntimeMBean = null;
        ConnectorInboundRuntimeMBean connectorInboundRuntimeMBean2 = null;
        if (string != null && string.length() > 0) {
            Iterator iterator = this.connInboundRuntimes.iterator();
            while (iterator.hasNext() && !bl) {
                connectorInboundRuntimeMBean = (ConnectorInboundRuntimeMBean)iterator.next();
                if (!string.equals(connectorInboundRuntimeMBean.getMsgListenerType())) continue;
                connectorInboundRuntimeMBean2 = connectorInboundRuntimeMBean;
                bl = true;
            }
        }
        return connectorInboundRuntimeMBean2;
    }

    public String getEISResourceId() {
        EISResource eISResource = SecurityContext.getGlobalEISResource(this.raInstanceManager.getApplicationName(), this.raInstanceManager.getComponentName(), this.raInstanceManager.getRAInfo());
        return eISResource.toString();
    }

    public boolean addConnPoolRuntime(ConnectorConnectionPoolRuntimeMBean connectorConnectionPoolRuntimeMBean) {
        return this.connPoolRuntimes.add(connectorConnectionPoolRuntimeMBean);
    }

    public boolean removeConnPoolRuntime(ConnectorConnectionPoolRuntimeMBean connectorConnectionPoolRuntimeMBean) {
        return this.connPoolRuntimes.remove(connectorConnectionPoolRuntimeMBean);
    }

    public boolean addConnInboundRuntime(ConnectorInboundRuntimeMBean connectorInboundRuntimeMBean) {
        return this.connInboundRuntimes.add(connectorInboundRuntimeMBean);
    }

    public boolean removeConnInboundRuntime(ConnectorInboundRuntimeMBean connectorInboundRuntimeMBean) {
        return this.connInboundRuntimes.remove(connectorInboundRuntimeMBean);
    }

    public ConnectorServiceRuntimeMBean getConnectorServiceRuntime() {
        return this.connServiceRuntime;
    }

    public String getVersionId() {
        return this.raInstanceManager.getVersionId();
    }

    public String getActiveVersionId() {
        return this.raInstanceManager.getActiveVersion();
    }

    public boolean isVersioned() {
        return this.raInstanceManager.isVersioned();
    }

    public boolean isActiveVersion() {
        return this.raInstanceManager.isActiveVersion();
    }

    public String getJndiName() {
        return this.raInstanceManager.getJndiName();
    }

    public String getState() {
        return this.raInstanceManager.getState();
    }

    public int getSuspendedState() {
        return this.raInstanceManager.getSuspendedState();
    }

    public AppDeploymentMBean getAppDeploymentMBean() {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        String string = this.getParent().getName();
        return domainMBean.lookupAppDeployment(string);
    }

    public ConnectorComponentMBean getConnectorComponentMBean() {
        return this.raInstanceManager.getConnectorComponentMBean();
    }

    public Properties getConfiguredProperties() {
        Properties properties = new Properties();
        RAInfo rAInfo = this.raInstanceManager.getRAInfo();
        if (rAInfo.getRADescription() != null) {
            properties.setProperty("Description", rAInfo.getRADescription());
        }
        if (rAInfo.getEisType() != null) {
            properties.setProperty("EisType", rAInfo.getEisType());
        }
        if (rAInfo.getSpecVersion() != null) {
            properties.setProperty("SpecVersion", rAInfo.getSpecVersion());
        }
        if (rAInfo.getVendorName() != null) {
            properties.setProperty("VendorName", rAInfo.getVendorName());
        }
        if (rAInfo.getRAVersion() != null) {
            properties.setProperty("Version", rAInfo.getRAVersion());
        }
        if (rAInfo.getLinkref() != null) {
            properties.setProperty("RaLinkRef", rAInfo.getLinkref());
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        Iterator iterator = rAInfo.getOutboundInfos().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            OutboundInfo outboundInfo = (OutboundInfo)iterator.next();
            if (n != 0) {
                string = string + ",";
                string2 = string2 + ",";
                string3 = string3 + ",";
            }
            string = string + outboundInfo.getMCFClass();
            string2 = string2 + outboundInfo.getJndiName();
            string3 = string3 + outboundInfo.getTransactionSupport();
            ++n;
        }
        if (string != null && string.length() > 0) {
            properties.setProperty("MCFClassNames", string);
        }
        if (string2 != null && string2.length() > 0) {
            properties.setProperty("OutboundJndiNames", string2);
        }
        if (string3 != null && string3.length() > 0) {
            properties.setProperty("TransactionSupports", string3);
        }
        return properties;
    }

    public String getSchema() {
        return ConfigurationFactory.getConfiguration(this.raInstanceManager.getRAInfo()).getSchema();
    }

    public String getSchema(String string) {
        Configuration configuration = ConfigurationFactory.getConfiguration(string, this.raInstanceManager.getRAInfo());
        if (configuration != null) {
            return configuration.getSchema();
        }
        return null;
    }

    public String getConfigurationVersion() {
        return "1.0";
    }

    public String getConfiguration() {
        return ConfigurationFactory.getConfiguration(this.raInstanceManager.getRAInfo()).getConfiguration();
    }

    public String getConfiguration(String string) {
        Configuration configuration = ConfigurationFactory.getConfiguration(string, this.raInstanceManager.getRAInfo());
        if (configuration != null) {
            return configuration.getConfiguration();
        }
        return null;
    }

    public String getDescription() {
        return this.raInstanceManager.getRAInfo().getRADescription();
    }

    public String[] getDescriptions() {
        return this.raInstanceManager.getRAInfo().getRADescriptions();
    }

    public String getEISType() {
        return this.raInstanceManager.getRAInfo().getEisType();
    }

    public String getSpecVersion() {
        return this.raInstanceManager.getRAInfo().getSpecVersion();
    }

    public String getVendorName() {
        return this.raInstanceManager.getRAInfo().getVendorName();
    }

    public String getVersion() {
        return this.raInstanceManager.getRAInfo().getRAVersion();
    }

    public String getLinkref() {
        return this.raInstanceManager.getRAInfo().getLinkref();
    }

    public String getComponentName() {
        return this.raInstanceManager.getComponentName();
    }

    public Stats getStats() {
        return new JCAStatsImpl(this);
    }
}

