/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.monitoring;

import java.beans.BeanDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.ParameterDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import weblogic.connector.monitoring.ConnectorComponentRuntimeMBeanImpl;
import weblogic.j2ee.ComponentRuntimeMBeanImplBeanInfo;
import weblogic.management.internal.mbean.BeanInfoHelper;
import weblogic.management.runtime.ConnectorComponentRuntimeMBean;

public class ConnectorComponentRuntimeMBeanImplBeanInfo
extends ComponentRuntimeMBeanImplBeanInfo {
    public static Class INTERFACE_CLASS = ConnectorComponentRuntimeMBean.class;

    public ConnectorComponentRuntimeMBeanImplBeanInfo(boolean bl, String string) throws IntrospectionException {
        super(bl, string);
    }

    public ConnectorComponentRuntimeMBeanImplBeanInfo() throws IntrospectionException {
    }

    protected BeanDescriptor buildBeanDescriptor() {
        Class clazz = null;
        try {
            clazz = ConnectorComponentRuntimeMBeanImpl.class;
        }
        catch (Throwable throwable) {
            clazz = INTERFACE_CLASS;
        }
        BeanDescriptor beanDescriptor = new BeanDescriptor(clazz, null);
        beanDescriptor.setValue("since", "8.1.0.0");
        beanDescriptor.setValue("package", "weblogic.connector.monitoring");
        String string = new String("Generates notifications about the deployment state of resource adapters. (Each resource adapter is represented by an instance of {@link weblogic.management.configuration.ConnectorComponentMBean}.) <p> In 2-phase deployment, if a resource adapter's state is <code>PREPARED</code> then it has achieved the first phase of deployment (everything is set up and all that remains is to enable a reference to the adapter). When the resource adapter is in an <code>ACTIVATED</code> state, it has achieved the second phase of deployment, in which applications can obtain a reference to the adapter. <p> A server instance creates an instance of this interface when it creates an instance of <code>weblogic.management.configuration.ConnectorComponentMBean</code>.  <h3 class=\"TypeSafeDeprecation\">Deprecation of MBeanHome and Type-Safe Interfaces</h3>  <p class=\"TypeSafeDeprecation\">This is a type-safe interface for a WebLogic Server MBean, which you can import into your client classes and access through <code>weblogic.management.MBeanHome</code>. As of 9.0, the <code>MBeanHome</code> interface and all type-safe interfaces for WebLogic Server MBeans are deprecated. Instead, client classes that interact with WebLogic Server MBeans should use standard JMX design patterns in which clients use the <code>javax.management.MBeanServerConnection</code> interface to discover MBeans, attributes, and attribute types at runtime. For more information, see \"Developing Manageable Applications with JMX\" on <a href=\"http://www.oracle.com/technology/products/weblogic/index.html\" shape=\"rect\">http://www.oracle.com/technology/products/weblogic/index.html</a>.</p> ").intern();
        beanDescriptor.setShortDescription(string);
        beanDescriptor.setValue("description", string);
        beanDescriptor.setValue("interfaceclassname", "weblogic.management.runtime.ConnectorComponentRuntimeMBean");
        beanDescriptor.setValue("generatedByWLSInfoBinder", Boolean.TRUE);
        return beanDescriptor;
    }

    protected void buildPropertyDescriptors(Map map) throws IntrospectionException {
        String[] stringArray;
        String string;
        String string2;
        PropertyDescriptor propertyDescriptor = null;
        if (!map.containsKey("ActiveVersionId")) {
            string2 = "getActiveVersionId";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ActiveVersionId", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("ActiveVersionId", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Get the active version Id.</p> ");
        }
        if (!map.containsKey("AppDeploymentMBean")) {
            string2 = "getAppDeploymentMBean";
            string = null;
            propertyDescriptor = new PropertyDescriptor("AppDeploymentMBean", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("AppDeploymentMBean", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p> Gets the AppDeploymentMBean for the Connector Component </p> ");
            propertyDescriptor.setValue("deprecated", "9.1.0.0 Acquire this by looking up the AppDeploymentMBean with the same name as the parent ApplicationRuntime ");
        }
        if (!map.containsKey("ComponentName")) {
            string2 = "getComponentName";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ComponentName", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("ComponentName", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Get the name of the connector component.</p> ");
            propertyDescriptor.setValue("unharvestable", Boolean.TRUE);
        }
        if (!map.containsKey("Configuration")) {
            string2 = "getConfiguration";
            string = null;
            propertyDescriptor = new PropertyDescriptor("Configuration", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("Configuration", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Return the xml string representing the RA configuration. The xml corresponding to the latest schema is returned. The current supported version is \"1.0\"</p> ");
            propertyDescriptor.setValue("unharvestable", Boolean.TRUE);
        }
        if (!map.containsKey("ConfigurationVersion")) {
            string2 = "getConfigurationVersion";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ConfigurationVersion", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("ConfigurationVersion", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Return the latest configuration version.<.p> ");
        }
        if (!map.containsKey("ConfiguredProperties")) {
            string2 = "getConfiguredProperties";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ConfiguredProperties", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("ConfiguredProperties", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p> Gets a subset of the resource adapter descriptor information. </p> ");
        }
        if (!map.containsKey("ConnectionPoolCount")) {
            string2 = "getConnectionPoolCount";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ConnectionPoolCount", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("ConnectionPoolCount", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of connection pools.</p> ");
        }
        if (!map.containsKey("ConnectionPools")) {
            string2 = "getConnectionPools";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ConnectionPools", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("ConnectionPools", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>An array of <code>ConnectorConnectionPoolRuntimeMBeans</code>, each of which represents the runtime data for a connection pool in the resource adapter.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.runtime.ConnectorConnectionPoolRuntimeMBean")};
            propertyDescriptor.setValue("see", stringArray);
            propertyDescriptor.setValue("relationship", "containment");
        }
        if (!map.containsKey("ConnectorComponentMBean")) {
            string2 = "getConnectorComponentMBean";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ConnectorComponentMBean", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("ConnectorComponentMBean", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Gets the ConnectorComponentMBean for the Connector Component.</p> ");
            propertyDescriptor.setValue("deprecated", "9.1.0.0 The connector component mbean was already deprecated. ");
        }
        if (!map.containsKey("ConnectorServiceRuntime")) {
            string2 = "getConnectorServiceRuntime";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ConnectorServiceRuntime", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("ConnectorServiceRuntime", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Return the connector service runtime.</p> ");
            propertyDescriptor.setValue("relationship", "containment");
        }
        if (!map.containsKey("DeploymentState")) {
            string2 = "getDeploymentState";
            string = null;
            propertyDescriptor = new PropertyDescriptor("DeploymentState", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("DeploymentState", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The current deployment state of the module.</p>  <p>A module can be in one and only one of the following states. State can be changed via deployment or administrator console.</p>  <p>- UNPREPARED. State indicating at this  module is neither  prepared or active.</p>  <p>- PREPARED. State indicating at this module of this application is prepared, but not active. The classes have been loaded and the module has been validated.</p>  <p>- ACTIVATED. State indicating at this module  is currently active.</p>  <p>- NEW. State indicating this module has just been created and is being initialized.</p> ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"#setDeploymentState(int)")};
            propertyDescriptor.setValue("see", stringArray);
        }
        if (!map.containsKey("Description")) {
            string2 = "getDescription";
            string = null;
            propertyDescriptor = new PropertyDescriptor("Description", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("Description", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Get the Description for the resource adapter.</p> ");
            propertyDescriptor.setValue("unharvestable", Boolean.TRUE);
        }
        if (!map.containsKey("Descriptions")) {
            string2 = "getDescriptions";
            string = null;
            propertyDescriptor = new PropertyDescriptor("Descriptions", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("Descriptions", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Get the Descriptions for the resource adapter.</p> ");
            propertyDescriptor.setValue("unharvestable", Boolean.TRUE);
        }
        if (!map.containsKey("EISResourceId")) {
            string2 = "getEISResourceId";
            string = null;
            propertyDescriptor = new PropertyDescriptor("EISResourceId", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("EISResourceId", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Returns the EISResourceId for the component.</p> ");
            propertyDescriptor.setValue("unharvestable", Boolean.TRUE);
        }
        if (!map.containsKey("EISType")) {
            string2 = "getEISType";
            string = null;
            propertyDescriptor = new PropertyDescriptor("EISType", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("EISType", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Get the EIS type.</p> ");
            propertyDescriptor.setValue("unharvestable", Boolean.TRUE);
        }
        if (!map.containsKey("InboundConnections")) {
            string2 = "getInboundConnections";
            string = null;
            propertyDescriptor = new PropertyDescriptor("InboundConnections", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("InboundConnections", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>An array of runtime information for all inbound connections for the resource adapter.</p> ");
            propertyDescriptor.setValue("relationship", "containment");
        }
        if (!map.containsKey("InboundConnectionsCount")) {
            string2 = "getInboundConnectionsCount";
            string = null;
            propertyDescriptor = new PropertyDescriptor("InboundConnectionsCount", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("InboundConnectionsCount", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>The number of inbound connections for the resource adapter.</p> ");
        }
        if (!map.containsKey("JndiName")) {
            string2 = "getJndiName";
            string = null;
            propertyDescriptor = new PropertyDescriptor("JndiName", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("JndiName", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Get the Jndi name of the resource adapter.</p> ");
            propertyDescriptor.setValue("unharvestable", Boolean.TRUE);
        }
        if (!map.containsKey("Linkref")) {
            string2 = "getLinkref";
            string = null;
            propertyDescriptor = new PropertyDescriptor("Linkref", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("Linkref", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Get the linkref.</p> ");
            propertyDescriptor.setValue("unharvestable", Boolean.TRUE);
        }
        if (!map.containsKey("ModuleId")) {
            string2 = "getModuleId";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ModuleId", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("ModuleId", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Returns the identifier for this Component.  The identifier is unique within the application.</p>  <p>Typical modules will use the URI for their id.  Web Modules will return their context-root since the web-uri may not be unique within an EAR. ");
            propertyDescriptor.setValue("unharvestable", Boolean.TRUE);
        }
        if (!map.containsKey("Schema")) {
            string2 = "getSchema";
            string = null;
            propertyDescriptor = new PropertyDescriptor("Schema", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("Schema", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Get the latest schema for RA configuration.</p> ");
            propertyDescriptor.setValue("unharvestable", Boolean.TRUE);
        }
        if (!map.containsKey("SpecVersion")) {
            string2 = "getSpecVersion";
            string = null;
            propertyDescriptor = new PropertyDescriptor("SpecVersion", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("SpecVersion", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Get the spec version.</p> ");
            propertyDescriptor.setValue("unharvestable", Boolean.TRUE);
        }
        if (!map.containsKey("State")) {
            string2 = "getState";
            string = null;
            propertyDescriptor = new PropertyDescriptor("State", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("State", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Get the state of the resource adapter.</p> ");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"9.0.0.0", null, (String)this.targetVersion) && !map.containsKey("Stats")) {
            string2 = "getStats";
            string = null;
            propertyDescriptor = new PropertyDescriptor("Stats", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("Stats", propertyDescriptor);
            propertyDescriptor.setValue("description", " ");
            propertyDescriptor.setValue("exclude", Boolean.TRUE);
            propertyDescriptor.setValue("since", "9.0.0.0");
        }
        if (!map.containsKey("SuspendedState")) {
            string2 = "getSuspendedState";
            string = null;
            propertyDescriptor = new PropertyDescriptor("SuspendedState", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("SuspendedState", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Gets the suspended state information of the resource adapter.</p> If getState() returns SUSPENDED then getSuspendedState() returns an integer describing which functions of the resource adapter are suspended: one or more of INBOUND, OUTBOUND or WORK (or ALL) or 0 for nothing suspended ");
            stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.connector.extensions.Suspendable")};
            propertyDescriptor.setValue("see", stringArray);
        }
        if (!map.containsKey("VendorName")) {
            string2 = "getVendorName";
            string = null;
            propertyDescriptor = new PropertyDescriptor("VendorName", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("VendorName", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Get the vendor name.</p> ");
            propertyDescriptor.setValue("unharvestable", Boolean.TRUE);
        }
        if (!map.containsKey("Version")) {
            string2 = "getVersion";
            string = null;
            propertyDescriptor = new PropertyDescriptor("Version", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("Version", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Get the version.</p> ");
            propertyDescriptor.setValue("unharvestable", Boolean.TRUE);
        }
        if (!map.containsKey("VersionId")) {
            string2 = "getVersionId";
            string = null;
            propertyDescriptor = new PropertyDescriptor("VersionId", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("VersionId", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Get the version Id.</p> ");
        }
        if (BeanInfoHelper.isVersionCompliant((String)"9.0.0.0", null, (String)this.targetVersion) && !map.containsKey("WorkManagerRuntimes")) {
            string2 = "getWorkManagerRuntimes";
            string = null;
            propertyDescriptor = new PropertyDescriptor("WorkManagerRuntimes", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("WorkManagerRuntimes", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Get the runtime mbeans for all work managers defined in this component</p> ");
            propertyDescriptor.setValue("relationship", "reference");
            propertyDescriptor.setValue("since", "9.0.0.0");
        }
        if (!map.containsKey("ActiveVersion")) {
            string2 = "isActiveVersion";
            string = null;
            propertyDescriptor = new PropertyDescriptor("ActiveVersion", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("ActiveVersion", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Return true if this version is the active version. Returns true if this resource adapter is not versioned.</p> ");
        }
        if (!map.containsKey("Versioned")) {
            string2 = "isVersioned";
            string = null;
            propertyDescriptor = new PropertyDescriptor("Versioned", ConnectorComponentRuntimeMBean.class, string2, string);
            map.put("Versioned", propertyDescriptor);
            propertyDescriptor.setValue("description", "<p>Check if the resource adapter is versioned. Returns true if it is.</p> ");
        }
        super.buildPropertyDescriptors(map);
    }

    private void fillinFactoryMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinCollectionMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinFinderMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
    }

    private void fillinOperationMethodInfos(Map map) throws IntrospectionException, NoSuchMethodException {
        MethodDescriptor methodDescriptor;
        Method method = ConnectorComponentRuntimeMBean.class.getMethod("preDeregister", new Class[0]);
        ParameterDescriptor[] parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(parameterDescriptorArray)) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", " ");
            methodDescriptor.setValue("role", "operation");
        }
        method = ConnectorComponentRuntimeMBean.class.getMethod("getConnectionPool", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{ConnectorComponentRuntimeMBeanImplBeanInfo.createParameterDescriptor((String)"key", (String)"JNDI name or resource-link name of the connection pool. ")};
        String string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Returns a <code>ConnectorConnectionPoolRuntimeMBean</code> that represents the statistics for a connection pool. The pool that is accessed in this call must be part of the resource adapter that is being accessed. A null is returned if the JNDI name or resource-link name is not found.</p> ");
            String[] stringArray = new String[]{BeanInfoHelper.encodeEntities((String)"weblogic.management.runtime.ConnectorConnectionPoolRuntimeMBean")};
            methodDescriptor.setValue("see", stringArray);
            methodDescriptor.setValue("role", "operation");
        }
        method = ConnectorComponentRuntimeMBean.class.getMethod("getInboundConnection", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{ConnectorComponentRuntimeMBeanImplBeanInfo.createParameterDescriptor((String)"messageListenerType", (String)"Message listener type. ")};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Runtime information for the specified inbound connection. A null is returned if the inbound connection is not found in the resource adapter.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = ConnectorComponentRuntimeMBean.class.getMethod("suspendAll", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Resumes all activities of this resource adapter.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        method = ConnectorComponentRuntimeMBean.class.getMethod("suspend", Integer.TYPE);
        parameterDescriptorArray = new ParameterDescriptor[]{ConnectorComponentRuntimeMBeanImplBeanInfo.createParameterDescriptor((String)"type", (String)"int The type of activity(ies), @see weblogic.connector.extensions.Suspendable ")};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Suspend a particular type of activity for this resource adapter</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        method = ConnectorComponentRuntimeMBean.class.getMethod("suspend", Integer.TYPE, Properties.class);
        parameterDescriptorArray = new ParameterDescriptor[]{ConnectorComponentRuntimeMBeanImplBeanInfo.createParameterDescriptor((String)"type", (String)"int The type of activity(ies), @see weblogic.connector.extensions.Suspendable "), ConnectorComponentRuntimeMBeanImplBeanInfo.createParameterDescriptor((String)"props", (String)"Properties to pass on to the RA or null ")};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Suspends the specified type of activity for this resource adapter</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        if (!map.containsKey(parameterDescriptorArray = BeanInfoHelper.buildMethodKey((Method)(method = ConnectorComponentRuntimeMBean.class.getMethod("resumeAll", new Class[0]))))) {
            methodDescriptor = new MethodDescriptor(method, null);
            map.put(parameterDescriptorArray, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Resumes all activities of this resource adapter.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        method = ConnectorComponentRuntimeMBean.class.getMethod("resume", Integer.TYPE);
        parameterDescriptorArray = new ParameterDescriptor[]{ConnectorComponentRuntimeMBeanImplBeanInfo.createParameterDescriptor((String)"type", (String)"int The type of activity(ies), @see weblogic.connector.extensions.Suspendable ")};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Resumes the specified type of activity for this resource adapter</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        method = ConnectorComponentRuntimeMBean.class.getMethod("resume", Integer.TYPE, Properties.class);
        parameterDescriptorArray = new ParameterDescriptor[]{ConnectorComponentRuntimeMBeanImplBeanInfo.createParameterDescriptor((String)"type", (String)"int The type of activity(ies), @see weblogic.connector.extensions.Suspendable "), ConnectorComponentRuntimeMBeanImplBeanInfo.createParameterDescriptor((String)"props", (String)"Properties to pass on to the RA or null ")};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Resumes the specified type of activity for this resource adapter</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        method = ConnectorComponentRuntimeMBean.class.getMethod("getSchema", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{ConnectorComponentRuntimeMBeanImplBeanInfo.createParameterDescriptor((String)"version", (String)"String ")};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Get the schema for RA configuration based on the version that is provided. Return null if the version is not found. The current supported version is \"1.0\"</p> ");
            methodDescriptor.setValue("role", "operation");
        }
        method = ConnectorComponentRuntimeMBean.class.getMethod("getConfiguration", String.class);
        parameterDescriptorArray = new ParameterDescriptor[]{ConnectorComponentRuntimeMBeanImplBeanInfo.createParameterDescriptor((String)"version", (String)"String ")};
        string = BeanInfoHelper.buildMethodKey((Method)method);
        if (!map.containsKey(string)) {
            methodDescriptor = new MethodDescriptor(method, parameterDescriptorArray);
            map.put(string, methodDescriptor);
            methodDescriptor.setValue("description", "<p>Return the xml string representing the RA configuration. The xml corresponding to the version specified is returned.</p> ");
            methodDescriptor.setValue("role", "operation");
        }
    }

    protected void buildMethodDescriptors(Map map) throws IntrospectionException, NoSuchMethodException {
        this.fillinFinderMethodInfos(map);
        if (!this.readOnly) {
            this.fillinCollectionMethodInfos(map);
            this.fillinFactoryMethodInfos(map);
        }
        this.fillinOperationMethodInfos(map);
        super.buildMethodDescriptors(map);
    }

    protected void buildEventSetDescriptors(Map map) throws IntrospectionException {
    }
}

