/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.monitoring;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import weblogic.connector.common.Debug;
import weblogic.connector.common.RACollectionManager;
import weblogic.connector.common.RAInstanceManager;
import weblogic.management.ManagementException;
import weblogic.management.runtime.ConnectorComponentRuntimeMBean;
import weblogic.management.runtime.ConnectorConnectionPoolRuntimeMBean;
import weblogic.management.runtime.ConnectorInboundRuntimeMBean;
import weblogic.management.runtime.ConnectorServiceRuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.utils.ErrorCollectionException;

public final class ServiceRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements ConnectorServiceRuntimeMBean {
    Set connRuntimes = new HashSet(10);

    public ServiceRuntimeMBeanImpl() throws ManagementException {
        super("ConnectorService");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void suspendOrResume(int n, int n2, Properties properties) throws ErrorCollectionException {
        Debug.service("About to suspend/resume all resource adapters");
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        Iterator iterator = RACollectionManager.getRAs();
        boolean bl = false;
        try {
            if (iterator != null) {
                while (iterator.hasNext()) {
                    try {
                        if (n == 1) {
                            ((RAInstanceManager)iterator.next()).suspend(n2, properties);
                            continue;
                        }
                        if (n != 2) continue;
                        ((RAInstanceManager)iterator.next()).resume(n2, properties);
                    }
                    catch (Throwable throwable) {
                        errorCollectionException.addError(throwable);
                        bl = true;
                    }
                }
            }
            Object var9_8 = null;
            if (!bl) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (!bl) throw throwable;
            throw errorCollectionException;
        }
        throw errorCollectionException;
    }

    public void suspendAll(Properties properties) throws ErrorCollectionException {
        this.suspendOrResume(1, 7, properties);
    }

    public void resumeAll(Properties properties) throws ErrorCollectionException {
        this.suspendOrResume(2, 7, properties);
    }

    public void suspend(int n, Properties properties) throws ErrorCollectionException {
        this.suspendOrResume(1, n, properties);
    }

    public void resume(int n, Properties properties) throws ErrorCollectionException {
        this.suspendOrResume(2, n, properties);
    }

    public void suspendAll() throws ErrorCollectionException {
        this.suspendOrResume(1, 7, null);
    }

    public void suspend(int n) throws ErrorCollectionException {
        this.suspendOrResume(1, n, null);
    }

    public void resumeAll() throws ErrorCollectionException {
        this.suspendOrResume(2, 7, null);
    }

    public void resume(int n) throws ErrorCollectionException {
        this.suspendOrResume(2, n, null);
    }

    public int getActiveRACount() {
        int n = 0;
        for (ConnectorComponentRuntimeMBean connectorComponentRuntimeMBean : this.connRuntimes) {
            if (!connectorComponentRuntimeMBean.isActiveVersion()) continue;
            ++n;
        }
        return n;
    }

    public int getRACount() {
        return this.connRuntimes.size();
    }

    public ConnectorComponentRuntimeMBean[] getRAs() {
        return this.connRuntimes.toArray(new ConnectorComponentRuntimeMBean[this.connRuntimes.size()]);
    }

    public ConnectorComponentRuntimeMBean[] getActiveRAs() {
        Vector<ConnectorComponentRuntimeMBean> vector = new Vector<ConnectorComponentRuntimeMBean>(10);
        for (ConnectorComponentRuntimeMBean connectorComponentRuntimeMBean : this.connRuntimes) {
            if (!connectorComponentRuntimeMBean.isActiveVersion()) continue;
            vector.add(connectorComponentRuntimeMBean);
        }
        return vector.toArray(new ConnectorComponentRuntimeMBean[vector.size()]);
    }

    public ConnectorComponentRuntimeMBean[] getInactiveRAs() {
        Vector<ConnectorComponentRuntimeMBean> vector = new Vector<ConnectorComponentRuntimeMBean>(10);
        for (ConnectorComponentRuntimeMBean connectorComponentRuntimeMBean : this.connRuntimes) {
            if (connectorComponentRuntimeMBean.isActiveVersion()) continue;
            vector.add(connectorComponentRuntimeMBean);
        }
        return vector.toArray(new ConnectorComponentRuntimeMBean[vector.size()]);
    }

    public ConnectorComponentRuntimeMBean getRA(String string) {
        ConnectorComponentRuntimeMBean connectorComponentRuntimeMBean = null;
        Iterator iterator = this.connRuntimes.iterator();
        if (string != null && string.length() > 0) {
            while (iterator.hasNext() && !string.equals((connectorComponentRuntimeMBean = (ConnectorComponentRuntimeMBean)iterator.next()).getJndiName())) {
                connectorComponentRuntimeMBean = null;
            }
        }
        return connectorComponentRuntimeMBean;
    }

    public int getConnectionPoolCurrentCount() {
        int n = 0;
        ConnectorComponentRuntimeMBean connectorComponentRuntimeMBean2 = null;
        for (ConnectorComponentRuntimeMBean connectorComponentRuntimeMBean2 : this.connRuntimes) {
            ConnectorConnectionPoolRuntimeMBean[] connectorConnectionPoolRuntimeMBeanArray;
            if (!connectorComponentRuntimeMBean2.isActiveVersion() || (connectorConnectionPoolRuntimeMBeanArray = connectorComponentRuntimeMBean2.getConnectionPools()) == null) continue;
            n += connectorConnectionPoolRuntimeMBeanArray.length;
        }
        return n;
    }

    public int getConnectionPoolsTotalCount() {
        return RACollectionManager.getConnectionPoolsTotalCount();
    }

    public ConnectorConnectionPoolRuntimeMBean[] getConnectionPools() {
        ConnectorComponentRuntimeMBean connectorComponentRuntimeMBean = null;
        Iterator iterator = this.connRuntimes.iterator();
        Vector<ConnectorConnectionPoolRuntimeMBean> vector = new Vector<ConnectorConnectionPoolRuntimeMBean>(10);
        while (iterator.hasNext()) {
            ConnectorConnectionPoolRuntimeMBean[] connectorConnectionPoolRuntimeMBeanArray;
            connectorComponentRuntimeMBean = (ConnectorComponentRuntimeMBean)iterator.next();
            if (!connectorComponentRuntimeMBean.isActiveVersion() || (connectorConnectionPoolRuntimeMBeanArray = connectorComponentRuntimeMBean.getConnectionPools()) == null) continue;
            for (int i = 0; i < connectorConnectionPoolRuntimeMBeanArray.length; ++i) {
                vector.add(connectorConnectionPoolRuntimeMBeanArray[i]);
            }
        }
        return vector.toArray(new ConnectorConnectionPoolRuntimeMBean[vector.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectorConnectionPoolRuntimeMBean getConnectionPool(String string) {
        String string2;
        Debug.enter(this, "getConnectionPool( " + string + " )");
        Object object = null;
        try {
            ConnectorConnectionPoolRuntimeMBean[] connectorConnectionPoolRuntimeMBeanArray = null;
            ConnectorComponentRuntimeMBean connectorComponentRuntimeMBean = null;
            Iterator iterator = null;
            boolean bl = false;
            if (string != null && string.length() > 0) {
                iterator = this.connRuntimes.iterator();
                while (iterator.hasNext() && !bl) {
                    connectorComponentRuntimeMBean = (ConnectorComponentRuntimeMBean)iterator.next();
                    if (connectorComponentRuntimeMBean.isActiveVersion()) {
                        connectorConnectionPoolRuntimeMBeanArray = connectorComponentRuntimeMBean.getConnectionPools();
                        if (connectorConnectionPoolRuntimeMBeanArray == null) continue;
                        string2 = null;
                        for (int i = 0; i < connectorConnectionPoolRuntimeMBeanArray.length && !bl; ++i) {
                            string2 = connectorConnectionPoolRuntimeMBeanArray[i].getKey();
                            Debug.println(this, ".getConnectionPool() pool[" + i + "] = " + string2);
                            if (!string.equals(string2)) continue;
                            Debug.println(this, ".getConnectionPool() Found pool");
                            object = connectorConnectionPoolRuntimeMBeanArray[i];
                            bl = true;
                        }
                        continue;
                    }
                    if (!Debug.getVerbose(this)) continue;
                    Debug.println(this, "getConnectionPool() found inactive conn component, name = " + connectorComponentRuntimeMBean.getName());
                }
            }
            string2 = object;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            block7: {
                Object var10_10 = null;
                if (!Debug.getVerbose(this)) break block7;
                Debug.exit(this, "getConnectionPool( " + string + " ) returned " + object);
            }
            throw throwable;
        }
        if (Debug.getVerbose(this)) {
            Debug.exit(this, "getConnectionPool( " + string + " ) returned " + object);
        }
        return string2;
    }

    public ConnectorInboundRuntimeMBean[] getInboundConnections(String string) {
        ConnectorInboundRuntimeMBean[] connectorInboundRuntimeMBeanArray = null;
        ConnectorComponentRuntimeMBean connectorComponentRuntimeMBean = null;
        Iterator iterator = this.connRuntimes.iterator();
        boolean bl = false;
        Vector<ConnectorInboundRuntimeMBean> vector = new Vector<ConnectorInboundRuntimeMBean>(10);
        if (string != null && string.length() > 0) {
            while (iterator.hasNext() && !bl) {
                connectorComponentRuntimeMBean = (ConnectorComponentRuntimeMBean)iterator.next();
                if (!connectorComponentRuntimeMBean.isActiveVersion() || (connectorInboundRuntimeMBeanArray = connectorComponentRuntimeMBean.getInboundConnections()) == null) continue;
                for (int i = 0; i < connectorInboundRuntimeMBeanArray.length; ++i) {
                    if (!string.equals(connectorInboundRuntimeMBeanArray[i].getMsgListenerType())) continue;
                    vector.add(connectorInboundRuntimeMBeanArray[i]);
                }
            }
        }
        return vector.toArray(new ConnectorInboundRuntimeMBean[vector.size()]);
    }

    public boolean addConnectorRuntime(ConnectorComponentRuntimeMBean connectorComponentRuntimeMBean) {
        return this.connRuntimes.add(connectorComponentRuntimeMBean);
    }

    public boolean removeConnectorRuntime(ConnectorComponentRuntimeMBean connectorComponentRuntimeMBean) {
        return this.connRuntimes.remove(connectorComponentRuntimeMBean);
    }
}

