/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.monitoring.inbound;

import java.util.HashSet;
import java.util.Set;
import weblogic.connector.inbound.RAInboundManager;
import weblogic.management.ManagementException;
import weblogic.management.runtime.ConnectorInboundRuntimeMBean;
import weblogic.management.runtime.MessageDrivenEJBRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;

public class ConnectorInboundRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements ConnectorInboundRuntimeMBean {
    private String msgListenerType;
    private String activationSpecClass;
    private Set mdbRuntimes;
    private RAInboundManager raInboundManager;

    public ConnectorInboundRuntimeMBeanImpl(String string, String string2, String string3, RuntimeMBean runtimeMBean, RAInboundManager rAInboundManager) throws ManagementException {
        super(string, runtimeMBean, false);
        this.msgListenerType = string2;
        this.activationSpecClass = string3;
        this.mdbRuntimes = new HashSet();
        this.raInboundManager = rAInboundManager;
        this.register();
    }

    public String getMsgListenerType() {
        return this.msgListenerType;
    }

    public String getActivationSpecClass() {
        return this.activationSpecClass;
    }

    public MessageDrivenEJBRuntimeMBean[] getMDBRuntimes() {
        return this.mdbRuntimes.toArray(new MessageDrivenEJBRuntimeMBean[this.mdbRuntimes.size()]);
    }

    public boolean addMDBRuntime(MessageDrivenEJBRuntimeMBean messageDrivenEJBRuntimeMBean) {
        boolean bl = false;
        if (messageDrivenEJBRuntimeMBean != null) {
            bl = this.mdbRuntimes.add(messageDrivenEJBRuntimeMBean);
        }
        return bl;
    }

    public boolean removeMDBRuntime(MessageDrivenEJBRuntimeMBean messageDrivenEJBRuntimeMBean) {
        boolean bl = false;
        if (messageDrivenEJBRuntimeMBean != null) {
            bl = this.mdbRuntimes.remove(messageDrivenEJBRuntimeMBean);
        }
        return bl;
    }

    public void removeAllMDBRuntimes() {
        this.mdbRuntimes.clear();
    }

    public String getState() {
        return this.raInboundManager.getState();
    }
}

