/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.monitoring.outbound;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Hashtable;
import weblogic.connector.common.Debug;
import weblogic.connector.exception.RAOutboundException;
import weblogic.connector.monitoring.outbound.ConnectionRuntimeMBeanImpl;
import weblogic.connector.outbound.ConnectionInfo;
import weblogic.connector.outbound.ConnectionPool;
import weblogic.connector.outbound.RAOutboundManager;
import weblogic.connector.security.outbound.SecurityContext;
import weblogic.jdbc.common.internal.ConnectionLeakProfile;
import weblogic.management.ManagementException;
import weblogic.management.runtime.ConnectorConnectionPoolRuntimeMBean;
import weblogic.management.runtime.ConnectorConnectionRuntimeMBean;
import weblogic.management.runtime.LogRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.EISResource;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;

public final class ConnectionPoolRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements ConnectorConnectionPoolRuntimeMBean {
    private ConnectionPool pool;
    private String applicationName;
    private String componentName;
    private RAOutboundManager poolsManager;
    private Hashtable connRuntimeMBeans = new Hashtable();
    private int nextConnectionId = 0;

    public ConnectionPoolRuntimeMBeanImpl(String string, String string2, ConnectionPool connectionPool, RuntimeMBean runtimeMBean, RAOutboundManager rAOutboundManager) throws ManagementException {
        super(connectionPool.getKey(), runtimeMBean, false);
        this.pool = connectionPool;
        this.applicationName = string;
        this.componentName = string2;
        this.poolsManager = rAOutboundManager;
        this.register();
    }

    public void addConnectionRuntimeMBean(ConnectionInfo connectionInfo) {
        ConnectionRuntimeMBeanImpl connectionRuntimeMBeanImpl = this.createConnectionRuntimeMBean(connectionInfo);
        this.connRuntimeMBeans.put(connectionInfo, connectionRuntimeMBeanImpl);
    }

    public void removeConnectionRuntimeMBean(ConnectionInfo connectionInfo) {
        ConnectionRuntimeMBeanImpl connectionRuntimeMBeanImpl = (ConnectionRuntimeMBeanImpl)this.connRuntimeMBeans.get(connectionInfo);
        this.connRuntimeMBeans.remove(connectionInfo);
        this.destroyConnectionRuntimeMBean(connectionRuntimeMBeanImpl);
    }

    private ConnectionRuntimeMBeanImpl createConnectionRuntimeMBean(ConnectionInfo connectionInfo) {
        final ConnectionInfo connectionInfo2 = connectionInfo;
        ConnectionRuntimeMBeanImpl connectionRuntimeMBeanImpl = null;
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        try {
            connectionRuntimeMBeanImpl = (ConnectionRuntimeMBeanImpl)SecurityServiceManager.runAs((AuthenticatedSubject)authenticatedSubject, (AuthenticatedSubject)authenticatedSubject, (PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    try {
                        return new ConnectionRuntimeMBeanImpl(ConnectionPoolRuntimeMBeanImpl.this.pool, connectionInfo2);
                    }
                    catch (Exception exception) {
                        Debug.logInitConnRTMBeanError(ConnectionPoolRuntimeMBeanImpl.this.pool.getName(), exception.toString());
                        return null;
                    }
                }
            });
        }
        catch (Exception exception) {
            Debug.logInitConnRTMBeanError(this.pool.getName(), exception.toString());
        }
        return connectionRuntimeMBeanImpl;
    }

    private void destroyConnectionRuntimeMBean(ConnectionRuntimeMBeanImpl connectionRuntimeMBeanImpl) {
        final ConnectionRuntimeMBeanImpl connectionRuntimeMBeanImpl2 = connectionRuntimeMBeanImpl;
        try {
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            SecurityServiceManager.runAs((AuthenticatedSubject)authenticatedSubject, (AuthenticatedSubject)authenticatedSubject, (PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    try {
                        if (connectionRuntimeMBeanImpl2 != null) {
                            connectionRuntimeMBeanImpl2.unregister();
                        }
                        return null;
                    }
                    catch (Exception exception) {
                        Debug.logUnregisterConnRTMBeanError(ConnectionPoolRuntimeMBeanImpl.this.pool.getName(), exception.toString());
                        return null;
                    }
                }
            });
        }
        catch (Exception exception) {
            Debug.logUnregisterConnRTMBeanError(this.pool.getName(), exception.toString());
        }
    }

    public String getPoolName() {
        return this.pool.getName();
    }

    public String getJNDIName() {
        return this.pool.getJNDIName();
    }

    public String getKey() {
        return this.pool.getKey();
    }

    public String getConnectionFactoryName() {
        return this.pool.getConnectionFactoryName();
    }

    public String getResourceAdapterLinkRefName() {
        return this.pool.getRALinkRefName();
    }

    public boolean isLoggingEnabled() {
        return this.pool.isLoggingEnabled();
    }

    public String getLogFileName() {
        return this.pool.getLogFileName();
    }

    public LogRuntimeMBean getLogRuntime() {
        return this.pool.getLogRuntime();
    }

    public String getTransactionSupport() {
        return this.pool.getTransactionSupport();
    }

    public int getMaxCapacity() {
        return this.pool.getMaxCapacity();
    }

    public int getMaxIdleTime() {
        return this.getInactiveResourceTimeoutSeconds();
    }

    public int getInactiveResourceTimeoutSeconds() {
        return this.pool.getInactiveResourceTimeoutSeconds();
    }

    public boolean getConnectionProfilingEnabled() {
        return this.pool.getConnectionProfilingEnabled();
    }

    public int getNumberDetectedLeaks() {
        return this.pool.getNumLeaked();
    }

    public int getNumberDetectedIdle() {
        return this.pool.getNumIdleDetected();
    }

    public int getInitialCapacity() {
        return this.pool.getInitialCapacity();
    }

    public int getCapacityIncrement() {
        return this.pool.getCapacityIncrement();
    }

    public boolean isShrinkingEnabled() {
        return this.pool.isShrinkingEnabled();
    }

    public int getShrinkPeriodMinutes() {
        return this.getShrinkFrequencySeconds() / 60;
    }

    public int getShrinkFrequencySeconds() {
        return this.pool.getShrinkFrequencySeconds();
    }

    public int getActiveConnectionsCurrentCount() {
        return this.pool.getNumReserved();
    }

    public int getActiveConnectionsHighCount() {
        return this.pool.getHighestNumReserved();
    }

    public int getFreeConnectionsCurrentCount() {
        return this.pool.getNumAvailable();
    }

    public int getFreeConnectionsHighCount() {
        return this.pool.getHighestNumAvailable();
    }

    public int getAverageActiveUsage() {
        return this.pool.getAverageReserved();
    }

    public int getShrinkCountDownTime() {
        return this.pool.getTimeToNextShrinkOperation();
    }

    public long getLastShrinkTime() {
        return this.pool.getLastShrinkTime();
    }

    public int getRecycledTotal() {
        return this.pool.getNumRecycled();
    }

    public int getConnectionsCreatedTotalCount() {
        return this.pool.getTotalNumAllocated();
    }

    public int getConnectionsMatchedTotalCount() {
        return this.pool.getConnectionsMatchedTotalCount();
    }

    public int getConnectionsDestroyedTotalCount() {
        return this.pool.getTotalNumDestroyed();
    }

    public int getConnectionsDestroyedByErrorTotalCount() {
        return this.pool.getConnectionsDestroyedByErrorCount();
    }

    public int getConnectionsDestroyedByShrinkingTotalCount() {
        return this.pool.getResourcesDestroyedByShrinkingCount();
    }

    public int getConnectionsRejectedTotalCount() {
        return this.pool.getConnectionsRejectedTotalCount();
    }

    public int getConnectionLeakProfileCount() {
        return this.pool.getLeakProfileCount();
    }

    public ConnectionLeakProfile[] getConnectionLeakProfiles(int n, int n2) {
        return this.pool.getConnectionLeakProfiles(n, n2);
    }

    public ConnectionLeakProfile[] getConnectionLeakProfiles() {
        return this.pool.getConnectionLeakProfiles();
    }

    public int getConnectionIdleProfileCount() {
        return this.pool.getIdleProfileCount();
    }

    public ConnectionLeakProfile[] getConnectionIdleProfiles(int n, int n2) {
        return this.pool.getConnectionIdleProfiles(n, n2);
    }

    public ConnectionLeakProfile[] getConnectionIdleProfiles() {
        return this.pool.getConnectionIdleProfiles();
    }

    public int getNumWaitersCurrentCount() {
        return this.pool.getNumWaiters();
    }

    public int getNumUnavailableCurrentCount() {
        return this.pool.getNumUnavailable();
    }

    public int getNumUnavailableHighCount() {
        return this.pool.getHighestNumUnavailable();
    }

    public boolean isProxyOn() {
        return this.pool.isProxyOn();
    }

    public ConnectorConnectionRuntimeMBean[] getConnections() {
        Collection collection = this.connRuntimeMBeans.values();
        return collection.toArray(new ConnectorConnectionRuntimeMBean[collection.size()]);
    }

    public String getConnectorEisType() {
        return this.pool.getOutboundInfo().getEisType();
    }

    public String getEISResourceId() {
        EISResource eISResource = SecurityContext.getPoolEISResource(this.applicationName, this.componentName, this.pool.getOutboundInfo());
        return eISResource.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNextConnectionId() {
        ConnectionPoolRuntimeMBeanImpl connectionPoolRuntimeMBeanImpl = this;
        synchronized (connectionPoolRuntimeMBeanImpl) {
            ++this.nextConnectionId;
            return this.nextConnectionId;
        }
    }

    public long getCloseCount() {
        return this.pool.getCloseCount();
    }

    public long getFreePoolSizeHighWaterMark() {
        return this.pool.getFreePoolSizeHighWaterMark();
    }

    public long getFreePoolSizeLowWaterMark() {
        return this.pool.getFreePoolSizeLowWaterMark();
    }

    public long getCurrentCapacity() {
        return this.pool.getCurrCapacity();
    }

    public long getPoolSizeHighWaterMark() {
        return this.pool.getPoolSizeHighWaterMark();
    }

    public long getPoolSizeLowWaterMark() {
        return this.pool.getPoolSizeLowWaterMark();
    }

    public String getManagedConnectionFactoryClassName() {
        return this.pool.getManagedConnectionFactoryClassName();
    }

    public String getConnectionFactoryClassName() {
        return this.pool.getConnectionFactoryClassName();
    }

    public long getNumWaiters() {
        return this.pool.getNumWaiters();
    }

    public long getHighestNumWaiters() {
        return this.pool.getHighestNumWaiters();
    }

    public boolean isTestable() {
        return this.pool.isTestable();
    }

    public boolean testPool() {
        return this.pool.testPool();
    }

    public String getState() {
        return this.pool.getState();
    }

    public String getMCFClassName() {
        return this.pool.getManagedConnectionFactoryClassName();
    }

    public String getResourceLink() {
        return this.pool.getResourceLink();
    }

    public void forceLogRotation() throws ManagementException {
        this.pool.forceLogRotation();
    }

    public void ensureLogOpened() throws ManagementException {
        this.pool.ensureLogOpened();
    }

    public void forceReset() throws ManagementException {
        try {
            this.poolsManager.forceResetPool(this.getKey());
        }
        catch (RAOutboundException rAOutboundException) {
            throw new ManagementException((Throwable)((Object)rAOutboundException));
        }
    }

    public boolean reset() throws ManagementException {
        try {
            return this.poolsManager.resetPool(this.getKey());
        }
        catch (RAOutboundException rAOutboundException) {
            throw new ManagementException((Throwable)((Object)rAOutboundException));
        }
    }
}

