/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.monitoring.outbound;

import weblogic.connector.common.Debug;
import weblogic.connector.outbound.ConnectionInfo;
import weblogic.connector.outbound.ConnectionPool;
import weblogic.connector.outbound.EisMetaData;
import weblogic.management.ManagementException;
import weblogic.management.runtime.ConnectorConnectionRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;

public final class ConnectionRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements ConnectorConnectionRuntimeMBean {
    private static final long serialVersionUID = -4867452571996075418L;
    private ConnectionInfo connectionInfo = null;
    private ConnectionPool connectionPool = null;

    public ConnectionRuntimeMBeanImpl(ConnectionPool connectionPool, ConnectionInfo connectionInfo) throws ManagementException {
        super(connectionPool.getKey() + "_" + connectionPool.getRuntimeMBean().getNextConnectionId() + "@" + System.currentTimeMillis(), (RuntimeMBean)connectionPool.getRuntimeMBean(), false);
        this.connectionInfo = connectionInfo;
        this.connectionPool = connectionPool;
        this.register();
    }

    public void delete() throws ManagementException {
        if (!this.isDeletable()) {
            String string = Debug.getExceptionCannotDeleteConnection();
            throw new ManagementException(string);
        }
        this.connectionInfo.getConnectionHandler().destroyConnection();
    }

    public int getActiveHandlesCurrentCount() {
        return this.connectionInfo.getConnectionHandler().getNumActiveConns();
    }

    public int getActiveHandlesHighCount() {
        return this.connectionInfo.getConnectionHandler().getActiveHandlesHighCount();
    }

    public int getHandlesCreatedTotalCount() {
        return this.connectionInfo.getConnectionHandler().getHandlesCreatedTotalCount();
    }

    public long getLastUsage() {
        return this.connectionInfo.getLastUsedTime();
    }

    public String getLastUsageString() {
        return this.connectionInfo.getLastUsageString();
    }

    public String getStackTrace() {
        return this.connectionInfo.getAllocationCallStack();
    }

    public boolean isCurrentlyInUse() {
        return this.connectionInfo.getConnectionHandler().getNumActiveConns() > 0;
    }

    public boolean isInTransaction() {
        return this.connectionInfo.getConnectionHandler().isInTransaction();
    }

    public boolean isShared() {
        return this.connectionInfo.isBeingShared();
    }

    public boolean isIdle() {
        return 0 != this.connectionPool.getHighestWaitSeconds() && this.isCurrentlyInUse() && System.currentTimeMillis() - this.connectionInfo.getLastUsedTime() > (long)this.connectionPool.getHighestWaitSeconds();
    }

    public boolean isDeletable() {
        return !this.isInTransaction() && this.isIdle() && !this.isShared();
    }

    public String getEISProductName() {
        EisMetaData eisMetaData = EisMetaData.getMetaData(this.connectionInfo.getConnectionHandler().getManagedConnection(), this.connectionPool);
        return eisMetaData.productName;
    }

    public String getEISProductVersion() {
        EisMetaData eisMetaData = EisMetaData.getMetaData(this.connectionInfo.getConnectionHandler().getManagedConnection(), this.connectionPool);
        return eisMetaData.productVersion;
    }

    public String getMaxConnections() {
        EisMetaData eisMetaData = EisMetaData.getMetaData(this.connectionInfo.getConnectionHandler().getManagedConnection(), this.connectionPool);
        return eisMetaData.maxConnections;
    }

    public String getUserName() {
        EisMetaData eisMetaData = EisMetaData.getMetaData(this.connectionInfo.getConnectionHandler().getManagedConnection(), this.connectionPool);
        return eisMetaData.userName;
    }

    public long getCreationDurationTime() {
        return this.connectionInfo.getCreationDurationTime();
    }

    public long getReserveDurationTime() {
        return this.connectionInfo.getReserveDurationTime();
    }

    public String getTransactionId() {
        return this.connectionInfo.getTransactionId();
    }

    public long getReserveTime() {
        return this.connectionInfo.getReserveTime();
    }

    public String getManagedConnectionFactoryClassName() {
        return this.connectionPool.getManagedConnectionFactoryClassName();
    }

    public String getConnectionFactoryClassName() {
        return this.connectionPool.getConnectionFactoryClassName();
    }

    public boolean testConnection() {
        int n = 0;
        boolean bl = true;
        try {
            n = this.connectionInfo.test();
        }
        catch (Exception exception) {
            n = -1;
        }
        if (n != 0) {
            bl = false;
        }
        return bl;
    }

    public boolean hasError() {
        return this.connectionInfo.hasError();
    }
}

