/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.monitoring.outbound;

import java.io.Serializable;
import javax.management.j2ee.statistics.BoundedRangeStatistic;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.JCAConnectionPoolStats;
import javax.management.j2ee.statistics.RangeStatistic;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.TimeStatistic;
import weblogic.connector.common.Debug;
import weblogic.management.j2ee.statistics.BoundedRangeStatisticImpl;
import weblogic.management.j2ee.statistics.CountStatisticImpl;
import weblogic.management.j2ee.statistics.RangeStatisticImpl;
import weblogic.management.j2ee.statistics.StatException;
import weblogic.management.runtime.ConnectorConnectionPoolRuntimeMBean;

public class JCAConnectionPoolStatsImpl
implements JCAConnectionPoolStats,
Serializable {
    private String key;
    private long closeCount;
    private String connectionFactory;
    private long createCount;
    private String managedConnectionFactory;
    private long freeConnectionsCurrentCount;
    private long freePoolSizeHighWaterMark;
    private long freePoolSizeLowWaterMark;
    private long maxCapacity;
    private long poolSize;
    private long numWaiters;
    private long highestNumWaiters;
    protected static final String STAT_CLOSE_COUNT = Debug.getStringCloseCount();
    protected static final String STAT_CREATE_COUNT = Debug.getStringCreateCount();
    protected static final String STAT_FREE_POOL_SIZE = Debug.getStringFreePoolSize();
    protected static final String STAT_POOL_SIZE = Debug.getStringPoolSize();
    protected static final String STAT_WAITING_THREAD_COUNT = Debug.getStringWaitingThreadCount();
    protected static final String STAT_CLOSE_COUNT_DESCRIPTION = Debug.getStringCloseCountDescription();
    protected static final String STAT_CREATE_COUNT_DESCRIPTION = Debug.getStringCreateCountDescription();
    protected static final String STAT_FREE_POOL_SIZE_DESCRIPTION = Debug.getStringFreePoolSizeDescription();
    protected static final String STAT_POOL_SIZE_DESCRIPTION = Debug.getStringPoolSizeDescription();
    protected static final String STAT_WAITING_THREAD_COUNT_DESCRIPTION = Debug.getStringWaitingThreadCountDescription();

    public JCAConnectionPoolStatsImpl(ConnectorConnectionPoolRuntimeMBean connectorConnectionPoolRuntimeMBean) {
        this.key = connectorConnectionPoolRuntimeMBean.getKey();
        this.closeCount = connectorConnectionPoolRuntimeMBean.getCloseCount();
        this.connectionFactory = connectorConnectionPoolRuntimeMBean.getConnectionFactoryClassName();
        connectorConnectionPoolRuntimeMBean.getManagedConnectionFactoryClassName();
        this.managedConnectionFactory = connectorConnectionPoolRuntimeMBean.getManagedConnectionFactoryClassName();
        this.createCount = connectorConnectionPoolRuntimeMBean.getConnectionsCreatedTotalCount();
        this.freeConnectionsCurrentCount = connectorConnectionPoolRuntimeMBean.getFreeConnectionsCurrentCount();
        this.freePoolSizeHighWaterMark = connectorConnectionPoolRuntimeMBean.getFreePoolSizeHighWaterMark();
        this.freePoolSizeLowWaterMark = connectorConnectionPoolRuntimeMBean.getFreePoolSizeLowWaterMark();
        this.maxCapacity = connectorConnectionPoolRuntimeMBean.getMaxCapacity();
        this.poolSize = connectorConnectionPoolRuntimeMBean.getCurrentCapacity();
        this.numWaiters = connectorConnectionPoolRuntimeMBean.getNumWaiters();
        this.highestNumWaiters = connectorConnectionPoolRuntimeMBean.getHighestNumWaiters();
    }

    public CountStatistic getCloseCount() {
        CountStatisticImpl countStatisticImpl = null;
        try {
            countStatisticImpl = new CountStatisticImpl(STAT_CLOSE_COUNT_DESCRIPTION, STAT_CLOSE_COUNT, this.key);
            countStatisticImpl.setCount(this.closeCount);
        }
        catch (StatException statException) {
            // empty catch block
        }
        return countStatisticImpl;
    }

    public CountStatistic getCreateCount() {
        CountStatisticImpl countStatisticImpl = null;
        try {
            countStatisticImpl = new CountStatisticImpl(STAT_CREATE_COUNT_DESCRIPTION, STAT_CREATE_COUNT, this.key);
            countStatisticImpl.setCount(this.createCount);
        }
        catch (StatException statException) {
            // empty catch block
        }
        return countStatisticImpl;
    }

    public BoundedRangeStatistic getFreePoolSize() {
        BoundedRangeStatisticImpl boundedRangeStatisticImpl = null;
        try {
            boundedRangeStatisticImpl = new BoundedRangeStatisticImpl(STAT_FREE_POOL_SIZE_DESCRIPTION, STAT_FREE_POOL_SIZE, this.key);
            boundedRangeStatisticImpl.setCurrent(this.freeConnectionsCurrentCount);
            boundedRangeStatisticImpl.setHighWaterMark(this.freePoolSizeHighWaterMark);
            boundedRangeStatisticImpl.setLowWaterMark(this.freePoolSizeLowWaterMark);
            boundedRangeStatisticImpl.setUpperBound(this.maxCapacity);
            boundedRangeStatisticImpl.setLowerBound(0L);
        }
        catch (StatException statException) {
            // empty catch block
        }
        return boundedRangeStatisticImpl;
    }

    public BoundedRangeStatistic getPoolSize() {
        BoundedRangeStatisticImpl boundedRangeStatisticImpl = null;
        try {
            boundedRangeStatisticImpl = new BoundedRangeStatisticImpl(STAT_POOL_SIZE_DESCRIPTION, STAT_POOL_SIZE, this.key);
            boundedRangeStatisticImpl.setCurrent(this.poolSize);
            boundedRangeStatisticImpl.setHighWaterMark(this.freePoolSizeHighWaterMark);
            boundedRangeStatisticImpl.setLowWaterMark(this.freePoolSizeLowWaterMark);
            boundedRangeStatisticImpl.setUpperBound(this.maxCapacity);
            boundedRangeStatisticImpl.setLowerBound(0L);
        }
        catch (StatException statException) {
            // empty catch block
        }
        return boundedRangeStatisticImpl;
    }

    public RangeStatistic getWaitingThreadCount() {
        RangeStatisticImpl rangeStatisticImpl = null;
        try {
            rangeStatisticImpl = new RangeStatisticImpl(STAT_WAITING_THREAD_COUNT_DESCRIPTION, STAT_WAITING_THREAD_COUNT, this.key);
            rangeStatisticImpl.setCurrent(this.numWaiters);
            rangeStatisticImpl.setHighWaterMark(this.highestNumWaiters);
            rangeStatisticImpl.setLowWaterMark(0L);
        }
        catch (StatException statException) {
            // empty catch block
        }
        return rangeStatisticImpl;
    }

    public String getConnectionFactory() {
        return this.connectionFactory;
    }

    public String getManagedConnectionFactory() {
        return this.managedConnectionFactory;
    }

    public TimeStatistic getWaitTime() {
        return null;
    }

    public TimeStatistic getUseTime() {
        return null;
    }

    public Statistic getStatistic(String string) {
        CountStatistic countStatistic = null;
        if (string != null && string.length() > 0) {
            if (string.equals(STAT_CLOSE_COUNT)) {
                countStatistic = this.getCloseCount();
            } else if (string.equals(STAT_CREATE_COUNT)) {
                countStatistic = this.getCreateCount();
            } else if (string.equals(STAT_FREE_POOL_SIZE)) {
                countStatistic = this.getFreePoolSize();
            } else if (string.equals(STAT_POOL_SIZE)) {
                countStatistic = this.getPoolSize();
            } else if (string.equals(STAT_WAITING_THREAD_COUNT)) {
                countStatistic = this.getWaitingThreadCount();
            }
        }
        return countStatistic;
    }

    public String[] getStatisticNames() {
        String[] stringArray = new String[]{STAT_CLOSE_COUNT, STAT_CREATE_COUNT, STAT_FREE_POOL_SIZE, STAT_POOL_SIZE, STAT_WAITING_THREAD_COUNT};
        return stringArray;
    }

    public Statistic[] getStatistics() {
        Statistic[] statisticArray = new Statistic[]{this.getCloseCount(), this.getCreateCount(), this.getFreePoolSize(), this.getPoolSize(), this.getWaitingThreadCount()};
        return statisticArray;
    }
}

