/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.outbound;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ResourceAdapterInternalException;
import weblogic.common.ResourceException;
import weblogic.common.resourcepool.PooledResource;
import weblogic.common.resourcepool.PooledResourceFactory;
import weblogic.common.resourcepool.PooledResourceInfo;
import weblogic.connector.common.Debug;
import weblogic.connector.outbound.ConnectionInfo;
import weblogic.connector.outbound.ConnectionManagerImpl;
import weblogic.connector.outbound.ConnectionPool;
import weblogic.connector.outbound.ConnectionReqInfo;
import weblogic.connector.security.outbound.SecurityContext;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.jms.bridge.TemporaryResourceException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class ConnectionFactory
implements PooledResourceFactory {
    private ConnectionPool connectionPool;
    private boolean connectionProxyChecked;
    static final long serialVersionUID = 3702342262897055916L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_After_Outbound;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Around_Outbound;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Before_Outbound;
    public static final JoinPoint _WLDF$INST_JPFLD_0;

    public ConnectionFactory(ConnectionPool connectionPool) throws ResourceException {
        this.connectionPool = connectionPool;
        this.connectionProxyChecked = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PooledResource createResource(PooledResourceInfo pooledResourceInfo) throws ResourceException {
        ConnectionInfo connectionInfo;
        ConnectionInfo connectionInfo2;
        DynamicJoinPoint dynamicJoinPoint;
        Object[] objectArray;
        boolean bl = _WLDF$INST_FLD_Connector_Around_Outbound.isEnabledAndNotDyeFiltered();
        DiagnosticAction[] diagnosticActionArray = null;
        DiagnosticActionState[] diagnosticActionStateArray = null;
        Object var21_5 = null;
        if (bl) {
            objectArray = null;
            if (_WLDF$INST_FLD_Connector_Around_Outbound.isArgumentsCaptureNeeded()) {
                objectArray = InstrumentationSupport.toSensitive((int)2);
            }
            dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Around_Outbound;
            diagnosticActionArray = delegatingMonitor.getActions();
            diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
            InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        if (_WLDF$INST_FLD_Connector_Before_Outbound.isEnabledAndNotDyeFiltered()) {
            objectArray = null;
            if (_WLDF$INST_FLD_Connector_Before_Outbound.isArgumentsCaptureNeeded()) {
                objectArray = InstrumentationSupport.toSensitive((int)2);
            }
            dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Before_Outbound;
            InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        }
        try {
            Debug.enter(this, "createResource(...)");
            SecurityContext securityContext = null;
            String string = this.connectionPool.getTransactionSupport();
            ManagedConnection managedConnection = null;
            connectionInfo2 = null;
            long l = 0L;
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            try {
                Debug.println("Create the Security Context");
                securityContext = pooledResourceInfo == null ? this.connectionPool.createSecurityContext(null, true, authenticatedSubject) : ((ConnectionReqInfo)pooledResourceInfo).getSecurityContext();
                Debug.println("Create the managed connection");
                long l2 = System.currentTimeMillis();
                managedConnection = this.connectionPool.getRAInstanceManager().getAdapterLayer().createManagedConnection(this.connectionPool.getManagedConnectionFactory(), securityContext.getSubject(), securityContext.getClientInfo(), authenticatedSubject);
                long l3 = System.currentTimeMillis();
                l = l3 - l2;
            }
            catch (TemporaryResourceException temporaryResourceException) {
                String string2;
                String string3 = this.connectionPool.getRAInstanceManager().getAdapterLayer().toString((Object)temporaryResourceException, authenticatedSubject);
                if (Debug.isPoolingEnabled()) {
                    string2 = Debug.logCreateManagedConnectionException(this.connectionPool.getName(), string3);
                    Debug.logStackTrace(string2, (Throwable)((Object)temporaryResourceException));
                }
                string2 = Debug.getExceptionCreateMCFailed(string3);
                throw new ResourceException(string2, (Throwable)((Object)temporaryResourceException));
            }
            catch (javax.resource.ResourceException resourceException) {
                String string4 = this.connectionPool.getRAInstanceManager().getAdapterLayer().toString((Object)resourceException, authenticatedSubject);
                String string5 = Debug.logCreateManagedConnectionException(this.connectionPool.getName(), string4);
                if (Debug.isPoolingEnabled()) {
                    Debug.logStackTrace(string5, resourceException);
                }
                String string6 = Debug.getExceptionCreateMCFailed(resourceException.toString());
                throw new ResourceException(string6, resourceException);
            }
            catch (Throwable throwable) {
                String string7 = Debug.getExceptionCreateMCFailed(throwable.toString());
                ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException(string7, throwable);
                String string8 = this.connectionPool.getRAInstanceManager().getAdapterLayer().toString(resourceAdapterInternalException, authenticatedSubject);
                String string9 = Debug.logCreateManagedConnectionException(this.connectionPool.getName(), string8);
                if (!Debug.isConnectionsEnabled()) throw new ResourceException(string7, (Throwable)resourceAdapterInternalException);
                Debug.logStackTrace(string9, (Throwable)resourceAdapterInternalException);
                throw new ResourceException(string7, (Throwable)resourceAdapterInternalException);
            }
            if (managedConnection == null) {
                Debug.logCreateManagedConnectionError(this.connectionPool.getName());
                String string10 = Debug.getExceptionMCFCreateManagedConnectionReturnedNull();
                ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException(string10);
                throw new ResourceException(string10, (Throwable)resourceAdapterInternalException);
            }
            try {
                connectionInfo2 = ConnectionInfo.createConnectionInfo(this.connectionPool, string, managedConnection, securityContext);
                connectionInfo2.setCreationDurationTime(l);
            }
            catch (javax.resource.ResourceException resourceException) {
                this.cleanupManagedConnectionAfterFailure(managedConnection);
                String string11 = Debug.getExceptionFailedMCSetup();
                throw new ResourceException(string11, resourceException);
            }
            if (managedConnection != null && !this.connectionProxyChecked) {
                try {
                    if (this.connectionPool.getUseConnectionProxies() == null) {
                        this.testConnectionProxyViability(managedConnection, securityContext);
                    } else {
                        this.connectionPool.setCanUseProxy(this.connectionPool.getUseConnectionProxies());
                        if (Debug.isPoolingEnabled()) {
                            Debug.pooling("For pool '" + this.connectionPool.getName() + "', the user has specified that use-connection-proxies is '" + this.connectionPool.getUseConnectionProxies() + "'");
                        }
                    }
                    Object var15_33 = null;
                    this.connectionProxyChecked = true;
                }
                catch (Throwable throwable) {
                    Object var15_34 = null;
                    this.connectionProxyChecked = true;
                    Debug.exit(this, "createResource(...)");
                    throw throwable;
                }
                Debug.exit(this, "createResource(...)");
                {
                }
            }
            Object var19_36 = null;
        }
        catch (Throwable throwable) {
            Object var19_37 = null;
            Object var18_39 = null;
            if (bl) {
                InstrumentationSupport.postProcess((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, null, var18_39), (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Outbound, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            }
            if (!_WLDF$INST_FLD_Connector_After_Outbound.isEnabledAndNotDyeFiltered()) throw throwable;
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Outbound;
            InstrumentationSupport.process((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, null, var18_39), (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            throw throwable;
        }
        ConnectionInfo connectionInfo3 = connectionInfo;
        if (bl) {
            InstrumentationSupport.postProcess((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, null, (Object)connectionInfo3), (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Outbound, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        if (!_WLDF$INST_FLD_Connector_After_Outbound.isEnabledAndNotDyeFiltered()) return connectionInfo2;
        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Outbound;
        InstrumentationSupport.process((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, null, (Object)connectionInfo3), (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        return connectionInfo2;
    }

    public void refreshResource(PooledResource pooledResource) throws ResourceException {
    }

    private void cleanupManagedConnectionAfterFailure(ManagedConnection managedConnection) {
        block2: {
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            try {
                this.connectionPool.getRAInstanceManager().getAdapterLayer().destroy(managedConnection, authenticatedSubject);
            }
            catch (javax.resource.ResourceException resourceException) {
                if (!Debug.isConnectionsEnabled()) break block2;
                Debug.connections("WARNING: For pool '" + this.connectionPool.getName() + "':  Failed to destroy managed connection after createConnectionInfo failed:  " + this.connectionPool.getRAInstanceManager().getAdapterLayer().toString((Object)resourceException, authenticatedSubject));
                Throwable throwable = this.connectionPool.getRAInstanceManager().getAdapterLayer().getCause(resourceException, authenticatedSubject);
                if (throwable == null) break block2;
                String string = this.connectionPool.getRAInstanceManager().getAdapterLayer().toString(throwable, authenticatedSubject);
                Debug.connections("LinkedException:  " + string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void testConnectionProxyViability(ManagedConnection managedConnection, SecurityContext securityContext) {
        Throwable throwable;
        String string;
        block15: {
            if (this.connectionProxyChecked) return;
            string = this.connectionPool.getKey();
            Debug.logProxyTestStarted(string);
            Object object = null;
            throwable = null;
            ConnectionManagerImpl connectionManagerImpl = this.connectionPool.getConnMgr();
            connectionManagerImpl.setTestingProxy(true);
            connectionManagerImpl.setTestingProxyThread(Thread.currentThread());
            connectionManagerImpl.setMgdConnForTest(managedConnection);
            connectionManagerImpl.setSecurityContext(securityContext);
            try {
                try {
                    object = this.connectionPool.getConnectionFactory();
                    Class<?> clazz = object.getClass();
                    Method method = clazz.getMethod("getConnection", null);
                    if (method != null) {
                        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                        Object object2 = this.connectionPool.getRAInstanceManager().getAdapterLayer().invoke(method, object, null, authenticatedSubject);
                        this.closeProxyTestConnection(object2);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    IllegalAccessException illegalAccessException2 = illegalAccessException;
                    Object var12_21 = null;
                    connectionManagerImpl.setTestingProxy(false);
                    connectionManagerImpl.setMgdConnForTest(null);
                    connectionManagerImpl.setTestingProxyThread(null);
                    this.connectionProxyChecked = true;
                    this.connectionPool.setCanUseProxy(illegalAccessException2 == null);
                    if (illegalAccessException2 == null) {
                        Debug.logProxyTestSuccess(string);
                        return;
                    }
                    this.logProxyTestFailure(string, illegalAccessException2);
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    IllegalArgumentException illegalArgumentException2 = illegalArgumentException;
                    Object var12_22 = null;
                    connectionManagerImpl.setTestingProxy(false);
                    connectionManagerImpl.setMgdConnForTest(null);
                    connectionManagerImpl.setTestingProxyThread(null);
                    this.connectionProxyChecked = true;
                    this.connectionPool.setCanUseProxy(illegalArgumentException2 == null);
                    if (illegalArgumentException2 == null) {
                        Debug.logProxyTestSuccess(string);
                        return;
                    }
                    this.logProxyTestFailure(string, illegalArgumentException2);
                    return;
                }
                catch (InvocationTargetException invocationTargetException) {
                    InvocationTargetException invocationTargetException2 = invocationTargetException;
                    Object var12_23 = null;
                    connectionManagerImpl.setTestingProxy(false);
                    connectionManagerImpl.setMgdConnForTest(null);
                    connectionManagerImpl.setTestingProxyThread(null);
                    this.connectionProxyChecked = true;
                    this.connectionPool.setCanUseProxy(invocationTargetException2 == null);
                    if (invocationTargetException2 == null) {
                        Debug.logProxyTestSuccess(string);
                        return;
                    }
                    this.logProxyTestFailure(string, invocationTargetException2);
                    return;
                }
                catch (Throwable throwable2) {
                    Throwable throwable3;
                    Throwable throwable4 = throwable2.getCause();
                    Throwable throwable5 = throwable3 = throwable4 != null ? throwable4 : throwable2;
                    if (throwable4 instanceof ClassCastException) {
                        this.closeProxyTestConnection(this.connectionPool.getProxyTestConnectionHandle());
                    }
                    Object var12_24 = null;
                    connectionManagerImpl.setTestingProxy(false);
                    connectionManagerImpl.setMgdConnForTest(null);
                    connectionManagerImpl.setTestingProxyThread(null);
                    this.connectionProxyChecked = true;
                    this.connectionPool.setCanUseProxy(throwable3 == null);
                    if (throwable3 == null) {
                        Debug.logProxyTestSuccess(string);
                        return;
                    }
                    this.logProxyTestFailure(string, throwable3);
                    return;
                }
                Object var12_20 = null;
                connectionManagerImpl.setTestingProxy(false);
                connectionManagerImpl.setMgdConnForTest(null);
                connectionManagerImpl.setTestingProxyThread(null);
                this.connectionProxyChecked = true;
                this.connectionPool.setCanUseProxy(throwable == null);
                if (throwable != null) break block15;
            }
            catch (Throwable throwable6) {
                Object var12_25 = null;
                connectionManagerImpl.setTestingProxy(false);
                connectionManagerImpl.setMgdConnForTest(null);
                connectionManagerImpl.setTestingProxyThread(null);
                this.connectionProxyChecked = true;
                this.connectionPool.setCanUseProxy(throwable == null);
                if (throwable == null) {
                    Debug.logProxyTestSuccess(string);
                    throw throwable6;
                }
                this.logProxyTestFailure(string, throwable);
                throw throwable6;
            }
            Debug.logProxyTestSuccess(string);
            return;
        }
        this.logProxyTestFailure(string, throwable);
    }

    private void logProxyTestFailure(String string, Throwable throwable) {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        String string2 = this.connectionPool.getRAInstanceManager().getAdapterLayer().toString(throwable, authenticatedSubject);
        if (Debug.isConnectionsEnabled()) {
            Debug.logProxyTestError(string, throwable);
        } else {
            Debug.logProxyTestFailureInfo(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeProxyTestConnection(Object object) {
        block5: {
            Class<?> clazz = object.getClass();
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            try {
                try {
                    Method method = clazz.getMethod("close", null);
                    this.connectionPool.getRAInstanceManager().getAdapterLayer().invoke(method, object, null, authenticatedSubject);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Debug.logCloseNotFoundOnHandle(this.connectionPool.getName());
                    Object var7_6 = null;
                    this.connectionPool.setProxyTestConnectionHandle(null);
                    break block5;
                }
                catch (Exception exception) {
                    this.logProxyTestFailure(this.connectionPool.getKey(), exception);
                    Object var7_7 = null;
                    this.connectionPool.setProxyTestConnectionHandle(null);
                }
                Object var7_5 = null;
                this.connectionPool.setProxyTestConnectionHandle(null);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.connectionPool.setProxyTestConnectionHandle(null);
                throw throwable;
            }
        }
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.connector.outbound.ConnectionFactory");
        _WLDF$INST_FLD_Connector_After_Outbound = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_After_Outbound");
        _WLDF$INST_FLD_Connector_Around_Outbound = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Around_Outbound");
        _WLDF$INST_FLD_Connector_Before_Outbound = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Before_Outbound");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"ConnectionFactory.java", (String)"weblogic.connector.outbound.ConnectionFactory", (String)"createResource", (String)"(Lweblogic/common/resourcepool/PooledResourceInfo;)Lweblogic/common/resourcepool/PooledResource;", (int)60, null, (boolean)false);
    }
}

