/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.outbound;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.spi.DissociatableManagedConnection;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ResourceAdapterInternalException;
import weblogic.common.ResourceException;
import weblogic.connector.ConnectorLogger;
import weblogic.connector.common.Debug;
import weblogic.connector.common.RAInstanceManager;
import weblogic.connector.common.Utils;
import weblogic.connector.monitoring.outbound.ConnectionPoolRuntimeMBeanImpl;
import weblogic.connector.outbound.ConnectionHandler;
import weblogic.connector.outbound.ConnectionInfo;
import weblogic.connector.outbound.ConnectionPool;
import weblogic.connector.outbound.ConnectionState;
import weblogic.connector.outbound.ConnectionWrapper;
import weblogic.connector.security.outbound.SecurityContext;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.transaction.Transaction;
import weblogic.transaction.TransactionHelper;
import weblogic.utils.StackTraceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConnectionHandlerBaseImpl
implements ConnectionHandler {
    public volatile boolean connectionErrorOccurred;
    protected ConnectionPool connPool;
    protected SecurityContext securityContext;
    protected ManagedConnection managedConnection;
    protected ConnectionInfo connectionInfo;
    protected volatile boolean isDestroyed;
    private volatile Boolean physicallyDestroyed = false;
    private AtomicBoolean mcDestroyed = new AtomicBoolean(false);
    private Throwable destroyStacktrace;
    private int numHandlesCreated;
    private int activeHighCount;
    private int numActiveHandles;
    private Hashtable connectionStates;
    private String transSupport;
    private Hashtable objectTable = new Hashtable();
    private Hashtable refTable = new Hashtable();
    static final long serialVersionUID = -4294097268005257698L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_After_Outbound;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Around_Outbound;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Destroy_Connection_Low;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Before_Outbound;
    public static final JoinPoint _WLDF$INST_JPFLD_0;

    protected ConnectionHandlerBaseImpl(ManagedConnection managedConnection, ConnectionPool connectionPool, SecurityContext securityContext, ConnectionInfo connectionInfo, String string) {
        this.transSupport = string;
        this.managedConnection = managedConnection;
        this.connPool = connectionPool;
        this.securityContext = securityContext;
        this.numHandlesCreated = 0;
        this.activeHighCount = 0;
        this.connectionInfo = connectionInfo;
        this.numActiveHandles = 0;
        this.connectionStates = new Hashtable();
        this.connectionErrorOccurred = false;
        this.isDestroyed = false;
        this.initializeConnectionEventListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forcedCleanup() {
        if (Debug.isConnectionsEnabled()) {
            Debug.connections("For pool '" + this.connPool.getName() + "' a connection " + "has timed out.  Closing all handles and releasing back to the " + "available pool");
        }
        Utils.startManagement();
        try {
            this.connPool.trackIdle(this.connectionInfo.getAllocationCallStack());
            for (WeakReference weakReference : this.connectionStates.keySet()) {
                try {
                    this.closeConnection(weakReference);
                }
                catch (ResourceException resourceException) {
                    if (!Debug.isConnectionsEnabled()) continue;
                    Debug.connections("For pool '" + this.connPool.getName() + "' a ResourceException was thrown while trying to force cleanup " + "on idle connection handle:  " + (Object)((Object)resourceException));
                }
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Utils.stopManagement();
            throw throwable;
        }
        Utils.stopManagement();
    }

    @Override
    public void closeConnection(Object object) throws ResourceException {
        WeakReference weakReference = (WeakReference)this.refTable.get(object);
        this.closeConnection(weakReference);
    }

    private void closeConnection(WeakReference weakReference) throws ResourceException {
        if (weakReference != null) {
            ConnectionState connectionState = (ConnectionState)this.connectionStates.get(weakReference);
            if (connectionState != null) {
                connectionState.setConnectionClosed(true);
                this.untrackObject(weakReference);
                if (!connectionState.isConnectionFinalized()) {
                    this.decrementNumActiveHandles();
                    this.connPool.releaseOnConnectionClosed(this.connectionInfo);
                }
            } else if (!this.connPool.getConnMgr().isProxyBeingTested()) {
                Debug.logConnectionAlreadyClosed(this.connPool.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionFinalized(Reference reference) {
        if (Debug.isConnectionsEnabled()) {
            Debug.connections("connectionFinalized() for pool '" + this.connPool.getName() + "'");
        }
        try {
            ConnectionState connectionState = (ConnectionState)this.connectionStates.get(reference);
            if (connectionState != null) {
                Utils.startManagement();
                try {
                    if (this.untrackObject(reference) && !connectionState.isConnectionClosed() && !this.isConnectionErrorOccurred()) {
                        connectionState.setConnectionFinalized(true);
                        this.connPool.trackLeak(this.connectionInfo.getAllocationCallStack());
                        this.connPool.releaseOnConnectionClosed(this.connectionInfo);
                        this.decrementNumActiveHandles();
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    Utils.stopManagement();
                    throw throwable;
                }
                Utils.stopManagement();
                {
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (Debug.isConnectionsEnabled()) {
                Debug.connections("connectionFinalized() completed for pool '" + this.connPool.getName() + "'");
            }
            throw throwable;
        }
        if (Debug.isConnectionsEnabled()) {
            Debug.connections("connectionFinalized() completed for pool '" + this.connPool.getName() + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyConnection() {
        this.isDestroyed = true;
        if (!this.isInTransaction() || this.isConnectionErrorOccurred()) {
            Boolean bl = this.physicallyDestroyed;
            synchronized (bl) {
                if (!this.physicallyDestroyed.booleanValue()) {
                    this.connPool.destroyConnection(this.connectionInfo);
                    this.physicallyDestroyed = true;
                }
            }
        }
    }

    @Override
    public Object createConnectionHandle(SecurityContext securityContext) throws javax.resource.ResourceException {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        Object object = this.getRAiM().getAdapterLayer().getConnection(this.managedConnection, securityContext.getSubject(), securityContext.getClientInfo(), authenticatedSubject);
        if (object == null) {
            String string = Debug.getExceptionMCGetConnectionReturnedNull(this.managedConnection.getClass().getName());
            throw new ResourceAdapterInternalException(string);
        }
        return this.prepareHandle(object);
    }

    @Override
    public void associateConnectionHandle(Object object) throws javax.resource.ResourceException {
        if (Debug.isConnectionsEnabled()) {
            Debug.enter(this, "associateConnectionHandle()");
        }
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        this.getRAiM().getAdapterLayer().associateConnection(this.managedConnection, object, authenticatedSubject);
        this.prepareHandle(object);
        if (Debug.isConnectionsEnabled()) {
            Debug.exit(this, "associateConnectionHandle()");
        }
    }

    public abstract void enListResource() throws javax.resource.ResourceException;

    @Override
    public void cleanup() throws javax.resource.ResourceException {
        this.numHandlesCreated = 0;
        this.activeHighCount = 0;
        this.numActiveHandles = 0;
        this.connectionStates = new Hashtable();
        this.objectTable = new Hashtable();
        this.refTable = new Hashtable();
        this.connectionErrorOccurred = false;
        try {
            if (!this.isDestroyed && !this.mcDestroyed.get()) {
                AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                this.getRAiM().getAdapterLayer().cleanup(this.managedConnection, authenticatedSubject);
            }
        }
        catch (javax.resource.ResourceException resourceException) {
            Debug.logCloseConnectionError(this.transSupport, this.connectionInfo, "cleanup", resourceException);
            throw resourceException;
        }
        catch (Throwable throwable) {
            Debug.logCloseConnectionError(this.transSupport, this.connectionInfo, "cleanup", throwable);
            throw new javax.resource.ResourceException("Failed to cleanup ManagedConnection " + this.managedConnection, throwable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void destroy() {
        block13: {
            DynamicJoinPoint dynamicJoinPoint;
            Object[] objectArray;
            boolean bl = _WLDF$INST_FLD_Connector_Around_Outbound.isEnabledAndNotDyeFiltered();
            DiagnosticAction[] diagnosticActionArray = null;
            DiagnosticActionState[] diagnosticActionStateArray = null;
            Object var8_4 = null;
            if (bl) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Around_Outbound.isArgumentsCaptureNeeded()) {
                    objectArray = new Object[]{this};
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Around_Outbound;
                diagnosticActionArray = delegatingMonitor.getActions();
                diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
                InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            }
            if (_WLDF$INST_FLD_Connector_Destroy_Connection_Low.isEnabledAndNotDyeFiltered()) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Destroy_Connection_Low.isArgumentsCaptureNeeded()) {
                    objectArray = new Object[]{this};
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Destroy_Connection_Low;
                InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
            if (_WLDF$INST_FLD_Connector_Before_Outbound.isEnabledAndNotDyeFiltered()) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Before_Outbound.isArgumentsCaptureNeeded()) {
                    objectArray = new Object[]{this};
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Before_Outbound;
                InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
            try {
                AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                try {
                    this.destroyConnectionRuntimeMBean();
                    if (this.mcDestroyed.compareAndSet(false, true)) {
                        this.getRAiM().getAdapterLayer().destroy(this.managedConnection, authenticatedSubject);
                        this.destroyStacktrace = new Exception("ManagedConnection [" + this.managedConnection + "] of " + this.getConnectionInfo() + " is destoyed at " + new Date() + " in thread " + Thread.currentThread());
                    } else {
                        Exception exception = new Exception("ManagedConnection [" + this.managedConnection + "] of " + this.getConnectionInfo() + " is destoyed again at " + new Date() + " in thread " + Thread.currentThread());
                        ConnectorLogger.logMCDestroyedAlready((String)this.managedConnection.toString(), (String)this.getConnectionInfo().toString(), (String)this.getPoolName(), (String)(this.destroyStacktrace == null ? "previous stacktrace was not recorded" : StackTraceUtils.throwable2StackTrace((Throwable)this.destroyStacktrace)), (String)StackTraceUtils.throwable2StackTrace((Throwable)exception));
                    }
                }
                catch (Throwable throwable) {
                    Debug.logCloseConnectionError(this.transSupport, this.connectionInfo, "destroy", throwable);
                }
                Object var6_11 = null;
                if (!bl) break block13;
            }
            catch (Throwable throwable) {
                Object var6_12 = null;
                if (bl) {
                    InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Outbound, (DiagnosticAction[])diagnosticActionArray, diagnosticActionStateArray);
                }
                if (!_WLDF$INST_FLD_Connector_After_Outbound.isEnabledAndNotDyeFiltered()) throw throwable;
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Outbound;
                InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
                throw throwable;
            }
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Outbound, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        if (!_WLDF$INST_FLD_Connector_After_Outbound.isEnabledAndNotDyeFiltered()) return;
        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Outbound;
        InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_0, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
    }

    @Override
    public boolean shouldBeDiscard() {
        return this.isDestroyed || this.mcDestroyed.get() || this.connectionErrorOccurred || this.physicallyDestroyed != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void dissociateHandles() {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        try {
            block5: {
                try {
                    if (Debug.isConnectionsEnabled()) {
                        Debug.enter(this, "dissociateHandles()");
                    }
                    if (this.isInTransaction() || !(this.managedConnection instanceof DissociatableManagedConnection) || this.numActiveHandles <= 0 || !this.connectionInfo.isShareable()) break block5;
                    this.connectionStates.clear();
                    this.refTable.clear();
                    this.numActiveHandles = 0;
                    this.connPool.releaseOnConnectionClosed(this.connectionInfo);
                    this.getRAiM().getAdapterLayer().dissociateConnections((DissociatableManagedConnection)this.managedConnection, authenticatedSubject);
                }
                catch (javax.resource.ResourceException resourceException) {
                    String string = Debug.logDissociateHandlesFailed(this.connPool.getKey(), StackTraceUtils.throwable2StackTrace((Throwable)resourceException) + "\n" + (this.mcDestroyed.get() ? "ManagedConnection was destroyed previously at: " + (this.destroyStacktrace == null ? "previous stacktrace was not recorded" : StackTraceUtils.throwable2StackTrace((Throwable)this.destroyStacktrace)) : "ManagedConnection was not destroyed yet"));
                    Debug.logStackTrace(string, resourceException);
                    Debug.println(this.getRAiM().getAdapterLayer().toString((Object)resourceException, authenticatedSubject), "dissociateHandles failed");
                    Object var5_3 = null;
                    if (!Debug.isConnectionsEnabled()) return;
                    Debug.exit(this, "dissociateHandles()");
                    return;
                }
            }
            Object var5_2 = null;
            if (!Debug.isConnectionsEnabled()) return;
            Debug.exit(this, "dissociateHandles()");
            return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (!Debug.isConnectionsEnabled()) throw throwable;
            Debug.exit(this, "dissociateHandles()");
            throw throwable;
        }
    }

    protected synchronized void updateActiveHighCount() {
        if (this.numActiveHandles > this.activeHighCount) {
            this.activeHighCount = this.numActiveHandles;
        }
    }

    private synchronized void trackObject(Reference reference) {
        Integer n = (Integer)this.objectTable.get(reference);
        n = n == null ? new Integer(1) : new Integer(n + 1);
        this.objectTable.put(reference, n);
    }

    private synchronized boolean untrackObject(Reference reference) {
        boolean bl;
        Integer n = (Integer)this.objectTable.get(reference);
        if (n != null) {
            if ((n = new Integer(n - 1)) > 0) {
                bl = false;
                this.objectTable.put(reference, n);
            } else {
                bl = true;
                this.objectTable.remove(reference);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    protected synchronized void decrementNumActiveHandles() {
        --this.numActiveHandles;
    }

    protected synchronized void incrementNumActiveHandles() {
        ++this.numActiveHandles;
        this.updateActiveHighCount();
    }

    protected synchronized void incrementNumHandlesCreated() {
        ++this.numHandlesCreated;
    }

    protected void addConnectionRuntimeMBean() {
        ConnectionPoolRuntimeMBeanImpl connectionPoolRuntimeMBeanImpl;
        if (this.connPool == null) {
            Debug.throwAssertionError("ConnectionPool == null");
        }
        if ((connectionPoolRuntimeMBeanImpl = this.connPool.getRuntimeMBean()) == null) {
            Debug.throwAssertionError("ConnectionPool has a null runtime mbean");
        }
        if (this.connectionInfo == null) {
            Debug.throwAssertionError("connectionInfo == null");
        }
        connectionPoolRuntimeMBeanImpl.addConnectionRuntimeMBean(this.connectionInfo);
    }

    private void destroyConnectionRuntimeMBean() {
        ConnectionPoolRuntimeMBeanImpl connectionPoolRuntimeMBeanImpl;
        if (this.connPool == null) {
            Debug.throwAssertionError("ConnectionPool == null");
        }
        if ((connectionPoolRuntimeMBeanImpl = this.connPool.getRuntimeMBean()) == null) {
            Debug.throwAssertionError("ConnectionPool has a null runtime mbean");
        }
        if (this.connectionInfo == null) {
            Debug.throwAssertionError("connectionInfo == null");
        }
        connectionPoolRuntimeMBeanImpl.removeConnectionRuntimeMBean(this.connectionInfo);
    }

    private Object prepareHandle(Object object) throws javax.resource.ResourceException {
        this.enListResource();
        Object object2 = this.getConnectionOrProxy(object);
        WeakHandleReference weakHandleReference = new WeakHandleReference(object2, this);
        if (this.refTable.containsKey(object)) {
            String string = Debug.getExceptionDuplicateHandle();
            throw new ResourceAdapterInternalException(string);
        }
        this.trackObject(weakHandleReference);
        this.connectionStates.put(weakHandleReference, new ConnectionState());
        this.refTable.put(weakHandleReference, weakHandleReference);
        this.incrementNumActiveHandles();
        this.incrementNumHandlesCreated();
        return object2;
    }

    @Override
    public void setConnectionErrorOccurred(boolean bl) {
        this.connectionErrorOccurred = bl;
    }

    @Override
    public boolean isConnectionErrorOccurred() {
        return this.connectionErrorOccurred;
    }

    @Override
    public synchronized int getActiveHandlesHighCount() {
        return this.activeHighCount;
    }

    @Override
    public boolean isInTransaction() {
        return false;
    }

    @Override
    public int getHandlesCreatedTotalCount() {
        return this.getNumHandlesCreated();
    }

    @Override
    public String getPoolName() {
        return this.connPool.getName();
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    @Override
    public ManagedConnection getManagedConnection() {
        return this.managedConnection;
    }

    @Override
    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public boolean isCallingTransactionLocal() {
        Transaction transaction = (Transaction)TransactionHelper.getTransactionHelper().getTransaction();
        if (transaction != null) {
            return transaction.getProperty("LOCAL_ENTITY_TX") != null;
        }
        return false;
    }

    @Override
    public int getNumActiveConns() {
        return this.numActiveHandles;
    }

    @Override
    public ConnectionPool getPool() {
        return this.connPool;
    }

    protected int getNumHandlesCreated() {
        return this.numHandlesCreated;
    }

    private Object getConnectionOrProxy(Object object) {
        if (this.connPool.getCanUseProxy()) {
            Object object2 = ConnectionWrapper.createConnectionWrapper(this.connPool, this.connectionInfo, object);
            return object2;
        }
        return object;
    }

    protected abstract void initializeConnectionEventListener();

    protected RAInstanceManager getRAiM() {
        return this.connPool.getRAInstanceManager();
    }

    public Map<String, Object> dumpState() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("activeHighCount", this.activeHighCount);
        hashMap.put("connectionErrorOccurred", this.connectionErrorOccurred);
        hashMap.put("connectionInfo", this.connectionInfo);
        hashMap.put("connectionStates", this.connectionStates);
        hashMap.put("pool", (Object)this.connPool);
        hashMap.put("poolName", this.getPoolName());
        hashMap.put("destroyStacktrace", this.destroyStacktrace);
        hashMap.put("isDestroyed", this.isDestroyed);
        hashMap.put("managedConnection", this.managedConnection);
        hashMap.put("mcDestroyed", this.mcDestroyed);
        hashMap.put("numActiveHandles", this.numActiveHandles);
        hashMap.put("numHandlesCreated", this.numHandlesCreated);
        hashMap.put("objectTable", this.objectTable);
        hashMap.put("physicallyDestroyed", this.physicallyDestroyed);
        hashMap.put("refTable", this.refTable);
        hashMap.put("securityContext", this.securityContext);
        hashMap.put("transSupport", this.transSupport);
        hashMap.put("RAiM", this.getRAiM());
        return hashMap;
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.connector.outbound.ConnectionHandlerBaseImpl");
        _WLDF$INST_FLD_Connector_After_Outbound = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_After_Outbound");
        _WLDF$INST_FLD_Connector_Around_Outbound = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Around_Outbound");
        _WLDF$INST_FLD_Connector_Destroy_Connection_Low = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Destroy_Connection_Low");
        _WLDF$INST_FLD_Connector_Before_Outbound = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Before_Outbound");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"ConnectionHandlerBaseImpl.java", (String)"weblogic.connector.outbound.ConnectionHandlerBaseImpl", (String)"destroy", (String)"()V", (int)466, (Map)InstrumentationSupport.makeMap((String[])new String[]{"Connector_After_Outbound", "Connector_Destroy_Connection_Low", "Connector_Around_Outbound", "Connector_Before_Outbound"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{null, InstrumentationSupport.createPointcutHandlingInfo((ValueHandlingInfo)InstrumentationSupport.createValueHandlingInfo((String)"pool", (String)"weblogic.diagnostics.instrumentation.gathering.JCAConnectionHandlerPoolRenderer", (boolean)false, (boolean)true), null, null), null, null}), (boolean)false);
    }

    private class WeakHandleReference
    extends WeakReference {
        private ConnectionHandler connHandler;
        private int hash;

        public WeakHandleReference(Object object, ConnectionHandler connectionHandler) {
            super(object, null);
            this.connHandler = connectionHandler;
            this.hash = object.hashCode();
            if (Proxy.isProxyClass(object.getClass()) && Proxy.getInvocationHandler(object) instanceof ConnectionWrapper) {
                ((ConnectionWrapper)Proxy.getInvocationHandler(object)).setWeakReference(this);
            }
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            boolean bl;
            if (object == null) {
                bl = false;
            } else if (object instanceof WeakHandleReference) {
                bl = object == this;
            } else {
                Object object2 = this.get();
                if (object2 != null && Proxy.isProxyClass(object2.getClass()) && Proxy.getInvocationHandler(object2) instanceof ConnectionWrapper) {
                    ConnectionWrapper connectionWrapper = (ConnectionWrapper)Proxy.getInvocationHandler(object2);
                    object2 = connectionWrapper.getConnectionInstance();
                }
                bl = object2 == object;
            }
            return bl;
        }
    }
}

