/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.outbound;

import com.bea.connector.diagnostic.ManagedConnectionType;
import com.bea.connector.diagnostic.TransactionInfoType;
import com.bea.connector.diagnostic.TransactionType;
import java.security.AccessController;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.resource.spi.DissociatableManagedConnection;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.transaction.SystemException;
import weblogic.common.ResourceException;
import weblogic.common.resourcepool.PooledResource;
import weblogic.common.resourcepool.PooledResourceInfo;
import weblogic.common.resourcepool.ResourceCleanupHandler;
import weblogic.connector.common.ConnectorDiagnosticImageSource;
import weblogic.connector.common.Debug;
import weblogic.connector.common.Utils;
import weblogic.connector.external.TrackableConnection;
import weblogic.connector.outbound.ConnectionHandler;
import weblogic.connector.outbound.ConnectionPool;
import weblogic.connector.outbound.NoTxConnectionHandler;
import weblogic.connector.security.outbound.SecurityContext;
import weblogic.connector.transaction.outbound.LocalTxConnectionHandler;
import weblogic.connector.transaction.outbound.TxConnectionHandler;
import weblogic.connector.transaction.outbound.XATxConnectionHandler;
import weblogic.j2ee.MethodInvocationHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.transaction.Transaction;

public class ConnectionInfo
implements PooledResource,
TrackableConnection {
    ConnectionHandler connectionHandler;
    private long creationTime = 0L;
    private boolean connectionUsed = false;
    private boolean enabled = true;
    private int sharingCount = 0;
    private long lastUsedTime = 0L;
    private int pushCount = 0;
    private String allocationCallStack;
    private boolean shareable;
    private static final String CLASS_NAME = "weblogic.connector.outbound.ConnectionInfo";
    private long creationDurationTime = 0L;
    private long reserveDurationTime = 0L;
    private long reserveTime = 0L;
    boolean hasError = false;
    PooledResourceInfo prInfo = null;
    private boolean destroyAfterRelease;

    ConnectionInfo() {
    }

    public synchronized void incrementSharingCount() {
        if (Debug.verbose) {
            Debug.enter(this, "incrementSharingCount() of " + this + "; old sharingCount:" + this.sharingCount);
        }
        ++this.sharingCount;
        if (Debug.verbose) {
            Debug.exit(this, "incrementSharingCount() of " + this + "; new sharingCount:" + this.sharingCount);
        }
    }

    public synchronized void resetSharingCount() {
        if (Debug.verbose) {
            Debug.enter(this, "resetSharingCount() of " + this + "; old sharingCount:" + this.sharingCount);
        }
        this.sharingCount = 0;
        if (Debug.verbose) {
            Debug.exit(this, "resetSharingCount() of " + this + "; new sharingCount:" + this.sharingCount);
        }
    }

    public synchronized void decrementSharingCount() {
        if (Debug.verbose) {
            Debug.enter(this, "decrementSharingCount() of " + this + "; old sharingCount:" + this.sharingCount);
        }
        --this.sharingCount;
        if (Debug.verbose) {
            Debug.exit(this, "decrementSharingCount() of " + this + "; new sharingCount:" + this.sharingCount);
        }
    }

    public void initialize() {
        this.creationTime = System.currentTimeMillis();
    }

    public void setup() {
    }

    public void enable() {
        this.enabled = true;
    }

    public PooledResourceInfo getPooledResourceInfo() {
        return this.prInfo;
    }

    public void setPooledResourceInfo(PooledResourceInfo pooledResourceInfo) {
        this.prInfo = pooledResourceInfo;
    }

    public void disable() {
        this.enabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed() {
        if (Debug.verbose) {
            Debug.enter(this, "connectionClosed()");
        }
        Utils.startManagement();
        int n = this.decrementPushCount();
        try {
            if (n <= 0) {
                this.connectionHandler.dissociateHandles();
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Utils.stopManagement();
            if (Debug.verbose) {
                Debug.exit(this, "connectionClosed()");
            }
            throw throwable;
        }
        Utils.stopManagement();
        if (Debug.verbose) {
            Debug.exit(this, "connectionClosed()");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cleanup() throws ResourceException {
        if (Debug.verbose) {
            Debug.enter(this, "cleanup()");
        }
        this.sharingCount = 0;
        try {
            try {
                this.connectionHandler.cleanup();
            }
            catch (javax.resource.ResourceException resourceException) {
                throw new ResourceException(resourceException);
            }
            Object var3_1 = null;
            if (!Debug.verbose) return;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            if (!Debug.verbose) throw throwable;
            Debug.exit(this, "cleanup()");
            throw throwable;
        }
        Debug.exit(this, "cleanup()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (Debug.verbose) {
            Debug.enter(this, "destroy()");
        }
        Utils.startManagement();
        try {
            this.connectionHandler.destroy();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            Utils.stopManagement();
            if (Debug.verbose) {
                Debug.exit(this, "destroy()");
            }
            throw throwable;
        }
        Utils.stopManagement();
        if (Debug.verbose) {
            Debug.exit(this, "destroy()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int test() throws ResourceException {
        int n;
        Utils.startManagement();
        try {
            ManagedConnectionFactory managedConnectionFactory = this.connectionHandler.getPool().getManagedConnectionFactory();
            if (managedConnectionFactory instanceof ValidatingManagedConnectionFactory) {
                HashSet<ManagedConnection> hashSet = new HashSet<ManagedConnection>();
                Set set = null;
                hashSet.add(this.connectionHandler.getManagedConnection());
                AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                try {
                    set = this.connectionHandler.getPool().getRAInstanceManager().getAdapterLayer().getInvalidConnections((ValidatingManagedConnectionFactory)managedConnectionFactory, hashSet, authenticatedSubject);
                }
                catch (javax.resource.ResourceException resourceException) {
                    String string = Debug.getExceptionTestResourceException(this.connectionHandler.getPool().getRAInstanceManager().getAdapterLayer().toString((Object)resourceException, authenticatedSubject));
                    if (Debug.isConnectionsEnabled()) {
                        Debug.connections("Connection test failed: " + string, resourceException);
                    }
                    throw new ResourceException(string, resourceException);
                }
                catch (Throwable throwable) {
                    String string = Debug.getExceptionTestNonResourceException(this.connectionHandler.getPool().getRAInstanceManager().getAdapterLayer().toString(throwable, authenticatedSubject));
                    if (Debug.isConnectionsEnabled()) {
                        Debug.connections("Connection test failed: " + string, throwable);
                    }
                    throw new ResourceException(string, throwable);
                }
                if (set == null || set.isEmpty()) {
                    n = 0;
                } else {
                    n = -1;
                    this.hasError = true;
                    if (Debug.isConnectionsEnabled()) {
                        Debug.connections("Managed Connection " + this.connectionHandler.getManagedConnection() + " is not valid as reported by Adapter");
                    }
                }
            } else {
                String string = Debug.getExceptionMCFNotImplementValidatingMCF();
                if (Debug.isConnectionsEnabled()) {
                    Debug.connections(string);
                }
                throw new ResourceException(string);
            }
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            Utils.stopManagement();
            throw throwable;
        }
        Utils.stopManagement();
        return n;
    }

    public Object createConnectionHandle(SecurityContext securityContext) throws javax.resource.ResourceException {
        Object object = this.connectionHandler.createConnectionHandle(securityContext);
        if (object != null) {
            this.incrementSharingCount();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ConnectionInfo createConnectionInfo(ConnectionPool connectionPool, String string, ManagedConnection managedConnection, SecurityContext securityContext) throws javax.resource.ResourceException {
        if (Debug.verbose) {
            Debug.enter(CLASS_NAME, "createConnectioInfo() for pool '" + connectionPool.getName() + "' creating connection info/handler with " + string + " transaction support");
        }
        ConnectionInfo connectionInfo = new ConnectionInfo();
        Object var5_5 = null;
        try {
            try {
                void var5_9;
                if (string.equals("NoTransaction")) {
                    NoTxConnectionHandler noTxConnectionHandler = new NoTxConnectionHandler(managedConnection, connectionPool, securityContext, connectionInfo);
                } else if (string.equals("LocalTransaction")) {
                    LocalTxConnectionHandler localTxConnectionHandler = new LocalTxConnectionHandler(managedConnection, connectionPool, securityContext, connectionInfo);
                } else if (string.equals("XATransaction")) {
                    XATxConnectionHandler xATxConnectionHandler = new XATxConnectionHandler(managedConnection, connectionPool, securityContext, connectionInfo);
                } else {
                    String string2 = "Illegal value of transSupport passed to ConnectionHandlerImpl.createConnectionHandler(): " + string;
                    Debug.println(CLASS_NAME, ".createConnectionInfo() " + string2);
                    Debug.throwAssertionError(string2);
                }
                connectionInfo.setConnectionHandler((ConnectionHandler)var5_9);
            }
            catch (javax.resource.ResourceException resourceException) {
                Debug.println(CLASS_NAME, ".createConnectionInfo() Failed to create " + string + " Connection Handler");
                throw resourceException;
            }
            Object var8_12 = null;
            if (!Debug.verbose) return connectionInfo;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (!Debug.verbose) throw throwable;
            Debug.exit(CLASS_NAME, "createConnectionInfo()");
            throw throwable;
        }
        Debug.exit(CLASS_NAME, "createConnectionInfo()");
        return connectionInfo;
    }

    void associateConnectionHandle(Object object) throws javax.resource.ResourceException {
        this.connectionHandler.associateConnectionHandle(object);
    }

    public void setUsed(boolean bl) {
        this.connectionUsed = bl;
    }

    public void setResourceCleanupHandler(ResourceCleanupHandler resourceCleanupHandler) {
    }

    public void setConnectionHandler(ConnectionHandler connectionHandler) {
        this.connectionHandler = connectionHandler;
    }

    public void setLastUsedTime(long l) {
        this.lastUsedTime = l;
    }

    public void setAllocationCallStack(String string) {
        this.allocationCallStack = string;
    }

    void setShareable(boolean bl) {
        this.shareable = bl;
    }

    public boolean isLocalTransactionInProgress() {
        boolean bl = this.connectionHandler instanceof TxConnectionHandler ? ((TxConnectionHandler)this.connectionHandler).isLocalTransactionInProgress() : false;
        return bl;
    }

    public synchronized int getSharingCount() {
        return this.sharingCount;
    }

    public long getCreationTime() throws ResourceException {
        return this.creationTime;
    }

    public boolean getUsed() {
        return this.connectionUsed;
    }

    public ResourceCleanupHandler getResourceCleanupHandler() {
        return this.connectionHandler;
    }

    public ConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    public long getLastUsedTime() {
        return this.lastUsedTime;
    }

    public String getLastUsageString() {
        String string;
        if (this.lastUsedTime > 0L) {
            Date date = new Date(this.lastUsedTime);
            string = date.toString();
        } else {
            string = Debug.getStringNever();
        }
        return string;
    }

    public String getAllocationCallStack() {
        return this.allocationCallStack;
    }

    public boolean isInTransaction() {
        return this.connectionHandler.isInTransaction();
    }

    public boolean isBeingShared() {
        return this.sharingCount > 1;
    }

    public ManagedConnectionType getXMLBean(ConnectorDiagnosticImageSource connectorDiagnosticImageSource) {
        Object object;
        TransactionInfoType transactionInfoType;
        Transaction transaction;
        boolean bl;
        ManagedConnection managedConnection = this.connectionHandler.getManagedConnection();
        ManagedConnectionType managedConnectionType = ManagedConnectionType.Factory.newInstance();
        managedConnectionType.setHashcode(managedConnection.hashCode());
        managedConnectionType.setId(managedConnection.toString());
        boolean bl2 = bl = connectorDiagnosticImageSource != null ? connectorDiagnosticImageSource.timedout() : false;
        if (bl) {
            return managedConnectionType;
        }
        if (this.connectionHandler instanceof TxConnectionHandler && (transaction = (Transaction)((TxConnectionHandler)this.connectionHandler).getTransaction()) != null) {
            transactionInfoType = managedConnectionType.getTransactionInfo();
            if (transactionInfoType == null) {
                transactionInfoType = managedConnectionType.addNewTransactionInfo();
            }
            try {
                object = String.valueOf(transaction.getStatus());
            }
            catch (SystemException systemException) {
                object = "Not Available";
            }
            TransactionType transactionType = transactionInfoType.addNewTransaction();
            transactionType.setId(transaction.getXid().toString());
            transactionType.setStatus((String)object);
            transactionType.setTransactionType("XATransaction");
            transactionType.setEnlistmentTime("Not Available");
        }
        if (this.connectionHandler instanceof LocalTxConnectionHandler && (transaction = ((LocalTxConnectionHandler)this.connectionHandler).getLocalTransaction()) != null) {
            transactionInfoType = managedConnectionType.getTransactionInfo();
            if (transactionInfoType == null) {
                transactionInfoType = managedConnectionType.addNewTransactionInfo();
            }
            object = transactionInfoType.addNewTransaction();
            object.setId(transaction.toString());
            object.setStatus("Started");
            object.setTransactionType("LocalTransaction");
            object.setEnlistmentTime("Not Available");
        }
        return managedConnectionType;
    }

    boolean isShareable() {
        return this.shareable;
    }

    public String toString() {
        return "ConnectionInfo@" + this.hashCode() + " of pool " + this.connectionHandler.getPoolName();
    }

    public long getCreationDurationTime() {
        return this.creationDurationTime;
    }

    public long getReserveDurationTime() {
        return this.reserveDurationTime;
    }

    public long getReserveTime() {
        return this.reserveTime;
    }

    public void setCreationDurationTime(long l) {
        this.creationDurationTime = l;
    }

    public void setReserveDurationTime(long l) {
        this.reserveDurationTime = l;
    }

    public void setReserveTime(long l) {
        this.reserveTime = l;
    }

    public String getTransactionId() {
        Transaction transaction;
        String string = "";
        if (this.connectionHandler instanceof TxConnectionHandler && (transaction = (Transaction)((TxConnectionHandler)this.connectionHandler).getTransaction()) != null) {
            string = transaction.getXid().toString();
        }
        return string;
    }

    public boolean hasError() {
        return this.hasError;
    }

    protected void pushConnection() {
        ManagedConnection managedConnection = this.getConnectionHandler().getManagedConnection();
        if (!this.getConnectionHandler().getPool().getCanUseProxy() && managedConnection instanceof DissociatableManagedConnection) {
            MethodInvocationHelper.pushConnectionObject(this);
            this.incrementPushCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int incrementPushCount() {
        ConnectionInfo connectionInfo = this;
        synchronized (connectionInfo) {
            if (Debug.verbose) {
                Debug.println("incrementPushCount(): increase from " + this.pushCount + " to " + (this.pushCount + 1));
            }
            return ++this.pushCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int decrementPushCount() {
        ConnectionInfo connectionInfo = this;
        synchronized (connectionInfo) {
            if (Debug.verbose) {
                Debug.println("decrementPushCount(): decrease from " + this.pushCount + " to " + (this.pushCount - 1));
            }
            return --this.pushCount;
        }
    }

    public int getPushCount() {
        return this.pushCount;
    }

    public String getGroupId() {
        return null;
    }

    public boolean needDestroyAfterRelease() {
        return this.destroyAfterRelease || this.hasError || this.connectionHandler != null && this.connectionHandler.shouldBeDiscard();
    }

    public void setDestroyAfterRelease() {
        this.destroyAfterRelease = true;
    }
}

