/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.outbound;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.security.AccessController;
import javax.resource.spi.ApplicationServerInternalException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import weblogic.common.ResourceException;
import weblogic.connector.ConnectorLogger;
import weblogic.connector.common.Debug;
import weblogic.connector.common.RACollectionManager;
import weblogic.connector.common.RAInstanceManager;
import weblogic.connector.outbound.ConnectionHandler;
import weblogic.connector.outbound.ConnectionInfo;
import weblogic.connector.outbound.ConnectionManagerRemote;
import weblogic.connector.outbound.ConnectionPool;
import weblogic.connector.outbound.ConnectionReqInfo;
import weblogic.connector.outbound.ConnectionWrapper;
import weblogic.connector.security.outbound.SecurityContext;
import weblogic.connector.transaction.outbound.TxConnectionHandler;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class ConnectionManagerImpl
implements ConnectionManagerRemote {
    private static final long serialVersionUID = 7744058501606837252L;
    private transient boolean testingProxy;
    private transient Thread testingProxyThread;
    private String key;
    private String raJndi;
    private transient ManagedConnection mgdConnForTest;
    private transient SecurityContext secCtx;
    private transient ConnectionPool connPool;

    public ConnectionManagerImpl(ConnectionPool connectionPool) {
        Debug.println("Constructing the ConnectionManagerImpl : " + (Object)((Object)connectionPool));
        this.connPool = connectionPool;
        this.testingProxy = false;
        this.key = connectionPool.getKey();
        this.raJndi = connectionPool.getRAInstanceManager().getJndiName();
        this.mgdConnForTest = null;
    }

    public Object allocateConnection(ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws javax.resource.ResourceException {
        this.checkIfPoolIsValid("allocateConnection(...)");
        if (this.testingProxy && Thread.currentThread().equals(this.testingProxyThread)) {
            return this.testAllocateConnection(connectionRequestInfo);
        }
        if (Debug.getVerbose(this)) {
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            Debug.println(this, ".allocateConnection() called with cxReqInfo = " + this.connPool.getRAInstanceManager().getAdapterLayer().toString(connectionRequestInfo, authenticatedSubject));
        }
        return this.getConnection(connectionRequestInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lazyEnlist(ManagedConnection managedConnection) throws javax.resource.ResourceException {
        Debug.enter(this, "lazyEnlist(...)");
        this.checkIfPoolIsValid("lazyEnlist(...)");
        try {
            if (managedConnection != null) {
                ConnectionHandler connectionHandler = this.connPool.getConnectionHandler(managedConnection);
                if (connectionHandler instanceof TxConnectionHandler) {
                    ((TxConnectionHandler)connectionHandler).enListResource();
                }
            } else {
                Debug.logLazyEnlistNullMC();
                Debug.println(this, ".lazyEnlist() was passed a null Managed Connection");
                String string = Debug.getLazyEnlistNullMC(this.connPool.getKey());
                throw new javax.resource.ResourceException(string);
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            Debug.exit(this, "lazyEnlist(...)");
            throw throwable;
        }
        Debug.exit(this, "lazyEnlist(...)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateConnection(Object object, ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws javax.resource.ResourceException {
        try {
            Debug.enter(this, "associateConnection(...)");
            this.checkIfPoolIsValid("associateConnection(...)");
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            SecurityContext securityContext = this.connPool.createSecurityContext(connectionRequestInfo, false, authenticatedSubject);
            ConnectionInfo connectionInfo = this.getConnectionInfo(connectionRequestInfo, securityContext);
            connectionInfo.associateConnectionHandle(object);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            Debug.exit(this, "associateConnection(...)");
            throw throwable;
        }
        Debug.exit(this, "associateConnection(...)");
    }

    public Object testAllocateConnection(ConnectionRequestInfo connectionRequestInfo) throws javax.resource.ResourceException {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        if (Debug.getVerbose(this)) {
            Debug.println(this, ".testAllocateConnection() called for pool '" + this.connPool.getName() + "' with cxReqInfo=" + this.connPool.getRAInstanceManager().getAdapterLayer().toString(connectionRequestInfo, authenticatedSubject));
        }
        Object object = this.mgdConnForTest.getConnection(this.secCtx.getSubject(), this.secCtx.getClientInfo());
        this.connPool.setProxyTestConnectionHandle(object);
        return ConnectionWrapper.createProxyTestConnectionWrapper(this.connPool, object);
    }

    void setTestingProxy(boolean bl) {
        this.testingProxy = bl;
    }

    void setMgdConnForTest(ManagedConnection managedConnection) {
        this.mgdConnForTest = managedConnection;
    }

    void setSecurityContext(SecurityContext securityContext) {
        this.secCtx = securityContext;
    }

    void setTestingProxyThread(Thread thread2) {
        this.testingProxyThread = thread2;
    }

    boolean isProxyBeingTested() {
        return this.testingProxy;
    }

    private Object getConnection(ConnectionRequestInfo connectionRequestInfo) throws javax.resource.ResourceException {
        Debug.enter(this, "getConnection(...)");
        ConnectionInfo connectionInfo = null;
        Object object = null;
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        try {
            try {
                SecurityContext securityContext = this.connPool.createSecurityContext(connectionRequestInfo, false, authenticatedSubject);
                connectionInfo = this.getConnectionInfo(connectionRequestInfo, securityContext);
                object = connectionInfo.createConnectionHandle(securityContext);
            }
            catch (Throwable throwable) {
                if (Debug.isPoolingEnabled()) {
                    Debug.pooling().debug("Connection pool " + this.key + ":" + this + ": getConnection() failed with exception: " + throwable, throwable);
                }
                if (throwable instanceof javax.resource.ResourceException) {
                    throw (javax.resource.ResourceException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new javax.resource.ResourceException("Connection pool " + this + ": getConnection() failed with exception: " + throwable, throwable);
            }
            Object var7_7 = null;
            if (object == null && connectionInfo != null) {
                this.connPool.releaseResource(connectionInfo);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (object == null && connectionInfo != null) {
                this.connPool.releaseResource(connectionInfo);
            }
            Debug.exit(this, "getConnection(...)");
            throw throwable;
        }
        Debug.exit(this, "getConnection(...)");
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionInfo getConnectionInfo(ConnectionRequestInfo connectionRequestInfo, SecurityContext securityContext) throws javax.resource.ResourceException {
        Debug.enter(this, "getConnectionInfo(...)");
        ConnectionInfo connectionInfo = null;
        try {
            ConnectionReqInfo connectionReqInfo = new ConnectionReqInfo(connectionRequestInfo, securityContext);
            try {
                Debug.println(this, ".getConnectionInfo() Check if access is allowed");
                if (!securityContext.isAccessAllowed()) {
                    String string = Debug.getExceptionRAAccessDenied(this.connPool.getKey());
                    throw new ApplicationServerInternalException(string);
                }
                connectionReqInfo.setShareable(securityContext.isShareable());
                Debug.println(this, ".getConnectionInfo() Reserve connection from the pool");
                connectionInfo = (ConnectionInfo)this.connPool.reserveResource(connectionReqInfo);
            }
            catch (SecurityException securityException) {
                throw securityException;
            }
            catch (ResourceException resourceException) {
                Throwable throwable = resourceException.getNested();
                if (throwable != null && throwable instanceof ResourceException) {
                    throwable = ((ResourceException)((Object)throwable)).getNested();
                }
                if (throwable != null && throwable instanceof javax.resource.ResourceException) {
                    throw (javax.resource.ResourceException)throwable;
                }
                String string = Debug.getExceptionGetConnectionFailed(this.connPool.getKey(), resourceException.toString());
                throw new ApplicationServerInternalException(string, (Throwable)((Object)resourceException));
            }
            if (securityContext.isShareable()) {
                connectionInfo.pushConnection();
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            Debug.exit(this, "getConnectionInfo(...)");
            throw throwable;
        }
        Debug.exit(this, "getConnectionInfo(...)");
        return connectionInfo;
    }

    private void checkIfPoolIsValid(String string) throws IllegalStateException {
        if (this.connPool.isShutdown()) {
            throw new IllegalStateException(ConnectorLogger.getExceptionAllocateConnectionOnStaleConnectionFactory((String)this.connPool.getKey(), (String)string));
        }
    }

    private Object readResolve() throws ObjectStreamException {
        ConnectionPool connectionPool = null;
        RAInstanceManager rAInstanceManager = RACollectionManager.getRAInstanceManager(this.raJndi);
        if (rAInstanceManager != null) {
            connectionPool = rAInstanceManager.getRAOutboundManager().getConnectionPool(this.key);
        }
        if (connectionPool == null) {
            throw new InvalidObjectException(ConnectorLogger.getExceptionDeserializeConnectionManager());
        }
        return connectionPool.getConnMgr();
    }

    public String toString() {
        return super.toString() + "-" + this.key;
    }
}

