/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.outbound;

import com.bea.connector.diagnostic.ManagedConnectionType;
import com.bea.connector.diagnostic.OutboundAdapterType;
import com.bea.logging.RotatingFileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.resource.NotSupportedException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.SecurityException;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.transaction.SystemException;
import weblogic.common.ConnectDisabledException;
import weblogic.common.ResourceException;
import weblogic.common.resourcepool.PooledResource;
import weblogic.common.resourcepool.PooledResourceFactory;
import weblogic.common.resourcepool.PooledResourceInfo;
import weblogic.common.resourcepool.ResourcePoolImpl;
import weblogic.common.resourcepool.ResourcePoolProfiler;
import weblogic.connector.common.ConnectorDiagnosticImageSource;
import weblogic.connector.common.Debug;
import weblogic.connector.common.RAInstanceManager;
import weblogic.connector.external.OutboundInfo;
import weblogic.connector.monitoring.ConnectorComponentRuntimeMBeanImpl;
import weblogic.connector.monitoring.outbound.ConnectionPoolRuntimeMBeanImpl;
import weblogic.connector.outbound.ConnectionFactory;
import weblogic.connector.outbound.ConnectionHandler;
import weblogic.connector.outbound.ConnectionInfo;
import weblogic.connector.outbound.ConnectionManagerImpl;
import weblogic.connector.outbound.ConnectionPoolProfiler;
import weblogic.connector.outbound.ConnectionReqInfo;
import weblogic.connector.outbound.ConnectionSharingManager;
import weblogic.connector.outbound.RAOutboundManager;
import weblogic.connector.security.outbound.SecurityContext;
import weblogic.connector.transaction.outbound.RecoveryOnlyXAWrapper;
import weblogic.connector.transaction.outbound.ResourceRegistrationManager;
import weblogic.connector.transaction.outbound.XATxConnectionHandler;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;
import weblogic.jdbc.common.internal.ConnectionLeakProfile;
import weblogic.logging.LogFileConfigUtil;
import weblogic.logging.LoggingOutputStream;
import weblogic.logging.WLLevel;
import weblogic.logging.j2ee.LoggingBeanAdapter;
import weblogic.management.ManagementException;
import weblogic.management.logging.LogRuntime;
import weblogic.management.runtime.ConnectorComponentRuntimeMBean;
import weblogic.management.runtime.LogRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;

public class ConnectionPool
extends ResourcePoolImpl {
    public static final String CP_MATCH_CONNECTIONS_SUPORTED = "matchConnectionsSupported";
    private ConnectionPoolRuntimeMBeanImpl rMBean = null;
    private String poolName;
    private ManagedConnectionFactory managedConnectionFactory;
    private ConnectionSharingManager connectionSharingManager;
    private int numReserves = 0;
    private int numReleases = 0;
    private int numLeaks = 0;
    private int numMatchSuccesses;
    private int numRequestsRejected;
    private boolean canUseProxy;
    private ConnectionManagerImpl connMgr;
    private Object connectionFactory;
    private Vector leakProfiles;
    private Vector idleProfiles;
    private int numRecycled = 0;
    private ResourceRegistrationManager resRegManager = new ResourceRegistrationManager();
    private Object proxyTestConnectionHandle;
    private OutboundInfo initOutboundInfo;
    private OutboundInfo pendingOutboundInfo;
    private RAOutboundManager raOutboundManager;
    private RecoveryOnlyXAWrapper recoveryWrapper;
    private int alternateCount = 0;
    long closeCount = 0L;
    long freePoolSizeHighWaterMark = 0L;
    long freePoolSizeLowWaterMark = 0L;
    long poolSizeHighWaterMark = 0L;
    long poolSizeLowWaterMark = 0L;
    ConnectorComponentRuntimeMBean connRuntimeMbean;
    int connectionsDestroyedByErrorCount = 0;
    boolean useFirstAvailable;
    ResourcePoolProfiler profiler;
    private volatile boolean shutdown = false;
    private LoggingBeanAdapter loggingBeanAdapter = null;
    private LogRuntime logRuntime = null;
    private String applicationName;
    private String componentName;
    private boolean isShareAllowed;
    static final long serialVersionUID = -8294346449592412623L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_After_Outbound;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Around_Outbound;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Release_Connection_Low;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Before_Outbound;
    public static final DelegatingMonitor _WLDF$INST_FLD_Connector_Reserve_Connection_Low;
    public static final JoinPoint _WLDF$INST_JPFLD_0;
    public static final JoinPoint _WLDF$INST_JPFLD_1;

    public ConnectionPool(ManagedConnectionFactory managedConnectionFactory, OutboundInfo outboundInfo, String string, String string2, RAOutboundManager rAOutboundManager) {
        this.leakProfiles = new Vector();
        this.idleProfiles = new Vector();
        this.profiler = new ConnectionPoolProfiler(this);
        this.applicationName = string;
        this.componentName = string2;
        this.managedConnectionFactory = managedConnectionFactory;
        this.initOutboundInfo = outboundInfo;
        this.raOutboundManager = rAOutboundManager;
        this.setPoolName();
        this.connectionSharingManager = new ConnectionSharingManager(this.poolName);
        this.connMgr = new ConnectionManagerImpl(this);
        if (Debug.isPoolingEnabled()) {
            Debug.pooling("Constructed the connection pool : '" + this.poolName + "' with Key '" + this.getKey() + "'");
        }
        this.useFirstAvailable = outboundInfo.isUseFirstAvailable();
        this.isShareAllowed = !"NoTransaction".equals(outboundInfo.getTransactionSupport());
    }

    public void shutdown() throws ResourceException {
        this.undoSetupForXARecovery();
        super.shutdown();
        this.unregisterConnectionPoolRuntimeMBean();
        this.setLoggingBeanAdapter(null);
        this.shutdown = true;
    }

    public PooledResourceFactory initPooledResourceFactory(Properties properties) throws ResourceException {
        return new ConnectionFactory(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PooledResource matchResource(PooledResourceInfo pooledResourceInfo) throws ResourceException {
        if (pooledResourceInfo == null) {
            if (Debug.verbose) {
                Debug.enter((Object)this, "matchResource(): called with null. delegate to super's default behavior");
            }
            return super.matchResource(pooledResourceInfo);
        }
        Object object = null;
        HashSet<ManagedConnection> hashSet = new HashSet<ManagedConnection>();
        Hashtable hashtable = new Hashtable();
        Object[] objectArray = null;
        ManagedConnection managedConnection = null;
        ConnectionInfo connectionInfo = null;
        SecurityContext securityContext = null;
        if (Debug.verbose) {
            Debug.enter((Object)this, "matchResource()");
        }
        if (Debug.isPoolVerboseEnabled()) {
            this.debugVerbose("matchResource() called with PoolResourceInfo: " + pooledResourceInfo.toString());
            this.dumpPool("at start of matchResource");
        }
        try {
            objectArray = this.available.toArray();
            int n = this.available.size();
            if (!this.useFirstAvailable) {
                securityContext = ((ConnectionReqInfo)pooledResourceInfo).getSecurityContext();
                if (Debug.isPoolVerboseEnabled()) {
                    this.debugVerbose("There are " + n + " in the available list");
                }
                AuthenticatedSubject authenticatedSubject = null;
                if (objectArray != null && n > 0) {
                    if (authenticatedSubject == null) {
                        authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                    }
                    for (int i = 0; i < n; ++i) {
                        PooledResource pooledResource = (PooledResource)objectArray[i];
                        ConnectionInfo connectionInfo2 = (ConnectionInfo)objectArray[i];
                        hashSet.add(connectionInfo2.getConnectionHandler().getManagedConnection());
                        this.getRAInstanceManager().getAdapterLayer().htPut(hashtable, connectionInfo2.getConnectionHandler().getManagedConnection(), pooledResource, authenticatedSubject);
                    }
                }
                if (hashSet.size() > 0) {
                    if (authenticatedSubject == null) {
                        authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                    }
                    try {
                        managedConnection = this.getRAInstanceManager().getAdapterLayer().matchManagedConnection(this.managedConnectionFactory, hashSet, securityContext.getSubject(), securityContext.getClientInfo(), authenticatedSubject);
                    }
                    catch (NotSupportedException notSupportedException) {
                        this.matchSupported = false;
                    }
                    catch (javax.resource.ResourceException resourceException) {
                        throw new ResourceException(resourceException);
                    }
                }
                if (managedConnection != null) {
                    if (authenticatedSubject == null) {
                        authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                    }
                    if ((connectionInfo = (ConnectionInfo)this.getRAInstanceManager().getAdapterLayer().htGet(hashtable, managedConnection, authenticatedSubject)) != null) {
                        if (Debug.isPoolVerboseEnabled()) {
                            this.debugVerbose("removing " + connectionInfo.toString() + " from available");
                        }
                        if (this.available.remove((Object)connectionInfo)) {
                            object = connectionInfo;
                        }
                        this.incrementNumMatchSuccesses();
                    }
                }
            } else if (n > 0 && this.available.remove(objectArray[0])) {
                object = (PooledResource)objectArray[0];
            }
            Object var15_16 = null;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            if (Debug.isPoolVerboseEnabled()) {
                this.dumpPool("on exiting matchResource()");
                this.debugVerbose("exiting ConnectionPool.matchResource() and returning " + (object == null ? "null" : object.toString()));
            }
            if (Debug.verbose) {
                Debug.exit((Object)this, "matchResource()");
            }
            throw throwable;
        }
        if (Debug.isPoolVerboseEnabled()) {
            this.dumpPool("on exiting matchResource()");
            this.debugVerbose("exiting ConnectionPool.matchResource() and returning " + (object == null ? "null" : object.toString()));
        }
        if (Debug.verbose) {
            Debug.exit((Object)this, "matchResource()");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PooledResource reserveResource(int n, PooledResourceInfo pooledResourceInfo) throws ResourceException {
        ConnectionInfo connectionInfo;
        ConnectionInfo connectionInfo2;
        DynamicJoinPoint dynamicJoinPoint;
        Object[] objectArray;
        boolean bl = _WLDF$INST_FLD_Connector_Around_Outbound.isEnabledAndNotDyeFiltered();
        DiagnosticAction[] diagnosticActionArray = null;
        DiagnosticActionState[] diagnosticActionStateArray = null;
        Object var14_6 = null;
        if (bl) {
            objectArray = null;
            if (_WLDF$INST_FLD_Connector_Around_Outbound.isArgumentsCaptureNeeded()) {
                objectArray = new Object[]{this, InstrumentationSupport.convertToObject((int)n), pooledResourceInfo};
            }
            dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Around_Outbound;
            diagnosticActionArray = delegatingMonitor.getActions();
            diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
            InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        if (_WLDF$INST_FLD_Connector_Before_Outbound.isEnabledAndNotDyeFiltered()) {
            objectArray = null;
            if (_WLDF$INST_FLD_Connector_Before_Outbound.isArgumentsCaptureNeeded()) {
                objectArray = new Object[]{this, InstrumentationSupport.convertToObject((int)n), pooledResourceInfo};
            }
            dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Before_Outbound;
            InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        }
        if (_WLDF$INST_FLD_Connector_Reserve_Connection_Low.isEnabledAndNotDyeFiltered()) {
            objectArray = null;
            if (_WLDF$INST_FLD_Connector_Reserve_Connection_Low.isArgumentsCaptureNeeded()) {
                objectArray = new Object[]{this, InstrumentationSupport.convertToObject((int)n), pooledResourceInfo};
            }
            dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, (Object[])objectArray, null);
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Reserve_Connection_Low;
            InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        }
        try {
            long l;
            block24: {
                if (Debug.verbose) {
                    Debug.enter((Object)this, "reserveResource()");
                }
                if (Debug.isPoolVerboseEnabled()) {
                    this.debugVerbose("Entering reserveResource( " + n + ", " + pooledResourceInfo.toString() + " )");
                    this.debugVerbose("reserveResource() current capacity = " + this.getCurrCapacity() + ", max capacity = " + this.getMaxCapacity());
                    this.dumpPool("on entering reserveResource");
                }
                connectionInfo2 = null;
                l = System.currentTimeMillis();
                try {
                    block23: {
                        try {
                            if (this.state != 101 && this.state != 103) {
                                String string = Debug.getExceptionPoolDisabled(this.poolName);
                                throw new ConnectDisabledException(string);
                            }
                            boolean bl2 = ((ConnectionReqInfo)pooledResourceInfo).isShareable();
                            if (this.isShareAllowed && bl2) {
                                connectionInfo2 = this.connectionSharingManager.getSharedConnection();
                            }
                            if (connectionInfo2 != null) break block23;
                            connectionInfo2 = (ConnectionInfo)super.reserveResource(n, pooledResourceInfo);
                            connectionInfo2.setShareable(bl2);
                            this.incrementNumReserves();
                            if (this.isShareAllowed && bl2) {
                                this.connectionSharingManager.addSharedConnection(connectionInfo2);
                            }
                        }
                        catch (ResourceException resourceException) {
                            this.incrementNumRequestsRejected();
                            throw resourceException;
                        }
                    }
                    if (Debug.isPoolVerboseEnabled()) {
                        this.dumpPool("on exiting reserveResource");
                        this.debugVerbose("Returning " + connectionInfo2 + " from reserveResource(  " + n + ", " + pooledResourceInfo.toString() + " )");
                    }
                    Debug.assertion(connectionInfo2 != null, "returnConnectionInfo != null");
                    this.updatePoolStats();
                    Object var8_16 = null;
                    if (!Debug.verbose) break block24;
                }
                catch (Throwable throwable) {
                    Object var8_17 = null;
                    if (Debug.verbose) {
                        Debug.exit((Object)this, "reserveResource()");
                    }
                    throw throwable;
                }
                Debug.exit((Object)this, "reserveResource()");
            }
            long l2 = System.currentTimeMillis();
            connectionInfo2.setReserveDurationTime(l2 - l);
            connectionInfo2.setReserveTime(l2);
            Object var12_19 = null;
        }
        catch (Throwable throwable) {
            Object var12_20 = null;
            Object var11_22 = null;
            if (bl) {
                InstrumentationSupport.postProcess((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, null, var11_22), (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Outbound, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            }
            if (_WLDF$INST_FLD_Connector_After_Outbound.isEnabledAndNotDyeFiltered()) {
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Outbound;
                InstrumentationSupport.process((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, null, var11_22), (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
            throw throwable;
        }
        ConnectionInfo connectionInfo3 = connectionInfo;
        if (bl) {
            InstrumentationSupport.postProcess((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, null, (Object)connectionInfo3), (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Outbound, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        if (_WLDF$INST_FLD_Connector_After_Outbound.isEnabledAndNotDyeFiltered()) {
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Outbound;
            InstrumentationSupport.process((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, null, (Object)connectionInfo3), (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        }
        return connectionInfo2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void releaseResource(PooledResource pooledResource) {
        block26: {
            DynamicJoinPoint dynamicJoinPoint;
            Object[] objectArray;
            boolean bl = _WLDF$INST_FLD_Connector_Around_Outbound.isEnabledAndNotDyeFiltered();
            DiagnosticAction[] diagnosticActionArray = null;
            DiagnosticActionState[] diagnosticActionStateArray = null;
            Object var13_5 = null;
            if (bl) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Around_Outbound.isArgumentsCaptureNeeded()) {
                    objectArray = new Object[]{this, pooledResource};
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Around_Outbound;
                diagnosticActionArray = delegatingMonitor.getActions();
                diagnosticActionStateArray = InstrumentationSupport.getActionStates((DiagnosticAction[])diagnosticActionArray);
                InstrumentationSupport.preProcess((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
            }
            if (_WLDF$INST_FLD_Connector_Release_Connection_Low.isEnabledAndNotDyeFiltered()) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Release_Connection_Low.isArgumentsCaptureNeeded()) {
                    objectArray = new Object[]{this, pooledResource};
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Release_Connection_Low;
                InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
            if (_WLDF$INST_FLD_Connector_Before_Outbound.isEnabledAndNotDyeFiltered()) {
                objectArray = null;
                if (_WLDF$INST_FLD_Connector_Before_Outbound.isArgumentsCaptureNeeded()) {
                    objectArray = new Object[]{this, pooledResource};
                }
                dynamicJoinPoint = InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_1, (Object[])objectArray, null);
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_Before_Outbound;
                InstrumentationSupport.process((JoinPoint)dynamicJoinPoint, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            }
            try {
                if (Debug.verbose) {
                    Debug.enter((Object)this, "releaseResource()");
                }
                if (Debug.isPoolVerboseEnabled()) {
                    this.debugVerbose("Entering releaseResource( " + pooledResource + ")");
                    this.dumpPool("on entering releaseResource");
                }
                try {
                    block25: {
                        int n = this.available.size();
                        int n2 = this.reserved.size();
                        try {
                            ConnectionPool connectionPool = this;
                            synchronized (connectionPool) {
                                if (this.reserved.contains((Object)pooledResource)) {
                                    if (Debug.isPoolVerboseEnabled()) {
                                        this.debugVerbose("calling super.releaseResource()");
                                    }
                                    super.releaseResource(pooledResource);
                                    this.incrementNumReleases();
                                } else {
                                    Debug.logReReleasingResource(this.poolName);
                                }
                            }
                        }
                        catch (ResourceException resourceException) {
                            ((ConnectionInfo)pooledResource).getConnectionHandler().destroyConnection();
                            if (!Debug.isPoolVerboseEnabled()) break block25;
                            this.debugVerbose("Exception/exiting releaseResource( " + pooledResource + ")", (Throwable)((Object)resourceException));
                        }
                    }
                    if (Debug.isPoolVerboseEnabled()) {
                        this.dumpPool("on exiting releaseResource");
                    }
                    this.updatePoolStats();
                    Object var7_14 = null;
                }
                catch (Throwable throwable) {
                    Object var7_15 = null;
                    if (Debug.isPoolVerboseEnabled()) {
                        this.debugVerbose("Exiting releaseResource( " + pooledResource + ")");
                    }
                    if (!Debug.verbose) throw throwable;
                    Debug.exit((Object)this, "releaseResource()");
                    throw throwable;
                }
                if (Debug.isPoolVerboseEnabled()) {
                    this.debugVerbose("Exiting releaseResource( " + pooledResource + ")");
                }
                if (Debug.verbose) {
                    Debug.exit((Object)this, "releaseResource()");
                }
                Object var11_17 = null;
                if (!bl) break block26;
            }
            catch (Throwable throwable) {
                Object var11_18 = null;
                if (bl) {
                    InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Outbound, (DiagnosticAction[])diagnosticActionArray, diagnosticActionStateArray);
                }
                if (!_WLDF$INST_FLD_Connector_After_Outbound.isEnabledAndNotDyeFiltered()) throw throwable;
                DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Outbound;
                InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
                throw throwable;
            }
            InstrumentationSupport.postProcess((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)_WLDF$INST_FLD_Connector_Around_Outbound, (DiagnosticAction[])diagnosticActionArray, (DiagnosticActionState[])diagnosticActionStateArray);
        }
        if (!_WLDF$INST_FLD_Connector_After_Outbound.isEnabledAndNotDyeFiltered()) return;
        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_Connector_After_Outbound;
        InstrumentationSupport.process((JoinPoint)_WLDF$INST_JPFLD_1, (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseOnTransactionCompleted(ConnectionInfo connectionInfo) {
        if (Debug.verbose) {
            Debug.enter((Object)this, "releaseOnTransactionCompleted()");
        }
        try {
            if (Debug.isPoolVerboseEnabled()) {
                this.debugVerbose("Entering releaseOnTransactionCompleted() with ConnectionInfo = " + connectionInfo);
            }
            this.releaseResource(connectionInfo, true);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (Debug.isPoolVerboseEnabled()) {
                this.debugVerbose("Exiting releaseOnTransactionCompleted() with ConnectionInfo = " + connectionInfo);
            }
            if (Debug.verbose) {
                Debug.exit((Object)this, "releaseOnTransactionCompleted()");
            }
            throw throwable;
        }
        if (Debug.isPoolVerboseEnabled()) {
            this.debugVerbose("Exiting releaseOnTransactionCompleted() with ConnectionInfo = " + connectionInfo);
        }
        if (Debug.verbose) {
            Debug.exit((Object)this, "releaseOnTransactionCompleted()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseOnConnectionClosed(ConnectionInfo connectionInfo) {
        if (Debug.verbose) {
            Debug.enter((Object)this, "releaseOnConnectionClosed()");
        }
        try {
            if (Debug.isPoolVerboseEnabled()) {
                this.debugVerbose("Entering releaseOnConnectionClosed() with ConnectionInfo = " + connectionInfo);
            }
            this.releaseResource(connectionInfo, false);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (Debug.isPoolVerboseEnabled()) {
                this.debugVerbose("Exiting releaseOnConnectionClosed() with ConnectionInfo = " + connectionInfo);
            }
            if (Debug.verbose) {
                Debug.exit((Object)this, "releaseOnConnectionClosed()");
            }
            throw throwable;
        }
        if (Debug.isPoolVerboseEnabled()) {
            this.debugVerbose("Exiting releaseOnConnectionClosed() with ConnectionInfo = " + connectionInfo);
        }
        if (Debug.verbose) {
            Debug.exit((Object)this, "releaseOnConnectionClosed()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyConnection(ConnectionInfo connectionInfo) {
        Debug.enter((Object)this, "destroyConnection()");
        if (Debug.isPoolVerboseEnabled()) {
            this.debugVerbose("Entering ConnectionPool.destroyConnection() with ConnectionInfo  " + connectionInfo);
            this.dumpPool("on entering destroyConnection");
        }
        try {
            if (Debug.isPoolVerboseEnabled()) {
                this.debugVerbose("Removing " + connectionInfo + " from the reserved ");
            }
            ConnectionPool connectionPool = this;
            synchronized (connectionPool) {
                ConnectionInfo connectionInfo2 = null;
                if (this.reserved.remove((Object)connectionInfo)) {
                    connectionInfo2 = connectionInfo;
                }
                if (connectionInfo2 == null && this.available.remove((Object)connectionInfo)) {
                    connectionInfo2 = connectionInfo;
                }
            }
            connectionInfo.destroy();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (Debug.isPoolVerboseEnabled()) {
                this.dumpPool("on exiting destroyConnection");
                this.debugVerbose("Exiting ConnectionPool.destroyConnection() with ConnectionInfo  " + connectionInfo.toString());
            }
            if (Debug.verbose) {
                Debug.exit((Object)this, "destroyConnection(");
            }
            throw throwable;
        }
        if (Debug.isPoolVerboseEnabled()) {
            this.dumpPool("on exiting destroyConnection");
            this.debugVerbose("Exiting ConnectionPool.destroyConnection() with ConnectionInfo  " + connectionInfo.toString());
        }
        if (Debug.verbose) {
            Debug.exit((Object)this, "destroyConnection(");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpPool(String string) {
        if (Debug.isPoolVerboseEnabled()) {
            this.debugVerbose(" DUMP of ConnectionPool[ " + string + " ]");
            try {
                ConnectionPool connectionPool = this;
                synchronized (connectionPool) {
                    this.debugVerbose(" currCapacity = " + this.getCurrCapacity() + " maxCapacity = " + this.getMaxCapacity() + " numReserves = " + this.numReserves + " numReleases = " + this.numReleases);
                    this.dumpPoolLists();
                }
            }
            catch (Exception exception) {
                this.debugVerbose("Exception occurred attempting to dump the connection pool", exception);
            }
        }
    }

    public SecurityContext createSecurityContext(ConnectionRequestInfo connectionRequestInfo, boolean bl, AuthenticatedSubject authenticatedSubject) throws SecurityException {
        return new SecurityContext(this.initOutboundInfo, this.applicationName, this.componentName, this.poolName, this.managedConnectionFactory, connectionRequestInfo, bl, authenticatedSubject);
    }

    public synchronized void incrementNumReserves() {
        ++this.numReserves;
    }

    public synchronized void incrementNumReleases() {
        ++this.numReleases;
    }

    public void suspend() throws ResourceException {
        super.suspend(false);
    }

    public void resume() throws ResourceException {
        super.resume();
    }

    protected PooledResource refreshOldestAvailResource(PooledResourceInfo pooledResourceInfo) throws ResourceException {
        PooledResource pooledResource = null;
        if (this.available.size() > 0 && (pooledResource = this.getOldestUnreservedResource()) != null) {
            this.available.remove((Object)pooledResource);
            pooledResource.destroy();
            pooledResource = null;
            Object[] objectArray = new PooledResourceInfo[1];
            Arrays.fill(objectArray, pooledResourceInfo);
            Vector vector = new Vector();
            super.makeResources(1, (PooledResourceInfo[])objectArray, vector, false);
            if (vector.size() > 0) {
                pooledResource = (PooledResource)vector.firstElement();
                if (pooledResource != null) {
                    this.available.remove((Object)pooledResource);
                }
                ++this.numRecycled;
            }
        }
        return pooledResource;
    }

    protected void initParameters(Properties properties) {
        super.initParameters(properties);
        String string = properties.getProperty(CP_MATCH_CONNECTIONS_SUPORTED);
        if (string != null) {
            this.matchSupported = Boolean.valueOf(string);
        }
        this.returnNewlyCreatedResource = true;
    }

    protected synchronized void incrementNumMatchSuccesses() {
        ++this.numMatchSuccesses;
    }

    protected synchronized void incrementNumRequestsRejected() {
        ++this.numRequestsRejected;
    }

    protected synchronized void trackLeak(String string) {
        ++this.numLeaks;
        if (this.getConnectionProfilingEnabled()) {
            this.leakProfiles.add(new ConnectionLeakProfile(this.poolName, string));
        }
    }

    protected synchronized void trackIdle(String string) {
        if (this.getConnectionProfilingEnabled()) {
            this.idleProfiles.add(new ConnectionLeakProfile(this.poolName, string));
        }
    }

    void debugXAout(String string) {
        if (Debug.isXAoutEnabled()) {
            Debug.xaOut("For pool '" + this.poolName + "' " + string);
        }
    }

    void debugXAout(String string, Throwable throwable) {
        if (Debug.isXAoutEnabled()) {
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            String string2 = this.getRAInstanceManager().getAdapterLayer().throwable2StackTrace(throwable, authenticatedSubject);
            Debug.xaOut("For pool '" + this.poolName + "' " + string + "\n" + string2);
        }
    }

    void debugVerbose(String string) {
        if (Debug.isPoolVerboseEnabled()) {
            Debug.poolVerbose("For pool '" + this.poolName + "' " + string);
        }
    }

    void debugVerbose(String string, Throwable throwable) {
        if (Debug.isPoolVerboseEnabled()) {
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            String string2 = this.getRAInstanceManager().getAdapterLayer().throwable2StackTrace(throwable, authenticatedSubject);
            Debug.poolVerbose("For pool '" + this.poolName + "' " + string + ":\n" + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseResource(PooledResource pooledResource, boolean bl) {
        Debug.enter((Object)this, "releaseResource()");
        if (Debug.isPoolVerboseEnabled()) {
            this.debugVerbose("on entering releaseResource() PooledResource = " + pooledResource.toString() + " & transCompleted = " + bl);
            this.dumpPool("on entering releaseResource");
        }
        ConnectionInfo connectionInfo = (ConnectionInfo)pooledResource;
        try {
            if (this.state != 100) {
                if (this.connectionSharingManager.releaseSharedConnection(connectionInfo, bl)) {
                    if (Debug.isPoolVerboseEnabled()) {
                        this.debugVerbose("calling releaseResource( " + pooledResource + " )");
                    }
                    this.releaseResource(pooledResource);
                } else if (Debug.isPoolVerboseEnabled()) {
                    this.debugVerbose("Not calling releaseResource( " + pooledResource + " )");
                }
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (Debug.isPoolVerboseEnabled()) {
                this.dumpPool("on exiting releaseResource");
            }
            if (Debug.verbose) {
                Debug.exit((Object)this, "releaseResource()");
            }
            throw throwable;
        }
        if (Debug.isPoolVerboseEnabled()) {
            this.dumpPool("on exiting releaseResource");
        }
        if (Debug.verbose) {
            Debug.exit((Object)this, "releaseResource()");
        }
    }

    private void unregisterConnectionPoolRuntimeMBean() {
        try {
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            SecurityServiceManager.runAs((AuthenticatedSubject)authenticatedSubject, (AuthenticatedSubject)authenticatedSubject, (PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    try {
                        if (ConnectionPool.this.rMBean != null) {
                            if (Debug.verbose) {
                                Debug.println(this, ".unregisterConnectionPoolRuntimeMBean() -- unregistering " + ConnectionPool.this.rMBean.getName());
                            }
                            ConnectionPool.this.rMBean.unregister();
                            ((ConnectorComponentRuntimeMBeanImpl)ConnectionPool.this.connRuntimeMbean).removeConnPoolRuntime(ConnectionPool.this.rMBean);
                        }
                        return null;
                    }
                    catch (Exception exception) {
                        Debug.logUnregisterConnRTMBeanError(ConnectionPool.this.poolName, exception.toString());
                        return null;
                    }
                }
            });
        }
        catch (Exception exception) {
            Debug.logUnregisterCPRTMBeanError(this.poolName, exception.toString());
        }
    }

    private void dumpPoolLists() {
        if (Debug.isPoolVerboseEnabled()) {
            this.debugVerbose(" DUMPING available list, #entries = " + this.available.size());
        }
        int n = 0;
        ListIterator listIterator = this.available.listIterator(0);
        while (listIterator.hasNext()) {
            ConnectionInfo connectionInfo = (ConnectionInfo)listIterator.next();
            if (!Debug.isPoolVerboseEnabled()) continue;
            this.debugVerbose(" available list[" + n++ + "].connectionInfo = " + connectionInfo + ", sharingCount = " + connectionInfo.getSharingCount());
        }
        if (Debug.isPoolVerboseEnabled()) {
            this.debugVerbose(" DUMPING reserved list, #entries = " + this.reserved.size());
        }
        n = 0;
        for (ConnectionInfo connectionInfo : this.reserved) {
            if (!Debug.isPoolVerboseEnabled()) continue;
            this.debugVerbose(" reserved list[" + n++ + "].connectionInfo = " + connectionInfo + ", sharingCount = " + connectionInfo.getSharingCount());
        }
        if (Debug.isPoolVerboseEnabled()) {
            this.debugVerbose(" DUMPING dead list, #entries = " + this.dead.size());
        }
    }

    public void setupForXARecovery() throws ResourceException {
        if (this.getTransactionSupport().equalsIgnoreCase("XATransaction")) {
            try {
                this.recoveryWrapper = RecoveryOnlyXAWrapper.initializeRecoveryOnlyXAWrapper(this);
                this.debugXAout("Registered XAResource for recovery:  " + this.recoveryWrapper);
            }
            catch (SystemException systemException) {
                String string = Debug.logRegisterForXARecoveryFailed(systemException.toString());
                Debug.logStackTrace(string, systemException);
                throw new ResourceException(systemException.toString(), systemException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undoSetupForXARecovery() {
        if (this.getTransactionSupport().equalsIgnoreCase("XATransaction")) {
            try {
                try {
                    if (this.recoveryWrapper != null) {
                        this.recoveryWrapper.cleanupRecoveryOnlyXAWrapper();
                    }
                    this.debugXAout("Unregistered XAResource for recovery");
                }
                catch (SystemException systemException) {
                    String string = Debug.logUnregisterForXARecoveryFailed(systemException.toString());
                    Debug.logStackTrace(string, systemException);
                    Object var4_2 = null;
                    this.recoveryWrapper = null;
                }
                Object var4_1 = null;
                this.recoveryWrapper = null;
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                this.recoveryWrapper = null;
                throw throwable;
            }
        }
    }

    public void setProxyTestConnectionHandle(Object object) {
        this.proxyTestConnectionHandle = object;
    }

    void setCanUseProxy(boolean bl) {
        this.canUseProxy = bl;
    }

    private void setPoolName() {
        this.poolName = this.getKey();
        Debug.println((Object)this, ".setNames() - poolName = " + this.poolName);
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this.managedConnectionFactory;
    }

    public String getJNDIName() {
        return this.initOutboundInfo.getJndiName();
    }

    public String getResourceLink() {
        return this.initOutboundInfo.getResourceLink();
    }

    public String getKey() {
        String string = null;
        String string2 = this.getJNDIName();
        string = string2 == null || string2.trim().length() == 0 ? this.getResourceLink() : string2;
        return string;
    }

    public String getName() {
        return this.poolName;
    }

    public ConnectionSharingManager getConnectionSharingManager() {
        return this.connectionSharingManager;
    }

    public ConnectionPoolRuntimeMBeanImpl getRuntimeMBean() {
        return this.rMBean;
    }

    public String getConnectionFactoryName() {
        return this.initOutboundInfo.getConnectionFactoryName();
    }

    public RAInstanceManager getRAInstanceManager() {
        return this.raOutboundManager.getRA();
    }

    public String getRALinkRefName() {
        return this.initOutboundInfo.getRaLinkRef();
    }

    public String getTransactionSupport() {
        return this.initOutboundInfo.getTransactionSupport();
    }

    public boolean isLoggingEnabled() {
        return this.getDynamicOutboundInfo().isLoggingEnabled();
    }

    public String getLogFileName() {
        return this.getDynamicOutboundInfo().getLogFilename();
    }

    public int getInactiveConnectionTimeoutSeconds() {
        return this.initOutboundInfo.getInactiveConnectionTimeoutSeconds();
    }

    public boolean getConnectionProfilingEnabled() {
        return this.initOutboundInfo.getConnectionProfilingEnabled();
    }

    public int getDetectedLeakCount() {
        return this.numLeaks;
    }

    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    public int getCapacityIncrement() {
        return this.capacityIncrement;
    }

    public int getShrinkPeriodMinutes() {
        return this.getInactiveResourceTimeoutSeconds() / 60;
    }

    public int getInactiveResourceTimeoutSeconds() {
        return this.inactiveSecs;
    }

    public int getResourceCreationRetrySeconds() {
        return this.retryIntervalSecs;
    }

    public int getResourceReserveTimeoutSeconds() {
        return this.reserveTimeoutSecs;
    }

    public boolean isShrinkingEnabled() {
        return this.allowShrinking;
    }

    public int getShrinkFrequencySeconds() {
        return this.shrinkSecs;
    }

    public int getTestFrequencySeconds() {
        return this.testSecs;
    }

    public boolean getTestOnReserve() {
        return this.testOnReserve;
    }

    public boolean getTestOnRelease() {
        return this.testOnRelease;
    }

    public boolean getTestOnCreate() {
        return this.testOnCreate;
    }

    public PooledResource getOldestUnreservedResource() {
        Object[] objectArray = null;
        objectArray = this.available.toArray();
        ConnectionInfo connectionInfo = null;
        int n = this.available.size();
        long l = -1L;
        if (objectArray != null && n > 0) {
            for (int i = 0; i < n; ++i) {
                ConnectionInfo connectionInfo2 = (ConnectionInfo)objectArray[i];
                if (l != -1L && connectionInfo.getLastUsedTime() <= connectionInfo2.getLastUsedTime()) continue;
                connectionInfo = connectionInfo2;
                l = connectionInfo2.getLastUsedTime();
            }
        }
        return connectionInfo;
    }

    public int getConnectionsMatchedTotalCount() {
        return this.numMatchSuccesses;
    }

    public int getConnectionsRejectedTotalCount() {
        return this.numRequestsRejected;
    }

    public int getNumRecycled() {
        return this.numRecycled;
    }

    public int getNumLeaked() {
        return this.numLeaks;
    }

    public int getLeakProfileCount() {
        return this.leakProfiles.size();
    }

    public ConnectionLeakProfile[] getConnectionLeakProfiles() {
        return this.leakProfiles.toArray(new ConnectionLeakProfile[this.leakProfiles.size()]);
    }

    public ConnectionLeakProfile[] getConnectionLeakProfiles(int n, int n2) {
        return this.getArray(this.leakProfiles, n, n2);
    }

    public int getIdleProfileCount() {
        return this.idleProfiles.size();
    }

    public ConnectionLeakProfile[] getConnectionIdleProfiles() {
        return this.idleProfiles.toArray(new ConnectionLeakProfile[this.idleProfiles.size()]);
    }

    public ConnectionLeakProfile[] getConnectionIdleProfiles(int n, int n2) {
        return this.getArray(this.idleProfiles, n, n2);
    }

    public Object getProxyTestConnectionHandle() {
        return this.proxyTestConnectionHandle;
    }

    public OutboundInfo getOutboundInfo() {
        return this.initOutboundInfo;
    }

    public ResourceRegistrationManager getResourceRegistrationManager() {
        return this.resRegManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionHandler getConnectionHandler(ManagedConnection managedConnection) {
        ConnectionHandler connectionHandler = null;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            Iterator iterator = this.reserved.iterator();
            while (iterator.hasNext()) {
                ConnectionHandler connectionHandler2 = ((ConnectionInfo)iterator.next()).getConnectionHandler();
                ManagedConnection managedConnection2 = connectionHandler2.getManagedConnection();
                if (managedConnection2 != managedConnection) continue;
                connectionHandler = connectionHandler2;
                break;
            }
        }
        return connectionHandler;
    }

    boolean getCanUseProxy() {
        return this.canUseProxy;
    }

    ConnectionManagerImpl getConnMgr() {
        return this.connMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getConnectionFactory() throws javax.resource.ResourceException, ResourceAdapterInternalException {
        Object object;
        block6: {
            if (Debug.verbose) {
                Debug.enter((Object)this, "getConnectionFactory()");
            }
            try {
                if (this.connectionFactory == null) {
                    if (Debug.verbose) {
                        Debug.println("Creating new connection factory using ConnectionManager = " + this.getConnMgr());
                    }
                    object = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                    Debug.showClassLoaders((Object)this, this.managedConnectionFactory);
                    this.connectionFactory = this.getRAInstanceManager().getAdapterLayer().createConnectionFactory(this.managedConnectionFactory, this.getConnMgr(), (AuthenticatedSubject)object);
                    Debug.showClassLoaders((Object)this, this.connectionFactory);
                    if (this.connectionFactory == null) {
                        Debug.logCreateCFReturnedNull(this.poolName);
                        String string = Debug.getExceptionMCFCreateCFReturnedNull();
                        throw new ResourceAdapterInternalException(string);
                    }
                }
                object = this.connectionFactory;
                Object var4_3 = null;
                if (!Debug.verbose) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var4_4 = null;
                    if (!Debug.verbose) break block7;
                    Debug.exit((Object)this, "getConnectionFactory()");
                }
                throw throwable;
            }
            Debug.exit((Object)this, "getConnectionFactory()");
        }
        return object;
    }

    private ConnectionLeakProfile[] getArray(Vector vector, int n, int n2) {
        Vector vector2 = new Vector();
        try {
            Object e;
            for (int i = 0; i < n2 && n + i < vector.size() && (e = vector.get(n + i)) != null; ++i) {
                vector2.add(e);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return (ConnectionLeakProfile[])vector2.toArray();
    }

    public String getDisplayName() {
        return this.initOutboundInfo.getDisplayName();
    }

    public XATxConnectionHandler findXATxConnectionHandler() {
        if (!this.getTransactionSupport().equalsIgnoreCase("XATransaction")) {
            return null;
        }
        XATxConnectionHandler xATxConnectionHandler = null;
        PooledResource[] pooledResourceArray = this.getResources();
        if (pooledResourceArray != null && pooledResourceArray.length > 0) {
            ConnectionInfo connectionInfo = (ConnectionInfo)pooledResourceArray[0];
            xATxConnectionHandler = (XATxConnectionHandler)connectionInfo.getConnectionHandler();
        }
        return xATxConnectionHandler;
    }

    public XATxConnectionHandler reserveInternal() throws ResourceException {
        ConnectionInfo connectionInfo = (ConnectionInfo)super.reserveResource(-1, null);
        if (connectionInfo != null) {
            XATxConnectionHandler xATxConnectionHandler = (XATxConnectionHandler)connectionInfo.getConnectionHandler();
            return xATxConnectionHandler;
        }
        return null;
    }

    public OutboundAdapterType getXMLBean(ConnectorDiagnosticImageSource connectorDiagnosticImageSource) {
        boolean bl;
        OutboundAdapterType outboundAdapterType = OutboundAdapterType.Factory.newInstance();
        outboundAdapterType.setJndiName(this.getJNDIName());
        outboundAdapterType.setResourceLink(this.getResourceLink());
        outboundAdapterType.setMaxCapacity(this.getMaxCapacity());
        outboundAdapterType.setConnectionsInFreePool(this.getNumAvailable());
        outboundAdapterType.setConnectionsInUse(this.getNumReserved());
        boolean bl2 = bl = connectorDiagnosticImageSource != null ? connectorDiagnosticImageSource.timedout() : false;
        if (bl) {
            return outboundAdapterType;
        }
        ManagedConnectionType[] managedConnectionTypeArray = null;
        PooledResource[] pooledResourceArray = this.getResources();
        if (pooledResourceArray != null) {
            managedConnectionTypeArray = new ManagedConnectionType[pooledResourceArray.length];
            for (int i = 0; i < pooledResourceArray.length; ++i) {
                ConnectionInfo connectionInfo = (ConnectionInfo)pooledResourceArray[i];
                managedConnectionTypeArray[i] = connectionInfo.getXMLBean(connectorDiagnosticImageSource);
            }
        }
        outboundAdapterType.setManagedConnectionArray(managedConnectionTypeArray);
        return outboundAdapterType;
    }

    public synchronized void incrementCloseCount() {
        ++this.closeCount;
    }

    public long getCloseCount() {
        return this.closeCount;
    }

    public synchronized void updatePoolStats() {
        this.updateFreePoolStats();
        this.updatePoolSizeStats();
    }

    public synchronized void updateFreePoolStats() {
        long l = this.getNumAvailable();
        if (l < this.freePoolSizeLowWaterMark) {
            this.freePoolSizeLowWaterMark = l;
        } else if (l > this.freePoolSizeHighWaterMark) {
            this.freePoolSizeHighWaterMark = l;
        }
    }

    public long getFreePoolSizeHighWaterMark() {
        return this.freePoolSizeHighWaterMark;
    }

    public long getFreePoolSizeLowWaterMark() {
        return this.freePoolSizeLowWaterMark;
    }

    public synchronized void updatePoolSizeStats() {
        long l = this.getCurrCapacity();
        if (l < this.freePoolSizeLowWaterMark) {
            this.poolSizeLowWaterMark = l;
        } else if (l > this.poolSizeHighWaterMark) {
            this.poolSizeHighWaterMark = l;
        }
    }

    public long getPoolSizeHighWaterMark() {
        return this.poolSizeHighWaterMark;
    }

    public long getPoolSizeLowWaterMark() {
        return this.poolSizeLowWaterMark;
    }

    public String getManagedConnectionFactoryClassName() {
        return this.initOutboundInfo.getMCFClass();
    }

    public String getConnectionFactoryClassName() {
        return this.initOutboundInfo.getCFImpl();
    }

    public boolean isTestable() {
        return this.getManagedConnectionFactory() instanceof ValidatingManagedConnectionFactory;
    }

    public boolean isProxyOn() {
        return this.canUseProxy;
    }

    public synchronized void incrementConnectionsDestroyedByErrorCount() {
        ++this.connectionsDestroyedByErrorCount;
    }

    public int getConnectionsDestroyedByErrorCount() {
        return this.connectionsDestroyedByErrorCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testPool() {
        boolean bl = true;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            ConnectionInfo connectionInfo = null;
            Object[] objectArray = this.available.toArray();
            int n = this.available.size();
            if (objectArray != null && n > 0) {
                for (int i = 0; i < n; ++i) {
                    connectionInfo = (ConnectionInfo)objectArray[i];
                    try {
                        connectionInfo.test();
                        if (!connectionInfo.hasError()) continue;
                        bl = false;
                        continue;
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                }
            }
        }
        return bl;
    }

    public void applyPoolParamChanges(Properties properties) {
        if (properties != null && properties.size() > 0) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                try {
                    this.applyPoolParamChange(string, string2);
                }
                catch (ResourceException resourceException) {
                    String string3 = Debug.logFailedToApplyPoolChanges(resourceException.toString());
                    Debug.logStackTrace(string3, (Throwable)((Object)resourceException));
                }
            }
        }
    }

    public void applyPoolParamChange(String string, String string2) throws ResourceException {
        if (string.equalsIgnoreCase("initialCapacity")) {
            this.setInitialCapacity(Integer.valueOf(string2));
        } else if (string.equalsIgnoreCase("maxCapacity")) {
            this.setMaximumCapacity(Integer.valueOf(string2));
        } else if (string.equalsIgnoreCase("capacityIncrement")) {
            this.setCapacityIncrement(Integer.valueOf(string2));
        } else if (string.equalsIgnoreCase("shrinkFrequencySeconds")) {
            this.setShrinkFrequencySeconds(Integer.valueOf(string2));
        } else if (string.equalsIgnoreCase("inactiveResTimeoutSeconds")) {
            this.setInactiveResourceTimeoutSeconds(Integer.valueOf(string2));
        } else if (string.equalsIgnoreCase("maxWaiters")) {
            this.setHighestNumWaiters(Integer.valueOf(string2));
        } else if (string.equalsIgnoreCase("maxUnavl")) {
            this.setHighestNumUnavailable(Integer.valueOf(string2));
        } else if (string.equalsIgnoreCase("resCreationRetrySeconds")) {
            this.setResourceCreationRetrySeconds(Integer.valueOf(string2));
        } else if (string.equalsIgnoreCase("resvTimeoutSeconds")) {
            this.setResourceReserveTimeoutSeconds(Integer.valueOf(string2));
        } else if (string.equalsIgnoreCase("testFrequencySeconds")) {
            this.setTestFrequencySeconds(Integer.valueOf(string2));
        } else if (string.equalsIgnoreCase("harvestFreqSecsonds")) {
            this.setProfileHarvestFrequencySeconds(Integer.valueOf(string2));
        } else if (string.equalsIgnoreCase("shrinkEnabled")) {
            this.setShrinkEnabled(Boolean.valueOf(string2));
        } else if (string.equalsIgnoreCase("testOnCreate")) {
            this.setTestOnCreate(Boolean.valueOf(string2));
        } else if (string.equalsIgnoreCase("testOnRelease")) {
            this.setTestOnRelease(Boolean.valueOf(string2));
        } else if (string.equalsIgnoreCase("testOnReserve")) {
            this.setTestOnReserve(Boolean.valueOf(string2));
        }
    }

    public void applyLoggingChanges(Properties properties, OutboundInfo outboundInfo) {
        if (properties != null && properties.size() > 0) {
            this.pendingOutboundInfo = outboundInfo;
            this.setLogger();
        }
    }

    protected void setLogger() {
        OutboundInfo outboundInfo = this.getDynamicOutboundInfo();
        try {
            if (Debug.isRALifecycleEnabled()) {
                Debug.raLifecycle("Creating logfile '" + outboundInfo.getLogFilename() + "' for ManagedConnectionFactory '" + outboundInfo.getMCFClass() + "' of RA module '" + outboundInfo.getRAInfo().getModuleName() + "'");
            }
            OutputStream outputStream = null;
            if (outboundInfo.isLoggingEnabled()) {
                this.setLoggingBeanAdapter(null);
                outputStream = null;
            }
            if (outboundInfo.getLogFilename() == null || outboundInfo.getLogFilename().length() == 0) {
                this.setLoggingBeanAdapter(null);
                outputStream = new LoggingOutputStream(this.getKey(), WLLevel.TRACE);
            } else {
                this.setLoggingBeanAdapter(this.createLoggingBeanAdapter(outboundInfo));
                outputStream = this.loggingBeanAdapter.getOutputStream();
            }
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            PrintWriter printWriter = outputStream != null ? new PrintWriter(outputStream, true) : null;
            this.getRAInstanceManager().getAdapterLayer().setLogWriter(this.managedConnectionFactory, printWriter, authenticatedSubject);
        }
        catch (javax.resource.ResourceException resourceException) {
            Throwable throwable = resourceException.getCause();
            String string = Debug.logSetLogWriterErrorWithCause(this.initOutboundInfo.getMCFClass(), resourceException.toString(), throwable != null && throwable != resourceException ? throwable.toString() : "");
            Debug.logStackTrace(string, resourceException);
            if (throwable != null && throwable != resourceException) {
                Debug.logStackTrace(string, throwable);
            }
        }
        catch (Throwable throwable) {
            String string = Debug.logSetLogWriterError(outboundInfo.getMCFClass());
            Debug.logStackTrace(string, throwable);
        }
    }

    private void setLoggingBeanAdapter(LoggingBeanAdapter loggingBeanAdapter) {
        OutputStream outputStream;
        if (this.loggingBeanAdapter != null) {
            outputStream = this.loggingBeanAdapter.getOutputStream();
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException iOException) {
                Debug.logFailedToCloseLog(this.getKey(), iOException.toString());
                Debug.println("WARNING:  Failed to flush and close the logging OutputStream for pool:  " + this.getKey() + ":  " + iOException);
            }
        }
        this.loggingBeanAdapter = loggingBeanAdapter;
        if (this.loggingBeanAdapter != null) {
            try {
                outputStream = new RotatingFileOutputStream(LogFileConfigUtil.getLogFileConfig(this.loggingBeanAdapter));
                this.loggingBeanAdapter.setOutputStream(outputStream);
            }
            catch (IOException iOException) {
                Debug.logFailedToCreateLogStream(this.getKey(), iOException.toString());
                Debug.println("Failed to create the logging OutputStream for pool:  " + this.getKey() + ":  " + iOException);
            }
        }
    }

    public Boolean getUseConnectionProxies() {
        return this.initOutboundInfo.getUseConnectionProxies();
    }

    public synchronized int getAlternateCount() {
        return ++this.alternateCount;
    }

    public ResourcePoolProfiler getProfiler() {
        return this.profiler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LoggingBeanAdapter createLoggingBeanAdapter(OutboundInfo outboundInfo) {
        Debug.enter((Object)this, ".createLoggingBeanAdapter()");
        LoggingBeanAdapter loggingBeanAdapter = new LoggingBeanAdapter(outboundInfo.getLoggingBean());
        loggingBeanAdapter.setFileCount(outboundInfo.getFileCount());
        loggingBeanAdapter.setFileMinSize(outboundInfo.getFileSizeLimit());
        loggingBeanAdapter.setFileTimeSpan(outboundInfo.getFileTimeSpan());
        loggingBeanAdapter.setLogFileRotationDir(outboundInfo.getLogFileRotationDir());
        loggingBeanAdapter.setFileName(outboundInfo.getLogFilename());
        loggingBeanAdapter.setNumberOfFilesLimited(outboundInfo.isNumberOfFilesLimited());
        loggingBeanAdapter.setRotateLogOnStartup(outboundInfo.isRotateLogOnStartup());
        loggingBeanAdapter.setRotationTime(outboundInfo.getRotationTime());
        loggingBeanAdapter.setRotationType(outboundInfo.getRotationType());
        try {
            try {
                this.logRuntime = new LogRuntime(loggingBeanAdapter, this.rMBean);
            }
            catch (ManagementException managementException) {
                Object var5_4 = null;
                Debug.exit((Object)this, ".createLoggingBeanAdapter()");
                return loggingBeanAdapter;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Debug.exit((Object)this, ".createLoggingBeanAdapter()");
            throw throwable;
        }
        Debug.exit((Object)this, ".createLoggingBeanAdapter()");
        return loggingBeanAdapter;
    }

    public void forceLogRotation() throws ManagementException {
        if (this.loggingBeanAdapter == null) {
            String string = Debug.getFailedToForceLogRotation(this.getKey());
            throw new ManagementException(string);
        }
        this.logRuntime.forceLogRotation();
    }

    public void ensureLogOpened() throws ManagementException {
        if (this.loggingBeanAdapter != null) {
            this.logRuntime.ensureLogOpened();
        }
    }

    public LogRuntimeMBean getLogRuntime() {
        return this.logRuntime;
    }

    public void setupRuntime(ConnectorComponentRuntimeMBeanImpl connectorComponentRuntimeMBeanImpl, RAOutboundManager rAOutboundManager) {
        try {
            this.connRuntimeMbean = connectorComponentRuntimeMBeanImpl;
            this.rMBean = new ConnectionPoolRuntimeMBeanImpl(this.applicationName, this.componentName, this, connectorComponentRuntimeMBeanImpl, rAOutboundManager);
            connectorComponentRuntimeMBeanImpl.addConnPoolRuntime(this.rMBean);
        }
        catch (Exception exception) {
            String string = Debug.logInitCPRTMBeanError(this.poolName, exception.toString());
            Debug.logStackTrace(string, exception);
        }
    }

    private OutboundInfo getDynamicOutboundInfo() {
        if (this.pendingOutboundInfo != null) {
            return this.pendingOutboundInfo;
        }
        return this.initOutboundInfo;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public String toString() {
        return super.toString() + "-" + this.poolName;
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.connector.outbound.ConnectionPool");
        _WLDF$INST_FLD_Connector_After_Outbound = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_After_Outbound");
        _WLDF$INST_FLD_Connector_Around_Outbound = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Around_Outbound");
        _WLDF$INST_FLD_Connector_Release_Connection_Low = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Release_Connection_Low");
        _WLDF$INST_FLD_Connector_Before_Outbound = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Before_Outbound");
        _WLDF$INST_FLD_Connector_Reserve_Connection_Low = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"Connector_Reserve_Connection_Low");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"ConnectionPool.java", (String)"weblogic.connector.outbound.ConnectionPool", (String)"reserveResource", (String)"(ILweblogic/common/resourcepool/PooledResourceInfo;)Lweblogic/common/resourcepool/PooledResource;", (int)573, (Map)InstrumentationSupport.makeMap((String[])new String[]{"Connector_After_Outbound", "Connector_Reserve_Connection_Low", "Connector_Around_Outbound", "Connector_Before_Outbound"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{null, InstrumentationSupport.createPointcutHandlingInfo((ValueHandlingInfo)InstrumentationSupport.createValueHandlingInfo((String)"pool", (String)"weblogic.diagnostics.instrumentation.gathering.JCAConnectionPoolRenderer", (boolean)false, (boolean)true), null, null), null, null}), (boolean)false);
        _WLDF$INST_JPFLD_1 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"ConnectionPool.java", (String)"weblogic.connector.outbound.ConnectionPool", (String)"releaseResource", (String)"(Lweblogic/common/resourcepool/PooledResource;)V", (int)684, (Map)InstrumentationSupport.makeMap((String[])new String[]{"Connector_After_Outbound", "Connector_Around_Outbound", "Connector_Release_Connection_Low", "Connector_Before_Outbound"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{null, null, InstrumentationSupport.createPointcutHandlingInfo((ValueHandlingInfo)InstrumentationSupport.createValueHandlingInfo((String)"pool", (String)"weblogic.diagnostics.instrumentation.gathering.JCAConnectionPoolRenderer", (boolean)false, (boolean)true), null, null), null}), (boolean)false);
    }
}

