/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.outbound;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import weblogic.common.resourcepool.PooledResource;
import weblogic.common.resourcepool.ResourcePoolProfiler;
import weblogic.connector.common.Debug;
import weblogic.connector.outbound.ConnectionPool;
import weblogic.connector.outbound.ProfileDataRecord;
import weblogic.diagnostics.instrumentation.EventDispatcher;
import weblogic.diagnostics.instrumentation.EventPayload;
import weblogic.utils.StackTraceUtils;

public class ConnectionPoolProfiler
implements ResourcePoolProfiler {
    private int NUM_TYPES = 4;
    private int TYPE_CONN_USAGE = 0;
    private int TYPE_CONN_WAIT = 1;
    private int TYPE_CONN_LEAK = 2;
    private int TYPE_CONN_RESV_FAIL = 3;
    private ConnectionPool pool;
    private HashMap[] profileData;
    private boolean resProfEnabled = false;

    ConnectionPoolProfiler(ConnectionPool connectionPool) {
        this.pool = connectionPool;
        this.profileData = new HashMap[this.NUM_TYPES];
        this.profileData[this.TYPE_CONN_USAGE] = new HashMap();
        this.profileData[this.TYPE_CONN_WAIT] = new HashMap();
        this.profileData[this.TYPE_CONN_LEAK] = new HashMap();
        this.profileData[this.TYPE_CONN_RESV_FAIL] = new HashMap();
        this.resProfEnabled = Boolean.getBoolean("weblogic.connector.ConnectionPoolProfilingEnabled");
    }

    private boolean isResourceProfilingEnabled() {
        return this.resProfEnabled;
    }

    public boolean isResourceUsageProfilingEnabled() {
        return this.isResourceProfilingEnabled();
    }

    public boolean isResourceReserveWaitProfilingEnabled() {
        return this.isResourceProfilingEnabled();
    }

    public boolean isResourceReserveFailProfilingEnabled() {
        return this.isResourceProfilingEnabled();
    }

    public boolean isResourceLeakProfilingEnabled() {
        return this.isResourceProfilingEnabled();
    }

    public synchronized void dumpData() {
        this.printData(this.profileData[this.TYPE_CONN_USAGE].values().iterator());
        this.printData(this.profileData[this.TYPE_CONN_WAIT].values().iterator());
        this.printData(this.profileData[this.TYPE_CONN_LEAK].values().iterator());
        this.printData(this.profileData[this.TYPE_CONN_RESV_FAIL].values().iterator());
    }

    public synchronized void harvestData() {
        if (this.isResourceProfilingEnabled()) {
            this.persistData("WEBLOGIC.CONNECTOR.OUTBOUND.CONNECTIONPOOL.USAGE", this.profileData[this.TYPE_CONN_USAGE].values().iterator());
            this.persistData("WEBLOGIC.CONNECTOR.OUTBOUND.CONNECTIONPOOL.WAIT", this.profileData[this.TYPE_CONN_WAIT].values().iterator());
            this.persistData("WEBLOGIC.CONNECTOR.OUTBOUND.CONNECTIONPOOL.LEAK", this.profileData[this.TYPE_CONN_LEAK].values().iterator());
            this.persistData("WEBLOGIC.CONNECTOR.OUTBOUND.CONNECTIONPOOL.RESVFAIL", this.profileData[this.TYPE_CONN_RESV_FAIL].values().iterator());
        }
    }

    public synchronized void deleteData() {
        this.deleteLeakData();
        this.deleteResvFailData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUsageData(PooledResource pooledResource) {
        Properties properties = new Properties();
        properties.setProperty("Connection", pooledResource.toString());
        ProfileDataRecord profileDataRecord = new ProfileDataRecord("WEBLOGIC.CONNECTOR.OUTBOUND.CONNECTIONPOOL.USAGE", this.pool.getName(), properties);
        ConnectionPoolProfiler connectionPoolProfiler = this;
        synchronized (connectionPoolProfiler) {
            this.profileData[this.TYPE_CONN_USAGE].put(pooledResource, profileDataRecord);
        }
    }

    public synchronized void deleteUsageData(PooledResource pooledResource) {
        this.profileData[this.TYPE_CONN_USAGE].remove(pooledResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWaitData() {
        String string = Thread.currentThread().getName();
        Properties properties = new Properties();
        properties.setProperty("ThreadID", string);
        properties.setProperty("StackTrace", StackTraceUtils.throwable2StackTrace((Throwable)new Exception()));
        ProfileDataRecord profileDataRecord = new ProfileDataRecord("WEBLOGIC.CONNECTOR.OUTBOUND.CONNECTIONPOOL.WAIT", this.pool.getName(), properties);
        ConnectionPoolProfiler connectionPoolProfiler = this;
        synchronized (connectionPoolProfiler) {
            this.profileData[this.TYPE_CONN_WAIT].put(string, profileDataRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteWaitData() {
        ConnectionPoolProfiler connectionPoolProfiler = this;
        synchronized (connectionPoolProfiler) {
            this.profileData[this.TYPE_CONN_WAIT].remove(Thread.currentThread().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLeakData(PooledResource pooledResource) {
        Properties properties = new Properties();
        properties.setProperty("Connection", pooledResource.toString());
        ProfileDataRecord profileDataRecord = new ProfileDataRecord("WEBLOGIC.CONNECTOR.OUTBOUND.CONNECTIONPOOL.LEAK", this.pool.getName(), properties);
        ConnectionPoolProfiler connectionPoolProfiler = this;
        synchronized (connectionPoolProfiler) {
            this.profileData[this.TYPE_CONN_LEAK].put(pooledResource, profileDataRecord);
        }
    }

    private void deleteLeakData() {
        this.profileData[this.TYPE_CONN_LEAK].clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResvFailData(String string) {
        Properties properties = new Properties();
        properties.setProperty("ThreadID", Thread.currentThread().getName());
        properties.setProperty("StackTrace", string);
        String string2 = Thread.currentThread().getName();
        ProfileDataRecord profileDataRecord = new ProfileDataRecord("WEBLOGIC.CONNECTOR.OUTBOUND.CONNECTIONPOOL.RESVFAIL", this.pool.getName(), properties);
        ConnectionPoolProfiler connectionPoolProfiler = this;
        synchronized (connectionPoolProfiler) {
            this.profileData[this.TYPE_CONN_RESV_FAIL].put(string2, profileDataRecord);
        }
    }

    private void deleteResvFailData() {
        this.profileData[this.TYPE_CONN_RESV_FAIL].clear();
    }

    private synchronized void printData(Iterator iterator) {
        while (iterator.hasNext()) {
            ProfileDataRecord profileDataRecord = (ProfileDataRecord)iterator.next();
            Debug.logPoolProfilingRecord(profileDataRecord);
        }
    }

    private void persistData(String string, Iterator iterator) {
        while (iterator.hasNext()) {
            EventDispatcher.Helper.dispatch((String)string, (EventPayload)((ProfileDataRecord)iterator.next()));
        }
    }
}

