/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.outbound;

import java.util.Hashtable;
import java.util.Iterator;
import javax.transaction.Transaction;
import weblogic.common.ResourceException;
import weblogic.connector.common.Debug;
import weblogic.connector.outbound.ConnectionInfo;
import weblogic.transaction.TransactionHelper;

public class ConnectionSharingManager {
    private Hashtable sharedConnections = new Hashtable();
    private String poolName;

    public ConnectionSharingManager(String string) {
        this.poolName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void addSharedConnection(ConnectionInfo connectionInfo) throws ResourceException {
        if (Debug.verbose) {
            Debug.enter(this, "addSharedConnection()");
        }
        if (Debug.isPoolVerboseEnabled()) {
            this.debugVerbose("on entering addSharedConnection() ConnectionInfo = " + connectionInfo.toString());
            this.dumpSharedConnectionsTable("On entry to addSharedConnection()");
        }
        try {
            Transaction transaction = TransactionHelper.getTransactionHelper().getTransaction();
            Transaction transaction2 = null;
            ConnectionInfo connectionInfo2 = null;
            if (transaction != null) {
                if (Debug.isPoolVerboseEnabled()) {
                    this.debugVerbose("tx is non-null, tx.hashcode() = " + transaction.hashCode() + ", txid = " + ((weblogic.transaction.Transaction)transaction).getXID() + " -- adding to sharedConnections");
                }
                if ((connectionInfo2 = (ConnectionInfo)this.sharedConnections.get(transaction)) == null) {
                    transaction2 = this.getTransaction(connectionInfo);
                    if (transaction2 != null) {
                        if (Debug.isPoolVerboseEnabled()) {
                            this.debugVerbose("Removing residual tx, tx.hashcode() = " + transaction.hashCode() + ", txid = " + ((weblogic.transaction.Transaction)transaction2).getXID());
                        }
                        this.sharedConnections.remove(transaction2);
                    }
                    this.sharedConnections.put(transaction, connectionInfo);
                } else if (connectionInfo2.equals(connectionInfo)) {
                    this.debugVerbose("*** attempt to add same connection/tx again -- doing nothing***");
                } else {
                    this.debugVerbose("*** new connection created with tx which already had a conneciton assoc. w/it.  Shouldn't happen!!!");
                }
            } else if (Debug.isPoolVerboseEnabled()) {
                this.debugVerbose("tx is null - not doing anything.");
            }
            if (Debug.isPoolVerboseEnabled()) {
                this.dumpSharedConnectionsTable("On exit from addSharedConnection()");
            }
            Object var6_5 = null;
            if (!Debug.verbose) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!Debug.verbose) throw throwable;
            Debug.exit(this, "addSharedConnection()");
            throw throwable;
        }
        Debug.exit(this, "addSharedConnection()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean releaseSharedConnection(ConnectionInfo connectionInfo, boolean bl) {
        if (Debug.verbose) {
            Debug.enter(this, "releaseSharedConnection()");
        }
        if (Debug.isPoolVerboseEnabled()) {
            this.debugVerbose("on entering releaseSharedConnection() ConnectionInfo = " + connectionInfo.toString() + " & transactionCompleted = " + bl);
        }
        boolean bl2 = false;
        boolean bl3 = false;
        Iterator iterator = this.sharedConnections.keySet().iterator();
        Transaction transaction = null;
        ConnectionInfo connectionInfo2 = null;
        try {
            if (Debug.isPoolVerboseEnabled()) {
                this.dumpSharedConnectionsTable("Before Release");
            }
            while (iterator.hasNext() && !bl3) {
                transaction = (Transaction)iterator.next();
                connectionInfo2 = (ConnectionInfo)this.sharedConnections.get(transaction);
                if (!connectionInfo2.equals(connectionInfo)) continue;
                bl3 = true;
                if (!bl) {
                    if (Debug.isPoolVerboseEnabled()) {
                        this.debugVerbose("decrementing sharing count from " + connectionInfo.getSharingCount());
                    }
                    connectionInfo.decrementSharingCount();
                }
                if (connectionInfo.getSharingCount() != 0 || connectionInfo.isInTransaction()) continue;
                if (Debug.isPoolVerboseEnabled()) {
                    this.debugVerbose("removing transaction from sharedConnections and releasing back to pool");
                }
                this.sharedConnections.remove(transaction);
                bl2 = true;
                break;
            }
            if (!bl3 && (connectionInfo.isShareable() || connectionInfo.getConnectionHandler().getNumActiveConns() <= 0)) {
                if (Debug.isPoolVerboseEnabled()) {
                    this.debugVerbose("*** couldn't find connection info in sharedConnection table ****");
                    this.debugVerbose("releasing to pool");
                }
                bl2 = !connectionInfo.isInTransaction();
                connectionInfo.resetSharingCount();
            }
            if (Debug.isPoolVerboseEnabled()) {
                this.debugVerbose("returning releaseToPool=" + bl2 + " from releaseSharedConnection()");
                this.dumpSharedConnectionsTable("After Release");
            }
            Object var9_8 = null;
            if (!Debug.verbose) return bl2;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (!Debug.verbose) throw throwable;
            Debug.exit(this, "releaseSharedConnection(): releaseToPool:" + bl2);
            throw throwable;
        }
        Debug.exit(this, "releaseSharedConnection(): releaseToPool:" + bl2);
        return bl2;
    }

    private void dumpSharedConnectionsTable(String string) {
        if (Debug.isPoolVerboseEnabled()) {
            Iterator iterator = this.sharedConnections.keySet().iterator();
            Transaction transaction = null;
            ConnectionInfo connectionInfo = null;
            this.debugVerbose("*** Dump of sharedConnections " + string + " ***");
            while (iterator.hasNext()) {
                transaction = (Transaction)iterator.next();
                connectionInfo = (ConnectionInfo)this.sharedConnections.get(transaction);
                this.debugVerbose("[ tx = " + ((weblogic.transaction.Transaction)transaction).getXID() + ", info = " + connectionInfo.toString() + ", sharingCount = " + connectionInfo.getSharingCount() + " ]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized ConnectionInfo getSharedConnection() {
        if (Debug.verbose) {
            Debug.enter(this, ".getSharedConnection");
        }
        ConnectionInfo connectionInfo = null;
        try {
            Transaction transaction;
            if (Debug.isPoolVerboseEnabled()) {
                this.dumpSharedConnectionsTable("On entry to getSharedConnection()");
            }
            if ((transaction = TransactionHelper.getTransactionHelper().getTransaction()) != null) {
                connectionInfo = (ConnectionInfo)this.sharedConnections.get(transaction);
            }
            if (Debug.isPoolVerboseEnabled()) {
                this.debugVerbose("Returning " + connectionInfo + "on exit from getSharedConnection() ");
            }
            Object var4_3 = null;
            if (!Debug.verbose) return connectionInfo;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Debug.verbose) throw throwable;
            Debug.exit(this, "getSharedConnection()");
            throw throwable;
        }
        Debug.exit(this, "getSharedConnection()");
        return connectionInfo;
    }

    private Transaction getTransaction(ConnectionInfo connectionInfo) {
        Transaction transaction = null;
        Transaction transaction2 = null;
        ConnectionInfo connectionInfo2 = null;
        Iterator iterator = this.sharedConnections.keySet().iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            transaction2 = (Transaction)iterator.next();
            connectionInfo2 = (ConnectionInfo)this.sharedConnections.get(transaction2);
            if (!connectionInfo2.equals(connectionInfo)) continue;
            bl = true;
            transaction = transaction2;
        }
        return transaction;
    }

    void debugVerbose(String string) {
        if (Debug.isPoolVerboseEnabled()) {
            Debug.poolVerbose("For pool '" + this.poolName + "' " + string);
        }
    }
}

