/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.outbound;

import java.lang.ref.Reference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import javax.resource.ResourceException;
import weblogic.connector.common.Debug;
import weblogic.connector.common.Utils;
import weblogic.connector.outbound.ConnectionHandler;
import weblogic.connector.outbound.ConnectionInfo;
import weblogic.connector.outbound.ConnectionPool;
import weblogic.connector.transaction.outbound.TxConnectionHandler;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.PlatformConstants;
import weblogic.utils.StackTraceUtils;

public final class ConnectionWrapper
implements InvocationHandler {
    private ConnectionPool connPool = null;
    private ConnectionInfo connInfo = null;
    private Object connInstance = null;
    private Reference ref = null;
    private int hash;

    private ConnectionWrapper(ConnectionPool connectionPool, ConnectionInfo connectionInfo, Object object) {
        this.connInstance = object;
        this.connPool = connectionPool;
        this.connInfo = connectionInfo;
        this.connInfo.setLastUsedTime(System.currentTimeMillis());
        this.connInfo.setUsed(true);
        this.hash = object != null ? object.hashCode() : super.hashCode();
        if (connectionPool != null && connectionPool.getConnectionProfilingEnabled()) {
            String string = Debug.getExceptionStackTrace() + PlatformConstants.EOL;
            Throwable throwable = new Throwable(string);
            String string2 = StackTraceUtils.throwable2StackTrace((Throwable)throwable);
            try {
                String string3 = ":";
                string2 = string2.substring(string2.indexOf(string3) + string3.length());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connInfo.setAllocationCallStack(string2);
        }
    }

    private ConnectionWrapper(ConnectionPool connectionPool, Object object) {
        this.connInstance = object;
        this.connPool = connectionPool;
        this.connInfo = new ConnectionInfo();
        this.connInfo.setLastUsedTime(System.currentTimeMillis());
        this.connInfo.setUsed(true);
        this.hash = object != null ? object.hashCode() : super.hashCode();
    }

    public static Object createConnectionWrapper(ConnectionPool connectionPool, ConnectionInfo connectionInfo, Object object) {
        Class<?> clazz = object.getClass();
        Class[] classArray = Utils.getInterfaces(clazz);
        return Proxy.newProxyInstance(clazz.getClassLoader(), classArray, (InvocationHandler)new ConnectionWrapper(connectionPool, connectionInfo, object));
    }

    public static Object createProxyTestConnectionWrapper(ConnectionPool connectionPool, Object object) {
        Class<?> clazz = object.getClass();
        Class[] classArray = Utils.getInterfaces(clazz);
        return Proxy.newProxyInstance(clazz.getClassLoader(), classArray, (InvocationHandler)new ConnectionWrapper(connectionPool, object));
    }

    public void setWeakReference(Reference reference) {
        this.ref = reference;
    }

    public int hashCode() {
        return this.hash;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws ResourceException, Throwable {
        this.connInfo.setLastUsedTime(System.currentTimeMillis());
        this.connInfo.setUsed(true);
        ConnectionHandler connectionHandler = this.connInfo.getConnectionHandler();
        if (connectionHandler != null && connectionHandler instanceof TxConnectionHandler && !method.getName().equals("close")) {
            ((TxConnectionHandler)connectionHandler).enListResource();
        }
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        try {
            return this.connPool.getRAInstanceManager().getAdapterLayer().invoke(method, this.connInstance, objectArray, authenticatedSubject);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw illegalAccessException;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable != null) {
                if (throwable instanceof ResourceException) {
                    throw (ResourceException)throwable;
                }
                throw throwable;
            }
            throw invocationTargetException;
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            Throwable throwable = undeclaredThrowableException.getUndeclaredThrowable();
            if (throwable != null) {
                if (throwable instanceof ResourceException) {
                    throw (ResourceException)throwable;
                }
                throw throwable;
            }
            throw undeclaredThrowableException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void finalize() throws Throwable {
        Debug.enter(this, "finalize() for " + this.connInfo);
        try {
            this.connInfo.getConnectionHandler().connectionFinalized(this.ref);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            Debug.exit(this, "finalize() for " + this.connInfo);
            throw throwable;
        }
        super.finalize();
        Debug.exit(this, "finalize() for " + this.connInfo);
    }

    protected Object getConnectionInstance() {
        return this.connInstance;
    }
}

