/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.outbound;

import com.bea.connector.diagnostic.OutboundAdapterType;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.naming.NoPermissionException;
import javax.resource.spi.ApplicationServerInternalException;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterAssociation;
import weblogic.application.ApplicationAccess;
import weblogic.application.ApplicationContextInternal;
import weblogic.common.ResourceException;
import weblogic.connector.ConnectorLogger;
import weblogic.connector.common.ConnectorDiagnosticImageSource;
import weblogic.connector.common.Debug;
import weblogic.connector.common.RAInstanceManager;
import weblogic.connector.common.Utils;
import weblogic.connector.deploy.JNDIHandler;
import weblogic.connector.deploy.RAOutboundDeployer;
import weblogic.connector.exception.RAException;
import weblogic.connector.exception.RAInternalException;
import weblogic.connector.exception.RAOutboundException;
import weblogic.connector.external.OutboundInfo;
import weblogic.connector.external.impl.OutboundInfoImpl;
import weblogic.connector.monitoring.ConnectorComponentRuntimeMBeanImpl;
import weblogic.connector.monitoring.outbound.ConnectionPoolRuntimeMBeanImpl;
import weblogic.connector.outbound.ConnectionPool;
import weblogic.management.DeploymentException;
import weblogic.management.UndeploymentException;
import weblogic.management.runtime.ConnectorConnectionPoolRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.PlatformConstants;

public class RAOutboundManager {
    private boolean isOutsideAppAccessEnabled = false;
    private final byte SUSPEND = 1;
    private final byte RESUME = (byte)2;
    private final byte SHUTDOWN = (byte)3;
    private final byte FORCE_SUSPEND = (byte)4;
    private Hashtable mcfMap = new Hashtable();
    private Hashtable outboundInfoMap = new Hashtable();
    private HashMap<String, OutboundInfo> pendingOutboundInfoMap = new HashMap();
    private Hashtable poolMap = new Hashtable();
    private Hashtable jndiPoolLookupMap = new Hashtable();
    private RAInstanceManager raInstanceMgr;
    private String moduleName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAOutboundManager(RAInstanceManager rAInstanceManager) throws RAOutboundException {
        Debug.enter(this, "Constructor");
        try {
            this.raInstanceMgr = rAInstanceManager;
            Debug.println(this, "Initializing the outbound manager");
            this.isOutsideAppAccessEnabled = this.raInstanceMgr.getRAInfo().isEnableAccessOutsideApp();
            this.initialize();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Debug.exit(this, "Constructor");
            throw throwable;
        }
        Debug.exit(this, "Constructor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws RAOutboundException {
        Debug.enter(this, "prepare()");
        try {
            Iterator iterator = this.mcfMap.keySet().iterator();
            String string = null;
            this.debugModule("Looping through all the outbound connections to prepare the pools");
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                this.preparePool(string);
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Debug.exit(this, "prepare()");
            throw throwable;
        }
        Debug.exit(this, "prepare()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() throws RAOutboundException {
        Debug.enter(this, "activate()");
        try {
            Iterator iterator = this.mcfMap.keySet().iterator();
            String string = null;
            this.debugModule("Looping through all the outbound connections to resume the pools and do a JNDI bind");
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                this.activatePool(string);
            }
            Object var4_3 = null;
            this.debugModule("Done Looping through all the outbound connections to resume the pools and do a JNDI bind");
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.debugModule("Done Looping through all the outbound connections to resume the pools and do a JNDI bind");
            Debug.exit(this, "activate()");
            throw throwable;
        }
        Debug.exit(this, "activate()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() throws RAOutboundException {
        Debug.enter(this, "deactivate()");
        try {
            RAOutboundException rAOutboundException = null;
            for (String string : this.poolMap.keySet()) {
                try {
                    this.deactivatePool(string);
                }
                catch (RAOutboundException rAOutboundException2) {
                    if (rAOutboundException == null) {
                        rAOutboundException = new RAOutboundException();
                    }
                    rAOutboundException.add((Throwable)((Object)rAOutboundException2));
                }
            }
            if (rAOutboundException != null) {
                throw rAOutboundException;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Debug.exit(this, "deactivate()");
            throw throwable;
        }
        Debug.exit(this, "deactivate()");
    }

    public void deactivatePool(String string) throws RAOutboundException {
        OutboundInfo outboundInfo = (OutboundInfo)this.outboundInfoMap.get(string);
        ConnectionPool connectionPool = (ConnectionPool)((Object)this.poolMap.get(string));
        try {
            Debug.println("JNDI unbind : " + string);
            JNDIHandler.unbindConnectionFactory(outboundInfo, this, connectionPool.getConnectionFactory());
        }
        catch (javax.resource.ResourceException resourceException) {
            String string2 = Debug.getExceptionDeactivateException(string, resourceException.getMessage(), resourceException.toString()) + PlatformConstants.EOL;
            throw new RAOutboundException(string2, resourceException);
        }
        catch (UndeploymentException undeploymentException) {
            String string3 = Debug.getExceptionDeactivateException(string, undeploymentException.getMessage(), undeploymentException.toString()) + PlatformConstants.EOL;
            throw new RAOutboundException(string3, (Throwable)((Object)undeploymentException));
        }
        try {
            Debug.println("Suspend the pool");
            connectionPool.suspend();
        }
        catch (ResourceException resourceException) {
            String string4 = Debug.getExceptionDeactivateException(string, resourceException.getMessage(), resourceException.toString()) + PlatformConstants.EOL;
            throw new RAOutboundException(string4, (Throwable)((Object)resourceException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws RAOutboundException {
        Debug.enter(this, "rollback()");
        try {
            Iterator iterator = this.poolMap.keySet().iterator();
            RAOutboundException rAOutboundException = null;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    this.internalShutdownPool(string);
                }
                catch (RAOutboundException rAOutboundException2) {
                    if (rAOutboundException == null) {
                        rAOutboundException = new RAOutboundException();
                    }
                    rAOutboundException.add((Throwable)((Object)rAOutboundException2));
                }
            }
            Debug.println("Reset the hashtables");
            this.reset();
            if (rAOutboundException != null) {
                throw rAOutboundException;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Debug.exit(this, "rollback()");
            throw throwable;
        }
        Debug.exit(this, "rollback()");
    }

    public void shutdownPool(String string) throws RAOutboundException {
        this.internalShutdownPool(string);
        this.outboundInfoMap.remove(string);
        this.poolMap.remove(string);
    }

    private void internalShutdownPool(String string) throws RAOutboundException {
        OutboundInfo outboundInfo = (OutboundInfo)this.outboundInfoMap.get(string);
        ConnectionPool connectionPool = (ConnectionPool)((Object)this.poolMap.get(string));
        if (outboundInfo == null || connectionPool == null) {
            return;
        }
        try {
            Debug.println("Shutdown the pool");
            connectionPool.shutdown();
        }
        catch (ResourceException resourceException) {
            String string2 = Debug.getExceptionShutdownException(outboundInfo.getKey(), resourceException.getMessage(), resourceException.toString());
            throw new RAOutboundException(string2, (Throwable)((Object)resourceException));
        }
    }

    public void stop() throws RAOutboundException {
        this.suspend();
    }

    public void halt() throws RAOutboundException {
        this.changeStateOfPools((byte)3);
    }

    public void suspend() throws RAOutboundException {
        this.changeStateOfPools((byte)1);
    }

    public void resume() throws RAOutboundException {
        this.changeStateOfPools((byte)2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws RAOutboundException {
        Debug.enter(this, "initialize()");
        try {
            Debug.println("Get OutboundInfos list");
            List list = this.raInstanceMgr.getRAInfo().getOutboundInfos();
            Iterator iterator = list.iterator();
            this.getModuleName();
            Debug.println("OutboundInfos List size : " + list.size());
            while (iterator.hasNext()) {
                OutboundInfo outboundInfo = (OutboundInfo)iterator.next();
                this.createConnectionFactory(outboundInfo);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Debug.exit(this, "initialize()");
            throw throwable;
        }
        Debug.exit(this, "initialize()");
    }

    public void createConnectionFactory(OutboundInfo outboundInfo) throws RAOutboundException {
        String string = outboundInfo.getJndiName();
        String string2 = outboundInfo.getResourceLink();
        boolean bl = string == null || string.length() == 0;
        try {
            if (!bl && JNDIHandler.verifyJNDIName(string)) {
                Debug.logJNDINameAlreadyExists(string);
                String string3 = Debug.getExceptionCFJndiNameDuplicate(string);
                throw new RAOutboundException(string3);
            }
            if (bl && JNDIHandler.verifyResourceLink(string2, this.raInstanceMgr.getConnectionFactoryContext())) {
                Debug.logJNDINameAlreadyExists(string2);
                String string4 = Debug.getExceptionCFResourceLinkDuplicate(string2);
                throw new RAOutboundException(string4);
            }
        }
        catch (RAException rAException) {
            String string5 = Debug.getExceptionJndiVerifyFailed(outboundInfo.getKey(), rAException.toString());
            throw new RAOutboundException(string5, (Throwable)((Object)rAException));
        }
        Debug.println(this, ".createConnectionFactory() Initialize MCF");
        ManagedConnectionFactory managedConnectionFactory = this.initializeMCF(outboundInfo);
        String string6 = ((OutboundInfoImpl)outboundInfo).getKey();
        String string7 = JNDIHandler.getJndiNameAndVersion(string6, this.raInstanceMgr.getVersionId());
        Debug.println(this, ".createConnectionFactory() Add to the mcfMap : " + string7);
        this.mcfMap.put(string7, managedConnectionFactory);
        Debug.println(this, ".createConnectionFactory() Add to the outboundInfoMap : " + string7);
        this.outboundInfoMap.put(string7, outboundInfo);
    }

    public OutboundInfo updateOutBoundInfo(String string, OutboundInfo outboundInfo) {
        String string2 = JNDIHandler.getJndiNameAndVersion(string, this.raInstanceMgr.getVersionId());
        return this.pendingOutboundInfoMap.put(string2, outboundInfo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ManagedConnectionFactory initializeMCF(OutboundInfo outboundInfo) throws RAOutboundException {
        ManagedConnectionFactory managedConnectionFactory;
        Debug.enter(this, "initializeMCF(...)");
        Class<?> clazz = null;
        String string = outboundInfo.getMCFClass();
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        try {
            try {
                Debug.println("Instantiate the MCF class : " + string);
                clazz = Class.forName(string, true, this.raInstanceMgr.getClassloader());
                ManagedConnectionFactory managedConnectionFactory2 = (ManagedConnectionFactory)this.raInstanceMgr.getAdapterLayer().newInstance(clazz, authenticatedSubject);
                if (this.raInstanceMgr.getResourceAdapter() != null && managedConnectionFactory2 instanceof ResourceAdapterAssociation) {
                    try {
                        Debug.println("Set the resource adapter bean in the mcf");
                        this.raInstanceMgr.getAdapterLayer().setResourceAdapter((ResourceAdapterAssociation)managedConnectionFactory2, this.raInstanceMgr.getResourceAdapter(), authenticatedSubject);
                    }
                    catch (Throwable throwable) {
                        String string2 = Debug.getExceptionSetRAClassFailed(string, throwable.toString());
                        throw new RAOutboundException(string2, throwable);
                    }
                }
                Debug.println("Configure the MCF class");
                Utils.setProperties(this.raInstanceMgr, managedConnectionFactory2, outboundInfo.getMCFProps().values(), this.raInstanceMgr.getRAValidationInfo().getConnectionFactoryPropSetterTable(outboundInfo.getCFInterface()));
                managedConnectionFactory = managedConnectionFactory2;
                Object var9_17 = null;
            }
            catch (RAInternalException rAInternalException) {
                String string3 = Debug.getExceptionMCFUnexpectedException(clazz.getName(), rAInternalException.toString());
                throw new RAOutboundException(string3, (Throwable)((Object)rAInternalException));
            }
            catch (ClassNotFoundException classNotFoundException) {
                String string4 = Debug.getExceptionMCFClassNotFound(outboundInfo.getMCFClass(), classNotFoundException.toString());
                throw new RAOutboundException(string4, classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                String string5 = Debug.getExceptionInstantiateMCFFailed(outboundInfo.getMCFClass(), instantiationException.toString());
                throw new RAOutboundException(string5, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                String string6 = Debug.getExceptionAccessMCFFailed(outboundInfo.getMCFClass(), illegalAccessException.toString());
                throw new RAOutboundException(string6, illegalAccessException);
            }
        }
        catch (Throwable throwable) {
            Object var9_18 = null;
            Debug.exit(this, "initializeMCF(...)");
            throw throwable;
        }
        Debug.exit(this, "initializeMCF(...)");
        return managedConnectionFactory;
    }

    private boolean fromSameApp(ConnectionPool connectionPool) {
        String string;
        boolean bl = true;
        boolean bl2 = this.raInstanceMgr.getAppContext().getRuntime().isEAR();
        String string2 = ApplicationAccess.getApplicationAccess().getCurrentApplicationName();
        if (connectionPool != null && bl2 && (string = this.raInstanceMgr.getApplicationName()) != null & string.length() != 0 && !string.equalsIgnoreCase(string2)) {
            bl = false;
            if (Debug.isConnectionsEnabled()) {
                Debug.connections("For pool '" + connectionPool.getName() + "' a connection " + "request was made from outside the application and is being rejected.");
                Debug.connections("Requesting app = " + string + " and current app = " + string2);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeStateOfPools(byte by) throws RAOutboundException {
        Debug.enter(this, "changeStateOfPools( " + by + " )");
        try {
            Iterator iterator = this.poolMap.values().iterator();
            RAOutboundException rAOutboundException = null;
            while (iterator.hasNext()) {
                ConnectionPool connectionPool = (ConnectionPool)((Object)iterator.next());
                try {
                    switch (by) {
                        case 2: {
                            connectionPool.resume();
                            break;
                        }
                        case 1: {
                            connectionPool.suspend();
                            break;
                        }
                        case 4: {
                            connectionPool.forceSuspend(false);
                            break;
                        }
                        case 3: {
                            connectionPool.shutdown();
                        }
                    }
                }
                catch (ResourceException resourceException) {
                    rAOutboundException = (RAOutboundException)Utils.consolidateException(new RAOutboundException(), (Throwable)((Object)resourceException));
                }
            }
            if (rAOutboundException != null) {
                throw rAOutboundException;
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Debug.exit(this, "changeStateOfPools( " + by + " )");
            throw throwable;
        }
        Debug.exit(this, "changeStateOfPools( " + by + " )");
    }

    private void reset() {
        this.mcfMap.clear();
        this.outboundInfoMap.clear();
        this.poolMap.clear();
    }

    public void setRA(RAInstanceManager rAInstanceManager) {
        this.raInstanceMgr = rAInstanceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getConnectionFactory(String string) throws ApplicationServerInternalException, NoPermissionException, javax.resource.ResourceException {
        Object object;
        Debug.enter(this, "getConnectionFactory(...)");
        try {
            Object object2 = null;
            try {
                object = (ConnectionPool)((Object)this.jndiPoolLookupMap.get(string));
                if (object == null) {
                    Debug.println("Failed to get the pool for key : " + string + " : " + (Object)object);
                    String string2 = Debug.getExceptionGetConnectionFactoryFailedInternalError(string);
                    throw new ApplicationServerInternalException(string2);
                }
                Debug.println("Got the pool for key : " + string + " : " + (Object)object);
                Debug.println("Check if access is allowed");
                if (!this.isOutsideAppAccessEnabled && !this.fromSameApp((ConnectionPool)((Object)object))) {
                    String string3 = Debug.getExceptionFailedAccessOutsideApp();
                    throw new NoPermissionException(string3);
                }
                Debug.println("Get the ConnectionFactory from the connection pool");
                object2 = object.getConnectionFactory();
            }
            catch (javax.resource.ResourceException resourceException) {
                Debug.logCreateCFforMCFError(string, resourceException);
                throw resourceException;
            }
            object = object2;
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            Debug.exit(this, "getConnectionFactory(...)");
            throw throwable;
        }
        Debug.exit(this, "getConnectionFactory(...)");
        return object;
    }

    public ConnectionPool getConnectionPool(String string) {
        ConnectionPool connectionPool = null;
        if (string != null) {
            String string2 = JNDIHandler.getJndiNameAndVersion(string, this.raInstanceMgr.getVersionId());
            connectionPool = (ConnectionPool)((Object)this.poolMap.get(string2));
        }
        return connectionPool;
    }

    public RAInstanceManager getRA() {
        return this.raInstanceMgr;
    }

    public Vector getMCFKeyNames() {
        Vector vector = new Vector();
        Iterator iterator = this.poolMap.keySet().iterator();
        if (this.poolMap == null) {
            return vector;
        }
        while (iterator.hasNext()) {
            vector.addElement(iterator.next());
        }
        return vector;
    }

    public int getAvailableConnetionPoolsCount() {
        return this.raInstanceMgr.getRAInfo().getOutboundInfos().size();
    }

    public List getConnectionPoolsRuntime() {
        Iterator iterator = this.poolMap.values().iterator();
        ConnectionPool connectionPool = null;
        Vector<ConnectionPoolRuntimeMBeanImpl> vector = new Vector<ConnectionPoolRuntimeMBeanImpl>(10);
        while (iterator.hasNext()) {
            connectionPool = (ConnectionPool)((Object)iterator.next());
            vector.add(connectionPool.getRuntimeMBean());
        }
        return vector;
    }

    public ConnectorConnectionPoolRuntimeMBean getConnectionPoolRuntime(String string) {
        String string2 = JNDIHandler.getJndiNameAndVersion(string, this.raInstanceMgr.getVersionId());
        ConnectionPoolRuntimeMBeanImpl connectionPoolRuntimeMBeanImpl = null;
        ConnectionPool connectionPool = (ConnectionPool)((Object)this.poolMap.get(string2));
        if (connectionPool != null) {
            connectionPoolRuntimeMBeanImpl = connectionPool.getRuntimeMBean();
        }
        return connectionPoolRuntimeMBeanImpl;
    }

    public OutboundAdapterType[] getXMLBeans(ConnectorDiagnosticImageSource connectorDiagnosticImageSource) {
        boolean bl;
        boolean bl2 = bl = connectorDiagnosticImageSource != null ? connectorDiagnosticImageSource.timedout() : false;
        if (bl) {
            return new OutboundAdapterType[0];
        }
        OutboundAdapterType[] outboundAdapterTypeArray = new OutboundAdapterType[this.poolMap.size()];
        Iterator iterator = this.poolMap.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ConnectionPool connectionPool = (ConnectionPool)((Object)iterator.next());
            outboundAdapterTypeArray[n] = connectionPool.getXMLBean(connectorDiagnosticImageSource);
            ++n;
        }
        return outboundAdapterTypeArray;
    }

    public String getModuleName() {
        if (this.moduleName != null) {
            return this.moduleName;
        }
        if (this.raInstanceMgr != null) {
            this.moduleName = this.raInstanceMgr.getModuleName();
        }
        return this.moduleName;
    }

    private void debugModule(String string) {
        if (Debug.isDeploymentEnabled()) {
            Debug.deployment("Module '" + this.getModuleName() + "' " + string);
        }
    }

    public void preparePool(String string) throws RAOutboundException {
        ManagedConnectionFactory managedConnectionFactory = (ManagedConnectionFactory)this.mcfMap.get(string);
        if (managedConnectionFactory == null) {
            String string2 = Debug.getExceptionOutboundPrepareFailed(string, "ManagedConnectionFactory was not found");
            throw new RAOutboundException(string2);
        }
        OutboundInfo outboundInfo = (OutboundInfo)this.outboundInfoMap.get(string);
        if (outboundInfo == null) {
            String string3 = Debug.getExceptionOutboundPrepareFailed(string, "Outbound Pool was not found");
            throw new RAOutboundException(string3);
        }
        try {
            boolean bl;
            this.debugModule("Preparing the pool with KEY id:  '" + string + "'");
            ConnectionPool connectionPool = RAOutboundDeployer.prepare(managedConnectionFactory, outboundInfo, this.raInstanceMgr.getApplicationName(), this.raInstanceMgr.getComponentName(), this);
            connectionPool.setupRuntime((ConnectorComponentRuntimeMBeanImpl)this.raInstanceMgr.getConnectorComponentRuntimeMBean(), this);
            Debug.println("Add to the poolMap : key = " + string + " : " + (Object)((Object)connectionPool));
            this.poolMap.put(string, connectionPool);
            String string4 = outboundInfo.getJndiName();
            boolean bl2 = bl = string4 == null || string4.length() == 0;
            if (!bl) {
                string4 = string;
                if (JNDIHandler.isJndiNameBound(string4)) {
                    String string5 = Debug.getExceptionJndiNameAlreadyBound(string4);
                    throw new RAOutboundException(string5);
                }
            } else {
                string4 = this.raInstanceMgr.getAppContext().getApplicationId() + "/" + outboundInfo.getResourceLink();
            }
            Debug.println(this, "Add to the jndiPoolLookupMap : " + string4 + " : " + (Object)((Object)connectionPool));
            this.jndiPoolLookupMap.put(string4, connectionPool);
        }
        catch (DeploymentException deploymentException) {
            String string6 = Debug.getExceptionOutboundPrepareFailed(string, deploymentException.toString());
            throw new RAOutboundException(string6, (Throwable)((Object)deploymentException));
        }
    }

    public void activatePool(String string) throws RAOutboundException {
        OutboundInfo outboundInfo = (OutboundInfo)this.outboundInfoMap.get(string);
        ConnectionPool connectionPool = (ConnectionPool)((Object)this.poolMap.get(string));
        try {
            block7: {
                try {
                    boolean bl;
                    Debug.println("Set the logger");
                    connectionPool.setLogger();
                    Debug.pooling("Updating the initial capacity of connection pool for module '" + this.moduleName + "' with key:  '" + string + "'");
                    RAOutboundDeployer.updateInitialCapacity(connectionPool, outboundInfo);
                    connectionPool.setupForXARecovery();
                    this.debugModule("Resuming the pool with name '" + connectionPool.getName() + "'");
                    connectionPool.resume();
                    boolean bl2 = bl = outboundInfo.getJndiName() == null || outboundInfo.getJndiName().length() == 0;
                    if (!bl) {
                        this.debugModule("Binding the pool into JNDI with JNDI name '" + string + "'");
                        JNDIHandler.bindConnectionFactory(outboundInfo, this, connectionPool.getConnectionFactory());
                        break block7;
                    }
                    String string2 = outboundInfo.getResourceLink();
                    ApplicationContextInternal applicationContextInternal = this.raInstanceMgr.getAppContext();
                    this.debugModule("Binding the pool into App-Scoped JNDI with ResourceLink '" + string2 + "'");
                    JNDIHandler.bindAppScopedConnectionFactory(outboundInfo, this, applicationContextInternal, this.raInstanceMgr.getConnectionFactoryContext(), this.moduleName);
                }
                catch (ResourceException resourceException) {
                    this.debugModule("Failed to activate the pool with key = '" + string + "'");
                    String string3 = Debug.getExceptionResumePoolFailed(resourceException.toString());
                    throw new RAOutboundException(string3, (Throwable)((Object)resourceException));
                }
                catch (javax.resource.ResourceException resourceException) {
                    String string4 = Debug.getFailedToGetCF(string, resourceException.toString());
                    this.debugModule(string4);
                    throw new RAOutboundException(string4);
                }
                catch (DeploymentException deploymentException) {
                    this.debugModule("Failed to bind the pool into JNDI, key = '" + string + "'");
                    String string5 = Debug.getExceptionJndiBindFailed(string, deploymentException.toString());
                    throw new RAOutboundException(string5, (Throwable)((Object)deploymentException));
                }
            }
            Object var8_13 = null;
            this.debugModule("Done resuming/binding the pool with key = '" + string + "'");
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            this.debugModule("Done resuming/binding the pool with key = '" + string + "'");
            throw throwable;
        }
    }

    public boolean resetPool(String string) throws RAOutboundException {
        return this.internalResetPool(string, false);
    }

    public void forceResetPool(String string) throws RAOutboundException {
        this.internalResetPool(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalResetPool(String string, boolean bl) throws RAOutboundException {
        String string2 = JNDIHandler.getJndiNameAndVersion(string, this.raInstanceMgr.getVersionId());
        ConnectionPool connectionPool = (ConnectionPool)((Object)this.poolMap.get(string2));
        OutboundInfo outboundInfo = this.pendingOutboundInfoMap.get(string2);
        if (outboundInfo == null) {
            outboundInfo = (OutboundInfo)this.outboundInfoMap.get(string2);
        }
        try {
            if (bl) {
                connectionPool.forceSuspend(true);
                Debug.println("ResetConnectionPool# forceSuspend Connection pool : key = " + string + " : " + (Object)((Object)connectionPool));
            } else {
                ConnectionPool connectionPool2 = connectionPool;
                synchronized (connectionPool2) {
                    if (connectionPool.getNumReserved() > 0) {
                        if (Debug.isPoolingEnabled()) {
                            Debug.pooling(ConnectorLogger.logCannotResetConnectionPoolInuse((String)string));
                        }
                        return false;
                    }
                    connectionPool.suspend(true);
                    Debug.println("ResetConnectionPool# suspend Connection pool : key = " + string + " : " + (Object)((Object)connectionPool));
                }
            }
            connectionPool.shutdown();
            Debug.println("ResetConnectionPool# shutdown Connection pool : key = " + string + " : " + (Object)((Object)connectionPool));
            JNDIHandler.unbindConnectionFactory(outboundInfo, this, connectionPool.getConnectionFactory());
            this.createConnectionFactory(outboundInfo);
            this.pendingOutboundInfoMap.remove(string2);
            this.preparePool(string2);
            this.activatePool(string2);
            if (Debug.getVerbose()) {
                connectionPool = (ConnectionPool)((Object)this.poolMap.get(string2));
                Debug.println("ResetConnectionPool# activate Connection pool : key = " + string + " : " + (Object)((Object)connectionPool));
            }
            if (Debug.isPoolingEnabled()) {
                Debug.pooling(ConnectorLogger.logConnectionPoolReset((String)string));
            }
            return true;
        }
        catch (ResourceException resourceException) {
            throw new RAOutboundException("unable to reset connection pool " + string, (Throwable)((Object)resourceException));
        }
        catch (UndeploymentException undeploymentException) {
            throw new RAOutboundException("unable to reset connection pool " + string, (Throwable)((Object)undeploymentException));
        }
        catch (javax.resource.ResourceException resourceException) {
            throw new RAOutboundException("unable to reset connection pool " + string, resourceException);
        }
    }
}

