/*
 * Decompiled with CFR 0.152.
 */
package weblogic.connector.security;

import java.net.URL;
import java.security.AccessController;
import java.util.List;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.utils.SecPermSpecUtils;
import weblogic.connector.external.RAInfo;
import weblogic.connector.external.SecurityPermissionInfo;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SupplementalPolicyObject;

public class SecurityPermissions {
    private static AuthenticatedSubject kernelId = null;

    public static void unSetSecurityPermissions(RAInfo rAInfo) {
        URL uRL = rAInfo.getURL();
        SupplementalPolicyObject.removePolicies((AuthenticatedSubject)SecurityPermissions.getKernelId(), (URL)uRL);
    }

    public static void setSecurityPermissions(RAInfo rAInfo) {
        SecurityPermissions.setSecurityPermissions(rAInfo, null);
    }

    public static void setSecurityPermissions(RAInfo rAInfo, ApplicationContextInternal applicationContextInternal) {
        URL uRL = rAInfo.getURL();
        List list = rAInfo.getSecurityPermissions();
        String string = null;
        if (list != null && !list.isEmpty()) {
            for (SecurityPermissionInfo securityPermissionInfo : list) {
                string = securityPermissionInfo.getSpec();
                SupplementalPolicyObject.setPoliciesFromGrantStatement((AuthenticatedSubject)SecurityPermissions.getKernelId(), (URL)uRL, (String)(applicationContextInternal == null ? string : SecPermSpecUtils.getNewSecurityPermissionSpec(applicationContextInternal, string)), (String)"CONNECTOR");
            }
        } else {
            SupplementalPolicyObject.setPoliciesFromGrantStatement((AuthenticatedSubject)SecurityPermissions.getKernelId(), (URL)uRL, (String)(applicationContextInternal == null ? string : SecPermSpecUtils.getNewSecurityPermissionSpec(applicationContextInternal, string)), (String)"CONNECTOR");
        }
    }

    private static AuthenticatedSubject getKernelId() {
        if (kernelId == null) {
            kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        }
        return kernelId;
    }
}

